/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosBridgeInternal;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.PartitionKey;
import java.util.List;
import reactor.core.publisher.Mono;

public final class ItemOperations {
    public static <T> FeedResponse<T> readMany(CosmosContainer container, List<Pair<String, PartitionKey>> itemKeyList, Class<T> classType) {
        return (FeedResponse)ItemOperations.readManyAsync(CosmosBridgeInternal.getCosmosAsyncContainer(container), itemKeyList, classType).block();
    }

    public static <T> Mono<FeedResponse<T>> readManyAsync(CosmosAsyncContainer container, List<Pair<String, PartitionKey>> itemKeyList, Class<T> classType) {
        CosmosQueryRequestOptions options = new CosmosQueryRequestOptions();
        options.setMaxDegreeOfParallelism(-1);
        return ItemOperations.readManyInternal(container, itemKeyList, new CosmosQueryRequestOptions(), classType);
    }

    static <T> Mono<FeedResponse<T>> readManyInternal(CosmosAsyncContainer container, List<Pair<String, PartitionKey>> itemKeyList, CosmosQueryRequestOptions options, Class<T> classType) {
        return CosmosBridgeInternal.getAsyncDocumentClient(container.getDatabase()).readMany(itemKeyList, BridgeInternal.getLink(container), options, classType);
    }

    private ItemOperations() {
    }
}

