/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.JsonSerializable;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class ReplicationPolicy
extends JsonSerializable {
    private static final int DEFAULT_MAX_REPLICA_SET_SIZE = 4;
    private static final int DEFAULT_MIN_REPLICA_SET_SIZE = 3;

    public ReplicationPolicy() {
    }

    public ReplicationPolicy(ObjectNode objectNode) {
        super(objectNode);
    }

    public ReplicationPolicy(String jsonString) {
        super(jsonString);
    }

    public int getMaxReplicaSetSize() {
        Integer maxReplicaSetSize = super.getInt("maxReplicasetSize");
        if (maxReplicaSetSize == null) {
            return 4;
        }
        return maxReplicaSetSize;
    }

    public void setMaxReplicaSetSize(int value) {
        Integer maxReplicaSetSize = super.getInt("maxReplicasetSize");
        BridgeInternal.setProperty(this, "maxReplicasetSize", value);
    }

    public int getMinReplicaSetSize() {
        Integer minReplicaSetSize = super.getInt("minReplicaSetSize");
        if (minReplicaSetSize == null) {
            return 3;
        }
        return minReplicaSetSize;
    }
}

