/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.StoredProcedureResponse;
import java.time.Duration;
import java.util.Map;

public class CosmosResponse<T> {
    private T properties;
    final ResourceResponse<?> resourceResponseWrapper;

    CosmosResponse(ResourceResponse<?> resourceResponse) {
        this.resourceResponseWrapper = resourceResponse;
    }

    CosmosResponse(T properties) {
        this.properties = properties;
        this.resourceResponseWrapper = null;
    }

    CosmosResponse(ResourceResponse<?> resourceResponse, T properties) {
        this.resourceResponseWrapper = resourceResponse;
        this.properties = properties;
    }

    CosmosResponse(StoredProcedureResponse response) {
        this.resourceResponseWrapper = null;
    }

    public T getProperties() {
        return this.properties;
    }

    CosmosResponse<T> setProperties(T resourceSettings) {
        this.properties = resourceSettings;
        return this;
    }

    public String getMaxResourceQuota() {
        return this.resourceResponseWrapper.getMaxResourceQuota();
    }

    public String getCurrentResourceQuotaUsage() {
        return this.resourceResponseWrapper.getCurrentResourceQuotaUsage();
    }

    public String getActivityId() {
        return this.resourceResponseWrapper.getActivityId();
    }

    public double getRequestCharge() {
        return this.resourceResponseWrapper.getRequestCharge();
    }

    public int getStatusCode() {
        return this.resourceResponseWrapper.getStatusCode();
    }

    public String getSessionToken() {
        return this.resourceResponseWrapper.getSessionToken();
    }

    public Map<String, String> getResponseHeaders() {
        return this.resourceResponseWrapper.getResponseHeaders();
    }

    public CosmosDiagnostics getDiagnostics() {
        return this.resourceResponseWrapper.getDiagnostics();
    }

    public Duration getDuration() {
        return this.resourceResponseWrapper.getDuration();
    }
}

