/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.core.credential.AzureKeyCredential;
import com.azure.cosmos.implementation.AuthorizationTokenProvider;
import com.azure.cosmos.implementation.PathsHelper;
import com.azure.cosmos.implementation.RequestVerb;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.ModelBridgeInternal;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class BaseAuthorizationTokenProvider
implements AuthorizationTokenProvider {
    private static final String AUTH_PREFIX = "type=master&ver=1.0&sig=";
    private final AzureKeyCredential credential;
    private final Mac macInstance;
    private int masterKeyHashCode;

    public BaseAuthorizationTokenProvider(AzureKeyCredential credential) {
        this.credential = credential;
        this.macInstance = this.getMacInstance();
    }

    private static String getResourceSegment(ResourceType resourceType) {
        switch (resourceType) {
            case Attachment: {
                return "attachments";
            }
            case Database: {
                return "dbs";
            }
            case Conflict: {
                return "conflicts";
            }
            case Document: {
                return "docs";
            }
            case DocumentCollection: {
                return "colls";
            }
            case Offer: {
                return "offers";
            }
            case Permission: {
                return "permissions";
            }
            case StoredProcedure: {
                return "sprocs";
            }
            case Trigger: {
                return "triggers";
            }
            case UserDefinedFunction: {
                return "udfs";
            }
            case User: {
                return "users";
            }
            case PartitionKeyRange: {
                return "pkranges";
            }
            case Media: {
                return "media";
            }
            case DatabaseAccount: {
                return "";
            }
        }
        return null;
    }

    @Override
    public String generateKeyAuthorizationSignature(RequestVerb verb, String resourceIdOrFullName, ResourceType resourceType, Map<String, String> headers) {
        return this.generateKeyAuthorizationSignature(verb, resourceIdOrFullName, BaseAuthorizationTokenProvider.getResourceSegment(resourceType), headers);
    }

    public String generateKeyAuthorizationSignature(RequestVerb verb, String resourceIdOrFullName, String resourceSegment, Map<String, String> headers) {
        if (verb == null) {
            throw new IllegalArgumentException("verb");
        }
        if (resourceIdOrFullName == null) {
            resourceIdOrFullName = "";
        }
        if (resourceSegment == null) {
            throw new IllegalArgumentException("resourceSegment");
        }
        if (headers == null) {
            throw new IllegalArgumentException("headers");
        }
        if (StringUtils.isEmpty(this.credential.getKey())) {
            throw new IllegalArgumentException("key credentials cannot be empty");
        }
        if (!PathsHelper.isNameBased(resourceIdOrFullName)) {
            resourceIdOrFullName = resourceIdOrFullName.toLowerCase(Locale.ROOT);
        }
        StringBuilder body = new StringBuilder();
        body.append(ModelBridgeInternal.toLower(verb)).append('\n').append(resourceSegment).append('\n').append(resourceIdOrFullName).append('\n');
        if (headers.containsKey("x-ms-date")) {
            body.append(headers.get("x-ms-date").toLowerCase(Locale.ROOT));
        }
        body.append('\n');
        if (headers.containsKey("date")) {
            body.append(headers.get("date").toLowerCase(Locale.ROOT));
        }
        body.append('\n');
        Mac mac = this.getMacInstance();
        byte[] digest = mac.doFinal(body.toString().getBytes(StandardCharsets.UTF_8));
        String auth = Utils.encodeBase64String(digest);
        return AUTH_PREFIX + auth;
    }

    @Override
    public String getAuthorizationTokenUsingResourceTokens(Map<String, String> resourceTokens, String path, String resourceId) {
        if (resourceTokens == null) {
            throw new IllegalArgumentException("resourceTokens");
        }
        String resourceToken = null;
        if (resourceTokens.containsKey(resourceId) && resourceTokens.get(resourceId) != null) {
            resourceToken = resourceTokens.get(resourceId);
        } else if (StringUtils.isEmpty(path) || StringUtils.isEmpty(resourceId)) {
            if (resourceTokens.size() > 0) {
                resourceToken = resourceTokens.values().iterator().next();
            }
        } else {
            String[] pathParts = StringUtils.split(path, "/");
            String[] resourceTypes = new String[]{"dbs", "colls", "docs", "sprocs", "udfs", "triggers", "users", "permissions", "attachments", "media", "conflicts"};
            HashSet resourceTypesSet = new HashSet();
            Collections.addAll(resourceTypesSet, resourceTypes);
            for (int i = pathParts.length - 1; i >= 0; --i) {
                if (resourceTypesSet.contains(pathParts[i]) || !resourceTokens.containsKey(pathParts[i])) continue;
                resourceToken = resourceTokens.get(pathParts[i]);
            }
        }
        return resourceToken;
    }

    private Mac getMacInstance() {
        int masterKeyLatestHashCode = this.credential.getKey().hashCode();
        if (masterKeyLatestHashCode != this.masterKeyHashCode) {
            byte[] masterKeyBytes = this.credential.getKey().getBytes(StandardCharsets.UTF_8);
            byte[] masterKeyDecodedBytes = Utils.Base64Decoder.decode(masterKeyBytes);
            SecretKeySpec signingKey = new SecretKeySpec(masterKeyDecodedBytes, "HMACSHA256");
            try {
                Mac macInstance = Mac.getInstance("HMACSHA256");
                macInstance.init(signingKey);
                this.masterKeyHashCode = masterKeyLatestHashCode;
                return macInstance;
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            return (Mac)this.macInstance.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

