/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequest;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestRecord;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RntbdRequestEncoder
extends MessageToByteEncoder<RntbdRequestRecord> {
    private static final Logger logger = LoggerFactory.getLogger(RntbdRequestEncoder.class);

    public boolean acceptOutboundMessage(Object message) {
        return message.getClass() == RntbdRequestRecord.class;
    }

    protected void encode(ChannelHandlerContext context, RntbdRequestRecord message, ByteBuf out) {
        RntbdRequest request = RntbdRequest.from(message.args());
        int start = out.writerIndex();
        try {
            request.encode(out);
        }
        catch (Throwable error) {
            out.writerIndex(start);
            throw error;
        }
        message.requestLength(out.writerIndex() - start);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: ENCODE COMPLETE: request={}", (Object)context.channel(), (Object)request);
        }
    }
}

