/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.core.http.ProxyOptions;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.net.InetSocketAddress;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientTelemetryConfig {
    private static Logger logger = LoggerFactory.getLogger(ClientTelemetryConfig.class);
    private static boolean DEFAULT_CLIENT_TELEMETRY_ENABLED = false;
    private static final Duration DEFAULT_NETWORK_REQUEST_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_IDLE_CONNECTION_TIMEOUT = Duration.ofSeconds(60L);
    private static final int DEFAULT_MAX_CONNECTION_POOL_SIZE = 1000;
    private boolean clientTelemetryEnabled = DEFAULT_CLIENT_TELEMETRY_ENABLED;
    private final Duration httpNetworkRequestTimeout = DEFAULT_NETWORK_REQUEST_TIMEOUT;
    private final int maxConnectionPoolSize;
    private final Duration idleHttpConnectionTimeout = DEFAULT_IDLE_CONNECTION_TIMEOUT;
    private final ProxyOptions proxy = this.getProxyOptions();

    public ClientTelemetryConfig() {
        this.maxConnectionPoolSize = 1000;
    }

    public static ClientTelemetryConfig getDefaultConfig() {
        return new ClientTelemetryConfig();
    }

    public void setClientTelemetryEnabled(boolean clientTelemetryEnabled) {
        this.clientTelemetryEnabled = clientTelemetryEnabled;
    }

    public boolean isClientTelemetryEnabled() {
        return this.clientTelemetryEnabled;
    }

    public Duration getHttpNetworkRequestTimeout() {
        return this.httpNetworkRequestTimeout;
    }

    public int getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    public Duration getIdleHttpConnectionTimeout() {
        return this.idleHttpConnectionTimeout;
    }

    public ProxyOptions getProxy() {
        return this.proxy;
    }

    private ProxyOptions getProxyOptions() {
        String config = Configs.getClientTelemetryProxyOptionsConfig();
        if (StringUtils.isNotEmpty(config)) {
            try {
                JsonProxyOptionsConfig proxyOptionsConfig = (JsonProxyOptionsConfig)Utils.getSimpleObjectMapper().readValue(config, JsonProxyOptionsConfig.class);
                ProxyOptions.Type type = ProxyOptions.Type.valueOf((String)proxyOptionsConfig.type);
                if (type != ProxyOptions.Type.HTTP) {
                    throw new IllegalArgumentException("Only http proxy type is supported.");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Enable proxy with type {}, host {}, port {}", new Object[]{type, proxyOptionsConfig.host, proxyOptionsConfig.port});
                }
                return new ProxyOptions(type, new InetSocketAddress(proxyOptionsConfig.host, proxyOptionsConfig.port));
            }
            catch (JsonProcessingException e) {
                logger.error("Failed to parse client telemetry proxy option config", (Throwable)e);
            }
        }
        return null;
    }

    private static class JsonProxyOptionsConfig {
        @JsonProperty
        private String host;
        @JsonProperty
        private int port;
        @JsonProperty
        private String type;

        private JsonProxyOptionsConfig() {
        }

        private JsonProxyOptionsConfig(String host, int port, String type) {
            this.host = host;
            this.port = port;
            this.type = type;
        }
    }
}

