/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.query.DefaultDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.DistinctDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.PipelinedDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.PipelinedDocumentQueryParams;
import com.azure.cosmos.implementation.query.PipelinedQueryExecutionContext;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.implementation.query.SkipDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.TopDocumentQueryExecutionContext;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Flux;

public abstract class PipelinedQueryExecutionContextBase<T>
implements IDocumentQueryExecutionContext<T> {
    protected final int actualPageSize;
    private final QueryInfo queryInfo;
    protected final Function<JsonNode, T> factoryMethod;

    protected PipelinedQueryExecutionContextBase(int actualPageSize, QueryInfo queryInfo, Function<JsonNode, T> factoryMethod) {
        this.actualPageSize = actualPageSize;
        this.queryInfo = queryInfo;
        this.factoryMethod = factoryMethod;
    }

    public static <T> Flux<PipelinedQueryExecutionContextBase<T>> createAsync(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, PipelinedDocumentQueryParams<T> initParams, Class<T> classOfT) {
        QueryInfo queryInfo = initParams.getQueryInfo();
        CosmosQueryRequestOptions cosmosQueryRequestOptions = initParams.getCosmosQueryRequestOptions();
        int actualPageSize = Utils.getValueOrDefault(ModelBridgeInternal.getMaxItemCountFromQueryRequestOptions(cosmosQueryRequestOptions), 100);
        if (actualPageSize == -1) {
            actualPageSize = Integer.MAX_VALUE;
        }
        int pageSize = Math.min(actualPageSize, Utils.getValueOrDefault(queryInfo.getTop(), actualPageSize));
        Function<JsonNode, T> factoryMethod = DefaultDocumentQueryExecutionContext.getEffectiveFactoryMethod(cosmosQueryRequestOptions, queryInfo.hasSelectValue(), classOfT);
        if (queryInfo.hasOrderBy() || queryInfo.hasAggregates() || queryInfo.hasGroupBy() || queryInfo.hasDCount()) {
            return PipelinedDocumentQueryExecutionContext.createAsyncCore(diagnosticsClientContext, client, initParams, pageSize, factoryMethod);
        }
        return PipelinedQueryExecutionContext.createAsyncCore(diagnosticsClientContext, client, initParams, pageSize, factoryMethod);
    }

    protected static <T> BiFunction<String, PipelinedDocumentQueryParams<T>, Flux<IDocumentQueryExecutionComponent<T>>> createDistinctPipelineComponentFunction(BiFunction<String, PipelinedDocumentQueryParams<T>, Flux<IDocumentQueryExecutionComponent<T>>> createBaseComponent, QueryInfo queryInfo) {
        if (queryInfo.hasDistinct()) {
            return (continuationToken, documentQueryParams) -> DistinctDocumentQueryExecutionContext.createAsync(createBaseComponent, queryInfo.getDistinctQueryType(), continuationToken, documentQueryParams);
        }
        return createBaseComponent;
    }

    protected static <T> BiFunction<String, PipelinedDocumentQueryParams<T>, Flux<IDocumentQueryExecutionComponent<T>>> createCommonPipelineComponentFunction(BiFunction<String, PipelinedDocumentQueryParams<T>, Flux<IDocumentQueryExecutionComponent<T>>> createBaseComponent, QueryInfo queryInfo) {
        BiFunction createSkipComponentFunction = queryInfo.hasOffset() ? (continuationToken, documentQueryParams) -> SkipDocumentQueryExecutionContext.createAsync(createBaseComponent, queryInfo.getOffset(), continuationToken, documentQueryParams) : createBaseComponent;
        BiFunction createTopComponentFunction = queryInfo.hasTop() ? (continuationToken, documentQueryParams) -> TopDocumentQueryExecutionContext.createAsync(createSkipComponentFunction, queryInfo.getTop(), queryInfo.getTop(), continuationToken, documentQueryParams) : createSkipComponentFunction;
        if (queryInfo.hasLimit()) {
            return (continuationToken, documentQueryParams) -> {
                int totalLimit = queryInfo.getLimit();
                if (queryInfo.hasOffset()) {
                    totalLimit = queryInfo.getOffset() + queryInfo.getLimit();
                }
                return TopDocumentQueryExecutionContext.createAsync(createTopComponentFunction, queryInfo.getLimit(), totalLimit, continuationToken, documentQueryParams);
            };
        }
        return createTopComponentFunction;
    }

    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }
}

