/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.throughputControl;

import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.throughputControl.config.ThroughputControlGroupInternal;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerThroughputControlGroupProperties {
    private static Logger logger = LoggerFactory.getLogger(ContainerThroughputControlGroupProperties.class);
    private final AtomicReference<ThroughputControlGroupInternal> defaultGroup = new AtomicReference();
    private final Set<ThroughputControlGroupInternal> throughputControlGroupSet = ConcurrentHashMap.newKeySet();
    private final Set<String> supressInitErrorGroupSet = ConcurrentHashMap.newKeySet();

    public Pair<Integer, Boolean> enableThroughputControlGroup(ThroughputControlGroupInternal group) {
        Preconditions.checkNotNull(group, "Throughput control group should not be null");
        if (group.isDefault() && !this.defaultGroup.compareAndSet(null, group) && !this.defaultGroup.get().equals(group)) {
            throw new IllegalArgumentException("A default group already exists");
        }
        if (group.isContinueOnInitError()) {
            this.supressInitErrorGroupSet.add(group.getGroupName());
        }
        AtomicBoolean updatedGroupConfig = new AtomicBoolean(false);
        this.throughputControlGroupSet.stream().forEach(existingGroup -> {
            if (Objects.equals(existingGroup.getIdPrefix(), group.getIdPrefix()) && !existingGroup.equals(group)) {
                if (existingGroup.isDefault() != group.isDefault() || existingGroup.isContinueOnInitError() != group.isContinueOnInitError()) {
                    throw new IllegalArgumentException("Throughput control group with id " + group.getId() + " already exists with different setting for isDefault or isContinueOnInitError - these properties are immutable and cannot be changed.");
                }
                this.throughputControlGroupSet.remove(existingGroup);
                logger.info("Throughput control group with id-prefix {} already exists with different config. Will update config.", (Object)group.getIdPrefix());
                updatedGroupConfig.set(true);
            }
        });
        this.throughputControlGroupSet.add(group);
        return Pair.of(this.throughputControlGroupSet.size(), updatedGroupConfig.get());
    }

    public Set<ThroughputControlGroupInternal> getThroughputControlGroupSet() {
        return this.throughputControlGroupSet;
    }

    public boolean allowRequestToContinueOnInitError(RxDocumentServiceRequest request) {
        Preconditions.checkNotNull(request, "Request should not be null");
        String requestGroupName = request.getThroughputControlGroupName();
        if (StringUtils.isEmpty(requestGroupName)) {
            requestGroupName = this.defaultGroup.get().getGroupName();
        }
        return this.supressInitErrorGroupSet.contains(requestGroupName);
    }
}

