/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.ChangeFeedProcessor;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.implementation.changefeed.incremental.ChangeFeedProcessorBuilderImpl;
import com.azure.cosmos.models.ChangeFeedProcessorOptions;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.function.Consumer;

public class ChangeFeedProcessorBuilder {
    private String hostName;
    private CosmosAsyncContainer feedContainer;
    private CosmosAsyncContainer leaseContainer;
    private ChangeFeedProcessorOptions changeFeedProcessorOptions;
    private Consumer<List<JsonNode>> consumer;

    public ChangeFeedProcessorBuilder hostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public ChangeFeedProcessorBuilder feedContainer(CosmosAsyncContainer feedContainer) {
        this.feedContainer = feedContainer;
        return this;
    }

    public ChangeFeedProcessorBuilder leaseContainer(CosmosAsyncContainer leaseContainer) {
        this.leaseContainer = leaseContainer;
        return this;
    }

    public ChangeFeedProcessorBuilder handleChanges(Consumer<List<JsonNode>> consumer) {
        this.consumer = consumer;
        return this;
    }

    public ChangeFeedProcessorBuilder options(ChangeFeedProcessorOptions changeFeedProcessorOptions) {
        this.changeFeedProcessorOptions = changeFeedProcessorOptions;
        return this;
    }

    public ChangeFeedProcessor buildChangeFeedProcessor() {
        if (this.hostName == null || this.hostName.isEmpty()) {
            throw new IllegalArgumentException("hostName");
        }
        if (this.feedContainer == null) {
            throw new IllegalArgumentException("feedContainer");
        }
        if (this.leaseContainer == null) {
            throw new IllegalArgumentException("leaseContainer");
        }
        if (this.consumer == null) {
            throw new IllegalArgumentException("consumer");
        }
        ChangeFeedProcessorBuilderImpl builder = new ChangeFeedProcessorBuilderImpl().hostName(this.hostName).feedContainer(this.feedContainer).leaseContainer(this.leaseContainer).handleChanges(this.consumer);
        if (this.changeFeedProcessorOptions != null) {
            if (this.changeFeedProcessorOptions.getLeaseRenewInterval().compareTo(this.changeFeedProcessorOptions.getLeaseExpirationInterval()) >= 0) {
                throw new IllegalArgumentException("changeFeedProcessorOptions: expecting leaseRenewInterval less than leaseExpirationInterval");
            }
            builder.options(this.changeFeedProcessorOptions);
        }
        return builder.build();
    }
}

