/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.incremental;

import com.azure.cosmos.implementation.changefeed.ChangeFeedObserverContext;
import com.azure.cosmos.implementation.changefeed.Lease;
import com.azure.cosmos.implementation.changefeed.PartitionCheckpointer;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedState;
import com.azure.cosmos.models.FeedResponse;
import com.fasterxml.jackson.databind.JsonNode;
import reactor.core.publisher.Mono;

class ChangeFeedObserverContextImpl
implements ChangeFeedObserverContext {
    private final PartitionCheckpointer checkpointer;
    private final String partitionKeyRangeId;
    private final FeedResponse<JsonNode> feedResponse;
    private final ChangeFeedState continuationState;

    public ChangeFeedObserverContextImpl(String leaseToken) {
        this.partitionKeyRangeId = leaseToken;
        this.checkpointer = null;
        this.feedResponse = null;
        this.continuationState = null;
    }

    public ChangeFeedObserverContextImpl(String leaseToken, FeedResponse<JsonNode> feedResponse, ChangeFeedState continuationState, PartitionCheckpointer checkpointer) {
        this.partitionKeyRangeId = leaseToken;
        this.feedResponse = feedResponse;
        this.checkpointer = checkpointer;
        this.continuationState = continuationState;
    }

    @Override
    public Mono<Lease> checkpoint() {
        return this.checkpointer.checkpointPartition(this.continuationState);
    }

    @Override
    public String getPartitionKeyRangeId() {
        return this.partitionKeyRangeId;
    }

    @Override
    public FeedResponse<JsonNode> getFeedResponse() {
        return this.feedResponse;
    }
}

