/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.GoneException;
import com.azure.cosmos.implementation.OpenConnectionResponse;
import com.azure.cosmos.implementation.clienttelemetry.ClientTelemetry;
import com.azure.cosmos.implementation.directconnectivity.IAddressResolver;
import com.azure.cosmos.implementation.directconnectivity.RntbdTransportClient;
import com.azure.cosmos.implementation.directconnectivity.TransportException;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import com.azure.cosmos.implementation.directconnectivity.rntbd.AsyncRntbdRequestRecord;
import com.azure.cosmos.implementation.directconnectivity.rntbd.FailFastRntbdRequestRecord;
import com.azure.cosmos.implementation.directconnectivity.rntbd.OpenConnectionRntbdRequestRecord;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdClientChannelPool;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdConnectionStateListener;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpointStatistics;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdLoop;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdLoopEpoll;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdLoopNativeDetector;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdMetrics;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestArgs;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestRecord;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestTimer;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdThreadFactory;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.guava25.collect.ImmutableMap;
import com.azure.cosmos.implementation.guava27.Strings;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.micrometer.core.instrument.Tag;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=JsonSerializer.class)
public final class RntbdServiceEndpoint
implements RntbdEndpoint {
    private static final String TAG_NAME = RntbdServiceEndpoint.class.getSimpleName();
    private static final long QUIET_PERIOD = 2000000000L;
    private static final AtomicLong instanceCount = new AtomicLong();
    private static final Logger logger = LoggerFactory.getLogger(RntbdServiceEndpoint.class);
    private static final AdaptiveRecvByteBufAllocator receiveBufferAllocator = new AdaptiveRecvByteBufAllocator();
    private final RntbdClientChannelPool channelPool;
    private final AtomicBoolean closed;
    private final AtomicInteger concurrentRequests;
    private final long id;
    private final AtomicLong lastRequestNanoTime;
    private final AtomicLong lastSuccessfulRequestNanoTime;
    private final Instant createdTime;
    private final RntbdMetrics metrics;
    private final Provider provider;
    private final URI serverKey;
    private final SocketAddress remoteAddress;
    private final RntbdRequestTimer requestTimer;
    private final Tag tag;
    private final int maxConcurrentRequests;
    private final RntbdConnectionStateListener connectionStateListener;
    private final ClientTelemetry clientTelemetry;

    private RntbdServiceEndpoint(Provider provider, RntbdEndpoint.Config config, EventLoopGroup group, RntbdRequestTimer timer, URI physicalAddress, ClientTelemetry clientTelemetry) {
        this.serverKey = RntbdUtils.getServerKey(physicalAddress);
        Bootstrap bootstrap = this.getBootStrap(group, config);
        this.createdTime = Instant.now();
        this.remoteAddress = bootstrap.config().remoteAddress();
        this.concurrentRequests = new AtomicInteger();
        this.lastRequestNanoTime = new AtomicLong(System.nanoTime());
        this.lastSuccessfulRequestNanoTime = new AtomicLong(System.nanoTime());
        this.closed = new AtomicBoolean();
        this.requestTimer = timer;
        this.tag = Tag.of((String)TAG_NAME, (String)RntbdMetrics.escape(this.remoteAddress.toString()));
        this.id = instanceCount.incrementAndGet();
        this.provider = provider;
        this.metrics = new RntbdMetrics(provider.transportClient, this);
        this.maxConcurrentRequests = config.maxConcurrentRequestsPerEndpoint();
        this.connectionStateListener = this.provider.addressResolver != null && config.isConnectionEndpointRediscoveryEnabled() ? new RntbdConnectionStateListener(this) : null;
        this.channelPool = new RntbdClientChannelPool(this, bootstrap, config, clientTelemetry, this.connectionStateListener);
        this.clientTelemetry = clientTelemetry;
    }

    private Bootstrap getBootStrap(EventLoopGroup eventLoopGroup, RntbdEndpoint.Config config) {
        Preconditions.checkNotNull(eventLoopGroup, "expected non-null eventLoopGroup");
        Preconditions.checkNotNull(config, "expected non-null config");
        RntbdLoop rntbdLoop = RntbdLoopNativeDetector.getRntbdLoop(config.preferTcpNative());
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(rntbdLoop.getChannelClass())).option(ChannelOption.ALLOCATOR, (Object)config.allocator())).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)config.connectTimeoutInMillis())).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)receiveBufferAllocator)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).remoteAddress(this.serverKey.getHost(), this.serverKey.getPort());
        if (rntbdLoop instanceof RntbdLoopEpoll) {
            ((Bootstrap)bootstrap.option(EpollChannelOption.TCP_KEEPINTVL, (Object)config.tcpKeepIntvl())).option(EpollChannelOption.TCP_KEEPIDLE, (Object)config.tcpKeepIdle());
        }
        return bootstrap;
    }

    @Override
    public int channelsAcquiredMetric() {
        return this.channelPool.channelsAcquiredMetrics();
    }

    @Override
    public int channelsAvailableMetric() {
        return this.channelPool.channelsAvailableMetrics();
    }

    @Override
    public int concurrentRequests() {
        return this.concurrentRequests.get();
    }

    @Override
    public int gettingEstablishedConnectionsMetrics() {
        return this.channelPool.attemptingToConnectMetrics();
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public int maxChannels() {
        return this.channelPool.channels(true);
    }

    @Override
    public long lastRequestNanoTime() {
        return this.lastRequestNanoTime.get();
    }

    @Override
    public long lastSuccessfulRequestNanoTime() {
        return this.lastSuccessfulRequestNanoTime.get();
    }

    @Override
    public int channelsMetrics() {
        return this.channelPool.channels(true);
    }

    @Override
    public int executorTaskQueueMetrics() {
        return this.channelPool.executorTaskQueueMetrics();
    }

    @Override
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public URI serverKey() {
        return this.serverKey;
    }

    @Override
    public int requestQueueLength() {
        return this.channelPool.requestQueueLength();
    }

    @Override
    public Tag tag() {
        return this.tag;
    }

    @Override
    public long usedDirectMemory() {
        return this.channelPool.usedDirectMemory();
    }

    @Override
    public long usedHeapMemory() {
        return this.channelPool.usedHeapMemory();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.provider.evict(this);
            this.channelPool.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RntbdRequestRecord request(RntbdRequestArgs args) {
        this.throwIfClosed();
        int concurrentRequestSnapshot = this.concurrentRequests.incrementAndGet();
        if (this.connectionStateListener != null) {
            this.connectionStateListener.onBeforeSendRequest(args.physicalAddressUri());
        }
        RntbdEndpointStatistics stat = this.endpointMetricsSnapshot(concurrentRequestSnapshot);
        if (concurrentRequestSnapshot > this.maxConcurrentRequests) {
            try {
                FailFastRntbdRequestRecord requestRecord = FailFastRntbdRequestRecord.createAndFailFast(args, concurrentRequestSnapshot, this.metrics, this.remoteAddress);
                requestRecord.serviceEndpointStatistics(stat);
                FailFastRntbdRequestRecord failFastRntbdRequestRecord = requestRecord;
                return failFastRntbdRequestRecord;
            }
            finally {
                this.concurrentRequests.decrementAndGet();
            }
        }
        this.lastRequestNanoTime.set(args.nanoTimeCreated());
        RntbdRequestRecord record = this.write(args);
        record.serviceEndpointStatistics(stat);
        record.whenComplete((response, error) -> {
            this.concurrentRequests.decrementAndGet();
            this.metrics.markComplete(record);
            this.onResponse((Throwable)error);
        });
        return record;
    }

    @Override
    public OpenConnectionRntbdRequestRecord openConnection(Uri addressUri) {
        OpenConnectionRntbdRequestRecord requestRecord;
        Future<Channel> openChannelFuture;
        Preconditions.checkNotNull(addressUri, "Argument 'addressUri' should not be null");
        this.throwIfClosed();
        if (this.connectionStateListener != null) {
            this.connectionStateListener.onBeforeSendRequest(addressUri);
        }
        if ((openChannelFuture = this.channelPool.acquire(requestRecord = new OpenConnectionRntbdRequestRecord(addressUri))).isDone()) {
            return this.processWhenConnectionOpened(requestRecord, openChannelFuture);
        }
        openChannelFuture.addListener(ignored -> this.processWhenConnectionOpened(requestRecord, openChannelFuture));
        return requestRecord;
    }

    private OpenConnectionRntbdRequestRecord processWhenConnectionOpened(OpenConnectionRntbdRequestRecord requestRecord, Future<Channel> openChannelFuture) {
        OpenConnectionResponse openConnectionResponse;
        if (openChannelFuture.isSuccess()) {
            Channel channel = (Channel)openChannelFuture.getNow();
            assert (channel != null) : "impossible";
            this.releaseToPool(channel);
            requestRecord.getAddressUri().setConnected();
            openConnectionResponse = new OpenConnectionResponse(requestRecord.getAddressUri(), true);
        } else {
            openConnectionResponse = new OpenConnectionResponse(requestRecord.getAddressUri(), false, openChannelFuture.cause());
        }
        requestRecord.complete(openConnectionResponse);
        return requestRecord;
    }

    private void onResponse(Throwable exception) {
        if (exception == null) {
            this.lastSuccessfulRequestNanoTime.set(System.nanoTime());
            return;
        }
        if (exception instanceof CosmosException) {
            CosmosException cosmosException = (CosmosException)((Object)exception);
            switch (cosmosException.getStatusCode()) {
                case 404: 
                case 409: {
                    this.lastSuccessfulRequestNanoTime.set(System.nanoTime());
                    return;
                }
            }
            return;
        }
    }

    private RntbdEndpointStatistics endpointMetricsSnapshot(int concurrentRequestSnapshot) {
        RntbdEndpointStatistics stats = new RntbdEndpointStatistics().availableChannels(this.channelsAvailableMetric()).acquiredChannels(this.channelsAcquiredMetric()).executorTaskQueueSize(this.executorTaskQueueMetrics()).lastSuccessfulRequestNanoTime(this.lastSuccessfulRequestNanoTime()).createdTime(this.createdTime).lastRequestNanoTime(this.lastRequestNanoTime()).closed(this.closed.get()).inflightRequests(concurrentRequestSnapshot);
        if (this.connectionStateListener != null) {
            stats.connectionStateListenerMetrics(this.connectionStateListener.getMetrics());
        }
        return stats;
    }

    public String toString() {
        return RntbdObjectMapper.toString(this);
    }

    private void ensureSuccessWhenReleasedToPool(Channel channel, Future<Void> released) {
        if (released.isSuccess()) {
            logger.debug("\n  [{}]\n  {}\n  release succeeded", (Object)this, (Object)channel);
        } else {
            logger.debug("\n  [{}]\n  {}\n  release failed due to {}", new Object[]{this, channel, released.cause()});
        }
    }

    private void releaseToPool(Channel channel) {
        logger.debug("\n  [{}]\n  {}\n  RELEASE", (Object)this, (Object)channel);
        Future<Void> released = this.channelPool.release(channel);
        if (logger.isDebugEnabled()) {
            if (released.isDone()) {
                this.ensureSuccessWhenReleasedToPool(channel, released);
            } else {
                released.addListener(ignored -> this.ensureSuccessWhenReleasedToPool(channel, released));
            }
        }
    }

    private void throwIfClosed() {
        if (this.closed.get()) {
            throw new TransportException(Strings.lenientFormat("%s is closed", this), new IllegalStateException());
        }
    }

    private RntbdRequestRecord write(RntbdRequestArgs requestArgs) {
        AsyncRntbdRequestRecord requestRecord = new AsyncRntbdRequestRecord(requestArgs, this.requestTimer);
        requestRecord.stage(RntbdRequestRecord.Stage.CHANNEL_ACQUISITION_STARTED);
        Future<Channel> connectedChannel = this.channelPool.acquire(requestRecord);
        logger.debug("\n  [{}]\n  {}\n  WRITE WHEN CONNECTED {}", new Object[]{this, requestArgs, connectedChannel});
        if (connectedChannel.isDone()) {
            return this.writeWhenConnected(requestRecord, connectedChannel);
        }
        connectedChannel.addListener(ignored -> this.writeWhenConnected(requestRecord, (Future<? super Channel>)connectedChannel));
        return requestRecord;
    }

    private RntbdRequestRecord writeWhenConnected(RntbdRequestRecord requestRecord, Future<? super Channel> connected) {
        if (connected.isSuccess()) {
            Channel channel = (Channel)connected.getNow();
            assert (channel != null) : "impossible";
            this.releaseToPool(channel);
            requestRecord.channelTaskQueueLength(RntbdUtils.tryGetExecutorTaskQueueSize((EventExecutor)channel.eventLoop()));
            channel.write((Object)requestRecord.stage(RntbdRequestRecord.Stage.PIPELINED));
            requestRecord.args().physicalAddressUri().setConnected();
            return requestRecord;
        }
        RntbdRequestArgs requestArgs = requestRecord.args();
        UUID activityId = requestArgs.activityId();
        Throwable cause = connected.cause();
        if (connected.isCancelled()) {
            if (logger.isDebugEnabled()) {
                logger.debug("\n  [{}]\n  {}\n  write cancelled: {}", new Object[]{this, requestArgs, cause});
            }
            requestRecord.cancel(true);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("\n  [{}]\n  {}\n  write failed due to {} ", new Object[]{this, requestArgs, cause});
            }
            String reason = cause.toString();
            GoneException goneException = new GoneException(Strings.lenientFormat("failed to establish connection to %s due to %s", this.remoteAddress, reason), cause instanceof Exception ? (Exception)cause : new IOException(reason, cause), ImmutableMap.of("x-ms-activity-id", activityId.toString()), requestArgs.replicaPath());
            BridgeInternal.setRequestHeaders(goneException, requestArgs.serviceRequest().getHeaders());
            requestRecord.completeExceptionally((Throwable)((Object)goneException));
        }
        return requestRecord;
    }

    public static final class Provider
    implements RntbdEndpoint.Provider {
        private static final Logger logger = LoggerFactory.getLogger(Provider.class);
        private final AtomicBoolean closed;
        private final RntbdEndpoint.Config config;
        private final ConcurrentHashMap<String, RntbdEndpoint> endpoints;
        private final EventLoopGroup eventLoopGroup;
        private final AtomicInteger evictions;
        private final RntbdEndpointMonitoringProvider monitoring;
        private final RntbdRequestTimer requestTimer;
        private final RntbdTransportClient transportClient;
        private final IAddressResolver addressResolver;
        private final ClientTelemetry clientTelemetry;

        public Provider(RntbdTransportClient transportClient, RntbdTransportClient.Options options, SslContext sslContext, IAddressResolver addressResolver, ClientTelemetry clientTelemetry) {
            Preconditions.checkNotNull(transportClient, "expected non-null provider");
            Preconditions.checkNotNull(options, "expected non-null options");
            Preconditions.checkNotNull(sslContext, "expected non-null sslContext");
            Object wireLogLevel = logger.isDebugEnabled() ? LogLevel.TRACE : null;
            this.addressResolver = addressResolver;
            this.transportClient = transportClient;
            this.config = new RntbdEndpoint.Config(options, sslContext, (LogLevel)wireLogLevel);
            this.requestTimer = new RntbdRequestTimer(this.config.tcpNetworkRequestTimeoutInNanos(), this.config.requestTimerResolutionInNanos());
            this.eventLoopGroup = this.getEventLoopGroup(options);
            this.endpoints = new ConcurrentHashMap();
            this.evictions = new AtomicInteger();
            this.closed = new AtomicBoolean();
            this.clientTelemetry = clientTelemetry;
            this.monitoring = new RntbdEndpointMonitoringProvider(this);
            this.monitoring.init();
        }

        private EventLoopGroup getEventLoopGroup(RntbdTransportClient.Options options) {
            Preconditions.checkNotNull(options, "expected non-null options");
            RntbdLoop rntbdEventLoop = RntbdLoopNativeDetector.getRntbdLoop(options.preferTcpNative());
            DefaultThreadFactory threadFactory = new DefaultThreadFactory("cosmos-rntbd-" + rntbdEventLoop.getName(), true, options.ioThreadPriority());
            return rntbdEventLoop.newEventLoopGroup(options.threadCount(), (ThreadFactory)threadFactory);
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                this.monitoring.close();
                for (RntbdEndpoint endpoint : this.endpoints.values()) {
                    endpoint.close();
                }
                this.eventLoopGroup.shutdownGracefully(2000000000L, this.config.shutdownTimeoutInNanos(), TimeUnit.NANOSECONDS).addListener(future -> {
                    this.requestTimer.close();
                    if (future.isSuccess()) {
                        logger.debug("\n  [{}]\n  closed endpoints", (Object)this);
                        return;
                    }
                    logger.error("\n  [{}]\n  failed to close endpoints due to ", (Object)this, (Object)future.cause());
                });
                return;
            }
            logger.debug("\n  [{}]\n  already closed", (Object)this);
        }

        @Override
        public RntbdEndpoint.Config config() {
            return this.config;
        }

        @Override
        public int count() {
            return this.endpoints.size();
        }

        @Override
        public int evictions() {
            return this.evictions.get();
        }

        @Override
        public RntbdEndpoint get(URI physicalAddress) {
            return this.endpoints.computeIfAbsent(physicalAddress.getAuthority(), authority -> new RntbdServiceEndpoint(this, this.config, this.eventLoopGroup, this.requestTimer, physicalAddress, this.clientTelemetry));
        }

        @Override
        public IAddressResolver getAddressResolver() {
            return this.addressResolver;
        }

        @Override
        public Stream<RntbdEndpoint> list() {
            return this.endpoints.values().stream();
        }

        private void evict(RntbdEndpoint endpoint) {
            if (this.endpoints.remove(endpoint.serverKey().getAuthority()) != null) {
                this.evictions.incrementAndGet();
            }
        }
    }

    public static class RntbdEndpointMonitoringProvider
    implements AutoCloseable {
        private final Logger logger = LoggerFactory.getLogger(RntbdEndpointMonitoringProvider.class);
        private static final EventExecutor monitoringRntbdChannelPool = new DefaultEventExecutor((ThreadFactory)new RntbdThreadFactory("monitoring-rntbd-endpoints", true, 1));
        private static final Duration MONITORING_PERIOD = Duration.ofSeconds(60L);
        private final Provider provider;
        private static final int MAX_TASK_LIMIT = 5000;
        private ScheduledFuture<?> future;

        RntbdEndpointMonitoringProvider(Provider provider) {
            this.provider = provider;
        }

        synchronized void init() {
            this.logger.info("Starting RntbdClientChannelPoolMonitoringProvider ...");
            this.future = monitoringRntbdChannelPool.scheduleAtFixedRate(() -> this.logAllPools(), 0L, MONITORING_PERIOD.toMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public synchronized void close() {
            this.logger.info("Shutting down RntbdClientChannelPoolMonitoringProvider ...");
            this.future.cancel(false);
            this.future = null;
        }

        synchronized void logAllPools() {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Total number of RntbdClientChannelPool [{}].", (Object)this.provider.endpoints.size());
                }
                for (RntbdEndpoint endpoint : this.provider.endpoints.values()) {
                    this.logEndpoint(endpoint);
                }
            }
            catch (Exception e) {
                this.logger.error("monitoring unexpected failure", (Throwable)e);
            }
        }

        private void logEndpoint(RntbdEndpoint endpoint) {
            if (this.logger.isWarnEnabled() && (endpoint.executorTaskQueueMetrics() > 5000 || endpoint.requestQueueLength() > 5000 || endpoint.gettingEstablishedConnectionsMetrics() > 0 || endpoint.channelsMetrics() > endpoint.maxChannels())) {
                this.logger.warn("RntbdEndpoint Identifier {}, Stat {}", (Object)this.getPoolId(endpoint), (Object)this.getPoolStat(endpoint));
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("RntbdEndpoint Identifier {}, Stat {}", (Object)this.getPoolId(endpoint), (Object)this.getPoolStat(endpoint));
            }
        }

        private String getPoolStat(RntbdEndpoint endpoint) {
            return "[ poolTaskExecutorSize " + endpoint.executorTaskQueueMetrics() + ", lastRequestNanoTime " + Instant.now().minusNanos(System.nanoTime() - endpoint.lastRequestNanoTime()) + ", connecting " + endpoint.gettingEstablishedConnectionsMetrics() + ", acquiredChannel " + endpoint.channelsAcquiredMetric() + ", availableChannel " + endpoint.channelsAvailableMetric() + ", pendingAcquisitionSize " + endpoint.requestQueueLength() + ", closed " + endpoint.isClosed() + " ]";
        }

        private String getPoolId(RntbdEndpoint endpoint) {
            if (endpoint == null) {
                return "null";
            }
            return "[RntbdEndpoint, id " + endpoint.id() + ", remoteAddress " + endpoint.remoteAddress() + ", creationTime " + endpoint.getCreatedTime() + ", hashCode " + endpoint.hashCode() + "]";
        }
    }

    static final class JsonSerializer
    extends StdSerializer<RntbdServiceEndpoint> {
        private static final long serialVersionUID = -5764954918168771152L;

        public JsonSerializer() {
            super(RntbdServiceEndpoint.class);
        }

        public void serialize(RntbdServiceEndpoint value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            RntbdTransportClient transportClient = value.provider.transportClient;
            generator.writeStartObject();
            generator.writeNumberField("id", value.id);
            generator.writeBooleanField("closed", value.isClosed());
            generator.writeNumberField("concurrentRequests", value.concurrentRequests());
            generator.writeStringField("remoteAddress", value.remoteAddress.toString());
            generator.writeObjectField("channelPool", (Object)value.channelPool);
            generator.writeObjectFieldStart("transportClient");
            generator.writeNumberField("id", transportClient.id());
            generator.writeBooleanField("closed", transportClient.isClosed());
            generator.writeNumberField("endpointCount", transportClient.endpointCount());
            generator.writeNumberField("endpointEvictionCount", transportClient.endpointEvictionCount());
            generator.writeEndObject();
            generator.writeEndObject();
        }
    }
}

