/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.throughputControl;

import com.azure.cosmos.implementation.throughputControl.LinkedCancellationTokenSource;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class LinkedCancellationToken {
    private final List<LinkedCancellationTokenSource> childTokenSourceList = new ArrayList<LinkedCancellationTokenSource>();
    private final LinkedCancellationTokenSource tokenSource;
    private final AtomicBoolean cancellationRequested;

    public LinkedCancellationToken(LinkedCancellationTokenSource tokenSource) {
        this.tokenSource = tokenSource;
        this.cancellationRequested = new AtomicBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(LinkedCancellationTokenSource childTokenSource) {
        LinkedCancellationToken linkedCancellationToken = this;
        synchronized (linkedCancellationToken) {
            if (this.cancellationRequested.get()) {
                throw new IllegalStateException("The cancellation token has been cancelled");
            }
            this.childTokenSourceList.add(childTokenSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        LinkedCancellationToken linkedCancellationToken = this;
        synchronized (linkedCancellationToken) {
            if (this.cancellationRequested.compareAndSet(false, true)) {
                for (LinkedCancellationTokenSource childTokenSource : this.childTokenSourceList) {
                    childTokenSource.close();
                }
                this.childTokenSourceList.clear();
            }
        }
    }

    public boolean isCancellationRequested() {
        return this.cancellationRequested.get() || this.tokenSource.isClosed();
    }
}

