/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.ChangeFeedProcessor;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedMode;
import com.azure.cosmos.implementation.changefeed.incremental.ChangeFeedProcessorBuilderImpl;
import com.azure.cosmos.models.ChangeFeedProcessorItem;
import com.azure.cosmos.models.ChangeFeedProcessorOptions;
import com.azure.cosmos.util.Beta;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.function.Consumer;

public class ChangeFeedProcessorBuilder {
    private String hostName;
    private CosmosAsyncContainer feedContainer;
    private CosmosAsyncContainer leaseContainer;
    private ChangeFeedProcessorOptions changeFeedProcessorOptions;
    private Consumer<List<JsonNode>> partitionKeyBasedLeaseConsumer;
    private Consumer<List<ChangeFeedProcessorItem>> epkRangeBasedLeaseConsumer;
    private ChangeFeedMode changeFeedMode = ChangeFeedMode.INCREMENTAL;

    public ChangeFeedProcessorBuilder hostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public ChangeFeedProcessorBuilder feedContainer(CosmosAsyncContainer feedContainer) {
        this.feedContainer = feedContainer;
        return this;
    }

    public ChangeFeedProcessorBuilder leaseContainer(CosmosAsyncContainer leaseContainer) {
        this.leaseContainer = leaseContainer;
        return this;
    }

    public ChangeFeedProcessorBuilder handleChanges(Consumer<List<JsonNode>> consumer) {
        this.partitionKeyBasedLeaseConsumer = consumer;
        this.changeFeedMode = ChangeFeedMode.INCREMENTAL;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_37_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public ChangeFeedProcessorBuilder handleAllVersionsAndDeletesChanges(Consumer<List<ChangeFeedProcessorItem>> consumer) {
        this.epkRangeBasedLeaseConsumer = consumer;
        this.changeFeedMode = ChangeFeedMode.FULL_FIDELITY;
        return this;
    }

    public ChangeFeedProcessorBuilder options(ChangeFeedProcessorOptions changeFeedProcessorOptions) {
        this.changeFeedProcessorOptions = changeFeedProcessorOptions;
        return this;
    }

    public ChangeFeedProcessor buildChangeFeedProcessor() {
        this.validateChangeFeedProcessorBuilder();
        if (ChangeFeedMode.INCREMENTAL.equals((Object)this.changeFeedMode)) {
            ChangeFeedProcessorBuilderImpl builder = new ChangeFeedProcessorBuilderImpl().hostName(this.hostName).feedContainer(this.feedContainer).leaseContainer(this.leaseContainer).handleChanges(this.partitionKeyBasedLeaseConsumer);
            if (this.changeFeedProcessorOptions != null) {
                builder.options(this.changeFeedProcessorOptions);
            }
            return builder.build();
        }
        com.azure.cosmos.implementation.changefeed.fullfidelity.ChangeFeedProcessorBuilderImpl builder = new com.azure.cosmos.implementation.changefeed.fullfidelity.ChangeFeedProcessorBuilderImpl().hostName(this.hostName).feedContainer(this.feedContainer).leaseContainer(this.leaseContainer).handleChanges(this.epkRangeBasedLeaseConsumer);
        if (this.changeFeedProcessorOptions != null) {
            builder.options(this.changeFeedProcessorOptions);
        }
        return builder.build();
    }

    private void validateChangeFeedProcessorBuilder() {
        if (this.hostName == null || this.hostName.isEmpty()) {
            throw new IllegalArgumentException("hostName cannot be null or empty");
        }
        if (this.feedContainer == null) {
            throw new IllegalArgumentException("feedContainer cannot be null");
        }
        if (this.leaseContainer == null) {
            throw new IllegalArgumentException("leaseContainer cannot be null");
        }
        if (this.partitionKeyBasedLeaseConsumer == null && this.epkRangeBasedLeaseConsumer == null || this.partitionKeyBasedLeaseConsumer != null && this.epkRangeBasedLeaseConsumer != null) {
            throw new IllegalArgumentException("expecting either LatestVersion or AllVersionsAndDeletes consumer for handling change feed processor changes");
        }
        this.validateChangeFeedProcessorOptions();
    }

    private void validateChangeFeedProcessorOptions() {
        if (this.changeFeedProcessorOptions == null) {
            return;
        }
        if (this.changeFeedProcessorOptions.getLeaseRenewInterval().compareTo(this.changeFeedProcessorOptions.getLeaseExpirationInterval()) >= 0) {
            throw new IllegalArgumentException("changeFeedProcessorOptions: expecting leaseRenewInterval less than leaseExpirationInterval");
        }
        if (ChangeFeedMode.FULL_FIDELITY.equals((Object)this.changeFeedMode)) {
            if (this.changeFeedProcessorOptions.getStartTime() != null) {
                throw new IllegalStateException("changeFeedProcessorOptions: AllVersionsAndDeletes change feed mode is not supported for startTime option.");
            }
            if (this.changeFeedProcessorOptions.isStartFromBeginning()) {
                throw new IllegalStateException("changeFeedProcessorOptions: AllVersionsAndDeletes change feed mode is not supported for startFromBeginning option.");
            }
        }
    }
}

