/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosException;

public class Exceptions {
    public static boolean isStatusCode(CosmosException e, int status) {
        return status == e.getStatusCode();
    }

    public static boolean isSubStatusCode(CosmosException e, int subStatus) {
        return subStatus == e.getSubStatusCode();
    }

    public static boolean isGone(CosmosException e) {
        return Exceptions.isStatusCode(e, 410);
    }

    public static boolean isConflict(CosmosException e) {
        return Exceptions.isStatusCode(e, 409);
    }

    public static boolean isNotFound(CosmosException e) {
        return Exceptions.isStatusCode(e, 404);
    }

    public static boolean isPartitionSplit(CosmosException e) {
        return Exceptions.isStatusCode(e, 410) && Exceptions.isSubStatusCode(e, 1002);
    }

    public static boolean isNameCacheStale(CosmosException e) {
        return Exceptions.isStatusCode(e, 410) && Exceptions.isSubStatusCode(e, 1000);
    }

    public static boolean isThroughputControlRequestRateTooLargeException(CosmosException e) {
        return Exceptions.isStatusCode(e, 429) && Exceptions.isSubStatusCode(e, 10003);
    }

    public static boolean isPartitionCompletingSplittingException(CosmosException cosmosException) {
        return Exceptions.isStatusCode(cosmosException, 410) && Exceptions.isSubStatusCode(cosmosException, 1007);
    }

    public static boolean isPartitionKeyMismatchException(CosmosException cosmosException) {
        return Exceptions.isStatusCode(cosmosException, 404) && Exceptions.isSubStatusCode(cosmosException, 1001);
    }
}

