/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.GoneException;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdMetricsCompletionRecorder;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestArgs;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestRecord;
import com.azure.cosmos.implementation.guava27.Strings;
import com.azure.cosmos.implementation.http.HttpHeaders;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailFastRntbdRequestRecord
extends RntbdRequestRecord {
    private static final Logger logger = LoggerFactory.getLogger(FailFastRntbdRequestRecord.class);

    private FailFastRntbdRequestRecord(RntbdRequestArgs args) {
        super(args);
    }

    @Override
    public Timeout newTimeout(TimerTask task) {
        throw new IllegalArgumentException("newTimeout must never be called for fail fast records.");
    }

    public static FailFastRntbdRequestRecord createAndFailFast(RntbdRequestArgs args, long concurrentRequestsSnapshot, RntbdMetricsCompletionRecorder metricsComplectionRecorder, SocketAddress remoteAddress) {
        FailFastRntbdRequestRecord failFastRecord = new FailFastRntbdRequestRecord(args);
        logger.debug("\n  [{}]\n  {}\n  created FailFastRntbdRequestRecord {} ", new Object[]{failFastRecord, args, concurrentRequestsSnapshot});
        String reason = Strings.lenientFormat("Failed due to too many (%s) concurrent requests.", concurrentRequestsSnapshot);
        HttpHeaders headers = new HttpHeaders();
        headers.set("x-ms-activity-id", failFastRecord.activityId().toString());
        GoneException admissionControlBlocksRequestException = new GoneException(reason, headers, remoteAddress);
        BridgeInternal.setRequestHeaders(admissionControlBlocksRequestException, args.serviceRequest().getHeaders());
        failFastRecord.whenComplete((T response, U error) -> metricsComplectionRecorder.markComplete(failFastRecord));
        failFastRecord.completeExceptionally((Throwable)((Object)admissionControlBlocksRequestException));
        return failFastRecord;
    }
}

