/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.ChangeFeedProcessor;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedMode;
import com.azure.cosmos.implementation.changefeed.common.LeaseVersion;
import com.azure.cosmos.implementation.changefeed.epkversion.FullFidelityChangeFeedProcessorImpl;
import com.azure.cosmos.implementation.changefeed.epkversion.IncrementalChangeFeedProcessorImpl;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.ChangeFeedProcessorItem;
import com.azure.cosmos.models.ChangeFeedProcessorOptions;
import com.azure.cosmos.util.Beta;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.function.Consumer;

public class ChangeFeedProcessorBuilder {
    private String hostName;
    private CosmosAsyncContainer feedContainer;
    private CosmosAsyncContainer leaseContainer;
    private ChangeFeedProcessorOptions changeFeedProcessorOptions;
    private Consumer<List<JsonNode>> incrementalModeLeaseConsumer;
    private Consumer<List<ChangeFeedProcessorItem>> fullFidelityModeLeaseConsumer;
    private ChangeFeedMode changeFeedMode = ChangeFeedMode.INCREMENTAL;
    private LeaseVersion leaseVersion = LeaseVersion.PARTITION_KEY_BASED_LEASE;

    public ChangeFeedProcessorBuilder hostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public ChangeFeedProcessorBuilder feedContainer(CosmosAsyncContainer feedContainer) {
        this.feedContainer = feedContainer;
        return this;
    }

    public ChangeFeedProcessorBuilder leaseContainer(CosmosAsyncContainer leaseContainer) {
        this.leaseContainer = leaseContainer;
        return this;
    }

    public ChangeFeedProcessorBuilder handleChanges(Consumer<List<JsonNode>> consumer) {
        Preconditions.checkNotNull(consumer, "Argument 'consumer' can not be null");
        Preconditions.checkArgument(this.incrementalModeLeaseConsumer == null, "consumer has already been defined");
        this.incrementalModeLeaseConsumer = consumer;
        this.changeFeedMode = ChangeFeedMode.INCREMENTAL;
        this.leaseVersion = LeaseVersion.PARTITION_KEY_BASED_LEASE;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_37_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public ChangeFeedProcessorBuilder handleAllVersionsAndDeletesChanges(Consumer<List<ChangeFeedProcessorItem>> consumer) {
        this.fullFidelityModeLeaseConsumer = consumer;
        this.changeFeedMode = ChangeFeedMode.FULL_FIDELITY;
        this.leaseVersion = LeaseVersion.EPK_RANGE_BASED_LEASE;
        return this;
    }

    public ChangeFeedProcessorBuilder options(ChangeFeedProcessorOptions changeFeedProcessorOptions) {
        this.changeFeedProcessorOptions = changeFeedProcessorOptions;
        return this;
    }

    public ChangeFeedProcessor buildChangeFeedProcessor() {
        ChangeFeedProcessor changeFeedProcessor;
        block5: {
            block4: {
                this.validateChangeFeedProcessorBuilder();
                changeFeedProcessor = null;
                if (this.leaseVersion != LeaseVersion.EPK_RANGE_BASED_LEASE) break block4;
                switch (this.changeFeedMode) {
                    case FULL_FIDELITY: {
                        changeFeedProcessor = new FullFidelityChangeFeedProcessorImpl(this.hostName, this.feedContainer, this.leaseContainer, this.fullFidelityModeLeaseConsumer, this.changeFeedProcessorOptions);
                        break block5;
                    }
                    case INCREMENTAL: {
                        changeFeedProcessor = new IncrementalChangeFeedProcessorImpl(this.hostName, this.feedContainer, this.leaseContainer, this.incrementalModeLeaseConsumer, this.changeFeedProcessorOptions);
                        break block5;
                    }
                    default: {
                        throw new IllegalStateException("ChangeFeed mode " + (Object)((Object)this.changeFeedMode) + " is not supported");
                    }
                }
            }
            changeFeedProcessor = new com.azure.cosmos.implementation.changefeed.pkversion.IncrementalChangeFeedProcessorImpl(this.hostName, this.feedContainer, this.leaseContainer, this.incrementalModeLeaseConsumer, this.changeFeedProcessorOptions);
        }
        return changeFeedProcessor;
    }

    private void validateChangeFeedProcessorBuilder() {
        Preconditions.checkArgument(StringUtils.isNotEmpty(this.hostName), "hostName cannot be null or empty");
        Preconditions.checkNotNull(this.feedContainer, "Argument 'feedContainer' can not be null");
        Preconditions.checkNotNull(this.leaseContainer, "Argument 'leaseContainer' can not be null");
        if (this.incrementalModeLeaseConsumer == null && this.fullFidelityModeLeaseConsumer == null || this.incrementalModeLeaseConsumer != null && this.fullFidelityModeLeaseConsumer != null) {
            throw new IllegalArgumentException("expecting either LatestVersion or AllVersionsAndDeletes consumer for handling change feed processor changes");
        }
        this.validateChangeFeedProcessorOptions();
    }

    private void validateChangeFeedProcessorOptions() {
        if (this.changeFeedProcessorOptions == null) {
            return;
        }
        if (this.changeFeedProcessorOptions.getLeaseRenewInterval().compareTo(this.changeFeedProcessorOptions.getLeaseExpirationInterval()) >= 0) {
            throw new IllegalArgumentException("changeFeedProcessorOptions: expecting leaseRenewInterval less than leaseExpirationInterval");
        }
        if (ChangeFeedMode.FULL_FIDELITY.equals((Object)this.changeFeedMode)) {
            if (this.changeFeedProcessorOptions.getStartTime() != null) {
                throw new IllegalStateException("changeFeedProcessorOptions: AllVersionsAndDeletes change feed mode is not supported for startTime option.");
            }
            if (this.changeFeedProcessorOptions.isStartFromBeginning()) {
                throw new IllegalStateException("changeFeedProcessorOptions: AllVersionsAndDeletes change feed mode is not supported for startFromBeginning option.");
            }
        }
    }
}

