/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.epkversion;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.InternalObjectNode;
import com.azure.cosmos.implementation.changefeed.ChangeFeedContextClient;
import com.azure.cosmos.implementation.changefeed.Lease;
import com.azure.cosmos.implementation.changefeed.ServiceItemLeaseUpdater;
import com.azure.cosmos.implementation.changefeed.epkversion.ServiceItemLeaseV1;
import com.azure.cosmos.implementation.changefeed.exceptions.LeaseConflictException;
import com.azure.cosmos.implementation.changefeed.exceptions.LeaseLostException;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.PartitionKey;
import java.time.Instant;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

class DocumentServiceLeaseUpdaterImpl
implements ServiceItemLeaseUpdater {
    private static final Logger logger = LoggerFactory.getLogger(DocumentServiceLeaseUpdaterImpl.class);
    private static final int RETRY_COUNT_ON_CONFLICT = 5;
    private final ChangeFeedContextClient client;

    public DocumentServiceLeaseUpdaterImpl(ChangeFeedContextClient client) {
        Preconditions.checkNotNull(client, "Argument 'client' can not be null");
        this.client = client;
    }

    @Override
    public Mono<Lease> updateLease(Lease cachedLease, String itemId, PartitionKey partitionKey, CosmosItemRequestOptions requestOptions, Function<Lease, Lease> updateLease) {
        Lease localLease = updateLease.apply(cachedLease);
        if (localLease == null) {
            return Mono.empty();
        }
        localLease.setTimestamp(Instant.now());
        cachedLease.setServiceItemLease(localLease);
        return Mono.just((Object)this).flatMap(value -> this.tryReplaceLease(cachedLease, itemId, partitionKey)).map(leaseDocument -> {
            cachedLease.setServiceItemLease(ServiceItemLeaseV1.fromDocument(leaseDocument));
            return cachedLease;
        }).hasElement().flatMap(hasItems -> {
            if (hasItems.booleanValue()) {
                return Mono.just((Object)cachedLease);
            }
            return this.client.readItem(itemId, partitionKey, requestOptions, InternalObjectNode.class).onErrorResume(throwable -> {
                CosmosException ex;
                if (throwable instanceof CosmosException && Exceptions.isNotFound(ex = (CosmosException)((Object)((Object)((Object)throwable))))) {
                    logger.info("Lease with token {}: Failed to update. Lease could not be found.", (Object)cachedLease.getLeaseToken());
                    throw new LeaseLostException(cachedLease);
                }
                return Mono.error((Throwable)throwable);
            }).map(cosmosItemResponse -> {
                InternalObjectNode document = BridgeInternal.getProperties(cosmosItemResponse);
                ServiceItemLeaseV1 serverLease = ServiceItemLeaseV1.fromDocument(document);
                logger.info("Lease with token {}: Failed to update. Lease with concurrency token '{}' was updated by owner '{}' with concurrency token '{}'.", new Object[]{cachedLease.getLeaseToken(), cachedLease.getConcurrencyToken(), serverLease.getOwner(), serverLease.getConcurrencyToken()});
                if (serverLease.getOwner() != null && !serverLease.getOwner().equalsIgnoreCase(cachedLease.getOwner())) {
                    logger.info("Lease with token {}: Failed to update. Lease was acquired already by owner '{}'", (Object)serverLease.getLeaseToken(), (Object)serverLease.getOwner());
                    throw new LeaseLostException(serverLease);
                }
                cachedLease.setTimestamp(Instant.now());
                cachedLease.setConcurrencyToken(serverLease.getConcurrencyToken());
                throw new LeaseConflictException(cachedLease, "Lease update failed");
            });
        }).retryWhen((Retry)Retry.max((long)5L).filter(throwable -> {
            if (throwable instanceof LeaseConflictException) {
                logger.info("Lease with token {}: Failed to update lease with concurrency token '{}', owner '{}'; will retry", new Object[]{cachedLease.getLeaseToken(), cachedLease.getConcurrencyToken(), cachedLease.getOwner()});
                return true;
            }
            return false;
        })).onErrorResume(throwable -> {
            if (throwable instanceof LeaseConflictException) {
                logger.warn("Lease with token {}: Failed to update lease with concurrency token '{}', owner '{}', continuationToken '{}'.", new Object[]{cachedLease.getLeaseToken(), cachedLease.getConcurrencyToken(), cachedLease.getOwner(), cachedLease.getReadableContinuationToken(), throwable});
                return Mono.just((Object)cachedLease);
            }
            return Mono.error((Throwable)throwable);
        });
    }

    private Mono<InternalObjectNode> tryReplaceLease(Lease lease, String itemId, PartitionKey partitionKey) throws LeaseLostException {
        return this.client.replaceItem(itemId, partitionKey, lease, this.getCreateIfMatchOptions(lease)).map(cosmosItemResponse -> BridgeInternal.getProperties(cosmosItemResponse)).onErrorResume(re -> {
            if (re instanceof CosmosException) {
                CosmosException ex = (CosmosException)((Object)((Object)re));
                switch (ex.getStatusCode()) {
                    case 412: {
                        return Mono.empty();
                    }
                    case 409: {
                        throw new LeaseLostException(lease, (Exception)((Object)ex), false);
                    }
                    case 404: {
                        throw new LeaseLostException(lease, (Exception)((Object)ex), true);
                    }
                }
                return Mono.error((Throwable)re);
            }
            return Mono.error((Throwable)re);
        });
    }

    private CosmosItemRequestOptions getCreateIfMatchOptions(Lease lease) {
        CosmosItemRequestOptions createIfMatchOptions = new CosmosItemRequestOptions();
        createIfMatchOptions.setIfMatchETag(lease.getConcurrencyToken());
        return createIfMatchOptions;
    }
}

