/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Strings;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestConfigurations {
    private static Logger logger = LoggerFactory.getLogger(TestConfigurations.class);
    private static Properties properties = TestConfigurations.loadProperties();
    public static final String MASTER_KEY = properties.getProperty("ACCOUNT_KEY", StringUtils.defaultString(Strings.emptyToNull(System.getenv().get("ACCOUNT_KEY")), "C2y6yDjf5/R+ob0N8A7Cgv30VRDJIWEHLM+4QDU5DE2nQ9nDuVTqobD4b8mGGyPMbIZnqyMsEcaGQy67XIw/Jw=="));
    public static final String SECONDARY_MASTER_KEY = properties.getProperty("SECONDARY_ACCOUNT_KEY", StringUtils.defaultString(Strings.emptyToNull(System.getenv().get("SECONDARY_ACCOUNT_KEY")), "C2y6yDjf5/R+ob0N8A7Cgv30VRDJIWEHLM+4QDU5DE2nQ9nDuVTqobD4b8mGGyPMbIZnqyMsEcaGQy67XIw/Jw=="));
    public static final String HOST = properties.getProperty("ACCOUNT_HOST", StringUtils.defaultString(Strings.emptyToNull(System.getenv().get("ACCOUNT_HOST")), "https://localhost:443/"));
    public static final String CONSISTENCY = properties.getProperty("ACCOUNT_CONSISTENCY", StringUtils.defaultString(Strings.emptyToNull(System.getenv().get("ACCOUNT_CONSISTENCY")), "Strong"));
    public static final String PREFERRED_LOCATIONS = properties.getProperty("PREFERRED_LOCATIONS", StringUtils.defaultString(Strings.emptyToNull(System.getenv().get("PREFERRED_LOCATIONS")), null));
    public static final String MAX_RETRY_LIMIT = properties.getProperty("MAX_RETRY_LIMIT", StringUtils.defaultString(Strings.emptyToNull(System.getenv().get("MAX_RETRY_LIMIT")), "2"));
    public static final String DESIRED_CONSISTENCIES = properties.getProperty("DESIRED_CONSISTENCIES", StringUtils.defaultString(Strings.emptyToNull(System.getenv().get("DESIRED_CONSISTENCIES")), null));
    public static final String PROTOCOLS = properties.getProperty("PROTOCOLS", StringUtils.defaultString(Strings.emptyToNull(System.getenv().get("PROTOCOLS")), null));

    private static Properties loadProperties() {
        Path root = FileSystems.getDefault().getPath("", new String[0]).toAbsolutePath();
        Path propertiesInProject = Paths.get(root.toString(), "../cosmos-v4.properties");
        Properties props = TestConfigurations.loadFromPathIfExists(propertiesInProject);
        if (props != null) {
            return props;
        }
        Path propertiesInUserHome = Paths.get(System.getProperty("user.home"), "cosmos-v4.properties");
        props = TestConfigurations.loadFromPathIfExists(propertiesInUserHome);
        if (props != null) {
            return props;
        }
        return System.getProperties();
    }

    private static Properties loadFromPathIfExists(Path propertiesFilePath) {
        if (Files.exists(propertiesFilePath, new LinkOption[0])) {
            Properties properties;
            block9: {
                InputStream in = Files.newInputStream(propertiesFilePath, new OpenOption[0]);
                try {
                    Properties props = new Properties();
                    props.load(in);
                    logger.info("properties loaded from {}", (Object)propertiesFilePath);
                    properties = props;
                    if (in == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        logger.error("Loading properties {} failed", (Object)propertiesFilePath, (Object)e);
                    }
                }
                in.close();
            }
            return properties;
        }
        return null;
    }
}

