/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.SimpleTokenCache;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.DirectConnectionConfig;
import com.azure.cosmos.implementation.AadTokenAuthorizationHelper;
import com.azure.cosmos.implementation.ApiType;
import com.azure.cosmos.implementation.AsyncDocumentClient;
import com.azure.cosmos.implementation.AuthorizationTokenType;
import com.azure.cosmos.implementation.BaseAuthorizationTokenProvider;
import com.azure.cosmos.implementation.ChangeFeedQueryImpl;
import com.azure.cosmos.implementation.ClientEncryptionKey;
import com.azure.cosmos.implementation.ClientSideRequestStatistics;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.Conflict;
import com.azure.cosmos.implementation.ConnectionPolicy;
import com.azure.cosmos.implementation.CosmosClientMetadataCachesSnapshot;
import com.azure.cosmos.implementation.CosmosResourceType;
import com.azure.cosmos.implementation.Database;
import com.azure.cosmos.implementation.DatabaseAccount;
import com.azure.cosmos.implementation.DatabaseAccountManagerInternal;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.HttpConstants;
import com.azure.cosmos.implementation.IAuthorizationTokenProvider;
import com.azure.cosmos.implementation.IRetryPolicyFactory;
import com.azure.cosmos.implementation.ISessionContainer;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.InternalObjectNode;
import com.azure.cosmos.implementation.InvalidPartitionException;
import com.azure.cosmos.implementation.InvalidPartitionExceptionRetryPolicy;
import com.azure.cosmos.implementation.ItemDeserializer;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.LifeCycleUtils;
import com.azure.cosmos.implementation.MetadataDiagnosticsContext;
import com.azure.cosmos.implementation.ObservableHelper;
import com.azure.cosmos.implementation.Offer;
import com.azure.cosmos.implementation.OfferAutoscaleAutoUpgradeProperties;
import com.azure.cosmos.implementation.OfferAutoscaleSettings;
import com.azure.cosmos.implementation.OpenConnectionResponse;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PartitionKeyMismatchRetryPolicy;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.PathInfo;
import com.azure.cosmos.implementation.PathParser;
import com.azure.cosmos.implementation.PathsHelper;
import com.azure.cosmos.implementation.Permission;
import com.azure.cosmos.implementation.QueryCompatibilityMode;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.RequestVerb;
import com.azure.cosmos.implementation.ResetSessionTokenRetryPolicyFactory;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.ResourceTokenAuthorizationHelper;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RetryPolicy;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.RxGatewayStoreModel;
import com.azure.cosmos.implementation.RxStoreModel;
import com.azure.cosmos.implementation.SerializationDiagnosticsContext;
import com.azure.cosmos.implementation.SessionContainer;
import com.azure.cosmos.implementation.SqlQuerySpecLogger;
import com.azure.cosmos.implementation.StoredProcedure;
import com.azure.cosmos.implementation.StoredProcedureResponse;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Trigger;
import com.azure.cosmos.implementation.User;
import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.UserDefinedFunction;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.batch.BatchResponseParser;
import com.azure.cosmos.implementation.batch.PartitionKeyRangeServerBatchRequest;
import com.azure.cosmos.implementation.batch.ServerBatchRequest;
import com.azure.cosmos.implementation.batch.SinglePartitionKeyServerBatchRequest;
import com.azure.cosmos.implementation.caches.RxClientCollectionCache;
import com.azure.cosmos.implementation.caches.RxCollectionCache;
import com.azure.cosmos.implementation.caches.RxPartitionKeyRangeCache;
import com.azure.cosmos.implementation.clienttelemetry.ClientTelemetry;
import com.azure.cosmos.implementation.clienttelemetry.TagName;
import com.azure.cosmos.implementation.cpu.CpuMemoryListener;
import com.azure.cosmos.implementation.cpu.CpuMemoryMonitor;
import com.azure.cosmos.implementation.directconnectivity.GatewayServiceConfigurationReader;
import com.azure.cosmos.implementation.directconnectivity.GlobalAddressResolver;
import com.azure.cosmos.implementation.directconnectivity.ServerStoreModel;
import com.azure.cosmos.implementation.directconnectivity.StoreClient;
import com.azure.cosmos.implementation.directconnectivity.StoreClientFactory;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.http.HttpClient;
import com.azure.cosmos.implementation.http.HttpClientConfig;
import com.azure.cosmos.implementation.http.HttpHeaders;
import com.azure.cosmos.implementation.http.SharedGatewayHttpClient;
import com.azure.cosmos.implementation.patch.PatchUtil;
import com.azure.cosmos.implementation.query.DocumentQueryExecutionContextFactory;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.Paginator;
import com.azure.cosmos.implementation.query.PartitionedQueryExecutionInfo;
import com.azure.cosmos.implementation.query.PipelinedQueryExecutionContextBase;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.implementation.routing.CollectionRoutingMap;
import com.azure.cosmos.implementation.routing.PartitionKeyAndResourceTokenPair;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.PartitionKeyInternalHelper;
import com.azure.cosmos.implementation.routing.PartitionKeyRangeIdentity;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.implementation.spark.OperationContext;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.implementation.spark.OperationListener;
import com.azure.cosmos.implementation.throughputControl.ThroughputControlStore;
import com.azure.cosmos.implementation.throughputControl.config.ThroughputControlGroupInternal;
import com.azure.cosmos.models.CosmosAuthorizationTokenResolver;
import com.azure.cosmos.models.CosmosBatchResponse;
import com.azure.cosmos.models.CosmosChangeFeedRequestOptions;
import com.azure.cosmos.models.CosmosClientTelemetryConfig;
import com.azure.cosmos.models.CosmosItemIdentity;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosPatchOperations;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.PartitionKeyDefinition;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.concurrent.Queues;

public class RxDocumentClientImpl
implements AsyncDocumentClient,
IAuthorizationTokenProvider,
CpuMemoryListener,
DiagnosticsClientContext {
    private static final String tempMachineId = "uuid:" + UUID.randomUUID();
    private static final AtomicInteger activeClientsCnt = new AtomicInteger(0);
    private static final Map<String, Integer> clientMap = new ConcurrentHashMap<String, Integer>();
    private static final AtomicInteger clientIdGenerator = new AtomicInteger(0);
    private static final Range<String> RANGE_INCLUDING_ALL_PARTITION_KEY_RANGES = new Range<String>(PartitionKeyInternalHelper.MinimumInclusiveEffectivePartitionKey, PartitionKeyInternalHelper.MaximumExclusiveEffectivePartitionKey, true, false);
    private static final String DUMMY_SQL_QUERY = "this is dummy and only used in creating ParallelDocumentQueryExecutioncontext, but not used";
    private static final ObjectMapper mapper = Utils.getSimpleObjectMapper();
    private final ItemDeserializer itemDeserializer = new ItemDeserializer.JsonDeserializer();
    private static final Logger logger = LoggerFactory.getLogger(RxDocumentClientImpl.class);
    private final String masterKeyOrResourceToken;
    private final URI serviceEndpoint;
    private final ConnectionPolicy connectionPolicy;
    private final ConsistencyLevel consistencyLevel;
    private final BaseAuthorizationTokenProvider authorizationTokenProvider;
    private final UserAgentContainer userAgentContainer;
    private final boolean hasAuthKeyResourceToken;
    private final Configs configs;
    private final boolean connectionSharingAcrossClientsEnabled;
    private AzureKeyCredential credential;
    private final TokenCredential tokenCredential;
    private String[] tokenCredentialScopes;
    private SimpleTokenCache tokenCredentialCache;
    private CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver;
    AuthorizationTokenType authorizationTokenType;
    private SessionContainer sessionContainer;
    private String firstResourceTokenFromPermissionFeed = "";
    private RxClientCollectionCache collectionCache;
    private RxGatewayStoreModel gatewayProxy;
    private RxStoreModel storeModel;
    private GlobalAddressResolver addressResolver;
    private RxPartitionKeyRangeCache partitionKeyRangeCache;
    private Map<String, List<PartitionKeyAndResourceTokenPair>> resourceTokensMap;
    private final boolean contentResponseOnWriteEnabled;
    private Map<String, PartitionedQueryExecutionInfo> queryPlanCache;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final int clientId;
    private ClientTelemetry clientTelemetry;
    private ApiType apiType;
    private IRetryPolicyFactory resetSessionTokenRetryPolicy;
    private final QueryCompatibilityMode queryCompatibilityMode = QueryCompatibilityMode.Default;
    private final GlobalEndpointManager globalEndpointManager;
    private final RetryPolicy retryPolicy;
    private HttpClient reactorHttpClient;
    private Function<HttpClient, HttpClient> httpClientInterceptor;
    private volatile boolean useMultipleWriteLocations;
    private StoreClientFactory storeClientFactory;
    private GatewayServiceConfigurationReader gatewayConfigurationReader;
    private final DiagnosticsClientContext.DiagnosticsClientConfig diagnosticsClientConfig;
    private final AtomicBoolean throughputControlEnabled;
    private ThroughputControlStore throughputControlStore;
    private final CosmosClientTelemetryConfig clientTelemetryConfig;
    private final String clientCorrelationId;
    private final EnumSet<TagName> metricTagNames;

    public RxDocumentClientImpl(URI serviceEndpoint, String masterKeyOrResourceToken, List<Permission> permissionFeed, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, Configs configs, CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver, AzureKeyCredential credential, boolean sessionCapturingOverride, boolean connectionSharingAcrossClientsEnabled, boolean contentResponseOnWriteEnabled, CosmosClientMetadataCachesSnapshot metadataCachesSnapshot, ApiType apiType, CosmosClientTelemetryConfig clientTelemetryConfig, String clientCorrelationId, EnumSet<TagName> tagNames) {
        this(serviceEndpoint, masterKeyOrResourceToken, permissionFeed, connectionPolicy, consistencyLevel, configs, credential, null, sessionCapturingOverride, connectionSharingAcrossClientsEnabled, contentResponseOnWriteEnabled, metadataCachesSnapshot, apiType, clientTelemetryConfig, clientCorrelationId, tagNames);
        this.cosmosAuthorizationTokenResolver = cosmosAuthorizationTokenResolver;
    }

    public RxDocumentClientImpl(URI serviceEndpoint, String masterKeyOrResourceToken, List<Permission> permissionFeed, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, Configs configs, CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver, AzureKeyCredential credential, TokenCredential tokenCredential, boolean sessionCapturingOverride, boolean connectionSharingAcrossClientsEnabled, boolean contentResponseOnWriteEnabled, CosmosClientMetadataCachesSnapshot metadataCachesSnapshot, ApiType apiType, CosmosClientTelemetryConfig clientTelemetryConfig, String clientCorrelationId, EnumSet<TagName> tagNames) {
        this(serviceEndpoint, masterKeyOrResourceToken, permissionFeed, connectionPolicy, consistencyLevel, configs, credential, tokenCredential, sessionCapturingOverride, connectionSharingAcrossClientsEnabled, contentResponseOnWriteEnabled, metadataCachesSnapshot, apiType, clientTelemetryConfig, clientCorrelationId, tagNames);
        this.cosmosAuthorizationTokenResolver = cosmosAuthorizationTokenResolver;
    }

    private RxDocumentClientImpl(URI serviceEndpoint, String masterKeyOrResourceToken, List<Permission> permissionFeed, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, Configs configs, AzureKeyCredential credential, TokenCredential tokenCredential, boolean sessionCapturingOverrideEnabled, boolean connectionSharingAcrossClientsEnabled, boolean contentResponseOnWriteEnabled, CosmosClientMetadataCachesSnapshot metadataCachesSnapshot, ApiType apiType, CosmosClientTelemetryConfig clientTelemetryConfig, String clientCorrelationId, EnumSet<TagName> tagNames) {
        this(serviceEndpoint, masterKeyOrResourceToken, connectionPolicy, consistencyLevel, configs, credential, tokenCredential, sessionCapturingOverrideEnabled, connectionSharingAcrossClientsEnabled, contentResponseOnWriteEnabled, metadataCachesSnapshot, apiType, clientTelemetryConfig, clientCorrelationId, tagNames);
        if (permissionFeed != null && permissionFeed.size() > 0) {
            this.resourceTokensMap = new HashMap<String, List<PartitionKeyAndResourceTokenPair>>();
            for (Permission permission : permissionFeed) {
                PartitionKey partitionKey;
                String[] segments = StringUtils.split(permission.getResourceLink(), "/".charAt(0));
                if (segments.length <= 0) {
                    throw new IllegalArgumentException("resourceLink");
                }
                List<PartitionKeyAndResourceTokenPair> partitionKeyAndResourceTokenPairs = null;
                PathInfo pathInfo = new PathInfo(false, "", "", false);
                if (!PathsHelper.tryParsePathSegments(permission.getResourceLink(), pathInfo, null)) {
                    throw new IllegalArgumentException(permission.getResourceLink());
                }
                partitionKeyAndResourceTokenPairs = this.resourceTokensMap.get(pathInfo.resourceIdOrFullName);
                if (partitionKeyAndResourceTokenPairs == null) {
                    partitionKeyAndResourceTokenPairs = new ArrayList<PartitionKeyAndResourceTokenPair>();
                    this.resourceTokensMap.put(pathInfo.resourceIdOrFullName, partitionKeyAndResourceTokenPairs);
                }
                partitionKeyAndResourceTokenPairs.add(new PartitionKeyAndResourceTokenPair((partitionKey = permission.getResourcePartitionKey()) != null ? BridgeInternal.getPartitionKeyInternal(partitionKey) : PartitionKeyInternal.Empty, permission.getToken()));
                logger.debug("Initializing resource token map  , with map key [{}] , partition key [{}] and resource token [{}]", new Object[]{pathInfo.resourceIdOrFullName, partitionKey != null ? partitionKey.toString() : null, permission.getToken()});
            }
            if (this.resourceTokensMap.isEmpty()) {
                throw new IllegalArgumentException("permissionFeed");
            }
            String firstToken = permissionFeed.get(0).getToken();
            if (ResourceTokenAuthorizationHelper.isResourceToken(firstToken)) {
                this.firstResourceTokenFromPermissionFeed = firstToken;
            }
        }
    }

    RxDocumentClientImpl(URI serviceEndpoint, String masterKeyOrResourceToken, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, Configs configs, AzureKeyCredential credential, TokenCredential tokenCredential, boolean sessionCapturingOverrideEnabled, boolean connectionSharingAcrossClientsEnabled, boolean contentResponseOnWriteEnabled, CosmosClientMetadataCachesSnapshot metadataCachesSnapshot, ApiType apiType, CosmosClientTelemetryConfig clientTelemetryConfig, String clientCorrelationId, EnumSet<TagName> tagNames) {
        assert (clientTelemetryConfig != null);
        Boolean clientTelemetryEnabled = ImplementationBridgeHelpers.CosmosClientTelemetryConfigHelper.getCosmosClientTelemetryConfigAccessor().isSendClientTelemetryToServiceEnabled(clientTelemetryConfig);
        assert (clientTelemetryEnabled != null);
        activeClientsCnt.incrementAndGet();
        this.clientId = clientIdGenerator.incrementAndGet();
        this.clientCorrelationId = Strings.isNullOrWhiteSpace(clientCorrelationId) ? String.format("%05d", this.clientId) : clientCorrelationId;
        this.metricTagNames = tagNames;
        clientMap.put(serviceEndpoint.toString(), clientMap.getOrDefault(serviceEndpoint.toString(), 0) + 1);
        this.diagnosticsClientConfig = new DiagnosticsClientContext.DiagnosticsClientConfig();
        this.diagnosticsClientConfig.withClientId(this.clientId);
        this.diagnosticsClientConfig.withActiveClientCounter(activeClientsCnt);
        this.diagnosticsClientConfig.withClientMap(clientMap);
        this.diagnosticsClientConfig.withConnectionSharingAcrossClientsEnabled(connectionSharingAcrossClientsEnabled);
        this.diagnosticsClientConfig.withConsistency(consistencyLevel);
        this.throughputControlEnabled = new AtomicBoolean(false);
        logger.info("Initializing DocumentClient [{}] with serviceEndpoint [{}], connectionPolicy [{}], consistencyLevel [{}], directModeProtocol [{}]", new Object[]{this.clientId, serviceEndpoint, connectionPolicy, consistencyLevel, configs.getProtocol()});
        try {
            this.connectionSharingAcrossClientsEnabled = connectionSharingAcrossClientsEnabled;
            this.configs = configs;
            this.masterKeyOrResourceToken = masterKeyOrResourceToken;
            this.serviceEndpoint = serviceEndpoint;
            this.credential = credential;
            this.tokenCredential = tokenCredential;
            this.contentResponseOnWriteEnabled = contentResponseOnWriteEnabled;
            this.authorizationTokenType = AuthorizationTokenType.Invalid;
            if (this.credential != null) {
                this.hasAuthKeyResourceToken = false;
                this.authorizationTokenType = AuthorizationTokenType.PrimaryMasterKey;
                this.authorizationTokenProvider = new BaseAuthorizationTokenProvider(this.credential);
            } else if (masterKeyOrResourceToken != null && ResourceTokenAuthorizationHelper.isResourceToken(masterKeyOrResourceToken)) {
                this.authorizationTokenProvider = null;
                this.hasAuthKeyResourceToken = true;
                this.authorizationTokenType = AuthorizationTokenType.ResourceToken;
            } else if (masterKeyOrResourceToken != null && !ResourceTokenAuthorizationHelper.isResourceToken(masterKeyOrResourceToken)) {
                this.credential = new AzureKeyCredential(this.masterKeyOrResourceToken);
                this.hasAuthKeyResourceToken = false;
                this.authorizationTokenType = AuthorizationTokenType.PrimaryMasterKey;
                this.authorizationTokenProvider = new BaseAuthorizationTokenProvider(this.credential);
            } else {
                this.hasAuthKeyResourceToken = false;
                this.authorizationTokenProvider = null;
                if (tokenCredential != null) {
                    this.tokenCredentialScopes = new String[]{serviceEndpoint.getScheme() + "://" + serviceEndpoint.getHost() + "/.default"};
                    this.tokenCredentialCache = new SimpleTokenCache(() -> this.tokenCredential.getToken(new TokenRequestContext().addScopes(this.tokenCredentialScopes)));
                    this.authorizationTokenType = AuthorizationTokenType.AadToken;
                }
            }
            this.connectionPolicy = connectionPolicy != null ? connectionPolicy : new ConnectionPolicy(DirectConnectionConfig.getDefaultConfig());
            this.diagnosticsClientConfig.withConnectionMode(this.getConnectionPolicy().getConnectionMode());
            this.diagnosticsClientConfig.withMultipleWriteRegionsEnabled(this.connectionPolicy.isMultipleWriteRegionsEnabled());
            this.diagnosticsClientConfig.withEndpointDiscoveryEnabled(this.connectionPolicy.isEndpointDiscoveryEnabled());
            this.diagnosticsClientConfig.withPreferredRegions(this.connectionPolicy.getPreferredRegions());
            this.diagnosticsClientConfig.withMachineId(tempMachineId);
            boolean disableSessionCapturing = ConsistencyLevel.SESSION != consistencyLevel && !sessionCapturingOverrideEnabled;
            this.sessionContainer = new SessionContainer(this.serviceEndpoint.getHost(), disableSessionCapturing);
            this.consistencyLevel = consistencyLevel;
            this.userAgentContainer = new UserAgentContainer();
            String userAgentSuffix = this.connectionPolicy.getUserAgentSuffix();
            if (userAgentSuffix != null && userAgentSuffix.length() > 0) {
                this.userAgentContainer.setSuffix(userAgentSuffix);
            }
            this.httpClientInterceptor = null;
            this.reactorHttpClient = this.httpClient();
            this.globalEndpointManager = new GlobalEndpointManager(this.asDatabaseAccountManagerInternal(), this.connectionPolicy, configs);
            this.retryPolicy = new RetryPolicy(this, this.globalEndpointManager, this.connectionPolicy);
            this.resetSessionTokenRetryPolicy = this.retryPolicy;
            CpuMemoryMonitor.register(this);
            this.queryPlanCache = new ConcurrentHashMap<String, PartitionedQueryExecutionInfo>();
            this.apiType = apiType;
            this.clientTelemetryConfig = clientTelemetryConfig;
        }
        catch (RuntimeException e) {
            logger.error("unexpected failure in initializing client.", (Throwable)e);
            this.close();
            throw e;
        }
    }

    @Override
    public DiagnosticsClientContext.DiagnosticsClientConfig getConfig() {
        return this.diagnosticsClientConfig;
    }

    @Override
    public CosmosDiagnostics createDiagnostics() {
        return BridgeInternal.createCosmosDiagnostics(this);
    }

    private void initializeGatewayConfigurationReader() {
        this.gatewayConfigurationReader = new GatewayServiceConfigurationReader(this.globalEndpointManager);
        DatabaseAccount databaseAccount = this.globalEndpointManager.getLatestDatabaseAccount();
        if (databaseAccount == null) {
            logger.error("Client initialization failed. Check if the endpoint is reachable and if your auth token is valid. More info: https://aka.ms/cosmosdb-tsg-service-unavailable-java");
            throw new RuntimeException("Client initialization failed. Check if the endpoint is reachable and if your auth token is valid. More info: https://aka.ms/cosmosdb-tsg-service-unavailable-java");
        }
        this.useMultipleWriteLocations = this.connectionPolicy.isMultipleWriteRegionsEnabled() && BridgeInternal.isEnableMultipleWriteLocations(databaseAccount);
    }

    private void updateGatewayProxy() {
        this.gatewayProxy.setGatewayServiceConfigurationReader(this.gatewayConfigurationReader);
        this.gatewayProxy.setCollectionCache(this.collectionCache);
        this.gatewayProxy.setPartitionKeyRangeCache(this.partitionKeyRangeCache);
        this.gatewayProxy.setUseMultipleWriteLocations(this.useMultipleWriteLocations);
    }

    public void init(CosmosClientMetadataCachesSnapshot metadataCachesSnapshot, Function<HttpClient, HttpClient> httpClientInterceptor) {
        try {
            this.httpClientInterceptor = httpClientInterceptor;
            if (httpClientInterceptor != null) {
                this.reactorHttpClient = httpClientInterceptor.apply(this.httpClient());
            }
            this.gatewayProxy = this.createRxGatewayProxy(this.sessionContainer, this.consistencyLevel, this.queryCompatibilityMode, this.userAgentContainer, this.globalEndpointManager, this.reactorHttpClient, this.apiType);
            this.globalEndpointManager.init();
            this.initializeGatewayConfigurationReader();
            this.collectionCache = metadataCachesSnapshot != null ? new RxClientCollectionCache(this, this.sessionContainer, this.gatewayProxy, this, this.retryPolicy, metadataCachesSnapshot.getCollectionInfoByNameCache(), metadataCachesSnapshot.getCollectionInfoByIdCache()) : new RxClientCollectionCache(this, this.sessionContainer, this.gatewayProxy, this, this.retryPolicy);
            this.resetSessionTokenRetryPolicy = new ResetSessionTokenRetryPolicyFactory(this.sessionContainer, this.collectionCache, this.retryPolicy);
            this.partitionKeyRangeCache = new RxPartitionKeyRangeCache(this, this.collectionCache);
            this.updateGatewayProxy();
            this.clientTelemetry = new ClientTelemetry(this, null, UUID.randomUUID().toString(), ManagementFactory.getRuntimeMXBean().getName(), this.userAgentContainer.getUserAgent(), this.connectionPolicy.getConnectionMode(), this.globalEndpointManager.getLatestDatabaseAccount().getId(), null, null, this.configs, this.clientTelemetryConfig, this, this.connectionPolicy.getPreferredRegions());
            this.clientTelemetry.init();
            if (this.connectionPolicy.getConnectionMode() == ConnectionMode.GATEWAY) {
                this.storeModel = this.gatewayProxy;
            } else {
                this.initializeDirectConnectivity();
            }
            this.retryPolicy.setRxCollectionCache(this.collectionCache);
        }
        catch (Exception e) {
            logger.error("unexpected failure in initializing client.", (Throwable)e);
            this.close();
            throw e;
        }
    }

    public void serialize(CosmosClientMetadataCachesSnapshot state) {
        RxCollectionCache.serialize(state, this.collectionCache);
    }

    private void initializeDirectConnectivity() {
        this.addressResolver = new GlobalAddressResolver(this, this.reactorHttpClient, this.globalEndpointManager, this.configs.getProtocol(), this, this.collectionCache, this.partitionKeyRangeCache, this.userAgentContainer, null, this.connectionPolicy, this.apiType);
        this.storeClientFactory = new StoreClientFactory(this.addressResolver, this.diagnosticsClientConfig, this.configs, this.connectionPolicy, this.userAgentContainer, this.connectionSharingAcrossClientsEnabled, this.clientTelemetry, this.globalEndpointManager);
        this.createStoreModel(true);
    }

    DatabaseAccountManagerInternal asDatabaseAccountManagerInternal() {
        return new DatabaseAccountManagerInternal(){

            @Override
            public URI getServiceEndpoint() {
                return RxDocumentClientImpl.this.getServiceEndpoint();
            }

            @Override
            public Flux<DatabaseAccount> getDatabaseAccountFromEndpoint(URI endpoint) {
                logger.info("Getting database account endpoint from {}", (Object)endpoint);
                return RxDocumentClientImpl.this.getDatabaseAccountFromEndpoint(endpoint);
            }

            @Override
            public ConnectionPolicy getConnectionPolicy() {
                return RxDocumentClientImpl.this.getConnectionPolicy();
            }
        };
    }

    RxGatewayStoreModel createRxGatewayProxy(ISessionContainer sessionContainer, ConsistencyLevel consistencyLevel, QueryCompatibilityMode queryCompatibilityMode, UserAgentContainer userAgentContainer, GlobalEndpointManager globalEndpointManager, HttpClient httpClient, ApiType apiType) {
        return new RxGatewayStoreModel(this, sessionContainer, consistencyLevel, queryCompatibilityMode, userAgentContainer, globalEndpointManager, httpClient, apiType);
    }

    private HttpClient httpClient() {
        HttpClientConfig httpClientConfig = new HttpClientConfig(this.configs).withMaxIdleConnectionTimeout(this.connectionPolicy.getIdleHttpConnectionTimeout()).withPoolSize(this.connectionPolicy.getMaxConnectionPoolSize()).withProxy(this.connectionPolicy.getProxy()).withNetworkRequestTimeout(this.connectionPolicy.getHttpNetworkRequestTimeout());
        if (this.connectionSharingAcrossClientsEnabled) {
            return SharedGatewayHttpClient.getOrCreateInstance(httpClientConfig, this.diagnosticsClientConfig);
        }
        this.diagnosticsClientConfig.withGatewayHttpClientConfig(httpClientConfig.toDiagnosticsString());
        return HttpClient.createFixed(httpClientConfig);
    }

    private void createStoreModel(boolean subscribeRntbdStatus) {
        StoreClient storeClient = this.storeClientFactory.createStoreClient(this, this.addressResolver, this.sessionContainer, this.gatewayConfigurationReader, this, this.useMultipleWriteLocations);
        this.storeModel = new ServerStoreModel(storeClient);
    }

    @Override
    public URI getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    @Override
    public URI getWriteEndpoint() {
        return this.globalEndpointManager.getWriteEndpoints().stream().findFirst().orElse(null);
    }

    @Override
    public URI getReadEndpoint() {
        return this.globalEndpointManager.getReadEndpoints().stream().findFirst().orElse(null);
    }

    @Override
    public ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    @Override
    public boolean isContentResponseOnWriteEnabled() {
        return this.contentResponseOnWriteEnabled;
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    @Override
    public ClientTelemetry getClientTelemetry() {
        return this.clientTelemetry;
    }

    @Override
    public String getClientCorrelationId() {
        return this.clientCorrelationId;
    }

    @Override
    public String getMachineId() {
        if (this.diagnosticsClientConfig == null) {
            return null;
        }
        return this.diagnosticsClientConfig.getMachineId();
    }

    @Override
    public Mono<ResourceResponse<Database>> createDatabase(Database database, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createDatabaseInternal(database, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Database>> createDatabaseInternal(Database database, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            SerializationDiagnosticsContext serializationDiagnosticsContext;
            if (database == null) {
                throw new IllegalArgumentException("Database");
            }
            logger.debug("Creating a Database. id: [{}]", (Object)database.getId());
            RxDocumentClientImpl.validateResource(database);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Database, OperationType.Create);
            Instant serializationStartTimeUTC = Instant.now();
            ByteBuffer byteBuffer = ModelBridgeInternal.serializeJsonToByteBuffer(database);
            Instant serializationEndTimeUTC = Instant.now();
            SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTimeUTC, serializationEndTimeUTC, SerializationDiagnosticsContext.SerializationType.DATABASE_SERIALIZATION);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Create, ResourceType.Database, "/dbs", byteBuffer, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            if ((serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics)) != null) {
                serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
            }
            return this.create(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, Database.class));
        }
        catch (Exception e) {
            logger.debug("Failure in creating a database. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Database>> deleteDatabase(String databaseLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteDatabaseInternal(databaseLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Database>> deleteDatabaseInternal(String databaseLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(databaseLink)) {
                throw new IllegalArgumentException("databaseLink");
            }
            logger.debug("Deleting a Database. databaseLink: [{}]", (Object)databaseLink);
            String path = Utils.joinPath(databaseLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Database, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Delete, ResourceType.Database, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, Database.class));
        }
        catch (Exception e) {
            logger.debug("Failure in deleting a database. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Database>> readDatabase(String databaseLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readDatabaseInternal(databaseLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Database>> readDatabaseInternal(String databaseLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(databaseLink)) {
                throw new IllegalArgumentException("databaseLink");
            }
            logger.debug("Reading a Database. databaseLink: [{}]", (Object)databaseLink);
            String path = Utils.joinPath(databaseLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Database, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.Database, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Database.class));
        }
        catch (Exception e) {
            logger.debug("Failure in reading a database. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Database>> readDatabases(CosmosQueryRequestOptions options) {
        return this.readFeed(options, ResourceType.Database, Database.class, "/dbs");
    }

    private String parentResourceLinkToQueryLink(String parentResourceLink, ResourceType resourceTypeEnum) {
        switch (resourceTypeEnum) {
            case Database: {
                return "/dbs";
            }
            case DocumentCollection: {
                return Utils.joinPath(parentResourceLink, "colls");
            }
            case Document: {
                return Utils.joinPath(parentResourceLink, "docs");
            }
            case Offer: {
                return "/offers/";
            }
            case User: {
                return Utils.joinPath(parentResourceLink, "users");
            }
            case ClientEncryptionKey: {
                return Utils.joinPath(parentResourceLink, "clientencryptionkeys");
            }
            case Permission: {
                return Utils.joinPath(parentResourceLink, "permissions");
            }
            case Attachment: {
                return Utils.joinPath(parentResourceLink, "attachments");
            }
            case StoredProcedure: {
                return Utils.joinPath(parentResourceLink, "sprocs");
            }
            case Trigger: {
                return Utils.joinPath(parentResourceLink, "triggers");
            }
            case UserDefinedFunction: {
                return Utils.joinPath(parentResourceLink, "udfs");
            }
            case Conflict: {
                return Utils.joinPath(parentResourceLink, "conflicts");
            }
        }
        throw new IllegalArgumentException("resource type not supported");
    }

    private OperationContextAndListenerTuple getOperationContextAndListenerTuple(CosmosQueryRequestOptions options) {
        if (options == null) {
            return null;
        }
        return ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().getOperationContext(options);
    }

    private OperationContextAndListenerTuple getOperationContextAndListenerTuple(RequestOptions options) {
        if (options == null) {
            return null;
        }
        return options.getOperationContextAndListenerTuple();
    }

    private <T> Flux<FeedResponse<T>> createQuery(String parentResourceLink, SqlQuerySpec sqlQuery, CosmosQueryRequestOptions options, Class<T> klass, ResourceType resourceTypeEnum) {
        String resourceLink = this.parentResourceLinkToQueryLink(parentResourceLink, resourceTypeEnum);
        UUID correlationActivityIdOfRequestOptions = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().getCorrelationActivityId(options);
        UUID correlationActivityId = correlationActivityIdOfRequestOptions != null ? correlationActivityIdOfRequestOptions : Utils.randomUUID();
        IDocumentQueryClient queryClient = this.documentQueryClientImpl(this, this.getOperationContextAndListenerTuple(options));
        InvalidPartitionExceptionRetryPolicy invalidPartitionExceptionRetryPolicy = new InvalidPartitionExceptionRetryPolicy(this.collectionCache, null, resourceLink, ModelBridgeInternal.getPropertiesFromQueryRequestOptions(options));
        return ObservableHelper.fluxInlineIfPossibleAsObs(() -> this.createQueryInternal(resourceLink, sqlQuery, options, klass, resourceTypeEnum, queryClient, correlationActivityId), invalidPartitionExceptionRetryPolicy);
    }

    private <T> Flux<FeedResponse<T>> createQueryInternal(String resourceLink, SqlQuerySpec sqlQuery, CosmosQueryRequestOptions options, Class<T> klass, ResourceType resourceTypeEnum, IDocumentQueryClient queryClient, UUID activityId) {
        Flux<IDocumentQueryExecutionContext<T>> executionContext = DocumentQueryExecutionContextFactory.createDocumentQueryExecutionContextAsync(this, queryClient, resourceTypeEnum, klass, sqlQuery, options, resourceLink, false, activityId, Configs.isQueryPlanCachingEnabled(), this.queryPlanCache);
        AtomicBoolean isFirstResponse = new AtomicBoolean(true);
        return executionContext.flatMap(iDocumentQueryExecutionContext -> {
            QueryInfo queryInfo = null;
            if (iDocumentQueryExecutionContext instanceof PipelinedQueryExecutionContextBase) {
                queryInfo = ((PipelinedQueryExecutionContextBase)iDocumentQueryExecutionContext).getQueryInfo();
            }
            QueryInfo finalQueryInfo = queryInfo;
            return iDocumentQueryExecutionContext.executeAsync().map(tFeedResponse -> {
                if (finalQueryInfo != null) {
                    if (finalQueryInfo.hasSelectValue()) {
                        ModelBridgeInternal.addQueryInfoToFeedResponse(tFeedResponse, finalQueryInfo);
                    }
                    if (isFirstResponse.compareAndSet(true, false)) {
                        ModelBridgeInternal.addQueryPlanDiagnosticsContextToFeedResponse(tFeedResponse, finalQueryInfo.getQueryPlanDiagnosticsContext());
                    }
                }
                return tFeedResponse;
            });
        }, Queues.SMALL_BUFFER_SIZE, 1);
    }

    @Override
    public Flux<FeedResponse<Database>> queryDatabases(String query, CosmosQueryRequestOptions options) {
        return this.queryDatabases(new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<Database>> queryDatabases(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery("/dbs", querySpec, options, Database.class, ResourceType.Database);
    }

    @Override
    public Mono<ResourceResponse<DocumentCollection>> createCollection(String databaseLink, DocumentCollection collection, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createCollectionInternal(databaseLink, collection, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<DocumentCollection>> createCollectionInternal(String databaseLink, DocumentCollection collection, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            SerializationDiagnosticsContext serializationDiagnosticsContext;
            if (StringUtils.isEmpty(databaseLink)) {
                throw new IllegalArgumentException("databaseLink");
            }
            if (collection == null) {
                throw new IllegalArgumentException("collection");
            }
            logger.debug("Creating a Collection. databaseLink: [{}], Collection id: [{}]", (Object)databaseLink, (Object)collection.getId());
            RxDocumentClientImpl.validateResource(collection);
            String path = Utils.joinPath(databaseLink, "colls");
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.DocumentCollection, OperationType.Create);
            Instant serializationStartTimeUTC = Instant.now();
            ByteBuffer byteBuffer = ModelBridgeInternal.serializeJsonToByteBuffer(collection);
            Instant serializationEndTimeUTC = Instant.now();
            SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTimeUTC, serializationEndTimeUTC, SerializationDiagnosticsContext.SerializationType.CONTAINER_SERIALIZATION);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Create, ResourceType.DocumentCollection, path, byteBuffer, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            if ((serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics)) != null) {
                serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
            }
            return this.create(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, DocumentCollection.class)).doOnNext(resourceResponse -> this.sessionContainer.setSessionToken(((DocumentCollection)resourceResponse.getResource()).getResourceId(), BridgeInternal.getAltLink(resourceResponse.getResource()), resourceResponse.getResponseHeaders()));
        }
        catch (Exception e) {
            logger.debug("Failure in creating a collection. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<DocumentCollection>> replaceCollection(DocumentCollection collection, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceCollectionInternal(collection, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<DocumentCollection>> replaceCollectionInternal(DocumentCollection collection, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            SerializationDiagnosticsContext serializationDiagnosticsContext;
            if (collection == null) {
                throw new IllegalArgumentException("collection");
            }
            logger.debug("Replacing a Collection. id: [{}]", (Object)collection.getId());
            RxDocumentClientImpl.validateResource(collection);
            String path = Utils.joinPath(collection.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.DocumentCollection, OperationType.Replace);
            Instant serializationStartTimeUTC = Instant.now();
            ByteBuffer byteBuffer = ModelBridgeInternal.serializeJsonToByteBuffer(collection);
            Instant serializationEndTimeUTC = Instant.now();
            SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTimeUTC, serializationEndTimeUTC, SerializationDiagnosticsContext.SerializationType.CONTAINER_SERIALIZATION);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Replace, ResourceType.DocumentCollection, path, byteBuffer, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            if ((serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics)) != null) {
                serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, DocumentCollection.class)).doOnNext(resourceResponse -> {
                if (resourceResponse.getResource() != null) {
                    this.sessionContainer.setSessionToken(((DocumentCollection)resourceResponse.getResource()).getResourceId(), BridgeInternal.getAltLink(resourceResponse.getResource()), resourceResponse.getResponseHeaders());
                }
            });
        }
        catch (Exception e) {
            logger.debug("Failure in replacing a collection. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<DocumentCollection>> deleteCollection(String collectionLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteCollectionInternal(collectionLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<DocumentCollection>> deleteCollectionInternal(String collectionLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(collectionLink)) {
                throw new IllegalArgumentException("collectionLink");
            }
            logger.debug("Deleting a Collection. collectionLink: [{}]", (Object)collectionLink);
            String path = Utils.joinPath(collectionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.DocumentCollection, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Delete, ResourceType.DocumentCollection, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, DocumentCollection.class));
        }
        catch (Exception e) {
            logger.debug("Failure in deleting a collection, due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    private Mono<RxDocumentServiceResponse> delete(RxDocumentServiceRequest request, DocumentClientRetryPolicy documentClientRetryPolicy, OperationContextAndListenerTuple operationContextAndListenerTuple) {
        return this.populateHeadersAsync(request, RequestVerb.DELETE).flatMap(requestPopulated -> {
            if (documentClientRetryPolicy.getRetryContext() != null && documentClientRetryPolicy.getRetryContext().getRetryCount() > 0) {
                documentClientRetryPolicy.getRetryContext().updateEndTime();
            }
            return this.getStoreProxy((RxDocumentServiceRequest)requestPopulated).processMessage((RxDocumentServiceRequest)requestPopulated, operationContextAndListenerTuple);
        });
    }

    private Mono<RxDocumentServiceResponse> deleteAllItemsByPartitionKey(RxDocumentServiceRequest request, DocumentClientRetryPolicy documentClientRetryPolicy, OperationContextAndListenerTuple operationContextAndListenerTuple) {
        return this.populateHeadersAsync(request, RequestVerb.POST).flatMap(requestPopulated -> {
            RxStoreModel storeProxy = this.getStoreProxy((RxDocumentServiceRequest)requestPopulated);
            if (documentClientRetryPolicy.getRetryContext() != null && documentClientRetryPolicy.getRetryContext().getRetryCount() > 0) {
                documentClientRetryPolicy.getRetryContext().updateEndTime();
            }
            return storeProxy.processMessage((RxDocumentServiceRequest)requestPopulated, operationContextAndListenerTuple);
        });
    }

    private Mono<RxDocumentServiceResponse> read(RxDocumentServiceRequest request, DocumentClientRetryPolicy documentClientRetryPolicy) {
        return this.populateHeadersAsync(request, RequestVerb.GET).flatMap(requestPopulated -> {
            if (documentClientRetryPolicy.getRetryContext() != null && documentClientRetryPolicy.getRetryContext().getRetryCount() > 0) {
                documentClientRetryPolicy.getRetryContext().updateEndTime();
            }
            return this.getStoreProxy((RxDocumentServiceRequest)requestPopulated).processMessage((RxDocumentServiceRequest)requestPopulated);
        });
    }

    Mono<RxDocumentServiceResponse> readFeed(RxDocumentServiceRequest request) {
        return this.populateHeadersAsync(request, RequestVerb.GET).flatMap(requestPopulated -> this.getStoreProxy((RxDocumentServiceRequest)requestPopulated).processMessage((RxDocumentServiceRequest)requestPopulated));
    }

    private Mono<RxDocumentServiceResponse> query(RxDocumentServiceRequest request) {
        return this.populateHeadersAsync(request, RequestVerb.POST).flatMap(requestPopulated -> this.getStoreProxy((RxDocumentServiceRequest)requestPopulated).processMessage((RxDocumentServiceRequest)requestPopulated).map(response -> {
            this.captureSessionToken((RxDocumentServiceRequest)requestPopulated, (RxDocumentServiceResponse)response);
            return response;
        }));
    }

    @Override
    public Mono<ResourceResponse<DocumentCollection>> readCollection(String collectionLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readCollectionInternal(collectionLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<DocumentCollection>> readCollectionInternal(String collectionLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(collectionLink)) {
                throw new IllegalArgumentException("collectionLink");
            }
            logger.debug("Reading a Collection. collectionLink: [{}]", (Object)collectionLink);
            String path = Utils.joinPath(collectionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.DocumentCollection, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.DocumentCollection, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, DocumentCollection.class));
        }
        catch (Exception e) {
            logger.debug("Failure in reading a collection, due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<DocumentCollection>> readCollections(String databaseLink, CosmosQueryRequestOptions options) {
        if (StringUtils.isEmpty(databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        return this.readFeed(options, ResourceType.DocumentCollection, DocumentCollection.class, Utils.joinPath(databaseLink, "colls"));
    }

    @Override
    public Flux<FeedResponse<DocumentCollection>> queryCollections(String databaseLink, String query, CosmosQueryRequestOptions options) {
        return this.createQuery(databaseLink, new SqlQuerySpec(query), options, DocumentCollection.class, ResourceType.DocumentCollection);
    }

    @Override
    public Flux<FeedResponse<DocumentCollection>> queryCollections(String databaseLink, SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery(databaseLink, querySpec, options, DocumentCollection.class, ResourceType.DocumentCollection);
    }

    private static String serializeProcedureParams(List<Object> objectArray) {
        Object[] stringArray = new String[objectArray.size()];
        for (int i = 0; i < objectArray.size(); ++i) {
            Object object = objectArray.get(i);
            if (object instanceof JsonSerializable) {
                stringArray[i] = ModelBridgeInternal.toJsonFromJsonSerializable((JsonSerializable)object);
                continue;
            }
            try {
                stringArray[i] = mapper.writeValueAsString(object);
                continue;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't serialize the object into the json string", e);
            }
        }
        return String.format("[%s]", StringUtils.join(stringArray, ","));
    }

    private static void validateResource(Resource resource) {
        if (!StringUtils.isEmpty(resource.getId())) {
            if (resource.getId().indexOf(47) != -1 || resource.getId().indexOf(92) != -1 || resource.getId().indexOf(63) != -1 || resource.getId().indexOf(35) != -1) {
                throw new IllegalArgumentException("Id contains illegal chars.");
            }
            if (resource.getId().endsWith(" ")) {
                throw new IllegalArgumentException("Id ends with a space.");
            }
        }
    }

    private Map<String, String> getRequestHeaders(RequestOptions options, ResourceType resourceType, OperationType operationType) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.useMultipleWriteLocations) {
            headers.put("x-ms-cosmos-allow-tentative-writes", Boolean.TRUE.toString());
        }
        if (this.consistencyLevel != null) {
            headers.put("x-ms-consistency-level", this.consistencyLevel.toString());
        }
        if (options == null) {
            if (!this.contentResponseOnWriteEnabled && resourceType.equals((Object)ResourceType.Document) && operationType.isWriteOperation()) {
                headers.put("Prefer", "return=minimal");
            }
            return headers;
        }
        Map<String, String> customOptions = options.getHeaders();
        if (customOptions != null) {
            headers.putAll(customOptions);
        }
        boolean contentResponseOnWriteEnabled = this.contentResponseOnWriteEnabled;
        if (options.isContentResponseOnWriteEnabled() != null) {
            contentResponseOnWriteEnabled = options.isContentResponseOnWriteEnabled();
        }
        if (!contentResponseOnWriteEnabled && resourceType.equals((Object)ResourceType.Document) && operationType.isWriteOperation()) {
            headers.put("Prefer", "return=minimal");
        }
        if (options.getIfMatchETag() != null) {
            headers.put("If-Match", options.getIfMatchETag());
        }
        if (options.getIfNoneMatchETag() != null) {
            headers.put("If-None-Match", options.getIfNoneMatchETag());
        }
        if (options.getConsistencyLevel() != null) {
            headers.put("x-ms-consistency-level", options.getConsistencyLevel().toString());
        }
        if (options.getIndexingDirective() != null) {
            headers.put("x-ms-indexing-directive", options.getIndexingDirective().toString());
        }
        if (options.getPostTriggerInclude() != null && options.getPostTriggerInclude().size() > 0) {
            String postTriggerInclude = StringUtils.join(options.getPostTriggerInclude(), ",");
            headers.put("x-ms-documentdb-post-trigger-include", postTriggerInclude);
        }
        if (options.getPreTriggerInclude() != null && options.getPreTriggerInclude().size() > 0) {
            String preTriggerInclude = StringUtils.join(options.getPreTriggerInclude(), ",");
            headers.put("x-ms-documentdb-pre-trigger-include", preTriggerInclude);
        }
        if (!Strings.isNullOrEmpty(options.getSessionToken())) {
            headers.put("x-ms-session-token", options.getSessionToken());
        }
        if (options.getResourceTokenExpirySeconds() != null) {
            headers.put("x-ms-documentdb-expiry-seconds", String.valueOf(options.getResourceTokenExpirySeconds()));
        }
        if (options.getOfferThroughput() != null && options.getOfferThroughput() >= 0) {
            headers.put("x-ms-offer-throughput", options.getOfferThroughput().toString());
        } else if (options.getOfferType() != null) {
            headers.put("x-ms-offer-type", options.getOfferType());
        }
        if (options.getOfferThroughput() == null && options.getThroughputProperties() != null) {
            Offer offer = ModelBridgeInternal.getOfferFromThroughputProperties(options.getThroughputProperties());
            OfferAutoscaleSettings offerAutoscaleSettings = offer.getOfferAutoScaleSettings();
            OfferAutoscaleAutoUpgradeProperties autoscaleAutoUpgradeProperties = null;
            if (offerAutoscaleSettings != null) {
                autoscaleAutoUpgradeProperties = offer.getOfferAutoScaleSettings().getAutoscaleAutoUpgradeProperties();
            }
            if (offer.hasOfferThroughput() && (offerAutoscaleSettings != null && offerAutoscaleSettings.getMaxThroughput() >= 0 || autoscaleAutoUpgradeProperties != null && autoscaleAutoUpgradeProperties.getAutoscaleThroughputProperties().getIncrementPercent() >= 0)) {
                throw new IllegalArgumentException("Autoscale provisioned throughput can not be configured with fixed offer");
            }
            if (offer.hasOfferThroughput()) {
                headers.put("x-ms-offer-throughput", String.valueOf(offer.getThroughput()));
            } else if (offer.getOfferAutoScaleSettings() != null) {
                headers.put("x-ms-cosmos-offer-autopilot-settings", ModelBridgeInternal.toJsonFromJsonSerializable(offer.getOfferAutoScaleSettings()));
            }
        }
        if (options.isQuotaInfoEnabled()) {
            headers.put("x-ms-documentdb-populatequotainfo", String.valueOf(true));
        }
        if (options.isScriptLoggingEnabled()) {
            headers.put("x-ms-documentdb-script-enable-logging", String.valueOf(true));
        }
        if (options.getDedicatedGatewayRequestOptions() != null && options.getDedicatedGatewayRequestOptions().getMaxIntegratedCacheStaleness() != null) {
            headers.put("x-ms-dedicatedgateway-max-age", String.valueOf(Utils.getMaxIntegratedCacheStalenessInMillis(options.getDedicatedGatewayRequestOptions())));
        }
        return headers;
    }

    public IRetryPolicyFactory getResetSessionTokenRetryPolicy() {
        return this.resetSessionTokenRetryPolicy;
    }

    private Mono<RxDocumentServiceRequest> addPartitionKeyInformation(RxDocumentServiceRequest request, ByteBuffer contentAsByteBuffer, Document document, RequestOptions options) {
        Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
        return collectionObs.map(collectionValueHolder -> {
            this.addPartitionKeyInformation(request, contentAsByteBuffer, (Object)document, options, (DocumentCollection)collectionValueHolder.v);
            return request;
        });
    }

    private Mono<RxDocumentServiceRequest> addPartitionKeyInformation(RxDocumentServiceRequest request, ByteBuffer contentAsByteBuffer, Object document, RequestOptions options, Mono<Utils.ValueHolder<DocumentCollection>> collectionObs) {
        return collectionObs.map(collectionValueHolder -> {
            this.addPartitionKeyInformation(request, contentAsByteBuffer, document, options, (DocumentCollection)collectionValueHolder.v);
            return request;
        });
    }

    private void addPartitionKeyInformation(RxDocumentServiceRequest request, ByteBuffer contentAsByteBuffer, Object objectDoc, RequestOptions options, DocumentCollection collection) {
        PartitionKeyDefinition partitionKeyDefinition = collection.getPartitionKey();
        PartitionKeyInternal partitionKeyInternal = null;
        if (options != null && options.getPartitionKey() != null && options.getPartitionKey().equals(PartitionKey.NONE)) {
            partitionKeyInternal = ModelBridgeInternal.getNonePartitionKey(partitionKeyDefinition);
        } else if (options != null && options.getPartitionKey() != null) {
            partitionKeyInternal = BridgeInternal.getPartitionKeyInternal(options.getPartitionKey());
        } else if (partitionKeyDefinition == null || partitionKeyDefinition.getPaths().size() == 0) {
            partitionKeyInternal = PartitionKeyInternal.getEmpty();
        } else if (contentAsByteBuffer != null || objectDoc != null) {
            InternalObjectNode internalObjectNode;
            if (objectDoc instanceof InternalObjectNode) {
                internalObjectNode = (InternalObjectNode)objectDoc;
            } else if (objectDoc instanceof ObjectNode) {
                internalObjectNode = new InternalObjectNode((ObjectNode)objectDoc);
            } else if (contentAsByteBuffer != null) {
                contentAsByteBuffer.rewind();
                internalObjectNode = new InternalObjectNode(contentAsByteBuffer);
            } else {
                throw new IllegalStateException("ContentAsByteBuffer and objectDoc are null");
            }
            Instant serializationStartTime = Instant.now();
            partitionKeyInternal = RxDocumentClientImpl.extractPartitionKeyValueFromDocument(internalObjectNode, partitionKeyDefinition);
            Instant serializationEndTime = Instant.now();
            SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTime, serializationEndTime, SerializationDiagnosticsContext.SerializationType.PARTITION_KEY_FETCH_SERIALIZATION);
            SerializationDiagnosticsContext serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics);
            if (serializationDiagnosticsContext != null) {
                serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
            }
        } else {
            throw new UnsupportedOperationException("PartitionKey value must be supplied for this operation.");
        }
        request.setPartitionKeyInternal(partitionKeyInternal);
        request.getHeaders().put("x-ms-documentdb-partitionkey", Utils.escapeNonAscii(partitionKeyInternal.toJson()));
    }

    public static PartitionKeyInternal extractPartitionKeyValueFromDocument(InternalObjectNode document, PartitionKeyDefinition partitionKeyDefinition) {
        if (partitionKeyDefinition != null) {
            switch (partitionKeyDefinition.getKind()) {
                case HASH: {
                    String path = partitionKeyDefinition.getPaths().iterator().next();
                    List<String> parts = PathParser.getPathParts(path);
                    if (parts.size() < 1) break;
                    Object value = ModelBridgeInternal.getObjectByPathFromJsonSerializable(document, parts);
                    if (value == null || value.getClass() == ObjectNode.class) {
                        value = ModelBridgeInternal.getNonePartitionKey(partitionKeyDefinition);
                    }
                    if (value instanceof PartitionKeyInternal) {
                        return (PartitionKeyInternal)value;
                    }
                    return PartitionKeyInternal.fromObjectArray(Collections.singletonList(value), false);
                }
                case MULTI_HASH: {
                    Object[] partitionKeyValues = new Object[partitionKeyDefinition.getPaths().size()];
                    for (int pathIter = 0; pathIter < partitionKeyDefinition.getPaths().size(); ++pathIter) {
                        String partitionPath = partitionKeyDefinition.getPaths().get(pathIter);
                        List<String> partitionPathParts = PathParser.getPathParts(partitionPath);
                        partitionKeyValues[pathIter] = ModelBridgeInternal.getObjectByPathFromJsonSerializable(document, partitionPathParts);
                    }
                    return PartitionKeyInternal.fromObjectArray(partitionKeyValues, false);
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized Partition kind: " + (Object)((Object)partitionKeyDefinition.getKind()));
                }
            }
        }
        return null;
    }

    private Mono<RxDocumentServiceRequest> getCreateDocumentRequest(DocumentClientRetryPolicy requestRetryPolicy, String documentCollectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration, OperationType operationType) {
        SerializationDiagnosticsContext serializationDiagnosticsContext;
        if (StringUtils.isEmpty(documentCollectionLink)) {
            throw new IllegalArgumentException("documentCollectionLink");
        }
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        Instant serializationStartTimeUTC = Instant.now();
        ByteBuffer content = BridgeInternal.serializeJsonToByteBuffer(document, mapper);
        Instant serializationEndTimeUTC = Instant.now();
        SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTimeUTC, serializationEndTimeUTC, SerializationDiagnosticsContext.SerializationType.ITEM_SERIALIZATION);
        String path = Utils.joinPath(documentCollectionLink, "docs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Document, operationType);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, operationType, ResourceType.Document, path, requestHeaders, options, content);
        if (requestRetryPolicy != null) {
            requestRetryPolicy.onBeforeSendRequest(request);
        }
        if ((serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics)) != null) {
            serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
        }
        Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
        return this.addPartitionKeyInformation(request, content, document, options, collectionObs);
    }

    private Mono<RxDocumentServiceRequest> getBatchDocumentRequest(DocumentClientRetryPolicy requestRetryPolicy, String documentCollectionLink, ServerBatchRequest serverBatchRequest, RequestOptions options, boolean disableAutomaticIdGeneration) {
        SerializationDiagnosticsContext serializationDiagnosticsContext;
        Preconditions.checkArgument(StringUtils.isNotEmpty(documentCollectionLink), "expected non empty documentCollectionLink");
        Preconditions.checkNotNull(serverBatchRequest, "expected non null serverBatchRequest");
        Instant serializationStartTimeUTC = Instant.now();
        ByteBuffer content = ByteBuffer.wrap(Utils.getUTF8Bytes(serverBatchRequest.getRequestBody()));
        Instant serializationEndTimeUTC = Instant.now();
        SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTimeUTC, serializationEndTimeUTC, SerializationDiagnosticsContext.SerializationType.ITEM_SERIALIZATION);
        String path = Utils.joinPath(documentCollectionLink, "docs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Document, OperationType.Batch);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Batch, ResourceType.Document, path, requestHeaders, options, content);
        if (requestRetryPolicy != null) {
            requestRetryPolicy.onBeforeSendRequest(request);
        }
        if ((serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics)) != null) {
            serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
        }
        Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
        return collectionObs.map(collectionValueHolder -> {
            this.addBatchHeaders(request, serverBatchRequest, (DocumentCollection)collectionValueHolder.v);
            return request;
        });
    }

    private RxDocumentServiceRequest addBatchHeaders(RxDocumentServiceRequest request, ServerBatchRequest serverBatchRequest, DocumentCollection collection) {
        if (serverBatchRequest instanceof SinglePartitionKeyServerBatchRequest) {
            PartitionKeyInternal partitionKeyInternal;
            PartitionKey partitionKey = ((SinglePartitionKeyServerBatchRequest)serverBatchRequest).getPartitionKeyValue();
            if (partitionKey.equals(PartitionKey.NONE)) {
                PartitionKeyDefinition partitionKeyDefinition = collection.getPartitionKey();
                partitionKeyInternal = ModelBridgeInternal.getNonePartitionKey(partitionKeyDefinition);
            } else {
                partitionKeyInternal = BridgeInternal.getPartitionKeyInternal(partitionKey);
            }
            request.setPartitionKeyInternal(partitionKeyInternal);
            request.getHeaders().put("x-ms-documentdb-partitionkey", Utils.escapeNonAscii(partitionKeyInternal.toJson()));
        } else if (serverBatchRequest instanceof PartitionKeyRangeServerBatchRequest) {
            request.setPartitionKeyRangeIdentity(new PartitionKeyRangeIdentity(((PartitionKeyRangeServerBatchRequest)serverBatchRequest).getPartitionKeyRangeId()));
        } else {
            throw new UnsupportedOperationException("Unknown Server request.");
        }
        request.getHeaders().put("x-ms-cosmos-is-batch-request", Boolean.TRUE.toString());
        request.getHeaders().put("x-ms-cosmos-batch-atomic", String.valueOf(serverBatchRequest.isAtomicBatch()));
        request.getHeaders().put("x-ms-cosmos-batch-continue-on-error", String.valueOf(serverBatchRequest.isShouldContinueOnError()));
        request.setNumberOfItemsInBatchRequest(serverBatchRequest.getOperations().size());
        return request;
    }

    private Mono<RxDocumentServiceRequest> populateHeadersAsync(RxDocumentServiceRequest request, RequestVerb httpMethod) {
        request.getHeaders().put("x-ms-date", Utils.nowAsRFC1123());
        if (this.masterKeyOrResourceToken != null || this.resourceTokensMap != null || this.cosmosAuthorizationTokenResolver != null || this.credential != null) {
            String resourceName = request.getResourceAddress();
            String authorization = this.getUserAuthorizationToken(resourceName, request.getResourceType(), httpMethod, request.getHeaders(), AuthorizationTokenType.PrimaryMasterKey, request.properties);
            try {
                authorization = URLEncoder.encode(authorization, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Failed to encode authtoken.", e);
            }
            request.getHeaders().put("authorization", authorization);
        }
        if (this.apiType != null) {
            request.getHeaders().put("x-ms-cosmos-apitype", this.apiType.toString());
        }
        this.populateCapabilitiesHeader(request);
        if ((RequestVerb.POST.equals((Object)httpMethod) || RequestVerb.PUT.equals((Object)httpMethod)) && !request.getHeaders().containsKey("Content-Type")) {
            request.getHeaders().put("Content-Type", "application/json");
        }
        if (RequestVerb.PATCH.equals((Object)httpMethod) && !request.getHeaders().containsKey("Content-Type")) {
            request.getHeaders().put("Content-Type", "application/json-patch+json");
        }
        if (!request.getHeaders().containsKey("Accept")) {
            request.getHeaders().put("Accept", "application/json");
        }
        MetadataDiagnosticsContext metadataDiagnosticsCtx = BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics);
        if (this.requiresFeedRangeFiltering(request)) {
            return request.getFeedRange().populateFeedRangeFilteringHeaders(this.getPartitionKeyRangeCache(), request, this.collectionCache.resolveCollectionAsync(metadataDiagnosticsCtx, request)).flatMap(this::populateAuthorizationHeader);
        }
        return this.populateAuthorizationHeader(request);
    }

    private void populateCapabilitiesHeader(RxDocumentServiceRequest request) {
        String capabilitiesHeaderValue = HttpConstants.SDKSupportedCapabilities.SUPPORTED_CAPABILITIES;
        if (request.getHeaders().containsKey("x-ms-cosmos-sdk-supportedcapabilities")) {
            capabilitiesHeaderValue = request.getHeaders().get("x-ms-cosmos-sdk-supportedcapabilities");
        }
        if (capabilitiesHeaderValue.equalsIgnoreCase(HttpConstants.SDKSupportedCapabilities.SUPPORTED_CAPABILITIES_NONE)) {
            request.getHeaders().remove("x-ms-cosmos-sdk-supportedcapabilities");
        } else {
            request.getHeaders().put("x-ms-cosmos-sdk-supportedcapabilities", capabilitiesHeaderValue);
        }
    }

    private boolean requiresFeedRangeFiltering(RxDocumentServiceRequest request) {
        if (request.getResourceType() != ResourceType.Document && request.getResourceType() != ResourceType.Conflict) {
            return false;
        }
        switch (request.getOperationType()) {
            case ReadFeed: 
            case Query: 
            case SqlQuery: {
                return request.getFeedRange() != null;
            }
        }
        return false;
    }

    @Override
    public Mono<RxDocumentServiceRequest> populateAuthorizationHeader(RxDocumentServiceRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request");
        }
        if (this.authorizationTokenType == AuthorizationTokenType.AadToken) {
            return AadTokenAuthorizationHelper.getAuthorizationToken(this.tokenCredentialCache).map(authorization -> {
                request.getHeaders().put("authorization", (String)authorization);
                return request;
            });
        }
        return Mono.just((Object)request);
    }

    @Override
    public Mono<HttpHeaders> populateAuthorizationHeader(HttpHeaders httpHeaders) {
        if (httpHeaders == null) {
            throw new IllegalArgumentException("httpHeaders");
        }
        if (this.authorizationTokenType == AuthorizationTokenType.AadToken) {
            return AadTokenAuthorizationHelper.getAuthorizationToken(this.tokenCredentialCache).map(authorization -> {
                httpHeaders.set("authorization", (String)authorization);
                return httpHeaders;
            });
        }
        return Mono.just((Object)httpHeaders);
    }

    @Override
    public AuthorizationTokenType getAuthorizationTokenType() {
        return this.authorizationTokenType;
    }

    @Override
    public String getUserAuthorizationToken(String resourceName, ResourceType resourceType, RequestVerb requestVerb, Map<String, String> headers, AuthorizationTokenType tokenType, Map<String, Object> properties) {
        if (this.cosmosAuthorizationTokenResolver != null) {
            return this.cosmosAuthorizationTokenResolver.getAuthorizationToken(requestVerb.toUpperCase(), resourceName, this.resolveCosmosResourceType(resourceType).toString(), properties != null ? Collections.unmodifiableMap(properties) : null);
        }
        if (this.credential != null) {
            return this.authorizationTokenProvider.generateKeyAuthorizationSignature(requestVerb, resourceName, resourceType, headers);
        }
        if (this.masterKeyOrResourceToken != null && this.hasAuthKeyResourceToken && this.resourceTokensMap == null) {
            return this.masterKeyOrResourceToken;
        }
        assert (this.resourceTokensMap != null);
        if (resourceType.equals((Object)ResourceType.DatabaseAccount)) {
            return this.firstResourceTokenFromPermissionFeed;
        }
        return ResourceTokenAuthorizationHelper.getAuthorizationTokenUsingResourceTokens(this.resourceTokensMap, requestVerb, resourceName, headers);
    }

    private CosmosResourceType resolveCosmosResourceType(ResourceType resourceType) {
        CosmosResourceType cosmosResourceType = ModelBridgeInternal.fromServiceSerializedFormat(resourceType.toString());
        if (cosmosResourceType == null) {
            return CosmosResourceType.SYSTEM;
        }
        return cosmosResourceType;
    }

    void captureSessionToken(RxDocumentServiceRequest request, RxDocumentServiceResponse response) {
        this.sessionContainer.setSessionToken(request, response.getResponseHeaders());
    }

    private Mono<RxDocumentServiceResponse> create(RxDocumentServiceRequest request, DocumentClientRetryPolicy documentClientRetryPolicy, OperationContextAndListenerTuple operationContextAndListenerTuple) {
        return this.populateHeadersAsync(request, RequestVerb.POST).flatMap(requestPopulated -> {
            RxStoreModel storeProxy = this.getStoreProxy((RxDocumentServiceRequest)requestPopulated);
            if (documentClientRetryPolicy.getRetryContext() != null && documentClientRetryPolicy.getRetryContext().getRetryCount() > 0) {
                documentClientRetryPolicy.getRetryContext().updateEndTime();
            }
            return storeProxy.processMessage((RxDocumentServiceRequest)requestPopulated, operationContextAndListenerTuple);
        });
    }

    private Mono<RxDocumentServiceResponse> upsert(RxDocumentServiceRequest request, DocumentClientRetryPolicy documentClientRetryPolicy, OperationContextAndListenerTuple operationContextAndListenerTuple) {
        return this.populateHeadersAsync(request, RequestVerb.POST).flatMap(requestPopulated -> {
            Map<String, String> headers = requestPopulated.getHeaders();
            assert (headers != null);
            headers.put("x-ms-documentdb-is-upsert", "true");
            if (documentClientRetryPolicy.getRetryContext() != null && documentClientRetryPolicy.getRetryContext().getRetryCount() > 0) {
                documentClientRetryPolicy.getRetryContext().updateEndTime();
            }
            return this.getStoreProxy((RxDocumentServiceRequest)requestPopulated).processMessage((RxDocumentServiceRequest)requestPopulated, operationContextAndListenerTuple).map(response -> {
                this.captureSessionToken((RxDocumentServiceRequest)requestPopulated, (RxDocumentServiceResponse)response);
                return response;
            });
        });
    }

    private Mono<RxDocumentServiceResponse> replace(RxDocumentServiceRequest request, DocumentClientRetryPolicy documentClientRetryPolicy) {
        return this.populateHeadersAsync(request, RequestVerb.PUT).flatMap(requestPopulated -> {
            if (documentClientRetryPolicy.getRetryContext() != null && documentClientRetryPolicy.getRetryContext().getRetryCount() > 0) {
                documentClientRetryPolicy.getRetryContext().updateEndTime();
            }
            return this.getStoreProxy((RxDocumentServiceRequest)requestPopulated).processMessage((RxDocumentServiceRequest)requestPopulated);
        });
    }

    private Mono<RxDocumentServiceResponse> patch(RxDocumentServiceRequest request, DocumentClientRetryPolicy documentClientRetryPolicy) {
        return this.populateHeadersAsync(request, RequestVerb.PATCH).flatMap(requestPopulated -> {
            if (documentClientRetryPolicy.getRetryContext() != null && documentClientRetryPolicy.getRetryContext().getRetryCount() > 0) {
                documentClientRetryPolicy.getRetryContext().updateEndTime();
            }
            return this.getStoreProxy((RxDocumentServiceRequest)requestPopulated).processMessage((RxDocumentServiceRequest)requestPopulated);
        });
    }

    @Override
    public Mono<ResourceResponse<Document>> createDocument(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        if (options == null || options.getPartitionKey() == null) {
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, options);
        }
        DocumentClientRetryPolicy finalRetryPolicyInstance = requestRetryPolicy;
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createDocumentInternal(collectionLink, document, options, disableAutomaticIdGeneration, finalRetryPolicyInstance), requestRetryPolicy);
    }

    private Mono<ResourceResponse<Document>> createDocumentInternal(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration, DocumentClientRetryPolicy requestRetryPolicy) {
        try {
            logger.debug("Creating a Document. collectionLink: [{}]", (Object)collectionLink);
            Mono<RxDocumentServiceRequest> requestObs = this.getCreateDocumentRequest(requestRetryPolicy, collectionLink, document, options, disableAutomaticIdGeneration, OperationType.Create);
            Mono responseObservable = requestObs.flatMap(request -> this.create((RxDocumentServiceRequest)request, requestRetryPolicy, this.getOperationContextAndListenerTuple(options)));
            return responseObservable.map(serviceResponse -> BridgeInternal.toResourceResponse(serviceResponse, Document.class));
        }
        catch (Exception e) {
            logger.debug("Failure in creating a document due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Document>> upsertDocument(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        if (options == null || options.getPartitionKey() == null) {
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, options);
        }
        DocumentClientRetryPolicy finalRetryPolicyInstance = requestRetryPolicy;
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertDocumentInternal(collectionLink, document, options, disableAutomaticIdGeneration, finalRetryPolicyInstance), finalRetryPolicyInstance);
    }

    private Mono<ResourceResponse<Document>> upsertDocumentInternal(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            logger.debug("Upserting a Document. collectionLink: [{}]", (Object)collectionLink);
            Mono<RxDocumentServiceRequest> reqObs = this.getCreateDocumentRequest(retryPolicyInstance, collectionLink, document, options, disableAutomaticIdGeneration, OperationType.Upsert);
            Mono responseObservable = reqObs.flatMap(request -> this.upsert((RxDocumentServiceRequest)request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)));
            return responseObservable.map(serviceResponse -> BridgeInternal.toResourceResponse(serviceResponse, Document.class));
        }
        catch (Exception e) {
            logger.debug("Failure in upserting a document due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Document>> replaceDocument(String documentLink, Object document, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        if (options == null || options.getPartitionKey() == null) {
            String collectionLink = Utils.getCollectionName(documentLink);
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, options);
        }
        DocumentClientRetryPolicy finalRequestRetryPolicy = requestRetryPolicy;
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceDocumentInternal(documentLink, document, options, finalRequestRetryPolicy), requestRetryPolicy);
    }

    private Mono<ResourceResponse<Document>> replaceDocumentInternal(String documentLink, Object document, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(documentLink)) {
                throw new IllegalArgumentException("documentLink");
            }
            if (document == null) {
                throw new IllegalArgumentException("document");
            }
            Document typedDocument = BridgeInternal.documentFromObject(document, mapper);
            return this.replaceDocumentInternal(documentLink, typedDocument, options, retryPolicyInstance);
        }
        catch (Exception e) {
            logger.debug("Failure in replacing a document due to [{}]", (Object)e.getMessage());
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Document>> replaceDocument(Document document, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        if (options == null || options.getPartitionKey() == null) {
            String collectionLink = document.getSelfLink();
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, options);
        }
        DocumentClientRetryPolicy finalRequestRetryPolicy = requestRetryPolicy;
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceDocumentInternal(document, options, finalRequestRetryPolicy), requestRetryPolicy);
    }

    private Mono<ResourceResponse<Document>> replaceDocumentInternal(Document document, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (document == null) {
                throw new IllegalArgumentException("document");
            }
            return this.replaceDocumentInternal(document.getSelfLink(), document, options, retryPolicyInstance);
        }
        catch (Exception e) {
            logger.debug("Failure in replacing a database due to [{}]", (Object)e.getMessage());
            return Mono.error((Throwable)e);
        }
    }

    private Mono<ResourceResponse<Document>> replaceDocumentInternal(String documentLink, Document document, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        SerializationDiagnosticsContext serializationDiagnosticsContext;
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        logger.debug("Replacing a Document. documentLink: [{}]", (Object)documentLink);
        String path = Utils.joinPath(documentLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Document, OperationType.Replace);
        Instant serializationStartTimeUTC = Instant.now();
        ByteBuffer content = ModelBridgeInternal.serializeJsonToByteBuffer(document);
        Instant serializationEndTime = Instant.now();
        SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTimeUTC, serializationEndTime, SerializationDiagnosticsContext.SerializationType.ITEM_SERIALIZATION);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Replace, ResourceType.Document, path, requestHeaders, options, content);
        if (retryPolicyInstance != null) {
            retryPolicyInstance.onBeforeSendRequest(request);
        }
        if ((serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics)) != null) {
            serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
        }
        Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
        Mono<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation(request, content, (Object)document, options, collectionObs);
        return requestObs.flatMap(req -> this.replace(request, retryPolicyInstance).map(resp -> BridgeInternal.toResourceResponse(resp, Document.class)));
    }

    @Override
    public Mono<ResourceResponse<Document>> patchDocument(String documentLink, CosmosPatchOperations cosmosPatchOperations, RequestOptions options) {
        DocumentClientRetryPolicy documentClientRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.patchDocumentInternal(documentLink, cosmosPatchOperations, options, documentClientRetryPolicy), documentClientRetryPolicy);
    }

    private Mono<ResourceResponse<Document>> patchDocumentInternal(String documentLink, CosmosPatchOperations cosmosPatchOperations, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        SerializationDiagnosticsContext serializationDiagnosticsContext;
        Preconditions.checkArgument(StringUtils.isNotEmpty(documentLink), "expected non empty documentLink");
        Preconditions.checkNotNull(cosmosPatchOperations, "expected non null cosmosPatchOperations");
        logger.debug("Running patch operations on Document. documentLink: [{}]", (Object)documentLink);
        String path = Utils.joinPath(documentLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Document, OperationType.Patch);
        Instant serializationStartTimeUTC = Instant.now();
        ByteBuffer content = ByteBuffer.wrap(PatchUtil.serializeCosmosPatchToByteArray(cosmosPatchOperations, options));
        Instant serializationEndTime = Instant.now();
        SerializationDiagnosticsContext.SerializationDiagnostics serializationDiagnostics = new SerializationDiagnosticsContext.SerializationDiagnostics(serializationStartTimeUTC, serializationEndTime, SerializationDiagnosticsContext.SerializationType.ITEM_SERIALIZATION);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Patch, ResourceType.Document, path, requestHeaders, options, content);
        if (retryPolicyInstance != null) {
            retryPolicyInstance.onBeforeSendRequest(request);
        }
        if ((serializationDiagnosticsContext = BridgeInternal.getSerializationDiagnosticsContext(request.requestContext.cosmosDiagnostics)) != null) {
            serializationDiagnosticsContext.addSerializationDiagnostics(serializationDiagnostics);
        }
        Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
        Mono<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation(request, null, null, options, collectionObs);
        return requestObs.flatMap(req -> this.patch(request, retryPolicyInstance).map(resp -> BridgeInternal.toResourceResponse(resp, Document.class)));
    }

    @Override
    public Mono<ResourceResponse<Document>> deleteDocument(String documentLink, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteDocumentInternal(documentLink, null, options, requestRetryPolicy), requestRetryPolicy);
    }

    @Override
    public Mono<ResourceResponse<Document>> deleteDocument(String documentLink, InternalObjectNode internalObjectNode, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteDocumentInternal(documentLink, internalObjectNode, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Mono<ResourceResponse<Document>> deleteDocumentInternal(String documentLink, InternalObjectNode internalObjectNode, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(documentLink)) {
                throw new IllegalArgumentException("documentLink");
            }
            logger.debug("Deleting a Document. documentLink: [{}]", (Object)documentLink);
            String path = Utils.joinPath(documentLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Document, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Delete, ResourceType.Document, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
            Mono<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation(request, null, (Object)internalObjectNode, options, collectionObs);
            return requestObs.flatMap(req -> this.delete((RxDocumentServiceRequest)req, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(serviceResponse -> BridgeInternal.toResourceResponse(serviceResponse, Document.class)));
        }
        catch (Exception e) {
            logger.debug("Failure in deleting a document due to [{}]", (Object)e.getMessage());
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Document>> deleteAllDocumentsByPartitionKey(String collectionLink, PartitionKey partitionKey, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteAllDocumentsByPartitionKeyInternal(collectionLink, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Mono<ResourceResponse<Document>> deleteAllDocumentsByPartitionKeyInternal(String collectionLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(collectionLink)) {
                throw new IllegalArgumentException("collectionLink");
            }
            logger.debug("Deleting all items by Partition Key. collectionLink: [{}]", (Object)collectionLink);
            String path = Utils.joinPath(collectionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.PartitionKey, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Delete, ResourceType.PartitionKey, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
            Mono<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation(request, null, null, options, collectionObs);
            return requestObs.flatMap(req -> this.deleteAllItemsByPartitionKey((RxDocumentServiceRequest)req, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(serviceResponse -> BridgeInternal.toResourceResponse(serviceResponse, Document.class)));
        }
        catch (Exception e) {
            logger.debug("Failure in deleting documents due to [{}]", (Object)e.getMessage());
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Document>> readDocument(String documentLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readDocumentInternal(documentLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Document>> readDocumentInternal(String documentLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(documentLink)) {
                throw new IllegalArgumentException("documentLink");
            }
            logger.debug("Reading a Document. documentLink: [{}]", (Object)documentLink);
            String path = Utils.joinPath(documentLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Document, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.Document, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), request);
            Mono<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation(request, null, null, options, collectionObs);
            return requestObs.flatMap(req -> this.read(request, retryPolicyInstance).map(serviceResponse -> BridgeInternal.toResourceResponse(serviceResponse, Document.class)));
        }
        catch (Exception e) {
            logger.debug("Failure in reading a document due to [{}]", (Object)e.getMessage());
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public <T> Flux<FeedResponse<T>> readDocuments(String collectionLink, CosmosQueryRequestOptions options, Class<T> classOfT) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.queryDocuments(collectionLink, "SELECT * FROM r", options, classOfT);
    }

    @Override
    public <T> Mono<FeedResponse<T>> readMany(List<CosmosItemIdentity> itemIdentityList, String collectionLink, CosmosQueryRequestOptions options, Class<T> klass) {
        String resourceLink = this.parentResourceLinkToQueryLink(collectionLink, ResourceType.Document);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Query, ResourceType.Document, collectionLink, null);
        Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(null, request);
        return collectionObs.flatMap(documentCollectionResourceResponse -> {
            DocumentCollection collection = (DocumentCollection)documentCollectionResourceResponse.v;
            if (collection == null) {
                throw new IllegalStateException("Collection cannot be null");
            }
            PartitionKeyDefinition pkDefinition = collection.getPartitionKey();
            Mono<Utils.ValueHolder<CollectionRoutingMap>> valueHolderMono = this.partitionKeyRangeCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), collection.getResourceId(), null, null);
            return valueHolderMono.flatMap(collectionRoutingMapValueHolder -> {
                HashMap<PartitionKeyRange, List<CosmosItemIdentity>> partitionRangeItemKeyMap = new HashMap<PartitionKeyRange, List<CosmosItemIdentity>>();
                CollectionRoutingMap routingMap = (CollectionRoutingMap)collectionRoutingMapValueHolder.v;
                if (routingMap == null) {
                    throw new IllegalStateException("Failed to get routing map.");
                }
                itemIdentityList.forEach(itemIdentity -> {
                    String effectivePartitionKeyString = PartitionKeyInternalHelper.getEffectivePartitionKeyString(BridgeInternal.getPartitionKeyInternal(itemIdentity.getPartitionKey()), pkDefinition);
                    PartitionKeyRange range = routingMap.getRangeByEffectivePartitionKey(effectivePartitionKeyString);
                    if (partitionRangeItemKeyMap.get(range) == null) {
                        ArrayList<CosmosItemIdentity> list = new ArrayList<CosmosItemIdentity>();
                        list.add((CosmosItemIdentity)itemIdentity);
                        partitionRangeItemKeyMap.put(range, list);
                    } else {
                        List pairs = (List)partitionRangeItemKeyMap.get(range);
                        pairs.add(itemIdentity);
                        partitionRangeItemKeyMap.put(range, pairs);
                    }
                });
                Map<PartitionKeyRange, SqlQuerySpec> rangeQueryMap = this.getRangeQueryMap(partitionRangeItemKeyMap, collection.getPartitionKey());
                Flux<FeedResponse<Document>> pointReads = this.createPointReadOperations(partitionRangeItemKeyMap, resourceLink, options, klass);
                Flux<FeedResponse<Document>> queries = this.createReadManyQuery(resourceLink, new SqlQuerySpec(DUMMY_SQL_QUERY), options, Document.class, ResourceType.Document, collection, Collections.unmodifiableMap(rangeQueryMap));
                return Flux.merge((Publisher[])new Publisher[]{pointReads, queries}).collectList().map(feedList -> {
                    ArrayList finalList = new ArrayList();
                    HashMap<String, String> headers = new HashMap<String, String>();
                    ConcurrentHashMap<String, QueryMetrics> aggregatedQueryMetrics = new ConcurrentHashMap<String, QueryMetrics>();
                    ArrayList<ClientSideRequestStatistics> aggregateRequestStatistics = new ArrayList<ClientSideRequestStatistics>();
                    double requestCharge = 0.0;
                    for (FeedResponse page : feedList) {
                        ConcurrentMap<String, QueryMetrics> pageQueryMetrics = ModelBridgeInternal.queryMetrics(page);
                        if (pageQueryMetrics != null) {
                            pageQueryMetrics.forEach(aggregatedQueryMetrics::putIfAbsent);
                        }
                        requestCharge += page.getRequestCharge();
                        finalList.addAll(page.getResults().stream().map(document -> ModelBridgeInternal.toObjectFromJsonSerializable(document, klass)).collect(Collectors.toList()));
                        aggregateRequestStatistics.addAll(BridgeInternal.getClientSideRequestStatisticsList(page.getCosmosDiagnostics()));
                    }
                    CosmosDiagnostics aggregatedDiagnostics = BridgeInternal.createCosmosDiagnostics(aggregatedQueryMetrics);
                    BridgeInternal.addClientSideDiagnosticsToFeed(aggregatedDiagnostics, aggregateRequestStatistics);
                    headers.put("x-ms-request-charge", Double.toString(requestCharge));
                    FeedResponse frp = BridgeInternal.createFeedResponseWithQueryMetrics(finalList, headers, aggregatedQueryMetrics, null, false, false, aggregatedDiagnostics);
                    return frp;
                });
            });
        });
    }

    private Map<PartitionKeyRange, SqlQuerySpec> getRangeQueryMap(Map<PartitionKeyRange, List<CosmosItemIdentity>> partitionRangeItemKeyMap, PartitionKeyDefinition partitionKeyDefinition) {
        HashMap<PartitionKeyRange, SqlQuerySpec> rangeQueryMap = new HashMap<PartitionKeyRange, SqlQuerySpec>();
        String partitionKeySelector = this.createPkSelector(partitionKeyDefinition);
        for (Map.Entry<PartitionKeyRange, List<CosmosItemIdentity>> entry : partitionRangeItemKeyMap.entrySet()) {
            List<CosmosItemIdentity> cosmosItemIdentityList = entry.getValue();
            if (cosmosItemIdentityList.size() <= 1) continue;
            SqlQuerySpec sqlQuerySpec = partitionKeySelector.equals("[\"id\"]") ? this.createReadManyQuerySpecPartitionKeyIdSame(cosmosItemIdentityList, partitionKeySelector) : this.createReadManyQuerySpec(cosmosItemIdentityList, partitionKeySelector);
            rangeQueryMap.put(entry.getKey(), sqlQuerySpec);
        }
        return rangeQueryMap;
    }

    private SqlQuerySpec createReadManyQuerySpecPartitionKeyIdSame(List<CosmosItemIdentity> idPartitionKeyPairList, String partitionKeySelector) {
        StringBuilder queryStringBuilder = new StringBuilder();
        ArrayList<SqlParameter> parameters = new ArrayList<SqlParameter>();
        queryStringBuilder.append("SELECT * FROM c WHERE c.id IN ( ");
        for (int i = 0; i < idPartitionKeyPairList.size(); ++i) {
            CosmosItemIdentity itemIdentity = idPartitionKeyPairList.get(i);
            String idValue = itemIdentity.getId();
            String idParamName = "@param" + i;
            PartitionKey pkValueAsPartitionKey = itemIdentity.getPartitionKey();
            Object pkValue = ModelBridgeInternal.getPartitionKeyObject(pkValueAsPartitionKey);
            if (!Objects.equals(idValue, pkValue)) continue;
            parameters.add(new SqlParameter(idParamName, idValue));
            queryStringBuilder.append(idParamName);
            if (i >= idPartitionKeyPairList.size() - 1) continue;
            queryStringBuilder.append(", ");
        }
        queryStringBuilder.append(" )");
        return new SqlQuerySpec(queryStringBuilder.toString(), parameters);
    }

    private SqlQuerySpec createReadManyQuerySpec(List<CosmosItemIdentity> itemIdentities, String partitionKeySelector) {
        StringBuilder queryStringBuilder = new StringBuilder();
        ArrayList<SqlParameter> parameters = new ArrayList<SqlParameter>();
        queryStringBuilder.append("SELECT * FROM c WHERE ( ");
        for (int i = 0; i < itemIdentities.size(); ++i) {
            CosmosItemIdentity itemIdentity = itemIdentities.get(i);
            PartitionKey pkValueAsPartitionKey = itemIdentity.getPartitionKey();
            Object pkValue = ModelBridgeInternal.getPartitionKeyObject(pkValueAsPartitionKey);
            String pkParamName = "@param" + 2 * i;
            parameters.add(new SqlParameter(pkParamName, pkValue));
            String idValue = itemIdentity.getId();
            String idParamName = "@param" + (2 * i + 1);
            parameters.add(new SqlParameter(idParamName, idValue));
            queryStringBuilder.append("(");
            queryStringBuilder.append("c.id = ");
            queryStringBuilder.append(idParamName);
            queryStringBuilder.append(" AND ");
            queryStringBuilder.append(" c");
            queryStringBuilder.append(partitionKeySelector);
            queryStringBuilder.append(" = ");
            queryStringBuilder.append(pkParamName);
            queryStringBuilder.append(" )");
            if (i >= itemIdentities.size() - 1) continue;
            queryStringBuilder.append(" OR ");
        }
        queryStringBuilder.append(" )");
        return new SqlQuerySpec(queryStringBuilder.toString(), parameters);
    }

    private String createPkSelector(PartitionKeyDefinition partitionKeyDefinition) {
        return partitionKeyDefinition.getPaths().stream().map(pathPart -> StringUtils.substring(pathPart, 1)).map(pathPart -> StringUtils.replace(pathPart, "\"", "\\")).map(part -> "[\"" + part + "\"]").collect(Collectors.joining());
    }

    private <T extends Resource> Flux<FeedResponse<T>> createReadManyQuery(String parentResourceLink, SqlQuerySpec sqlQuery, CosmosQueryRequestOptions options, Class<T> klass, ResourceType resourceTypeEnum, DocumentCollection collection, Map<PartitionKeyRange, SqlQuerySpec> rangeQueryMap) {
        if (rangeQueryMap.isEmpty()) {
            return Flux.empty();
        }
        UUID activityId = Utils.randomUUID();
        IDocumentQueryClient queryClient = this.documentQueryClientImpl(this, this.getOperationContextAndListenerTuple(options));
        Flux<IDocumentQueryExecutionContext<T>> executionContext = DocumentQueryExecutionContextFactory.createReadManyQueryAsync(this, queryClient, collection.getResourceId(), sqlQuery, rangeQueryMap, options, collection.getResourceId(), parentResourceLink, activityId, klass, resourceTypeEnum);
        return executionContext.flatMap(IDocumentQueryExecutionContext::executeAsync);
    }

    private <T> Flux<FeedResponse<Document>> createPointReadOperations(Map<PartitionKeyRange, List<CosmosItemIdentity>> singleItemPartitionRequestMap, String resourceLink, CosmosQueryRequestOptions queryRequestOptions, Class<T> klass) {
        return Flux.fromIterable(singleItemPartitionRequestMap.values()).flatMap(cosmosItemIdentityList -> {
            if (cosmosItemIdentityList.size() == 1) {
                CosmosItemIdentity firstIdentity = (CosmosItemIdentity)cosmosItemIdentityList.get(0);
                RequestOptions requestOptions = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().toRequestOptions(queryRequestOptions);
                requestOptions.setPartitionKey(firstIdentity.getPartitionKey());
                return this.readDocument(resourceLink + firstIdentity.getId(), requestOptions);
            }
            return Mono.empty();
        }).flatMap(resourceResponse -> {
            CosmosItemResponse cosmosItemResponse = ModelBridgeInternal.createCosmosAsyncItemResponse(resourceResponse, klass, this.getItemDeserializer());
            FeedResponse<Document> feedResponse = ModelBridgeInternal.createFeedResponse(Arrays.asList(InternalObjectNode.fromObject(cosmosItemResponse.getItem())), cosmosItemResponse.getResponseHeaders());
            BridgeInternal.addClientSideDiagnosticsToFeed(feedResponse.getCosmosDiagnostics(), Arrays.asList(BridgeInternal.getClientSideRequestStatics(cosmosItemResponse.getDiagnostics())));
            return Mono.just(feedResponse);
        });
    }

    @Override
    public <T> Flux<FeedResponse<T>> queryDocuments(String collectionLink, String query, CosmosQueryRequestOptions options, Class<T> classOfT) {
        return this.queryDocuments(collectionLink, new SqlQuerySpec(query), options, classOfT);
    }

    private IDocumentQueryClient documentQueryClientImpl(RxDocumentClientImpl rxDocumentClientImpl, final OperationContextAndListenerTuple operationContextAndListenerTuple) {
        return new IDocumentQueryClient(){

            @Override
            public RxCollectionCache getCollectionCache() {
                return RxDocumentClientImpl.this.collectionCache;
            }

            @Override
            public RxPartitionKeyRangeCache getPartitionKeyRangeCache() {
                return RxDocumentClientImpl.this.partitionKeyRangeCache;
            }

            @Override
            public IRetryPolicyFactory getResetSessionTokenRetryPolicy() {
                return RxDocumentClientImpl.this.resetSessionTokenRetryPolicy;
            }

            @Override
            public ConsistencyLevel getDefaultConsistencyLevelAsync() {
                return RxDocumentClientImpl.this.gatewayConfigurationReader.getDefaultConsistencyLevel();
            }

            @Override
            public ConsistencyLevel getDesiredConsistencyLevelAsync() {
                return RxDocumentClientImpl.this.consistencyLevel;
            }

            @Override
            public Mono<RxDocumentServiceResponse> executeQueryAsync(RxDocumentServiceRequest request) {
                if (operationContextAndListenerTuple == null) {
                    return RxDocumentClientImpl.this.query(request).single();
                }
                OperationListener listener = operationContextAndListenerTuple.getOperationListener();
                OperationContext operationContext = operationContextAndListenerTuple.getOperationContext();
                request.getHeaders().put("x-ms-cosmos-correlated-activityid", operationContext.getCorrelationActivityId());
                listener.requestListener(operationContext, request);
                return RxDocumentClientImpl.this.query(request).single().doOnNext(response -> listener.responseListener(operationContext, (RxDocumentServiceResponse)response)).doOnError(ex -> listener.exceptionListener(operationContext, (Throwable)ex));
            }

            @Override
            public IDocumentQueryClient.QueryCompatibilityMode getQueryCompatibilityMode() {
                return IDocumentQueryClient.QueryCompatibilityMode.Default;
            }

            @Override
            public Mono<RxDocumentServiceResponse> readFeedAsync(RxDocumentServiceRequest request) {
                return null;
            }
        };
    }

    @Override
    public <T> Flux<FeedResponse<T>> queryDocuments(String collectionLink, SqlQuerySpec querySpec, CosmosQueryRequestOptions options, Class<T> classOfT) {
        SqlQuerySpecLogger.getInstance().logQuery(querySpec);
        return this.createQuery(collectionLink, querySpec, options, classOfT, ResourceType.Document);
    }

    @Override
    public <T> Flux<FeedResponse<T>> queryDocumentChangeFeed(DocumentCollection collection, CosmosChangeFeedRequestOptions changeFeedOptions, Class<T> classOfT) {
        Preconditions.checkNotNull(collection, "Argument 'collection' must not be null.");
        ChangeFeedQueryImpl<T> changeFeedQueryImpl = new ChangeFeedQueryImpl<T>(this, ResourceType.Document, classOfT, collection.getAltLink(), collection.getResourceId(), changeFeedOptions);
        return changeFeedQueryImpl.executeAsync();
    }

    @Override
    public <T> Flux<FeedResponse<T>> readAllDocuments(String collectionLink, PartitionKey partitionKey, CosmosQueryRequestOptions options, Class<T> classOfT) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (partitionKey == null) {
            throw new IllegalArgumentException("partitionKey");
        }
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Query, ResourceType.Document, collectionLink, null);
        Flux collectionObs = this.collectionCache.resolveCollectionAsync(null, request).flux();
        return collectionObs.flatMap(documentCollectionResourceResponse -> {
            DocumentCollection collection = (DocumentCollection)documentCollectionResourceResponse.v;
            if (collection == null) {
                throw new IllegalStateException("Collection cannot be null");
            }
            PartitionKeyDefinition pkDefinition = collection.getPartitionKey();
            String pkSelector = this.createPkSelector(pkDefinition);
            SqlQuerySpec querySpec = RxDocumentClientImpl.createLogicalPartitionScanQuerySpec(partitionKey, pkSelector);
            String resourceLink = this.parentResourceLinkToQueryLink(collectionLink, ResourceType.Document);
            UUID activityId = Utils.randomUUID();
            IDocumentQueryClient queryClient = this.documentQueryClientImpl(this, this.getOperationContextAndListenerTuple(options));
            CosmosQueryRequestOptions effectiveOptions = ModelBridgeInternal.createQueryRequestOptions(options);
            InvalidPartitionExceptionRetryPolicy invalidPartitionExceptionRetryPolicy = new InvalidPartitionExceptionRetryPolicy(this.collectionCache, null, resourceLink, ModelBridgeInternal.getPropertiesFromQueryRequestOptions(effectiveOptions));
            return ObservableHelper.fluxInlineIfPossibleAsObs(() -> {
                Flux valueHolderMono = this.partitionKeyRangeCache.tryLookupAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), collection.getResourceId(), null, null).flux();
                return valueHolderMono.flatMap(collectionRoutingMapValueHolder -> {
                    CollectionRoutingMap routingMap = (CollectionRoutingMap)collectionRoutingMapValueHolder.v;
                    if (routingMap == null) {
                        throw new IllegalStateException("Failed to get routing map.");
                    }
                    String effectivePartitionKeyString = PartitionKeyInternalHelper.getEffectivePartitionKeyString(BridgeInternal.getPartitionKeyInternal(partitionKey), pkDefinition);
                    PartitionKeyRange range = routingMap.getRangeByEffectivePartitionKey(effectivePartitionKeyString);
                    return this.createQueryInternal(resourceLink, querySpec, ModelBridgeInternal.setPartitionKeyRangeIdInternal(effectiveOptions, range.getId()), classOfT, ResourceType.Document, queryClient, activityId);
                });
            }, invalidPartitionExceptionRetryPolicy);
        });
    }

    @Override
    public Map<String, PartitionedQueryExecutionInfo> getQueryPlanCache() {
        return this.queryPlanCache;
    }

    @Override
    public Flux<FeedResponse<PartitionKeyRange>> readPartitionKeyRanges(String collectionLink, CosmosQueryRequestOptions options) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.PartitionKeyRange, PartitionKeyRange.class, Utils.joinPath(collectionLink, "pkranges"));
    }

    private RxDocumentServiceRequest getStoredProcedureRequest(String collectionLink, StoredProcedure storedProcedure, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (storedProcedure == null) {
            throw new IllegalArgumentException("storedProcedure");
        }
        RxDocumentClientImpl.validateResource(storedProcedure);
        String path = Utils.joinPath(collectionLink, "sprocs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.StoredProcedure, operationType);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, operationType, ResourceType.StoredProcedure, path, (Resource)storedProcedure, requestHeaders, (Object)options);
        return request;
    }

    private RxDocumentServiceRequest getUserDefinedFunctionRequest(String collectionLink, UserDefinedFunction udf, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (udf == null) {
            throw new IllegalArgumentException("udf");
        }
        RxDocumentClientImpl.validateResource(udf);
        String path = Utils.joinPath(collectionLink, "udfs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.UserDefinedFunction, operationType);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, operationType, ResourceType.UserDefinedFunction, path, (Resource)udf, requestHeaders, (Object)options);
        return request;
    }

    @Override
    public Mono<ResourceResponse<StoredProcedure>> createStoredProcedure(String collectionLink, StoredProcedure storedProcedure, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createStoredProcedureInternal(collectionLink, storedProcedure, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Mono<ResourceResponse<StoredProcedure>> createStoredProcedureInternal(String collectionLink, StoredProcedure storedProcedure, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            logger.debug("Creating a StoredProcedure. collectionLink: [{}], storedProcedure id [{}]", (Object)collectionLink, (Object)storedProcedure.getId());
            RxDocumentServiceRequest request = this.getStoredProcedureRequest(collectionLink, storedProcedure, options, OperationType.Create);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.create(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, StoredProcedure.class));
        }
        catch (Exception e) {
            logger.debug("Failure in creating a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<StoredProcedure>> upsertStoredProcedure(String collectionLink, StoredProcedure storedProcedure, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertStoredProcedureInternal(collectionLink, storedProcedure, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Mono<ResourceResponse<StoredProcedure>> upsertStoredProcedureInternal(String collectionLink, StoredProcedure storedProcedure, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            logger.debug("Upserting a StoredProcedure. collectionLink: [{}], storedProcedure id [{}]", (Object)collectionLink, (Object)storedProcedure.getId());
            RxDocumentServiceRequest request = this.getStoredProcedureRequest(collectionLink, storedProcedure, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, StoredProcedure.class));
        }
        catch (Exception e) {
            logger.debug("Failure in upserting a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<StoredProcedure>> replaceStoredProcedure(StoredProcedure storedProcedure, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceStoredProcedureInternal(storedProcedure, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Mono<ResourceResponse<StoredProcedure>> replaceStoredProcedureInternal(StoredProcedure storedProcedure, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (storedProcedure == null) {
                throw new IllegalArgumentException("storedProcedure");
            }
            logger.debug("Replacing a StoredProcedure. storedProcedure id [{}]", (Object)storedProcedure.getId());
            RxDocumentClientImpl.validateResource(storedProcedure);
            String path = Utils.joinPath(storedProcedure.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.StoredProcedure, OperationType.Replace);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Replace, ResourceType.StoredProcedure, path, (Resource)storedProcedure, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, StoredProcedure.class));
        }
        catch (Exception e) {
            logger.debug("Failure in replacing a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<StoredProcedure>> deleteStoredProcedure(String storedProcedureLink, RequestOptions options) {
        DocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteStoredProcedureInternal(storedProcedureLink, options, requestRetryPolicy), requestRetryPolicy);
    }

    private Mono<ResourceResponse<StoredProcedure>> deleteStoredProcedureInternal(String storedProcedureLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(storedProcedureLink)) {
                throw new IllegalArgumentException("storedProcedureLink");
            }
            logger.debug("Deleting a StoredProcedure. storedProcedureLink [{}]", (Object)storedProcedureLink);
            String path = Utils.joinPath(storedProcedureLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.StoredProcedure, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Delete, ResourceType.StoredProcedure, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, StoredProcedure.class));
        }
        catch (Exception e) {
            logger.debug("Failure in deleting a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<StoredProcedure>> readStoredProcedure(String storedProcedureLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readStoredProcedureInternal(storedProcedureLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<StoredProcedure>> readStoredProcedureInternal(String storedProcedureLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(storedProcedureLink)) {
                throw new IllegalArgumentException("storedProcedureLink");
            }
            logger.debug("Reading a StoredProcedure. storedProcedureLink [{}]", (Object)storedProcedureLink);
            String path = Utils.joinPath(storedProcedureLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.StoredProcedure, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.StoredProcedure, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, StoredProcedure.class));
        }
        catch (Exception e) {
            logger.debug("Failure in reading a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<StoredProcedure>> readStoredProcedures(String collectionLink, CosmosQueryRequestOptions options) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.StoredProcedure, StoredProcedure.class, Utils.joinPath(collectionLink, "sprocs"));
    }

    @Override
    public Flux<FeedResponse<StoredProcedure>> queryStoredProcedures(String collectionLink, String query, CosmosQueryRequestOptions options) {
        return this.queryStoredProcedures(collectionLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<StoredProcedure>> queryStoredProcedures(String collectionLink, SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery(collectionLink, querySpec, options, StoredProcedure.class, ResourceType.StoredProcedure);
    }

    @Override
    public Mono<StoredProcedureResponse> executeStoredProcedure(String storedProcedureLink, List<Object> procedureParams) {
        return this.executeStoredProcedure(storedProcedureLink, null, procedureParams);
    }

    @Override
    public Mono<StoredProcedureResponse> executeStoredProcedure(String storedProcedureLink, RequestOptions options, List<Object> procedureParams) {
        DocumentClientRetryPolicy documentClientRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.executeStoredProcedureInternal(storedProcedureLink, options, procedureParams, documentClientRetryPolicy), documentClientRetryPolicy);
    }

    @Override
    public Mono<CosmosBatchResponse> executeBatchRequest(String collectionLink, ServerBatchRequest serverBatchRequest, RequestOptions options, boolean disableAutomaticIdGeneration) {
        DocumentClientRetryPolicy documentClientRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.executeBatchRequestInternal(collectionLink, serverBatchRequest, options, documentClientRetryPolicy, disableAutomaticIdGeneration), documentClientRetryPolicy);
    }

    private Mono<StoredProcedureResponse> executeStoredProcedureInternal(String storedProcedureLink, RequestOptions options, List<Object> procedureParams, DocumentClientRetryPolicy retryPolicy) {
        try {
            logger.debug("Executing a StoredProcedure. storedProcedureLink [{}]", (Object)storedProcedureLink);
            String path = Utils.joinPath(storedProcedureLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.StoredProcedure, OperationType.ExecuteJavaScript);
            requestHeaders.put("Accept", "application/json");
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.ExecuteJavaScript, ResourceType.StoredProcedure, path, procedureParams != null && !procedureParams.isEmpty() ? RxDocumentClientImpl.serializeProcedureParams(procedureParams) : "", requestHeaders, (Object)options);
            if (retryPolicy != null) {
                retryPolicy.onBeforeSendRequest(request);
            }
            Mono<RxDocumentServiceRequest> reqObs = this.addPartitionKeyInformation(request, null, null, options);
            return reqObs.flatMap(req -> this.create(request, retryPolicy, this.getOperationContextAndListenerTuple(options)).map(response -> {
                this.captureSessionToken(request, (RxDocumentServiceResponse)response);
                return BridgeInternal.toStoredProcedureResponse(response);
            }));
        }
        catch (Exception e) {
            logger.debug("Failure in executing a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    private Mono<CosmosBatchResponse> executeBatchRequestInternal(String collectionLink, ServerBatchRequest serverBatchRequest, RequestOptions options, DocumentClientRetryPolicy requestRetryPolicy, boolean disableAutomaticIdGeneration) {
        try {
            logger.debug("Executing a Batch request with number of operations {}", (Object)serverBatchRequest.getOperations().size());
            Mono<RxDocumentServiceRequest> requestObs = this.getBatchDocumentRequest(requestRetryPolicy, collectionLink, serverBatchRequest, options, disableAutomaticIdGeneration);
            Mono responseObservable = requestObs.flatMap(request -> this.create((RxDocumentServiceRequest)request, requestRetryPolicy, this.getOperationContextAndListenerTuple(options)));
            return responseObservable.map(serviceResponse -> BatchResponseParser.fromDocumentServiceResponse(serviceResponse, serverBatchRequest, true));
        }
        catch (Exception ex) {
            logger.debug("Failure in executing a batch due to [{}]", (Object)ex.getMessage(), (Object)ex);
            return Mono.error((Throwable)ex);
        }
    }

    @Override
    public Mono<ResourceResponse<Trigger>> createTrigger(String collectionLink, Trigger trigger, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createTriggerInternal(collectionLink, trigger, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Trigger>> createTriggerInternal(String collectionLink, Trigger trigger, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            logger.debug("Creating a Trigger. collectionLink [{}], trigger id [{}]", (Object)collectionLink, (Object)trigger.getId());
            RxDocumentServiceRequest request = this.getTriggerRequest(collectionLink, trigger, options, OperationType.Create);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.create(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, Trigger.class));
        }
        catch (Exception e) {
            logger.debug("Failure in creating a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Trigger>> upsertTrigger(String collectionLink, Trigger trigger, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertTriggerInternal(collectionLink, trigger, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Trigger>> upsertTriggerInternal(String collectionLink, Trigger trigger, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            logger.debug("Upserting a Trigger. collectionLink [{}], trigger id [{}]", (Object)collectionLink, (Object)trigger.getId());
            RxDocumentServiceRequest request = this.getTriggerRequest(collectionLink, trigger, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, Trigger.class));
        }
        catch (Exception e) {
            logger.debug("Failure in upserting a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    private RxDocumentServiceRequest getTriggerRequest(String collectionLink, Trigger trigger, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (trigger == null) {
            throw new IllegalArgumentException("trigger");
        }
        RxDocumentClientImpl.validateResource(trigger);
        String path = Utils.joinPath(collectionLink, "triggers");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Trigger, operationType);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, operationType, ResourceType.Trigger, path, (Resource)trigger, requestHeaders, (Object)options);
        return request;
    }

    @Override
    public Mono<ResourceResponse<Trigger>> replaceTrigger(Trigger trigger, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceTriggerInternal(trigger, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Trigger>> replaceTriggerInternal(Trigger trigger, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (trigger == null) {
                throw new IllegalArgumentException("trigger");
            }
            logger.debug("Replacing a Trigger. trigger id [{}]", (Object)trigger.getId());
            RxDocumentClientImpl.validateResource(trigger);
            String path = Utils.joinPath(trigger.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Trigger, OperationType.Replace);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Replace, ResourceType.Trigger, path, (Resource)trigger, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Trigger.class));
        }
        catch (Exception e) {
            logger.debug("Failure in replacing a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Trigger>> deleteTrigger(String triggerLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteTriggerInternal(triggerLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Trigger>> deleteTriggerInternal(String triggerLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(triggerLink)) {
                throw new IllegalArgumentException("triggerLink");
            }
            logger.debug("Deleting a Trigger. triggerLink [{}]", (Object)triggerLink);
            String path = Utils.joinPath(triggerLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Trigger, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Delete, ResourceType.Trigger, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, Trigger.class));
        }
        catch (Exception e) {
            logger.debug("Failure in deleting a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Trigger>> readTrigger(String triggerLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readTriggerInternal(triggerLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Trigger>> readTriggerInternal(String triggerLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(triggerLink)) {
                throw new IllegalArgumentException("triggerLink");
            }
            logger.debug("Reading a Trigger. triggerLink [{}]", (Object)triggerLink);
            String path = Utils.joinPath(triggerLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Trigger, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.Trigger, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Trigger.class));
        }
        catch (Exception e) {
            logger.debug("Failure in reading a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Trigger>> readTriggers(String collectionLink, CosmosQueryRequestOptions options) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.Trigger, Trigger.class, Utils.joinPath(collectionLink, "triggers"));
    }

    @Override
    public Flux<FeedResponse<Trigger>> queryTriggers(String collectionLink, String query, CosmosQueryRequestOptions options) {
        return this.queryTriggers(collectionLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<Trigger>> queryTriggers(String collectionLink, SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery(collectionLink, querySpec, options, Trigger.class, ResourceType.Trigger);
    }

    @Override
    public Mono<ResourceResponse<UserDefinedFunction>> createUserDefinedFunction(String collectionLink, UserDefinedFunction udf, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createUserDefinedFunctionInternal(collectionLink, udf, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<UserDefinedFunction>> createUserDefinedFunctionInternal(String collectionLink, UserDefinedFunction udf, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            logger.debug("Creating a UserDefinedFunction. collectionLink [{}], udf id [{}]", (Object)collectionLink, (Object)udf.getId());
            RxDocumentServiceRequest request = this.getUserDefinedFunctionRequest(collectionLink, udf, options, OperationType.Create);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.create(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            logger.debug("Failure in creating a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<UserDefinedFunction>> upsertUserDefinedFunction(String collectionLink, UserDefinedFunction udf, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertUserDefinedFunctionInternal(collectionLink, udf, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<UserDefinedFunction>> upsertUserDefinedFunctionInternal(String collectionLink, UserDefinedFunction udf, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            logger.debug("Upserting a UserDefinedFunction. collectionLink [{}], udf id [{}]", (Object)collectionLink, (Object)udf.getId());
            RxDocumentServiceRequest request = this.getUserDefinedFunctionRequest(collectionLink, udf, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            logger.debug("Failure in upserting a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<UserDefinedFunction>> replaceUserDefinedFunction(UserDefinedFunction udf, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceUserDefinedFunctionInternal(udf, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<UserDefinedFunction>> replaceUserDefinedFunctionInternal(UserDefinedFunction udf, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (udf == null) {
                throw new IllegalArgumentException("udf");
            }
            logger.debug("Replacing a UserDefinedFunction. udf id [{}]", (Object)udf.getId());
            RxDocumentClientImpl.validateResource(udf);
            String path = Utils.joinPath(udf.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.UserDefinedFunction, OperationType.Replace);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Replace, ResourceType.UserDefinedFunction, path, (Resource)udf, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            logger.debug("Failure in replacing a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<UserDefinedFunction>> deleteUserDefinedFunction(String udfLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteUserDefinedFunctionInternal(udfLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<UserDefinedFunction>> deleteUserDefinedFunctionInternal(String udfLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(udfLink)) {
                throw new IllegalArgumentException("udfLink");
            }
            logger.debug("Deleting a UserDefinedFunction. udfLink [{}]", (Object)udfLink);
            String path = Utils.joinPath(udfLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.UserDefinedFunction, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Delete, ResourceType.UserDefinedFunction, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            logger.debug("Failure in deleting a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<UserDefinedFunction>> readUserDefinedFunction(String udfLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readUserDefinedFunctionInternal(udfLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<UserDefinedFunction>> readUserDefinedFunctionInternal(String udfLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(udfLink)) {
                throw new IllegalArgumentException("udfLink");
            }
            logger.debug("Reading a UserDefinedFunction. udfLink [{}]", (Object)udfLink);
            String path = Utils.joinPath(udfLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.UserDefinedFunction, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.UserDefinedFunction, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            logger.debug("Failure in reading a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<UserDefinedFunction>> readUserDefinedFunctions(String collectionLink, CosmosQueryRequestOptions options) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.UserDefinedFunction, UserDefinedFunction.class, Utils.joinPath(collectionLink, "udfs"));
    }

    @Override
    public Flux<FeedResponse<UserDefinedFunction>> queryUserDefinedFunctions(String collectionLink, String query, CosmosQueryRequestOptions options) {
        return this.queryUserDefinedFunctions(collectionLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<UserDefinedFunction>> queryUserDefinedFunctions(String collectionLink, SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery(collectionLink, querySpec, options, UserDefinedFunction.class, ResourceType.UserDefinedFunction);
    }

    @Override
    public Mono<ResourceResponse<Conflict>> readConflict(String conflictLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readConflictInternal(conflictLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Conflict>> readConflictInternal(String conflictLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(conflictLink)) {
                throw new IllegalArgumentException("conflictLink");
            }
            logger.debug("Reading a Conflict. conflictLink [{}]", (Object)conflictLink);
            String path = Utils.joinPath(conflictLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Conflict, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.Conflict, path, requestHeaders, options);
            Mono<RxDocumentServiceRequest> reqObs = this.addPartitionKeyInformation(request, null, null, options);
            return reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(request);
                }
                return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Conflict.class));
            });
        }
        catch (Exception e) {
            logger.debug("Failure in reading a Conflict due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Conflict>> readConflicts(String collectionLink, CosmosQueryRequestOptions options) {
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.Conflict, Conflict.class, Utils.joinPath(collectionLink, "conflicts"));
    }

    @Override
    public Flux<FeedResponse<Conflict>> queryConflicts(String collectionLink, String query, CosmosQueryRequestOptions options) {
        return this.queryConflicts(collectionLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<Conflict>> queryConflicts(String collectionLink, SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery(collectionLink, querySpec, options, Conflict.class, ResourceType.Conflict);
    }

    @Override
    public Mono<ResourceResponse<Conflict>> deleteConflict(String conflictLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteConflictInternal(conflictLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Conflict>> deleteConflictInternal(String conflictLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(conflictLink)) {
                throw new IllegalArgumentException("conflictLink");
            }
            logger.debug("Deleting a Conflict. conflictLink [{}]", (Object)conflictLink);
            String path = Utils.joinPath(conflictLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Conflict, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Delete, ResourceType.Conflict, path, requestHeaders, options);
            Mono<RxDocumentServiceRequest> reqObs = this.addPartitionKeyInformation(request, null, null, options);
            return reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(request);
                }
                return this.delete(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, Conflict.class));
            });
        }
        catch (Exception e) {
            logger.debug("Failure in deleting a Conflict due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<User>> createUser(String databaseLink, User user, RequestOptions options) {
        DocumentClientRetryPolicy documentClientRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createUserInternal(databaseLink, user, options, documentClientRetryPolicy), documentClientRetryPolicy);
    }

    private Mono<ResourceResponse<User>> createUserInternal(String databaseLink, User user, RequestOptions options, DocumentClientRetryPolicy documentClientRetryPolicy) {
        try {
            logger.debug("Creating a User. databaseLink [{}], user id [{}]", (Object)databaseLink, (Object)user.getId());
            RxDocumentServiceRequest request = this.getUserRequest(databaseLink, user, options, OperationType.Create);
            return this.create(request, documentClientRetryPolicy, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            logger.debug("Failure in creating a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<User>> upsertUser(String databaseLink, User user, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertUserInternal(databaseLink, user, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<User>> upsertUserInternal(String databaseLink, User user, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            logger.debug("Upserting a User. databaseLink [{}], user id [{}]", (Object)databaseLink, (Object)user.getId());
            RxDocumentServiceRequest request = this.getUserRequest(databaseLink, user, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            logger.debug("Failure in upserting a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    private RxDocumentServiceRequest getUserRequest(String databaseLink, User user, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty(databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        if (user == null) {
            throw new IllegalArgumentException("user");
        }
        RxDocumentClientImpl.validateResource(user);
        String path = Utils.joinPath(databaseLink, "users");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.User, operationType);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, operationType, ResourceType.User, path, (Resource)user, requestHeaders, (Object)options);
        return request;
    }

    @Override
    public Mono<ResourceResponse<User>> replaceUser(User user, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceUserInternal(user, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<User>> replaceUserInternal(User user, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (user == null) {
                throw new IllegalArgumentException("user");
            }
            logger.debug("Replacing a User. user id [{}]", (Object)user.getId());
            RxDocumentClientImpl.validateResource(user);
            String path = Utils.joinPath(user.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.User, OperationType.Replace);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Replace, ResourceType.User, path, (Resource)user, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            logger.debug("Failure in replacing a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<User>> deleteUser(String userLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteUserInternal(userLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<User>> deleteUserInternal(String userLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(userLink)) {
                throw new IllegalArgumentException("userLink");
            }
            logger.debug("Deleting a User. userLink [{}]", (Object)userLink);
            String path = Utils.joinPath(userLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.User, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Delete, ResourceType.User, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            logger.debug("Failure in deleting a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<User>> readUser(String userLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readUserInternal(userLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<User>> readUserInternal(String userLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(userLink)) {
                throw new IllegalArgumentException("userLink");
            }
            logger.debug("Reading a User. userLink [{}]", (Object)userLink);
            String path = Utils.joinPath(userLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.User, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.User, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, User.class));
        }
        catch (Exception e) {
            logger.debug("Failure in reading a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<User>> readUsers(String databaseLink, CosmosQueryRequestOptions options) {
        if (StringUtils.isEmpty(databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        return this.readFeed(options, ResourceType.User, User.class, Utils.joinPath(databaseLink, "users"));
    }

    @Override
    public Flux<FeedResponse<User>> queryUsers(String databaseLink, String query, CosmosQueryRequestOptions options) {
        return this.queryUsers(databaseLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<User>> queryUsers(String databaseLink, SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery(databaseLink, querySpec, options, User.class, ResourceType.User);
    }

    @Override
    public Mono<ResourceResponse<ClientEncryptionKey>> readClientEncryptionKey(String clientEncryptionKeyLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readClientEncryptionKeyInternal(clientEncryptionKeyLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<ClientEncryptionKey>> readClientEncryptionKeyInternal(String clientEncryptionKeyLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(clientEncryptionKeyLink)) {
                throw new IllegalArgumentException("clientEncryptionKeyLink");
            }
            logger.debug("Reading a client encryption key. clientEncryptionKeyLink [{}]", (Object)clientEncryptionKeyLink);
            String path = Utils.joinPath(clientEncryptionKeyLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.ClientEncryptionKey, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.ClientEncryptionKey, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, ClientEncryptionKey.class));
        }
        catch (Exception e) {
            logger.debug("Failure in reading a client encryption key due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<ClientEncryptionKey>> createClientEncryptionKey(String databaseLink, ClientEncryptionKey clientEncryptionKey, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createClientEncryptionKeyInternal(databaseLink, clientEncryptionKey, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<ClientEncryptionKey>> createClientEncryptionKeyInternal(String databaseLink, ClientEncryptionKey clientEncryptionKey, RequestOptions options, DocumentClientRetryPolicy documentClientRetryPolicy) {
        try {
            logger.debug("Creating a client encryption key. databaseLink [{}], clientEncryptionKey id [{}]", (Object)databaseLink, (Object)clientEncryptionKey.getId());
            RxDocumentServiceRequest request = this.getClientEncryptionKeyRequest(databaseLink, clientEncryptionKey, options, OperationType.Create);
            return this.create(request, documentClientRetryPolicy, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, ClientEncryptionKey.class));
        }
        catch (Exception e) {
            logger.debug("Failure in creating a client encryption key due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    private RxDocumentServiceRequest getClientEncryptionKeyRequest(String databaseLink, ClientEncryptionKey clientEncryptionKey, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty(databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        if (clientEncryptionKey == null) {
            throw new IllegalArgumentException("clientEncryptionKey");
        }
        RxDocumentClientImpl.validateResource(clientEncryptionKey);
        String path = Utils.joinPath(databaseLink, "clientencryptionkeys");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.ClientEncryptionKey, operationType);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, operationType, ResourceType.ClientEncryptionKey, path, (Resource)clientEncryptionKey, requestHeaders, (Object)options);
        return request;
    }

    @Override
    public Mono<ResourceResponse<ClientEncryptionKey>> replaceClientEncryptionKey(ClientEncryptionKey clientEncryptionKey, String nameBasedLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceClientEncryptionKeyInternal(clientEncryptionKey, nameBasedLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<ClientEncryptionKey>> replaceClientEncryptionKeyInternal(ClientEncryptionKey clientEncryptionKey, String nameBasedLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (clientEncryptionKey == null) {
                throw new IllegalArgumentException("clientEncryptionKey");
            }
            logger.debug("Replacing a clientEncryptionKey. clientEncryptionKey id [{}]", (Object)clientEncryptionKey.getId());
            RxDocumentClientImpl.validateResource(clientEncryptionKey);
            String path = Utils.joinPath(nameBasedLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.ClientEncryptionKey, OperationType.Replace);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Replace, ResourceType.ClientEncryptionKey, path, (Resource)clientEncryptionKey, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, ClientEncryptionKey.class));
        }
        catch (Exception e) {
            logger.debug("Failure in replacing a clientEncryptionKey due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<ClientEncryptionKey>> readClientEncryptionKeys(String databaseLink, CosmosQueryRequestOptions options) {
        if (StringUtils.isEmpty(databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        return this.readFeed(options, ResourceType.ClientEncryptionKey, ClientEncryptionKey.class, Utils.joinPath(databaseLink, "clientencryptionkeys"));
    }

    @Override
    public Flux<FeedResponse<ClientEncryptionKey>> queryClientEncryptionKeys(String databaseLink, String query, CosmosQueryRequestOptions options) {
        return this.queryClientEncryptionKeys(databaseLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<ClientEncryptionKey>> queryClientEncryptionKeys(String databaseLink, SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery(databaseLink, querySpec, options, ClientEncryptionKey.class, ResourceType.ClientEncryptionKey);
    }

    @Override
    public Mono<ResourceResponse<Permission>> createPermission(String userLink, Permission permission, RequestOptions options) {
        DocumentClientRetryPolicy documentClientRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createPermissionInternal(userLink, permission, options, documentClientRetryPolicy), this.resetSessionTokenRetryPolicy.getRequestPolicy());
    }

    private Mono<ResourceResponse<Permission>> createPermissionInternal(String userLink, Permission permission, RequestOptions options, DocumentClientRetryPolicy documentClientRetryPolicy) {
        try {
            logger.debug("Creating a Permission. userLink [{}], permission id [{}]", (Object)userLink, (Object)permission.getId());
            RxDocumentServiceRequest request = this.getPermissionRequest(userLink, permission, options, OperationType.Create);
            return this.create(request, documentClientRetryPolicy, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            logger.debug("Failure in creating a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Permission>> upsertPermission(String userLink, Permission permission, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertPermissionInternal(userLink, permission, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Permission>> upsertPermissionInternal(String userLink, Permission permission, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            logger.debug("Upserting a Permission. userLink [{}], permission id [{}]", (Object)userLink, (Object)permission.getId());
            RxDocumentServiceRequest request = this.getPermissionRequest(userLink, permission, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            logger.debug("Failure in upserting a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    private RxDocumentServiceRequest getPermissionRequest(String userLink, Permission permission, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty(userLink)) {
            throw new IllegalArgumentException("userLink");
        }
        if (permission == null) {
            throw new IllegalArgumentException("permission");
        }
        RxDocumentClientImpl.validateResource(permission);
        String path = Utils.joinPath(userLink, "permissions");
        Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Permission, operationType);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, operationType, ResourceType.Permission, path, (Resource)permission, requestHeaders, (Object)options);
        return request;
    }

    @Override
    public Mono<ResourceResponse<Permission>> replacePermission(Permission permission, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replacePermissionInternal(permission, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Permission>> replacePermissionInternal(Permission permission, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (permission == null) {
                throw new IllegalArgumentException("permission");
            }
            logger.debug("Replacing a Permission. permission id [{}]", (Object)permission.getId());
            RxDocumentClientImpl.validateResource(permission);
            String path = Utils.joinPath(permission.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Permission, OperationType.Replace);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Replace, ResourceType.Permission, path, (Resource)permission, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            logger.debug("Failure in replacing a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Permission>> deletePermission(String permissionLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deletePermissionInternal(permissionLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Permission>> deletePermissionInternal(String permissionLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(permissionLink)) {
                throw new IllegalArgumentException("permissionLink");
            }
            logger.debug("Deleting a Permission. permissionLink [{}]", (Object)permissionLink);
            String path = Utils.joinPath(permissionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Permission, OperationType.Delete);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Delete, ResourceType.Permission, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request, retryPolicyInstance, this.getOperationContextAndListenerTuple(options)).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            logger.debug("Failure in deleting a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Permission>> readPermission(String permissionLink, RequestOptions options) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readPermissionInternal(permissionLink, options, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Permission>> readPermissionInternal(String permissionLink, RequestOptions options, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(permissionLink)) {
                throw new IllegalArgumentException("permissionLink");
            }
            logger.debug("Reading a Permission. permissionLink [{}]", (Object)permissionLink);
            String path = Utils.joinPath(permissionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options, ResourceType.Permission, OperationType.Read);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.Permission, path, requestHeaders, options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Permission.class));
        }
        catch (Exception e) {
            logger.debug("Failure in reading a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Permission>> readPermissions(String userLink, CosmosQueryRequestOptions options) {
        if (StringUtils.isEmpty(userLink)) {
            throw new IllegalArgumentException("userLink");
        }
        return this.readFeed(options, ResourceType.Permission, Permission.class, Utils.joinPath(userLink, "permissions"));
    }

    @Override
    public Flux<FeedResponse<Permission>> queryPermissions(String userLink, String query, CosmosQueryRequestOptions options) {
        return this.queryPermissions(userLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<Permission>> queryPermissions(String userLink, SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery(userLink, querySpec, options, Permission.class, ResourceType.Permission);
    }

    @Override
    public Mono<ResourceResponse<Offer>> replaceOffer(Offer offer) {
        DocumentClientRetryPolicy documentClientRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceOfferInternal(offer, documentClientRetryPolicy), documentClientRetryPolicy);
    }

    private Mono<ResourceResponse<Offer>> replaceOfferInternal(Offer offer, DocumentClientRetryPolicy documentClientRetryPolicy) {
        try {
            if (offer == null) {
                throw new IllegalArgumentException("offer");
            }
            logger.debug("Replacing an Offer. offer id [{}]", (Object)offer.getId());
            RxDocumentClientImpl.validateResource(offer);
            String path = Utils.joinPath(offer.getSelfLink(), null);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Replace, ResourceType.Offer, path, (Resource)offer, null, null);
            return this.replace(request, documentClientRetryPolicy).map(response -> BridgeInternal.toResourceResponse(response, Offer.class));
        }
        catch (Exception e) {
            logger.debug("Failure in replacing an Offer due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Mono<ResourceResponse<Offer>> readOffer(String offerLink) {
        DocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readOfferInternal(offerLink, retryPolicyInstance), retryPolicyInstance);
    }

    private Mono<ResourceResponse<Offer>> readOfferInternal(String offerLink, DocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty(offerLink)) {
                throw new IllegalArgumentException("offerLink");
            }
            logger.debug("Reading an Offer. offerLink [{}]", (Object)offerLink);
            String path = Utils.joinPath(offerLink, null);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.Offer, path, (Map<String, String>)null, null);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request, retryPolicyInstance).map(response -> BridgeInternal.toResourceResponse(response, Offer.class));
        }
        catch (Exception e) {
            logger.debug("Failure in reading an Offer due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    @Override
    public Flux<FeedResponse<Offer>> readOffers(CosmosQueryRequestOptions options) {
        return this.readFeed(options, ResourceType.Offer, Offer.class, Utils.joinPath("offers", null));
    }

    private <T> Flux<FeedResponse<T>> readFeed(CosmosQueryRequestOptions options, ResourceType resourceType, Class<T> klass, String resourceLink) {
        Integer maxItemCount;
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        int maxPageSize = (maxItemCount = ModelBridgeInternal.getMaxItemCountFromQueryRequestOptions(options)) != null ? maxItemCount : -1;
        CosmosQueryRequestOptions finalCosmosQueryRequestOptions = options;
        DocumentClientRetryPolicy retryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc = (continuationToken, pageSize) -> {
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            if (continuationToken != null) {
                requestHeaders.put("x-ms-continuation", (String)continuationToken);
            }
            requestHeaders.put("x-ms-max-item-count", Integer.toString(pageSize));
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.ReadFeed, resourceType, resourceLink, requestHeaders, finalCosmosQueryRequestOptions);
            retryPolicy.onBeforeSendRequest(request);
            return request;
        };
        Function executeFunc = request -> ObservableHelper.inlineIfPossibleAsObs(() -> this.readFeed((RxDocumentServiceRequest)request).map(response -> BridgeInternal.toFeedResponsePage(response, ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().getItemFactoryMethod(finalCosmosQueryRequestOptions, klass), klass)), retryPolicy);
        return Paginator.getPaginatedQueryResultAsObservable(options, createRequestFunc, executeFunc, maxPageSize);
    }

    @Override
    public Flux<FeedResponse<Offer>> queryOffers(String query, CosmosQueryRequestOptions options) {
        return this.queryOffers(new SqlQuerySpec(query), options);
    }

    @Override
    public Flux<FeedResponse<Offer>> queryOffers(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.createQuery(null, querySpec, options, Offer.class, ResourceType.Offer);
    }

    @Override
    public Mono<DatabaseAccount> getDatabaseAccount() {
        DocumentClientRetryPolicy documentClientRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.getDatabaseAccountInternal(documentClientRetryPolicy), documentClientRetryPolicy);
    }

    @Override
    public DatabaseAccount getLatestDatabaseAccount() {
        return this.globalEndpointManager.getLatestDatabaseAccount();
    }

    private Mono<DatabaseAccount> getDatabaseAccountInternal(DocumentClientRetryPolicy documentClientRetryPolicy) {
        try {
            logger.debug("Getting Database Account");
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.DatabaseAccount, "", (Map<String, String>)null, null);
            return this.read(request, documentClientRetryPolicy).map(ModelBridgeInternal::toDatabaseAccount);
        }
        catch (Exception e) {
            logger.debug("Failure in getting Database Account due to [{}]", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }

    public Object getSession() {
        return this.sessionContainer;
    }

    public void setSession(Object sessionContainer) {
        this.sessionContainer = (SessionContainer)sessionContainer;
    }

    @Override
    public RxClientCollectionCache getCollectionCache() {
        return this.collectionCache;
    }

    @Override
    public RxPartitionKeyRangeCache getPartitionKeyRangeCache() {
        return this.partitionKeyRangeCache;
    }

    public Flux<DatabaseAccount> getDatabaseAccountFromEndpoint(URI endpoint) {
        return Flux.defer(() -> {
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Read, ResourceType.DatabaseAccount, "", null, null);
            return this.populateHeadersAsync(request, RequestVerb.GET).flatMap(requestPopulated -> {
                requestPopulated.setEndpointOverride(endpoint);
                return this.gatewayProxy.processMessage((RxDocumentServiceRequest)requestPopulated).doOnError(e -> {
                    String message = String.format("Failed to retrieve database account information. %s", e.getCause() != null ? e.getCause().toString() : e.toString());
                    logger.warn(message);
                }).map(rsp -> rsp.getResource(DatabaseAccount.class)).doOnNext(databaseAccount -> {
                    this.useMultipleWriteLocations = this.connectionPolicy.isMultipleWriteRegionsEnabled() && BridgeInternal.isEnableMultipleWriteLocations(databaseAccount);
                });
            });
        });
    }

    private RxStoreModel getStoreProxy(RxDocumentServiceRequest request) {
        if (request.useGatewayMode) {
            return this.gatewayProxy;
        }
        ResourceType resourceType = request.getResourceType();
        OperationType operationType = request.getOperationType();
        if (resourceType == ResourceType.Offer || resourceType == ResourceType.ClientEncryptionKey || resourceType.isScript() && operationType != OperationType.ExecuteJavaScript || resourceType == ResourceType.PartitionKeyRange || resourceType == ResourceType.PartitionKey && operationType == OperationType.Delete) {
            return this.gatewayProxy;
        }
        if (operationType == OperationType.Create || operationType == OperationType.Upsert) {
            if (resourceType == ResourceType.Database || resourceType == ResourceType.User || resourceType == ResourceType.DocumentCollection || resourceType == ResourceType.Permission) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if (operationType == OperationType.Delete) {
            if (resourceType == ResourceType.Database || resourceType == ResourceType.User || resourceType == ResourceType.DocumentCollection) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if (operationType == OperationType.Replace) {
            if (resourceType == ResourceType.DocumentCollection) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if (operationType == OperationType.Read) {
            if (resourceType == ResourceType.DocumentCollection) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if ((operationType == OperationType.Query || operationType == OperationType.SqlQuery || operationType == OperationType.ReadFeed) && Utils.isCollectionChild(request.getResourceType()) && request.getPartitionKeyRangeIdentity() == null && request.getHeaders().get("x-ms-documentdb-partitionkey") == null) {
            return this.gatewayProxy;
        }
        return this.storeModel;
    }

    @Override
    public void close() {
        logger.info("Attempting to close client {}", (Object)this.clientId);
        if (!this.closed.getAndSet(true)) {
            activeClientsCnt.decrementAndGet();
            logger.info("Shutting down ...");
            logger.info("Closing Global Endpoint Manager ...");
            LifeCycleUtils.closeQuietly(this.globalEndpointManager);
            logger.info("Closing StoreClientFactory ...");
            LifeCycleUtils.closeQuietly(this.storeClientFactory);
            logger.info("Shutting down reactorHttpClient ...");
            LifeCycleUtils.closeQuietly(this.reactorHttpClient);
            logger.info("Shutting down CpuMonitor ...");
            CpuMemoryMonitor.unregister(this);
            if (this.throughputControlEnabled.get()) {
                logger.info("Closing ThroughputControlStore ...");
                this.throughputControlStore.close();
            }
            logger.info("Shutting down completed.");
        } else {
            logger.warn("Already shutdown!");
        }
    }

    @Override
    public ItemDeserializer getItemDeserializer() {
        return this.itemDeserializer;
    }

    @Override
    public synchronized void enableThroughputControlGroup(ThroughputControlGroupInternal group) {
        Preconditions.checkNotNull(group, "Throughput control group can not be null");
        if (this.throughputControlEnabled.compareAndSet(false, true)) {
            this.throughputControlStore = new ThroughputControlStore(this.collectionCache, this.connectionPolicy.getConnectionMode(), this.partitionKeyRangeCache);
            this.storeModel.enableThroughputControl(this.throughputControlStore);
        }
        this.throughputControlStore.enableThroughputControlGroup(group);
    }

    @Override
    public Flux<OpenConnectionResponse> openConnectionsAndInitCaches(String containerLink) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(containerLink), "Argument 'containerLink' should not be null nor empty");
        return this.storeModel.openConnectionsAndInitCaches(containerLink);
    }

    private static SqlQuerySpec createLogicalPartitionScanQuerySpec(PartitionKey partitionKey, String partitionKeySelector) {
        StringBuilder queryStringBuilder = new StringBuilder();
        ArrayList<SqlParameter> parameters = new ArrayList<SqlParameter>();
        queryStringBuilder.append("SELECT * FROM c WHERE");
        Object pkValue = ModelBridgeInternal.getPartitionKeyObject(partitionKey);
        String pkParamName = "@pkValue";
        parameters.add(new SqlParameter(pkParamName, pkValue));
        queryStringBuilder.append(" c");
        queryStringBuilder.append(partitionKeySelector);
        queryStringBuilder.append(" = ");
        queryStringBuilder.append(pkParamName);
        return new SqlQuerySpec(queryStringBuilder.toString(), parameters);
    }

    @Override
    public Mono<List<FeedRange>> getFeedRanges(String collectionLink) {
        InvalidPartitionExceptionRetryPolicy invalidPartitionExceptionRetryPolicy = new InvalidPartitionExceptionRetryPolicy(this.collectionCache, null, collectionLink, new HashMap<String, Object>());
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((DiagnosticsClientContext)this, OperationType.Query, ResourceType.Document, collectionLink, null);
        invalidPartitionExceptionRetryPolicy.onBeforeSendRequest(request);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.getFeedRangesInternal(request, collectionLink), invalidPartitionExceptionRetryPolicy);
    }

    private Mono<List<FeedRange>> getFeedRangesInternal(RxDocumentServiceRequest request, String collectionLink) {
        logger.debug("getFeedRange collectionLink=[{}]", (Object)collectionLink);
        if (StringUtils.isEmpty(collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(null, request);
        return collectionObs.flatMap(documentCollectionResourceResponse -> {
            DocumentCollection collection = (DocumentCollection)documentCollectionResourceResponse.v;
            if (collection == null) {
                throw new IllegalStateException("Collection cannot be null");
            }
            Mono<Utils.ValueHolder<List<PartitionKeyRange>>> valueHolderMono = this.partitionKeyRangeCache.tryGetOverlappingRangesAsync(BridgeInternal.getMetaDataDiagnosticContext(request.requestContext.cosmosDiagnostics), collection.getResourceId(), RANGE_INCLUDING_ALL_PARTITION_KEY_RANGES, true, null);
            return valueHolderMono.map(partitionKeyRangeList -> RxDocumentClientImpl.toFeedRanges(partitionKeyRangeList, request));
        });
    }

    private static List<FeedRange> toFeedRanges(Utils.ValueHolder<List<PartitionKeyRange>> partitionKeyRangeListValueHolder, RxDocumentServiceRequest request) {
        List partitionKeyRangeList = (List)partitionKeyRangeListValueHolder.v;
        if (partitionKeyRangeList == null) {
            request.forceNameCacheRefresh = true;
            throw new InvalidPartitionException();
        }
        ArrayList<FeedRange> feedRanges = new ArrayList<FeedRange>();
        partitionKeyRangeList.forEach(pkRange -> feedRanges.add(RxDocumentClientImpl.toFeedRange(pkRange)));
        return feedRanges;
    }

    private static FeedRange toFeedRange(PartitionKeyRange pkRange) {
        return new FeedRangeEpkImpl(pkRange.toRange());
    }
}

