/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.clienttelemetry;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.implementation.ClientSideRequestStatistics;
import com.azure.cosmos.implementation.FeedResponseDiagnostics;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.clienttelemetry.TagName;
import com.azure.cosmos.implementation.directconnectivity.RntbdTransportClient;
import com.azure.cosmos.implementation.directconnectivity.StoreResponseDiagnostics;
import com.azure.cosmos.implementation.directconnectivity.StoreResultDiagnostics;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpointStatistics;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdMetricsCompletionRecorder;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestRecord;
import com.azure.cosmos.implementation.guava25.net.PercentEscaper;
import com.azure.cosmos.implementation.query.QueryInfo;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientTelemetryMetrics {
    private static final Logger logger = LoggerFactory.getLogger(ClientTelemetryMetrics.class);
    private static final ImplementationBridgeHelpers.CosmosAsyncClientHelper.CosmosAsyncClientAccessor clientAccessor = ImplementationBridgeHelpers.CosmosAsyncClientHelper.getCosmosAsyncClientAccessor();
    private static final ImplementationBridgeHelpers.CosmosDiagnosticsHelper.CosmosDiagnosticsAccessor diagnosticsAccessor = ImplementationBridgeHelpers.CosmosDiagnosticsHelper.getCosmosDiagnosticsAccessor();
    private static final PercentEscaper PERCENT_ESCAPER = new PercentEscaper("_-/.", false);
    private static CompositeMeterRegistry compositeRegistry = ClientTelemetryMetrics.createFreshRegistry();
    private static final ConcurrentHashMap<MeterRegistry, AtomicLong> registryRefCount = new ConcurrentHashMap();

    /*
     * Enabled aggressive exception aggregation
     */
    private static String convertStackTraceToString(Throwable throwable) {
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                throwable.printStackTrace(pw);
                String string = sw.toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable2) {
                try {
                    pw.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    private static CompositeMeterRegistry createFreshRegistry() {
        CompositeMeterRegistry registry = new CompositeMeterRegistry();
        if (logger.isTraceEnabled()) {
            registry.config().onMeterAdded(meter -> logger.trace("Meter '{}' added. Callstack: {}", (Object)meter.getId().getName(), (Object)ClientTelemetryMetrics.convertStackTraceToString(new IllegalStateException("Dummy"))));
        }
        return registry;
    }

    public static void recordSystemUsage(float averageSystemCpuUsage, float freeMemoryAvailableInMB) {
        if (compositeRegistry.getRegistries().isEmpty()) {
            return;
        }
        DistributionSummary averageSystemCpuUsageMeter = DistributionSummary.builder((String)ClientTelemetryMetrics.nameOf("system.avgCpuLoad")).baseUnit("%").description("Avg. System CPU load").maximumExpectedValue(Double.valueOf(100.0)).publishPercentiles(new double[]{0.95, 0.99}).publishPercentileHistogram(Boolean.valueOf(true)).register((MeterRegistry)compositeRegistry);
        averageSystemCpuUsageMeter.record((double)averageSystemCpuUsage);
        DistributionSummary freeMemoryAvailableInMBMeter = DistributionSummary.builder((String)ClientTelemetryMetrics.nameOf("system.freeMemoryAvailable")).baseUnit("MB").description("Free memory available").publishPercentiles(new double[0]).publishPercentileHistogram(Boolean.valueOf(false)).register((MeterRegistry)compositeRegistry);
        freeMemoryAvailableInMBMeter.record((double)freeMemoryAvailableInMB);
    }

    public static void recordOperation(CosmosAsyncClient cosmosAsyncClient, CosmosDiagnostics cosmosDiagnostics, int statusCode, Integer maxItemCount, Integer actualItemCount, String containerId, String databaseId, OperationType operationType, ResourceType resourceType, ConsistencyLevel consistencyLevel, String operationId, float requestCharge, Duration latency) {
        if (compositeRegistry.getRegistries().isEmpty() || !clientAccessor.isClientTelemetryMetricsEnabled(cosmosAsyncClient)) {
            return;
        }
        boolean isPointOperation = maxItemCount == null || maxItemCount < 0;
        EnumSet<TagName> metricTagNames = clientAccessor.getMetricTagNames(cosmosAsyncClient);
        Set<String> contactedRegions = cosmosDiagnostics.getContactedRegionNames();
        Tags operationTags = ClientTelemetryMetrics.createOperationTags(metricTagNames, cosmosAsyncClient, statusCode, containerId, databaseId, operationType, resourceType, consistencyLevel, operationId, isPointOperation, contactedRegions);
        OperationMetricProducer metricProducer = new OperationMetricProducer(metricTagNames, operationTags);
        metricProducer.recordOperation(requestCharge, latency, maxItemCount == null ? -1 : maxItemCount, actualItemCount, cosmosDiagnostics, contactedRegions);
    }

    public static RntbdMetricsCompletionRecorder createRntbdMetrics(RntbdTransportClient client, RntbdEndpoint endpoint) {
        return new RntbdMetricsV2((MeterRegistry)compositeRegistry, client, endpoint);
    }

    public static synchronized void add(MeterRegistry registry) {
        if (registryRefCount.computeIfAbsent(registry, meterRegistry -> new AtomicLong(0L)).incrementAndGet() == 1L) {
            compositeRegistry.add(registry);
        }
    }

    public static synchronized void remove(MeterRegistry registry) {
        if (registryRefCount.get(registry).decrementAndGet() == 0L) {
            registry.clear();
            registry.close();
            compositeRegistry.remove(registry);
            if (compositeRegistry.getRegistries().isEmpty()) {
                compositeRegistry = ClientTelemetryMetrics.createFreshRegistry();
            }
        }
    }

    public static String escape(String value) {
        return PERCENT_ESCAPER.escape(value);
    }

    private static String nameOf(String member) {
        return "cosmos.client." + member;
    }

    private static Tags createOperationTags(EnumSet<TagName> metricTagNames, CosmosAsyncClient cosmosAsyncClient, int statusCode, String containerId, String databaseId, OperationType operationType, ResourceType resourceType, ConsistencyLevel consistencyLevel, String operationId, boolean isPointOperation, Set<String> contactedRegions) {
        ArrayList<Tag> effectiveTags = new ArrayList<Tag>();
        if (metricTagNames.contains((Object)TagName.ClientCorrelationId)) {
            effectiveTags.add(clientAccessor.getClientCorrelationTag(cosmosAsyncClient));
        }
        if (metricTagNames.contains((Object)TagName.Container)) {
            String containerTagValue = String.format("%s/%s/%s", ClientTelemetryMetrics.escape(clientAccessor.getAccountTagValue(cosmosAsyncClient)), databaseId != null ? ClientTelemetryMetrics.escape(databaseId) : "NONE", containerId != null ? ClientTelemetryMetrics.escape(containerId) : "NONE");
            effectiveTags.add(Tag.of((String)TagName.Container.toString(), (String)containerTagValue));
        }
        if (metricTagNames.contains((Object)TagName.Operation)) {
            String operationTagValue = !isPointOperation && !Strings.isNullOrWhiteSpace(operationId) ? String.format("%s/%s/%s", resourceType.toString(), operationType.toString(), ClientTelemetryMetrics.escape(operationId)) : String.format("%s/%s", resourceType.toString(), operationType.toString());
            effectiveTags.add(Tag.of((String)TagName.Operation.toString(), (String)operationTagValue));
        }
        if (metricTagNames.contains((Object)TagName.OperationStatusCode)) {
            effectiveTags.add(Tag.of((String)TagName.OperationStatusCode.toString(), (String)String.valueOf(statusCode)));
        }
        if (metricTagNames.contains((Object)TagName.ConsistencyLevel)) {
            effectiveTags.add(Tag.of((String)TagName.ConsistencyLevel.toString(), (String)(consistencyLevel == null ? BridgeInternal.getContextClient(cosmosAsyncClient).getConsistencyLevel().toString() : consistencyLevel.toString())));
        }
        if (contactedRegions != null && contactedRegions.size() > 0 && metricTagNames.contains((Object)TagName.RegionName)) {
            effectiveTags.add(Tag.of((String)TagName.RegionName.toString(), (String)String.join((CharSequence)", ", contactedRegions)));
        }
        return Tags.of(effectiveTags);
    }

    private static class OperationMetricProducer {
        private final EnumSet<TagName> metricTagNames;
        private final Tags operationTags;

        public OperationMetricProducer(EnumSet<TagName> metricTagNames, Tags operationTags) {
            this.metricTagNames = metricTagNames;
            this.operationTags = operationTags;
        }

        public void recordOperation(float requestCharge, Duration latency, int maxItemCount, int actualItemCount, CosmosDiagnostics diagnostics, Set<String> contactedRegions) {
            FeedResponseDiagnostics feedDiagnostics;
            Counter operationsCounter = Counter.builder((String)ClientTelemetryMetrics.nameOf("op.calls")).baseUnit("calls").description("Operation calls").tags((Iterable)this.operationTags).register((MeterRegistry)compositeRegistry);
            operationsCounter.increment();
            DistributionSummary requestChargeMeter = DistributionSummary.builder((String)ClientTelemetryMetrics.nameOf("op.RUs")).baseUnit("RU (request unit)").description("Operation RU charge").maximumExpectedValue(Double.valueOf(1.0E7)).publishPercentiles(new double[]{0.95, 0.99}).publishPercentileHistogram(Boolean.valueOf(true)).tags((Iterable)this.operationTags).register((MeterRegistry)compositeRegistry);
            requestChargeMeter.record(Math.min((double)requestCharge, 1.0E7));
            DistributionSummary regionsContactedMeter = DistributionSummary.builder((String)ClientTelemetryMetrics.nameOf("op.regionsContacted")).baseUnit("Regions contacted").description("Operation - regions contacted").maximumExpectedValue(Double.valueOf(100.0)).publishPercentiles(new double[]{0.95, 0.99}).publishPercentileHistogram(Boolean.valueOf(true)).tags((Iterable)this.operationTags).register((MeterRegistry)compositeRegistry);
            if (contactedRegions != null && contactedRegions.size() > 0) {
                regionsContactedMeter.record(Math.min((double)contactedRegions.size(), 100.0));
            }
            Timer latencyMeter = Timer.builder((String)ClientTelemetryMetrics.nameOf("op.latency")).description("Operation latency").maximumExpectedValue(Duration.ofSeconds(300L)).publishPercentiles(new double[]{0.95, 0.99}).publishPercentileHistogram(Boolean.valueOf(true)).tags((Iterable)this.operationTags).register((MeterRegistry)compositeRegistry);
            latencyMeter.record(latency);
            this.recordItemCounts(maxItemCount, actualItemCount);
            List<ClientSideRequestStatistics> clientSideRequestStatistics = diagnosticsAccessor.getClientSideRequestStatistics(diagnostics);
            if (clientSideRequestStatistics != null) {
                for (ClientSideRequestStatistics requestStatistics : clientSideRequestStatistics) {
                    this.recordStoreResponseStatistics(requestStatistics.getResponseStatisticsList());
                    this.recordStoreResponseStatistics(requestStatistics.getSupplementalResponseStatisticsList());
                    this.recordGatewayStatistics(requestStatistics.getDuration(), requestStatistics.getGatewayStatistics());
                    this.recordAddressResolutionStatistics(requestStatistics.getAddressResolutionStatistics());
                }
            }
            if ((feedDiagnostics = diagnosticsAccessor.getFeedResponseDiagnostics(diagnostics)) == null) {
                return;
            }
            QueryInfo.QueryPlanDiagnosticsContext queryPlanDiagnostics = feedDiagnostics.getQueryPlanDiagnosticsContext();
            this.recordQueryPlanDiagnostics(queryPlanDiagnostics);
        }

        private void recordQueryPlanDiagnostics(QueryInfo.QueryPlanDiagnosticsContext queryPlanDiagnostics) {
            if (queryPlanDiagnostics == null) {
                return;
            }
            Tags requestTags = this.operationTags.and((Iterable)this.createQueryPlanTags(this.metricTagNames));
            Counter requestCounter = Counter.builder((String)ClientTelemetryMetrics.nameOf("req.gw.requests")).baseUnit("requests").description("Gateway requests").tags((Iterable)requestTags).register((MeterRegistry)compositeRegistry);
            requestCounter.increment();
            Duration latency = queryPlanDiagnostics.getDuration();
            if (latency != null) {
                Timer requestLatencyMeter = Timer.builder((String)ClientTelemetryMetrics.nameOf("req.gw.latency")).description("Gateway Request latency").maximumExpectedValue(Duration.ofSeconds(300L)).publishPercentiles(new double[]{0.95, 0.99}).publishPercentileHistogram(Boolean.valueOf(true)).tags((Iterable)requestTags).register((MeterRegistry)compositeRegistry);
                requestLatencyMeter.record(latency);
            }
            this.recordRequestTimeline("req.gw.timeline.", queryPlanDiagnostics.getRequestTimeline(), requestTags);
        }

        private void recordRequestPayloadSizes(int requestPayloadSizeInBytes, int responsePayloadSizeInBytes) {
            DistributionSummary requestPayloadSizeMeter = DistributionSummary.builder((String)ClientTelemetryMetrics.nameOf("req.reqPayloadSize")).baseUnit("bytes").description("Request payload size in bytes").maximumExpectedValue(Double.valueOf(16384.0)).publishPercentiles(new double[0]).publishPercentileHistogram(Boolean.valueOf(false)).tags((Iterable)this.operationTags).register((MeterRegistry)compositeRegistry);
            requestPayloadSizeMeter.record((double)requestPayloadSizeInBytes);
            DistributionSummary responsePayloadSizeMeter = DistributionSummary.builder((String)ClientTelemetryMetrics.nameOf("req.rspPayloadSize")).baseUnit("bytes").description("Response payload size in bytes").maximumExpectedValue(Double.valueOf(16384.0)).publishPercentiles(new double[0]).publishPercentileHistogram(Boolean.valueOf(false)).tags((Iterable)this.operationTags).register((MeterRegistry)compositeRegistry);
            responsePayloadSizeMeter.record((double)responsePayloadSizeInBytes);
        }

        private void recordItemCounts(int maxItemCount, int actualItemCount) {
            if (maxItemCount > 0) {
                DistributionSummary maxItemCountMeter = DistributionSummary.builder((String)ClientTelemetryMetrics.nameOf("op.maxItemCount")).baseUnit("item count").description("Request max. item count").maximumExpectedValue(Double.valueOf(1000000.0)).publishPercentiles(new double[0]).publishPercentileHistogram(Boolean.valueOf(false)).tags((Iterable)this.operationTags).register((MeterRegistry)compositeRegistry);
                maxItemCountMeter.record(Math.max(0.0, Math.min((double)maxItemCount, 1000000.0)));
                DistributionSummary actualItemCountMeter = DistributionSummary.builder((String)ClientTelemetryMetrics.nameOf("op.actualItemCount")).baseUnit("item count").description("Response actual item count").maximumExpectedValue(Double.valueOf(1000000.0)).publishPercentiles(new double[0]).publishPercentileHistogram(Boolean.valueOf(false)).tags((Iterable)this.operationTags).register((MeterRegistry)compositeRegistry);
                actualItemCountMeter.record(Math.max(0.0, Math.min((double)actualItemCount, 1000000.0)));
            }
        }

        private Tags createRequestTags(EnumSet<TagName> metricTagNames, String pkRangeId, int statusCode, int subStatusCode, ResourceType resourceType, OperationType operationType, String regionName, String serviceEndpoint, String serviceAddress) {
            ArrayList<Tag> effectiveTags = new ArrayList<Tag>();
            if (metricTagNames.contains((Object)TagName.PartitionKeyRangeId)) {
                effectiveTags.add(Tag.of((String)TagName.PartitionKeyRangeId.toString(), (String)(Strings.isNullOrWhiteSpace(pkRangeId) ? "NONE" : ClientTelemetryMetrics.escape(pkRangeId))));
            }
            if (metricTagNames.contains((Object)TagName.RequestStatusCode)) {
                effectiveTags.add(Tag.of((String)TagName.RequestStatusCode.toString(), (String)String.format("%d/%d", statusCode, subStatusCode)));
            }
            if (metricTagNames.contains((Object)TagName.RequestOperationType)) {
                effectiveTags.add(Tag.of((String)TagName.RequestOperationType.toString(), (String)String.format("%s/%s", resourceType.toString(), operationType.toString())));
            }
            if (metricTagNames.contains((Object)TagName.RegionName)) {
                effectiveTags.add(Tag.of((String)TagName.RegionName.toString(), (String)(regionName != null ? regionName : "NONE")));
            }
            if (metricTagNames.contains((Object)TagName.ServiceEndpoint)) {
                effectiveTags.add(Tag.of((String)TagName.ServiceEndpoint.toString(), (String)(serviceEndpoint != null ? ClientTelemetryMetrics.escape(serviceEndpoint) : "NONE")));
            }
            if (metricTagNames.contains((Object)TagName.ServiceAddress)) {
                effectiveTags.add(Tag.of((String)TagName.ServiceAddress.toString(), (String)(serviceAddress != null ? ClientTelemetryMetrics.escape(serviceAddress) : "NONE")));
            }
            return Tags.of(effectiveTags);
        }

        private Tags createQueryPlanTags(EnumSet<TagName> metricTagNames) {
            ArrayList<Tag> effectiveTags = new ArrayList<Tag>();
            if (metricTagNames.contains((Object)TagName.RequestOperationType)) {
                effectiveTags.add(Tag.of((String)TagName.RequestOperationType.toString(), (String)String.format("%s/%s", new Object[]{ResourceType.DocumentCollection, OperationType.QueryPlan})));
            }
            return Tags.of(effectiveTags);
        }

        private Tags createAddressResolutionTags(EnumSet<TagName> metricTagNames, String serviceEndpoint, boolean isForceRefresh, boolean isForceCollectionRoutingMapRefresh) {
            ArrayList<Tag> effectiveTags = new ArrayList<Tag>();
            if (metricTagNames.contains((Object)TagName.ServiceEndpoint)) {
                effectiveTags.add(Tag.of((String)TagName.ServiceEndpoint.toString(), (String)(serviceEndpoint != null ? ClientTelemetryMetrics.escape(serviceEndpoint) : "NONE")));
            }
            if (metricTagNames.contains((Object)TagName.IsForceRefresh)) {
                effectiveTags.add(Tag.of((String)TagName.IsForceRefresh.toString(), (String)(isForceRefresh ? "True" : "False")));
            }
            if (metricTagNames.contains((Object)TagName.IsForceCollectionRoutingMapRefresh)) {
                effectiveTags.add(Tag.of((String)TagName.IsForceCollectionRoutingMapRefresh.toString(), (String)(isForceCollectionRoutingMapRefresh ? "True" : "False")));
            }
            return Tags.of(effectiveTags);
        }

        private void recordRntbdEndpointStatistics(RntbdEndpointStatistics endpointStatistics, Tags requestTags) {
            if (endpointStatistics == null) {
                return;
            }
            DistributionSummary acquiredChannelsMeter = DistributionSummary.builder((String)ClientTelemetryMetrics.nameOf("req.rntbd.stats.endpoint.acquiredChannels")).baseUnit("#").description("Endpoint statistics(acquired channels)").maximumExpectedValue(Double.valueOf(100000.0)).publishPercentiles(new double[0]).publishPercentileHistogram(Boolean.valueOf(false)).tags((Iterable)requestTags).register((MeterRegistry)compositeRegistry);
            acquiredChannelsMeter.record((double)endpointStatistics.getAcquiredChannels());
            DistributionSummary availableChannelsMeter = DistributionSummary.builder((String)ClientTelemetryMetrics.nameOf("req.rntbd.stats.endpoint.availableChannels")).baseUnit("#").description("Endpoint statistics(available channels)").maximumExpectedValue(Double.valueOf(100000.0)).publishPercentiles(new double[0]).publishPercentileHistogram(Boolean.valueOf(false)).tags((Iterable)requestTags).register((MeterRegistry)compositeRegistry);
            availableChannelsMeter.record((double)endpointStatistics.getAvailableChannels());
            DistributionSummary inflightRequestsMeter = DistributionSummary.builder((String)ClientTelemetryMetrics.nameOf("req.rntbd.stats.endpoint.inflightRequests")).baseUnit("#").description("Endpoint statistics(inflight requests)").tags((Iterable)requestTags).maximumExpectedValue(Double.valueOf(1000000.0)).publishPercentiles(new double[]{0.95, 0.99}).publishPercentileHistogram(Boolean.valueOf(true)).register((MeterRegistry)compositeRegistry);
            inflightRequestsMeter.record((double)endpointStatistics.getInflightRequests());
        }

        private void recordRequestTimeline(String prefix, RequestTimeline requestTimeline, Tags requestTags) {
            if (requestTimeline == null) {
                return;
            }
            for (RequestTimeline.Event event : requestTimeline) {
                Duration duration = event.getDuration();
                if (duration == null || duration == Duration.ZERO) continue;
                Timer eventMeter = Timer.builder((String)ClientTelemetryMetrics.nameOf(prefix + ClientTelemetryMetrics.escape(event.getName()))).description(String.format("Request timeline (%s)", event.getName())).maximumExpectedValue(Duration.ofSeconds(300L)).publishPercentiles(new double[]{0.95, 0.99}).publishPercentileHistogram(Boolean.valueOf(true)).tags((Iterable)requestTags).register((MeterRegistry)compositeRegistry);
                eventMeter.record(duration);
            }
        }

        private void recordStoreResponseStatistics(List<ClientSideRequestStatistics.StoreResponseStatistics> storeResponseStatistics) {
            for (ClientSideRequestStatistics.StoreResponseStatistics responseStatistics : storeResponseStatistics) {
                StoreResultDiagnostics storeResultDiagnostics = responseStatistics.getStoreResult();
                StoreResponseDiagnostics storeResponseDiagnostics = storeResultDiagnostics.getStoreResponseDiagnostics();
                Tags requestTags = this.operationTags.and((Iterable)this.createRequestTags(this.metricTagNames, storeResponseDiagnostics.getPartitionKeyRangeId(), storeResponseDiagnostics.getStatusCode(), storeResponseDiagnostics.getSubStatusCode(), responseStatistics.getRequestResourceType(), responseStatistics.getRequestOperationType(), responseStatistics.getRegionName(), storeResultDiagnostics.getStorePhysicalAddressEscapedAuthority(), storeResultDiagnostics.getStorePhysicalAddressEscapedPath()));
                Double backendLatency = storeResultDiagnostics.getBackendLatencyInMs();
                if (backendLatency != null) {
                    DistributionSummary backendRequestLatencyMeter = DistributionSummary.builder((String)ClientTelemetryMetrics.nameOf("req.rntbd.backendLatency")).baseUnit("ms").description("Backend service latency").maximumExpectedValue(Double.valueOf(6000.0)).publishPercentiles(new double[]{0.95, 0.99}).publishPercentileHistogram(Boolean.valueOf(true)).tags((Iterable)requestTags).register((MeterRegistry)compositeRegistry);
                    backendRequestLatencyMeter.record(storeResultDiagnostics.getBackendLatencyInMs().doubleValue());
                }
                double requestCharge = storeResponseDiagnostics.getRequestCharge();
                DistributionSummary requestChargeMeter = DistributionSummary.builder((String)ClientTelemetryMetrics.nameOf("req.rntbd.RUs")).baseUnit("RU (request unit)").description("RNTBD Request RU charge").maximumExpectedValue(Double.valueOf(1000000.0)).publishPercentiles(new double[]{0.95, 0.99}).publishPercentileHistogram(Boolean.valueOf(true)).tags((Iterable)requestTags).register((MeterRegistry)compositeRegistry);
                requestChargeMeter.record(Math.min(requestCharge, 1000000.0));
                Duration latency = responseStatistics.getDuration();
                if (latency != null) {
                    Timer requestLatencyMeter = Timer.builder((String)ClientTelemetryMetrics.nameOf("req.rntbd.latency")).description("RNTBD Request latency").maximumExpectedValue(Duration.ofSeconds(6L)).publishPercentiles(new double[]{0.95, 0.99}).publishPercentileHistogram(Boolean.valueOf(true)).tags((Iterable)requestTags).register((MeterRegistry)compositeRegistry);
                    requestLatencyMeter.record(latency);
                }
                Counter requestCounter = Counter.builder((String)ClientTelemetryMetrics.nameOf("req.rntbd.requests")).baseUnit("requests").description("RNTBD requests").tags((Iterable)requestTags).register((MeterRegistry)compositeRegistry);
                requestCounter.increment();
                this.recordRequestTimeline("req.rntbd.timeline.", storeResponseDiagnostics.getRequestTimeline(), requestTags);
                this.recordRequestPayloadSizes(storeResponseDiagnostics.getRequestPayloadLength(), storeResponseDiagnostics.getResponsePayloadLength());
                this.recordRntbdEndpointStatistics(storeResponseDiagnostics.getRntbdEndpointStatistics(), requestTags);
            }
        }

        private void recordGatewayStatistics(Duration latency, ClientSideRequestStatistics.GatewayStatistics gatewayStatistics) {
            if (gatewayStatistics == null) {
                return;
            }
            Object metricTagNamesForGateway = this.metricTagNames.clone();
            ((AbstractCollection)metricTagNamesForGateway).remove((Object)TagName.RegionName);
            ((AbstractCollection)metricTagNamesForGateway).remove((Object)TagName.ServiceAddress);
            ((AbstractCollection)metricTagNamesForGateway).remove((Object)TagName.ServiceEndpoint);
            Tags requestTags = this.operationTags.and((Iterable)this.createRequestTags((EnumSet<TagName>)metricTagNamesForGateway, gatewayStatistics.getPartitionKeyRangeId(), gatewayStatistics.getStatusCode(), gatewayStatistics.getSubStatusCode(), gatewayStatistics.getResourceType(), gatewayStatistics.getOperationType(), null, null, null));
            Counter requestCounter = Counter.builder((String)ClientTelemetryMetrics.nameOf("req.gw.requests")).baseUnit("requests").description("Gateway requests").tags((Iterable)requestTags).register((MeterRegistry)compositeRegistry);
            requestCounter.increment();
            double requestCharge = gatewayStatistics.getRequestCharge();
            DistributionSummary requestChargeMeter = DistributionSummary.builder((String)ClientTelemetryMetrics.nameOf("req.gw.RUs")).baseUnit("RU (request unit)").description("Gateway Request RU charge").maximumExpectedValue(Double.valueOf(1000000.0)).publishPercentiles(new double[]{0.95, 0.99}).publishPercentileHistogram(Boolean.valueOf(true)).tags((Iterable)requestTags).register((MeterRegistry)compositeRegistry);
            requestChargeMeter.record(Math.min(requestCharge, 1000000.0));
            if (latency != null) {
                Timer requestLatencyMeter = Timer.builder((String)ClientTelemetryMetrics.nameOf("req.gw.latency")).description("Gateway Request latency").maximumExpectedValue(Duration.ofSeconds(300L)).publishPercentiles(new double[]{0.95, 0.99}).publishPercentileHistogram(Boolean.valueOf(true)).tags((Iterable)requestTags).register((MeterRegistry)compositeRegistry);
                requestLatencyMeter.record(latency);
            }
            this.recordRequestTimeline("req.gw.timeline.", gatewayStatistics.getRequestTimeline(), requestTags);
        }

        private void recordAddressResolutionStatistics(Map<String, ClientSideRequestStatistics.AddressResolutionStatistics> addressResolutionStatisticsMap) {
            if (addressResolutionStatisticsMap == null || addressResolutionStatisticsMap.size() == 0) {
                return;
            }
            for (ClientSideRequestStatistics.AddressResolutionStatistics addressResolutionStatistics : addressResolutionStatisticsMap.values()) {
                if (addressResolutionStatistics.isInflightRequest() || addressResolutionStatistics.getEndTimeUTC() == null) continue;
                Tags addressResolutionTags = this.operationTags.and((Iterable)this.createAddressResolutionTags(this.metricTagNames, addressResolutionStatistics.getTargetEndpoint(), addressResolutionStatistics.isForceRefresh(), addressResolutionStatistics.isForceCollectionRoutingMapRefresh()));
                Duration latency = Duration.between(addressResolutionStatistics.getStartTimeUTC(), addressResolutionStatistics.getEndTimeUTC());
                Timer addressResolutionLatencyMeter = Timer.builder((String)ClientTelemetryMetrics.nameOf("rntbd.addressResolution.latency")).description("Address resolution latency").maximumExpectedValue(Duration.ofSeconds(6L)).publishPercentiles(new double[]{0.95, 0.99}).publishPercentileHistogram(Boolean.valueOf(true)).tags((Iterable)addressResolutionTags).register((MeterRegistry)compositeRegistry);
                addressResolutionLatencyMeter.record(latency);
                Counter requestCounter = Counter.builder((String)ClientTelemetryMetrics.nameOf("rntbd.addressResolution.requests")).baseUnit("requests").description("Address resolution requests").tags((Iterable)addressResolutionTags).register((MeterRegistry)compositeRegistry);
                requestCounter.increment();
            }
        }
    }

    private static class RntbdMetricsV2
    implements RntbdMetricsCompletionRecorder {
        private final DistributionSummary requestSize;
        private final Timer requests;
        private final Timer responseErrors;
        private final DistributionSummary responseSize;
        private final Timer responseSuccesses;

        private RntbdMetricsV2(MeterRegistry registry, RntbdTransportClient client, RntbdEndpoint endpoint) {
            Tags tags = Tags.of((Tag[])new Tag[]{endpoint.clientMetricTag()});
            this.requests = Timer.builder((String)ClientTelemetryMetrics.nameOf("rntbd.requests.latency")).description("RNTBD request latency").tags((Iterable)tags).maximumExpectedValue(Duration.ofSeconds(300L)).publishPercentileHistogram(Boolean.valueOf(true)).publishPercentiles(new double[]{0.95, 0.99}).register(registry);
            this.responseErrors = Timer.builder((String)ClientTelemetryMetrics.nameOf("rntbd.requests.failed.latency")).description("RNTBD failed request latency").tags((Iterable)tags).maximumExpectedValue(Duration.ofSeconds(300L)).publishPercentileHistogram(Boolean.valueOf(true)).publishPercentiles(new double[]{0.95, 0.99}).register(registry);
            this.responseSuccesses = Timer.builder((String)ClientTelemetryMetrics.nameOf("rntbd.requests.successful.latency")).description("RNTBD successful request latency").tags((Iterable)tags).maximumExpectedValue(Duration.ofSeconds(300L)).publishPercentileHistogram(Boolean.valueOf(true)).publishPercentiles(new double[]{0.95, 0.99}).register(registry);
            Gauge.builder((String)ClientTelemetryMetrics.nameOf("rntbd.endpoints.count"), (Object)client, RntbdTransportClient::endpointCount).description("RNTBD endpoint count").register(registry);
            Gauge.builder((String)ClientTelemetryMetrics.nameOf("rntbd.endpoints.evicted"), (Object)client, RntbdTransportClient::endpointEvictionCount).description("RNTBD endpoint eviction count").register(registry);
            Gauge.builder((String)ClientTelemetryMetrics.nameOf("rntbd.requests.concurrent.count"), (Object)endpoint, RntbdEndpoint::concurrentRequests).description("RNTBD concurrent requests (executing or queued request count)").tags((Iterable)tags).register(registry);
            Gauge.builder((String)ClientTelemetryMetrics.nameOf("rntbd.requests.queued.count"), (Object)endpoint, RntbdEndpoint::requestQueueLength).description("RNTBD queued request count").tags((Iterable)tags).register(registry);
            Gauge.builder((String)ClientTelemetryMetrics.nameOf("rntbd.channels.acquired.count"), (Object)endpoint, RntbdEndpoint::channelsAcquiredMetric).description("RNTBD acquired channel count").tags((Iterable)tags).register(registry);
            Gauge.builder((String)ClientTelemetryMetrics.nameOf("rntbd.channels.available.count"), (Object)endpoint, RntbdEndpoint::channelsAvailableMetric).description("RNTBD available channel count").tags((Iterable)tags).register(registry);
            this.requestSize = DistributionSummary.builder((String)ClientTelemetryMetrics.nameOf("rntbd.req.reqSize")).description("RNTBD request size (bytes)").baseUnit("bytes").tags((Iterable)tags).maximumExpectedValue(Double.valueOf(1.6E7)).publishPercentileHistogram(Boolean.valueOf(false)).publishPercentiles(new double[0]).register(registry);
            this.responseSize = DistributionSummary.builder((String)ClientTelemetryMetrics.nameOf("rntbd.req.rspSize")).description("RNTBD response size (bytes)").baseUnit("bytes").tags((Iterable)tags).maximumExpectedValue(Double.valueOf(1.6E7)).publishPercentileHistogram(Boolean.valueOf(false)).publishPercentiles(new double[0]).register(registry);
        }

        @Override
        public void markComplete(RntbdRequestRecord requestRecord) {
            requestRecord.stop(this.requests, requestRecord.isCompletedExceptionally() ? this.responseErrors : this.responseSuccesses);
            this.requestSize.record((double)requestRecord.requestLength());
            this.responseSize.record((double)requestRecord.responseLength());
        }
    }
}

