/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.query.DocumentProducer;
import com.azure.cosmos.implementation.query.DocumentQueryExecutionContextBase;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.TriFunction;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlQuerySpec;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class ParallelDocumentQueryExecutionContextBase<T>
extends DocumentQueryExecutionContextBase<T>
implements IDocumentQueryExecutionComponent<T> {
    protected final List<DocumentProducer<T>> documentProducers;
    protected final SqlQuerySpec querySpec;
    protected int top = -1;
    private final Function<JsonNode, T> factoryMethod;

    protected ParallelDocumentQueryExecutionContextBase(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceLink, String rewrittenQuery, UUID correlatedActivityId, boolean shouldUnwrapSelectValue) {
        super(diagnosticsClientContext, client, resourceTypeEnum, resourceType, query, cosmosQueryRequestOptions, resourceLink, correlatedActivityId);
        this.factoryMethod = DocumentQueryExecutionContextBase.getEffectiveFactoryMethod(this.cosmosQueryRequestOptions, shouldUnwrapSelectValue, resourceType);
        this.documentProducers = new ArrayList<DocumentProducer<T>>();
        this.querySpec = !Strings.isNullOrEmpty(rewrittenQuery) ? new SqlQuerySpec(rewrittenQuery, this.query.getParameters()) : this.query;
    }

    protected void initialize(String collectionRid, Map<FeedRangeEpkImpl, String> feedRangeToContinuationTokenMap, int initialPageSize, SqlQuerySpec querySpecForInit) {
        Map<String, String> commonRequestHeaders = this.createCommonHeadersAsync(this.getFeedOptions(null, null));
        for (Map.Entry<FeedRangeEpkImpl, String> entry : feedRangeToContinuationTokenMap.entrySet()) {
            TriFunction<FeedRangeEpkImpl, String, Integer, RxDocumentServiceRequest> createRequestFunc = (feedRange, continuationToken, pageSize) -> {
                HashMap<String, String> headers = new HashMap<String, String>(commonRequestHeaders);
                headers.put("x-ms-continuation", (String)continuationToken);
                headers.put("x-ms-max-item-count", Strings.toString(pageSize));
                headers.put("x-ms-cosmos-correlated-activityid", this.correlatedActivityId.toString());
                PartitionKeyInternal partitionKeyInternal = null;
                if (this.cosmosQueryRequestOptions.getPartitionKey() != null && this.cosmosQueryRequestOptions.getPartitionKey() != PartitionKey.NONE) {
                    partitionKeyInternal = BridgeInternal.getPartitionKeyInternal(this.cosmosQueryRequestOptions.getPartitionKey());
                    headers.put("x-ms-documentdb-partitionkey", partitionKeyInternal.toJson());
                }
                return this.createDocumentServiceRequestWithFeedRange((Map<String, String>)headers, querySpecForInit, partitionKeyInternal, (FeedRange)feedRange, collectionRid, this.cosmosQueryRequestOptions.getThroughputControlGroupName());
            };
            Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc = request -> this.executeRequestAsync(this.factoryMethod, (RxDocumentServiceRequest)request);
            FeedRangeEpkImpl targetRange = entry.getKey();
            String continuationToken2 = entry.getValue();
            DocumentProducer<T> dp = this.createDocumentProducer(collectionRid, continuationToken2, initialPageSize, this.cosmosQueryRequestOptions, querySpecForInit, commonRequestHeaders, createRequestFunc, executeFunc, () -> this.client.getResetSessionTokenRetryPolicy().getRequestPolicy(), targetRange);
            this.documentProducers.add(dp);
        }
    }

    protected abstract DocumentProducer<T> createDocumentProducer(String var1, String var2, int var3, CosmosQueryRequestOptions var4, SqlQuerySpec var5, Map<String, String> var6, TriFunction<FeedRangeEpkImpl, String, Integer, RxDocumentServiceRequest> var7, Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> var8, Callable<DocumentClientRetryPolicy> var9, FeedRangeEpkImpl var10);

    @Override
    public abstract Flux<FeedResponse<T>> drainAsync(int var1);

    public void setTop(int newTop) {
        this.top = newTop;
        for (DocumentProducer<T> producer : this.documentProducers) {
            producer.top = newTop;
        }
    }

    protected void initializeReadMany(Map<PartitionKeyRange, SqlQuerySpec> rangeQueryMap, CosmosQueryRequestOptions cosmosQueryRequestOptions, String collectionRid) {
        Map<String, String> commonRequestHeaders = this.createCommonHeadersAsync(this.getFeedOptions(null, null));
        for (Map.Entry<PartitionKeyRange, SqlQuerySpec> entry : rangeQueryMap.entrySet()) {
            PartitionKeyRange targetRange = entry.getKey();
            FeedRangeEpkImpl feedRangeEpk = new FeedRangeEpkImpl(targetRange.toRange());
            SqlQuerySpec querySpec = entry.getValue();
            TriFunction<FeedRangeEpkImpl, String, Integer, RxDocumentServiceRequest> createRequestFunc = (partitionKeyRange, continuationToken, pageSize) -> {
                HashMap<String, String> headers = new HashMap<String, String>(commonRequestHeaders);
                headers.put("x-ms-continuation", (String)continuationToken);
                headers.put("x-ms-max-item-count", Strings.toString(pageSize));
                return this.createDocumentServiceRequestWithFeedRange((Map<String, String>)headers, querySpec, null, (FeedRange)partitionKeyRange, collectionRid, cosmosQueryRequestOptions.getThroughputControlGroupName());
            };
            Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc = request -> this.executeRequestAsync(this.factoryMethod, (RxDocumentServiceRequest)request);
            DocumentProducer<T> dp = this.createDocumentProducer(collectionRid, null, -1, cosmosQueryRequestOptions, querySpec, commonRequestHeaders, createRequestFunc, executeFunc, () -> this.client.getResetSessionTokenRetryPolicy().getRequestPolicy(), feedRangeEpk);
            this.documentProducers.add(dp);
        }
    }
}

