/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ConnectionPolicy;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.GoneException;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OpenConnectionResponse;
import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.clienttelemetry.ClientTelemetry;
import com.azure.cosmos.implementation.clienttelemetry.CosmosMeterOptions;
import com.azure.cosmos.implementation.clienttelemetry.MetricCategory;
import com.azure.cosmos.implementation.directconnectivity.IAddressResolver;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.TransportClient;
import com.azure.cosmos.implementation.directconnectivity.TransportException;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdReporter;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestArgs;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestRecord;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdServiceEndpoint;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.guava27.Strings;
import com.azure.cosmos.models.CosmosClientTelemetryConfig;
import com.azure.cosmos.models.CosmosMetricName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.micrometer.core.instrument.Tag;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

@JsonSerialize(using=JsonSerializer.class)
public class RntbdTransportClient
extends TransportClient {
    private static final String TAG_NAME = RntbdTransportClient.class.getSimpleName();
    private static final AtomicLong instanceCount = new AtomicLong();
    private static final Logger logger = LoggerFactory.getLogger(RntbdTransportClient.class);
    private static final String KEY_ON_ERROR_DROPPED = "reactor.onErrorDropped.local";
    private static final Consumer<? super Throwable> onErrorDropHookWithReduceLogLevel = throwable -> {
        if (logger.isDebugEnabled()) {
            logger.debug("Extra error - on error dropped - operator called :", throwable);
        }
    };
    private final AtomicBoolean closed = new AtomicBoolean();
    private final RntbdEndpoint.Provider endpointProvider;
    private final long id;
    private final Tag tag;
    private boolean channelAcquisitionContextEnabled;
    private final GlobalEndpointManager globalEndpointManager;
    private final CosmosClientTelemetryConfig metricConfig;

    public RntbdTransportClient(Configs configs, ConnectionPolicy connectionPolicy, UserAgentContainer userAgent, IAddressResolver addressResolver, ClientTelemetry clientTelemetry, GlobalEndpointManager globalEndpointManager) {
        this(new Options.Builder(connectionPolicy).userAgent(userAgent).build(), configs.getSslContext(), addressResolver, clientTelemetry, globalEndpointManager);
    }

    RntbdTransportClient(RntbdEndpoint.Provider endpointProvider) {
        this.endpointProvider = endpointProvider;
        this.id = instanceCount.incrementAndGet();
        this.tag = RntbdTransportClient.tag(this.id);
        this.globalEndpointManager = null;
        this.metricConfig = null;
    }

    RntbdTransportClient(Options options, SslContext sslContext, IAddressResolver addressResolver, ClientTelemetry clientTelemetry, GlobalEndpointManager globalEndpointManager) {
        this.endpointProvider = new RntbdServiceEndpoint.Provider(this, options, Preconditions.checkNotNull(sslContext, "expected non-null sslContext"), addressResolver, clientTelemetry);
        this.id = instanceCount.incrementAndGet();
        this.tag = RntbdTransportClient.tag(this.id);
        this.channelAcquisitionContextEnabled = options.channelAcquisitionContextEnabled;
        this.globalEndpointManager = globalEndpointManager;
        this.metricConfig = clientTelemetry != null && clientTelemetry.getClientTelemetryConfig() != null ? clientTelemetry.getClientTelemetryConfig() : null;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            logger.debug("close {}", (Object)this);
            this.endpointProvider.close();
            return;
        }
        logger.debug("already closed {}", (Object)this);
    }

    @Override
    protected GlobalEndpointManager getGlobalEndpointManager() {
        return this.globalEndpointManager;
    }

    public int endpointCount() {
        return this.endpointProvider.count();
    }

    public int endpointEvictionCount() {
        return this.endpointProvider.evictions();
    }

    public long id() {
        return this.id;
    }

    @Override
    public Mono<StoreResponse> invokeStoreAsync(Uri addressUri, RxDocumentServiceRequest request) {
        Preconditions.checkNotNull(addressUri, "expected non-null addressUri");
        Preconditions.checkNotNull(request, "expected non-null request");
        this.throwIfClosed();
        URI address = addressUri.getURI();
        RntbdRequestArgs requestArgs = new RntbdRequestArgs(request, addressUri);
        RntbdEndpoint endpoint = this.endpointProvider.get(address);
        RntbdRequestRecord record = endpoint.request(requestArgs);
        Context reactorContext = Context.of((Object)KEY_ON_ERROR_DROPPED, onErrorDropHookWithReduceLogLevel);
        return Mono.fromFuture((CompletableFuture)record).map(storeResponse -> {
            record.stage(RntbdRequestRecord.Stage.COMPLETED);
            if (request.requestContext.cosmosDiagnostics == null) {
                request.requestContext.cosmosDiagnostics = request.createCosmosDiagnostics();
            }
            RequestTimeline timeline = record.takeTimelineSnapshot();
            storeResponse.setRequestTimeline(timeline);
            storeResponse.setEndpointStatistics(record.serviceEndpointStatistics());
            storeResponse.setChannelStatistics(record.channelStatistics());
            storeResponse.setRntbdResponseLength(record.responseLength());
            storeResponse.setRntbdRequestLength(record.requestLength());
            storeResponse.setRequestPayloadLength(request.getContentLength());
            if (this.channelAcquisitionContextEnabled) {
                storeResponse.setChannelAcquisitionTimeline(record.getChannelAcquisitionTimeline());
            }
            return storeResponse;
        }).onErrorMap(throwable -> {
            Object error;
            record.stage(RntbdRequestRecord.Stage.COMPLETED);
            if (request.requestContext.cosmosDiagnostics == null) {
                request.requestContext.cosmosDiagnostics = request.createCosmosDiagnostics();
            }
            Throwable throwable2 = error = throwable instanceof CompletionException ? throwable.getCause() : throwable;
            if (!(error instanceof CosmosException)) {
                String unexpectedError = RntbdObjectMapper.toJson(error);
                if (!(error instanceof CancellationException)) {
                    RntbdReporter.reportIssue(logger, endpoint, "request completed with an unexpected {}: \\{\"record\":{},\"error\":{}}", error.getClass(), record, unexpectedError);
                }
                error = new GoneException(Strings.lenientFormat("an unexpected %s occurred: %s", unexpectedError), address, error instanceof Exception ? (Exception)error : new RuntimeException((Throwable)error));
            }
            assert (error instanceof CosmosException);
            CosmosException cosmosException = (CosmosException)((Object)((Object)error));
            BridgeInternal.setServiceEndpointStatistics(cosmosException, record.serviceEndpointStatistics());
            ImplementationBridgeHelpers.CosmosExceptionHelper.getCosmosExceptionAccessor().setRntbdChannelStatistics(cosmosException, record.channelStatistics());
            BridgeInternal.setRntbdRequestLength(cosmosException, record.requestLength());
            BridgeInternal.setRntbdResponseLength(cosmosException, record.responseLength());
            BridgeInternal.setRequestBodyLength(cosmosException, request.getContentLength());
            BridgeInternal.setRequestTimeline(cosmosException, record.takeTimelineSnapshot());
            BridgeInternal.setSendingRequestStarted(cosmosException, record.hasSendingRequestStarted());
            if (this.channelAcquisitionContextEnabled) {
                BridgeInternal.setChannelAcquisitionTimeline(cosmosException, record.getChannelAcquisitionTimeline());
            }
            return cosmosException;
        }).doFinally(signalType -> {
            if (signalType != SignalType.CANCEL) {
                return;
            }
            record.cancel(true);
        }).contextWrite((ContextView)reactorContext);
    }

    @Override
    public Mono<OpenConnectionResponse> openConnection(Uri addressUri) {
        Preconditions.checkNotNull(addressUri, "Argument 'addressUri' should not be null");
        this.throwIfClosed();
        URI address = addressUri.getURI();
        RntbdEndpoint endpoint = this.endpointProvider.get(address);
        return Mono.fromFuture((CompletableFuture)endpoint.openConnection(addressUri));
    }

    public Tag tag() {
        return this.tag;
    }

    public String toString() {
        return RntbdObjectMapper.toString(this);
    }

    private static Tag tag(long id) {
        return Tag.of((String)TAG_NAME, (String)com.azure.cosmos.implementation.guava25.base.Strings.padStart(Long.toHexString(id).toUpperCase(Locale.ROOT), 4, '0'));
    }

    private void throwIfClosed() {
        if (this.closed.get()) {
            throw new TransportException(Strings.lenientFormat("%s is closed", this), null);
        }
    }

    public EnumSet<MetricCategory> getMetricCategories() {
        return this.metricConfig != null ? ImplementationBridgeHelpers.CosmosClientTelemetryConfigHelper.getCosmosClientTelemetryConfigAccessor().getMetricCategories(this.metricConfig) : MetricCategory.DEFAULT_CATEGORIES;
    }

    public CosmosMeterOptions getMeterOptions(CosmosMetricName name) {
        return this.metricConfig != null ? ImplementationBridgeHelpers.CosmosClientTelemetryConfigHelper.getCosmosClientTelemetryConfigAccessor().getMeterOptions(this.metricConfig, name) : ImplementationBridgeHelpers.CosmosClientTelemetryConfigHelper.getCosmosClientTelemetryConfigAccessor().createDisabledMeterOptions(name);
    }

    public static final class Options {
        private static final int DEFAULT_MIN_MAX_CONCURRENT_REQUESTS_PER_ENDPOINT = 10000;
        @JsonProperty
        private final int bufferPageSize;
        @JsonProperty
        private final Duration connectionAcquisitionTimeout;
        @JsonProperty
        private final boolean connectionEndpointRediscoveryEnabled;
        @JsonProperty
        private final Duration connectTimeout;
        @JsonProperty
        private final Duration idleChannelTimeout;
        @JsonProperty
        private final Duration idleChannelTimerResolution;
        @JsonProperty
        private final Duration idleEndpointTimeout;
        @JsonProperty
        private final int maxBufferCapacity;
        @JsonProperty
        private final int maxChannelsPerEndpoint;
        @JsonProperty
        private final int maxRequestsPerChannel;
        @JsonProperty
        private final int maxConcurrentRequestsPerEndpointOverride;
        @JsonProperty
        private final Duration receiveHangDetectionTime;
        @JsonProperty
        private final Duration tcpNetworkRequestTimeout;
        @JsonProperty
        private final Duration requestTimerResolution;
        @JsonProperty
        private final Duration sendHangDetectionTime;
        @JsonProperty
        private final Duration shutdownTimeout;
        @JsonProperty
        private final int threadCount;
        @JsonIgnore
        private final UserAgentContainer userAgent;
        @JsonProperty
        private final boolean channelAcquisitionContextEnabled;
        @JsonProperty
        private final int ioThreadPriority;
        @JsonProperty
        private final int tcpKeepIntvl;
        @JsonProperty
        private final int tcpKeepIdle;
        @JsonProperty
        private final boolean preferTcpNative;
        @JsonProperty
        private final Duration sslHandshakeTimeoutMinDuration;
        @JsonProperty
        private final boolean timeoutDetectionEnabled;
        @JsonProperty
        private final double timeoutDetectionDisableCPUThreshold;
        @JsonProperty
        private final Duration timeoutDetectionTimeLimit;
        @JsonProperty
        private final int timeoutDetectionHighFrequencyThreshold;
        @JsonProperty
        private final Duration timeoutDetectionHighFrequencyTimeLimit;
        @JsonProperty
        private final int timeoutDetectionOnWriteThreshold;
        @JsonProperty
        private final Duration timeoutDetectionOnWriteTimeLimit;

        @JsonCreator
        private Options() {
            this(ConnectionPolicy.getDefaultPolicy());
        }

        private Options(Builder builder) {
            this.bufferPageSize = builder.bufferPageSize;
            this.connectionAcquisitionTimeout = builder.connectionAcquisitionTimeout;
            this.connectionEndpointRediscoveryEnabled = builder.connectionEndpointRediscoveryEnabled;
            this.idleChannelTimeout = builder.idleChannelTimeout;
            this.idleChannelTimerResolution = builder.idleChannelTimerResolution;
            this.idleEndpointTimeout = builder.idleEndpointTimeout;
            this.maxBufferCapacity = builder.maxBufferCapacity;
            this.maxChannelsPerEndpoint = builder.maxChannelsPerEndpoint;
            this.maxRequestsPerChannel = builder.maxRequestsPerChannel;
            this.maxConcurrentRequestsPerEndpointOverride = builder.maxConcurrentRequestsPerEndpointOverride;
            this.receiveHangDetectionTime = builder.receiveHangDetectionTime;
            this.tcpNetworkRequestTimeout = builder.tcpNetworkRequestTimeout;
            this.requestTimerResolution = builder.requestTimerResolution;
            this.sendHangDetectionTime = builder.sendHangDetectionTime;
            this.shutdownTimeout = builder.shutdownTimeout;
            this.threadCount = builder.threadCount;
            this.userAgent = builder.userAgent;
            this.channelAcquisitionContextEnabled = builder.channelAcquisitionContextEnabled;
            this.ioThreadPriority = builder.ioThreadPriority;
            this.tcpKeepIntvl = builder.tcpKeepIntvl;
            this.tcpKeepIdle = builder.tcpKeepIdle;
            this.preferTcpNative = builder.preferTcpNative;
            this.sslHandshakeTimeoutMinDuration = builder.sslHandshakeTimeoutMinDuration;
            this.timeoutDetectionEnabled = builder.timeoutDetectionEnabled;
            this.timeoutDetectionDisableCPUThreshold = builder.timeoutDetectionDisableCPUThreshold;
            this.timeoutDetectionTimeLimit = builder.timeoutDetectionTimeLimit;
            this.timeoutDetectionHighFrequencyThreshold = builder.timeoutDetectionHighFrequencyThreshold;
            this.timeoutDetectionHighFrequencyTimeLimit = builder.timeoutDetectionHighFrequencyTimeLimit;
            this.timeoutDetectionOnWriteThreshold = builder.timeoutDetectionOnWriteThreshold;
            this.timeoutDetectionOnWriteTimeLimit = builder.timeoutDetectionOnWriteTimeLimit;
            this.connectTimeout = builder.connectTimeout == null ? builder.tcpNetworkRequestTimeout : builder.connectTimeout;
        }

        private Options(ConnectionPolicy connectionPolicy) {
            this.bufferPageSize = 8192;
            this.connectionAcquisitionTimeout = Duration.ofSeconds(5L);
            this.connectionEndpointRediscoveryEnabled = connectionPolicy.isTcpConnectionEndpointRediscoveryEnabled();
            this.connectTimeout = connectionPolicy.getConnectTimeout();
            this.idleChannelTimeout = connectionPolicy.getIdleTcpConnectionTimeout();
            this.idleChannelTimerResolution = Duration.ofMillis(100L);
            this.idleEndpointTimeout = connectionPolicy.getIdleTcpEndpointTimeout();
            this.maxBufferCapacity = 0x800000;
            this.maxChannelsPerEndpoint = connectionPolicy.getMaxConnectionsPerEndpoint();
            this.maxRequestsPerChannel = connectionPolicy.getMaxRequestsPerConnection();
            this.maxConcurrentRequestsPerEndpointOverride = -1;
            this.receiveHangDetectionTime = Duration.ofSeconds(65L);
            this.tcpNetworkRequestTimeout = connectionPolicy.getTcpNetworkRequestTimeout();
            this.requestTimerResolution = Duration.ofMillis(100L);
            this.sendHangDetectionTime = Duration.ofSeconds(10L);
            this.shutdownTimeout = Duration.ofSeconds(15L);
            this.threadCount = connectionPolicy.getIoThreadCountPerCoreFactor() * Runtime.getRuntime().availableProcessors();
            this.userAgent = new UserAgentContainer();
            this.channelAcquisitionContextEnabled = false;
            this.ioThreadPriority = connectionPolicy.getIoThreadPriority();
            this.tcpKeepIntvl = 1;
            this.tcpKeepIdle = 1;
            this.sslHandshakeTimeoutMinDuration = Duration.ofSeconds(5L);
            this.timeoutDetectionEnabled = connectionPolicy.isTcpHealthCheckTimeoutDetectionEnabled();
            this.timeoutDetectionDisableCPUThreshold = 90.0;
            this.timeoutDetectionTimeLimit = Duration.ofSeconds(60L);
            this.timeoutDetectionHighFrequencyThreshold = 3;
            this.timeoutDetectionHighFrequencyTimeLimit = Duration.ofSeconds(10L);
            this.timeoutDetectionOnWriteThreshold = 1;
            this.timeoutDetectionOnWriteTimeLimit = Duration.ofSeconds(6L);
            this.preferTcpNative = true;
        }

        public int bufferPageSize() {
            return this.bufferPageSize;
        }

        public Duration connectionAcquisitionTimeout() {
            return this.connectionAcquisitionTimeout;
        }

        public Duration connectTimeout() {
            return this.connectTimeout;
        }

        public Duration idleChannelTimeout() {
            return this.idleChannelTimeout;
        }

        public Duration idleChannelTimerResolution() {
            return this.idleChannelTimerResolution;
        }

        public Duration idleEndpointTimeout() {
            return this.idleEndpointTimeout;
        }

        public boolean isConnectionEndpointRediscoveryEnabled() {
            return this.connectionEndpointRediscoveryEnabled;
        }

        public int maxBufferCapacity() {
            return this.maxBufferCapacity;
        }

        public int maxChannelsPerEndpoint() {
            return this.maxChannelsPerEndpoint;
        }

        public int maxRequestsPerChannel() {
            return this.maxRequestsPerChannel;
        }

        public int maxConcurrentRequestsPerEndpoint() {
            if (this.maxConcurrentRequestsPerEndpointOverride > 0) {
                return this.maxConcurrentRequestsPerEndpointOverride;
            }
            return Math.max(10000, this.maxChannelsPerEndpoint * this.maxRequestsPerChannel);
        }

        public Duration receiveHangDetectionTime() {
            return this.receiveHangDetectionTime;
        }

        public Duration tcpNetworkRequestTimeout() {
            return this.tcpNetworkRequestTimeout;
        }

        public Duration requestTimerResolution() {
            return this.requestTimerResolution;
        }

        public Duration sendHangDetectionTime() {
            return this.sendHangDetectionTime;
        }

        public Duration shutdownTimeout() {
            return this.shutdownTimeout;
        }

        public int threadCount() {
            return this.threadCount;
        }

        public UserAgentContainer userAgent() {
            return this.userAgent;
        }

        public boolean isChannelAcquisitionContextEnabled() {
            return this.channelAcquisitionContextEnabled;
        }

        public int ioThreadPriority() {
            Preconditions.checkArgument(this.ioThreadPriority >= 1 && this.ioThreadPriority <= 10, "Expect ioThread priority between [%s, %s]", 1, 10);
            return this.ioThreadPriority;
        }

        public int tcpKeepIntvl() {
            return this.tcpKeepIntvl;
        }

        public int tcpKeepIdle() {
            return this.tcpKeepIdle;
        }

        public boolean preferTcpNative() {
            return this.preferTcpNative;
        }

        public long sslHandshakeTimeoutInMillis() {
            return Math.max(this.sslHandshakeTimeoutMinDuration.toMillis(), this.connectTimeout.toMillis());
        }

        public boolean timeoutDetectionEnabled() {
            return this.timeoutDetectionEnabled;
        }

        public double timeoutDetectionDisableCPUThreshold() {
            return this.timeoutDetectionDisableCPUThreshold;
        }

        public Duration timeoutDetectionTimeLimit() {
            return this.timeoutDetectionTimeLimit;
        }

        public int timeoutDetectionHighFrequencyThreshold() {
            return this.timeoutDetectionHighFrequencyThreshold;
        }

        public Duration timeoutDetectionHighFrequencyTimeLimit() {
            return this.timeoutDetectionHighFrequencyTimeLimit;
        }

        public int timeoutDetectionOnWriteThreshold() {
            return this.timeoutDetectionOnWriteThreshold;
        }

        public Duration timeoutDetectionOnWriteTimeLimit() {
            return this.timeoutDetectionOnWriteTimeLimit;
        }

        public String toString() {
            return RntbdObjectMapper.toJson(this);
        }

        public String toDiagnosticsString() {
            return Strings.lenientFormat("(cto:%s, nrto:%s, icto:%s, ieto:%s, mcpe:%s, mrpc:%s, cer:%s)", this.connectTimeout, this.tcpNetworkRequestTimeout, this.idleChannelTimeout, this.idleEndpointTimeout, this.maxChannelsPerEndpoint, this.maxRequestsPerChannel, this.connectionEndpointRediscoveryEnabled);
        }

        static /* synthetic */ int access$3400(Options x0) {
            return x0.bufferPageSize;
        }

        static /* synthetic */ Duration access$3500(Options x0) {
            return x0.connectionAcquisitionTimeout;
        }

        public static class Builder {
            private static final String DEFAULT_OPTIONS_PROPERTY_NAME = "azure.cosmos.directTcp.defaultOptions";
            private static final Options DEFAULT_OPTIONS;
            private int bufferPageSize = Options.access$3400(DEFAULT_OPTIONS);
            private Duration connectionAcquisitionTimeout = Options.access$3500(DEFAULT_OPTIONS);
            private boolean connectionEndpointRediscoveryEnabled;
            private Duration connectTimeout;
            private Duration idleChannelTimeout;
            private Duration idleChannelTimerResolution;
            private Duration idleEndpointTimeout;
            private int maxBufferCapacity;
            private int maxChannelsPerEndpoint;
            private int maxRequestsPerChannel;
            private int maxConcurrentRequestsPerEndpointOverride;
            private Duration receiveHangDetectionTime;
            private Duration tcpNetworkRequestTimeout;
            private Duration requestTimerResolution;
            private Duration sendHangDetectionTime;
            private Duration shutdownTimeout;
            private int threadCount;
            private UserAgentContainer userAgent;
            private boolean channelAcquisitionContextEnabled;
            private int ioThreadPriority;
            private int tcpKeepIntvl;
            private int tcpKeepIdle;
            private boolean preferTcpNative;
            private Duration sslHandshakeTimeoutMinDuration;
            private boolean timeoutDetectionEnabled;
            private double timeoutDetectionDisableCPUThreshold;
            private Duration timeoutDetectionTimeLimit;
            private int timeoutDetectionHighFrequencyThreshold;
            private Duration timeoutDetectionHighFrequencyTimeLimit;
            private int timeoutDetectionOnWriteThreshold;
            private Duration timeoutDetectionOnWriteTimeLimit;

            public Builder(ConnectionPolicy connectionPolicy) {
                this.connectionEndpointRediscoveryEnabled = connectionPolicy.isTcpConnectionEndpointRediscoveryEnabled();
                this.connectTimeout = connectionPolicy.getConnectTimeout();
                this.idleChannelTimeout = connectionPolicy.getIdleTcpConnectionTimeout();
                this.idleChannelTimerResolution = DEFAULT_OPTIONS.idleChannelTimerResolution;
                this.idleEndpointTimeout = connectionPolicy.getIdleTcpEndpointTimeout();
                this.maxBufferCapacity = DEFAULT_OPTIONS.maxBufferCapacity;
                this.maxChannelsPerEndpoint = connectionPolicy.getMaxConnectionsPerEndpoint();
                this.maxRequestsPerChannel = connectionPolicy.getMaxRequestsPerConnection();
                this.maxConcurrentRequestsPerEndpointOverride = DEFAULT_OPTIONS.maxConcurrentRequestsPerEndpointOverride;
                this.receiveHangDetectionTime = DEFAULT_OPTIONS.receiveHangDetectionTime;
                this.tcpNetworkRequestTimeout = connectionPolicy.getTcpNetworkRequestTimeout();
                this.requestTimerResolution = DEFAULT_OPTIONS.requestTimerResolution;
                this.sendHangDetectionTime = DEFAULT_OPTIONS.sendHangDetectionTime;
                this.shutdownTimeout = DEFAULT_OPTIONS.shutdownTimeout;
                this.threadCount = DEFAULT_OPTIONS.threadCount;
                this.userAgent = DEFAULT_OPTIONS.userAgent;
                this.channelAcquisitionContextEnabled = DEFAULT_OPTIONS.channelAcquisitionContextEnabled;
                this.ioThreadPriority = DEFAULT_OPTIONS.ioThreadPriority;
                this.tcpKeepIntvl = DEFAULT_OPTIONS.tcpKeepIntvl;
                this.tcpKeepIdle = DEFAULT_OPTIONS.tcpKeepIdle;
                this.preferTcpNative = DEFAULT_OPTIONS.preferTcpNative;
                this.sslHandshakeTimeoutMinDuration = DEFAULT_OPTIONS.sslHandshakeTimeoutMinDuration;
                this.timeoutDetectionEnabled = DEFAULT_OPTIONS.timeoutDetectionEnabled;
                this.timeoutDetectionDisableCPUThreshold = DEFAULT_OPTIONS.timeoutDetectionDisableCPUThreshold;
                this.timeoutDetectionTimeLimit = DEFAULT_OPTIONS.timeoutDetectionTimeLimit;
                this.timeoutDetectionHighFrequencyThreshold = DEFAULT_OPTIONS.timeoutDetectionHighFrequencyThreshold;
                this.timeoutDetectionHighFrequencyTimeLimit = DEFAULT_OPTIONS.timeoutDetectionHighFrequencyTimeLimit;
                this.timeoutDetectionOnWriteThreshold = DEFAULT_OPTIONS.timeoutDetectionOnWriteThreshold;
                this.timeoutDetectionOnWriteTimeLimit = DEFAULT_OPTIONS.timeoutDetectionOnWriteTimeLimit;
            }

            public Builder bufferPageSize(int value) {
                Preconditions.checkArgument(value >= 4096 && (value & value - 1) == 0, "expected value to be a power of 2 >= 4096, not %s", value);
                this.bufferPageSize = value;
                return this;
            }

            public Options build() {
                Preconditions.checkState(this.bufferPageSize <= this.maxBufferCapacity, "expected bufferPageSize (%s) <= maxBufferCapacity (%s)", this.bufferPageSize, this.maxBufferCapacity);
                return new Options(this);
            }

            public Builder connectionAcquisitionTimeout(Duration value) {
                Preconditions.checkNotNull(value, "expected non-null value");
                this.connectionAcquisitionTimeout = value.compareTo(Duration.ZERO) < 0 ? Duration.ZERO : value;
                return this;
            }

            public Builder connectionEndpointRediscoveryEnabled(boolean value) {
                this.connectionEndpointRediscoveryEnabled = value;
                return this;
            }

            public Builder connectionTimeout(Duration value) {
                Preconditions.checkArgument(value == null || value.compareTo(Duration.ZERO) > 0, "expected positive value, not %s", (Object)value);
                this.connectTimeout = value;
                return this;
            }

            public Builder idleChannelTimeout(Duration value) {
                Preconditions.checkNotNull(value, "expected non-null value");
                this.idleChannelTimeout = value;
                return this;
            }

            public Builder idleChannelTimerResolution(Duration value) {
                Preconditions.checkArgument(value != null && value.compareTo(Duration.ZERO) <= 0, "expected positive value, not %s", (Object)value);
                this.idleChannelTimerResolution = value;
                return this;
            }

            public Builder idleEndpointTimeout(Duration value) {
                Preconditions.checkArgument(value != null && value.compareTo(Duration.ZERO) > 0, "expected positive value, not %s", (Object)value);
                this.idleEndpointTimeout = value;
                return this;
            }

            public Builder maxBufferCapacity(int value) {
                Preconditions.checkArgument(value > 0 && (value & value - 1) == 0, "expected positive value, not %s", value);
                this.maxBufferCapacity = value;
                return this;
            }

            public Builder maxChannelsPerEndpoint(int value) {
                Preconditions.checkArgument(value > 0, "expected positive value, not %s", value);
                this.maxChannelsPerEndpoint = value;
                return this;
            }

            public Builder maxRequestsPerChannel(int value) {
                Preconditions.checkArgument(value > 0, "expected positive value, not %s", value);
                this.maxRequestsPerChannel = value;
                return this;
            }

            public Builder maxConcurrentRequestsPerEndpointOverride(int value) {
                Preconditions.checkArgument(value > 0, "expected positive value, not %s", value);
                this.maxConcurrentRequestsPerEndpointOverride = value;
                return this;
            }

            public Builder receiveHangDetectionTime(Duration value) {
                Preconditions.checkArgument(value != null && value.compareTo(Duration.ZERO) > 0, "expected positive value, not %s", (Object)value);
                this.receiveHangDetectionTime = value;
                return this;
            }

            public Builder tcpNetworkRequestTimeout(Duration value) {
                Preconditions.checkArgument(value != null && value.compareTo(Duration.ZERO) > 0, "expected positive value, not %s", (Object)value);
                this.tcpNetworkRequestTimeout = value;
                return this;
            }

            public Builder requestTimerResolution(Duration value) {
                Preconditions.checkArgument(value != null && value.compareTo(Duration.ZERO) > 0, "expected positive value, not %s", (Object)value);
                this.requestTimerResolution = value;
                return this;
            }

            public Builder sendHangDetectionTime(Duration value) {
                Preconditions.checkArgument(value != null && value.compareTo(Duration.ZERO) > 0, "expected positive value, not %s", (Object)value);
                this.sendHangDetectionTime = value;
                return this;
            }

            public Builder shutdownTimeout(Duration value) {
                Preconditions.checkArgument(value != null && value.compareTo(Duration.ZERO) > 0, "expected positive value, not %s", (Object)value);
                this.shutdownTimeout = value;
                return this;
            }

            public Builder threadCount(int value) {
                Preconditions.checkArgument(value > 0, "expected positive value, not %s", value);
                this.threadCount = value;
                return this;
            }

            public Builder userAgent(UserAgentContainer value) {
                Preconditions.checkNotNull(value, "expected non-null value");
                this.userAgent = value;
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            static {
                block22: {
                    Options options;
                    block21: {
                        options = null;
                        try {
                            String path;
                            String string = System.getProperty(DEFAULT_OPTIONS_PROPERTY_NAME);
                            if (string != null) {
                                try {
                                    options = RntbdObjectMapper.readValue(string, Options.class);
                                }
                                catch (IOException error) {
                                    logger.error("failed to parse default Direct TCP options {} due to ", (Object)string, (Object)error);
                                }
                            }
                            if (options == null && (path = System.getProperty("azure.cosmos.directTcp.defaultOptionsFile")) != null) {
                                try {
                                    options = RntbdObjectMapper.readValue(new File(path), Options.class);
                                }
                                catch (IOException error) {
                                    logger.error("failed to load default Direct TCP options from {} due to ", (Object)path, (Object)error);
                                }
                            }
                            if (options == null) {
                                ClassLoader loader = RntbdTransportClient.class.getClassLoader();
                                String name = "azure.cosmos.directTcp.defaultOptions.json";
                                try (InputStream stream = loader.getResourceAsStream("azure.cosmos.directTcp.defaultOptions.json");){
                                    if (stream != null) {
                                        options = RntbdObjectMapper.readValue(stream, Options.class);
                                    }
                                }
                                catch (IOException error) {
                                    logger.error("failed to load Direct TCP options from resource {} due to ", (Object)"azure.cosmos.directTcp.defaultOptions.json", (Object)error);
                                }
                            }
                            if (options != null) break block21;
                        }
                        catch (Throwable throwable) {
                            if (options == null) {
                                logger.info("Using default Direct TCP options: {}", (Object)DEFAULT_OPTIONS_PROPERTY_NAME);
                                DEFAULT_OPTIONS = new Options(ConnectionPolicy.getDefaultPolicy());
                            } else {
                                logger.info("Updated default Direct TCP options from system property {}: {}", (Object)DEFAULT_OPTIONS_PROPERTY_NAME, options);
                                DEFAULT_OPTIONS = options;
                            }
                            throw throwable;
                        }
                        logger.info("Using default Direct TCP options: {}", (Object)DEFAULT_OPTIONS_PROPERTY_NAME);
                        DEFAULT_OPTIONS = new Options(ConnectionPolicy.getDefaultPolicy());
                        break block22;
                    }
                    logger.info("Updated default Direct TCP options from system property {}: {}", (Object)DEFAULT_OPTIONS_PROPERTY_NAME, (Object)options);
                    DEFAULT_OPTIONS = options;
                }
            }
        }
    }

    static final class JsonSerializer
    extends StdSerializer<RntbdTransportClient> {
        private static final long serialVersionUID = 1007663695768825670L;

        JsonSerializer() {
            super(RntbdTransportClient.class);
        }

        public void serialize(RntbdTransportClient value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            generator.writeNumberField("id", value.id());
            generator.writeBooleanField("isClosed", value.isClosed());
            generator.writeObjectField("configuration", (Object)value.endpointProvider.config());
            generator.writeObjectFieldStart("serviceEndpoints");
            generator.writeNumberField("count", value.endpointCount());
            generator.writeArrayFieldStart("items");
            Iterator iterator = value.endpointProvider.list().iterator();
            while (iterator.hasNext()) {
                generator.writeObject(iterator.next());
            }
            generator.writeEndArray();
            generator.writeEndObject();
            generator.writeEndObject();
        }
    }
}

