/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.ISessionToken;
import com.azure.cosmos.implementation.InternalServerErrorException;
import com.azure.cosmos.implementation.RequestChargeTracker;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreResult {
    private static final Logger logger = LoggerFactory.getLogger(StoreResult.class);
    private final StoreResponse storeResponse;
    private final CosmosException exception;
    public final long lsn;
    public final String partitionKeyRangeId;
    public final long quorumAckedLSN;
    public final long globalCommittedLSN;
    public final long numberOfReadRegions;
    public final long itemLSN;
    public final ISessionToken sessionToken;
    public final double requestCharge;
    public final String activityId;
    public final String correlatedActivityId;
    public final int currentReplicaSetSize;
    public final int currentWriteQuorum;
    public final boolean isValid;
    public final boolean isGoneException;
    public final boolean isNotFoundException;
    public final boolean isInvalidPartitionException;
    public final Uri storePhysicalAddress;
    public final boolean isThroughputControlRequestRateTooLargeException;
    public final Double backendLatencyInMs;
    public final Double retryAfterInMs;

    public StoreResult(StoreResponse storeResponse, CosmosException exception, String partitionKeyRangeId, long lsn, long quorumAckedLsn, double requestCharge, String activityId, String correlatedActivityId, int currentReplicaSetSize, int currentWriteQuorum, boolean isValid, Uri storePhysicalAddress, long globalCommittedLSN, int numberOfReadRegions, long itemLSN, ISessionToken sessionToken, Double backendLatencyInMs, Double retryAfterInMs) {
        this.storeResponse = storeResponse;
        this.exception = exception;
        this.partitionKeyRangeId = partitionKeyRangeId;
        this.lsn = lsn;
        this.quorumAckedLSN = quorumAckedLsn;
        this.requestCharge = requestCharge;
        this.activityId = activityId;
        this.correlatedActivityId = correlatedActivityId;
        this.currentReplicaSetSize = currentReplicaSetSize;
        this.currentWriteQuorum = currentWriteQuorum;
        this.isValid = isValid;
        this.isGoneException = this.exception != null && this.exception.getStatusCode() == 410;
        this.isNotFoundException = this.exception != null && this.exception.getStatusCode() == 404;
        this.isInvalidPartitionException = this.exception != null && Exceptions.isNameCacheStale(this.exception);
        this.storePhysicalAddress = storePhysicalAddress;
        this.globalCommittedLSN = globalCommittedLSN;
        this.numberOfReadRegions = numberOfReadRegions;
        this.itemLSN = itemLSN;
        this.sessionToken = sessionToken;
        this.isThroughputControlRequestRateTooLargeException = this.exception != null && Exceptions.isThroughputControlRequestRateTooLargeException(this.exception);
        this.backendLatencyInMs = backendLatencyInMs;
        this.retryAfterInMs = retryAfterInMs;
    }

    public StoreResponse getStoreResponse() {
        return this.storeResponse;
    }

    public CosmosException getException() throws InternalServerErrorException {
        if (this.exception == null) {
            String message = "Exception should be available but found none";
            assert (false) : message;
            logger.error(message);
            throw new InternalServerErrorException("Unknown server error occurred when processing this request. If the issue persists, please contact Azure Support: http://aka.ms/azure-support");
        }
        return this.exception;
    }

    public StoreResponse toResponse() {
        return this.toResponse(null);
    }

    public StoreResponse toResponse(RequestChargeTracker requestChargeTracker) {
        if (!this.isValid) {
            if (this.exception == null) {
                logger.error("Exception not set for invalid response");
                throw new InternalServerErrorException("Unknown server error occurred when processing this request. If the issue persists, please contact Azure Support: http://aka.ms/azure-support");
            }
            throw this.exception;
        }
        if (requestChargeTracker != null) {
            StoreResult.setRequestCharge(this.storeResponse, this.exception, requestChargeTracker.getTotalRequestCharge());
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.storeResponse;
    }

    private static void setRequestCharge(StoreResponse response, CosmosException cosmosException, double totalRequestCharge) {
        if (cosmosException != null) {
            cosmosException.getResponseHeaders().put("x-ms-request-charge", Double.toString(totalRequestCharge));
        } else if (response.getResponseHeaderNames() != null) {
            for (int i = 0; i < response.getResponseHeaderNames().length; ++i) {
                if (!Strings.areEqualIgnoreCase(response.getResponseHeaderNames()[i], "x-ms-request-charge")) continue;
                response.getResponseHeaderValues()[i] = Double.toString(totalRequestCharge);
                break;
            }
        }
    }
}

