/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.clienttelemetry.TagName;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;

public final class CosmosMetricTagName {
    private final String name;
    private final EnumSet<TagName> tagNames;
    public static final CosmosMetricTagName ALL = new CosmosMetricTagName("All", TagName.ALL_TAGS);
    public static final CosmosMetricTagName DEFAULT = new CosmosMetricTagName("Default", TagName.DEFAULT_TAGS);
    public static final CosmosMetricTagName MINIMUM = new CosmosMetricTagName("Minimum", TagName.MINIMUM_TAGS);
    public static final CosmosMetricTagName CONSISTENCY_LEVEL = new CosmosMetricTagName("ConsistencyLevel", EnumSet.of(TagName.ConsistencyLevel));
    public static final CosmosMetricTagName CONTAINER = new CosmosMetricTagName("Container", EnumSet.of(TagName.Container));
    public static final CosmosMetricTagName SERVICE_ENDPOINT = new CosmosMetricTagName("ServiceEndpoint", EnumSet.of(TagName.ServiceEndpoint));
    public static final CosmosMetricTagName SERVICE_ADDRESS = new CosmosMetricTagName("ServiceAddress", EnumSet.of(TagName.ServiceAddress));
    public static final CosmosMetricTagName REGION_NAME = new CosmosMetricTagName("RegionName", EnumSet.of(TagName.RegionName));
    public static final CosmosMetricTagName OPERATION_STATUS_CODE = new CosmosMetricTagName("OperationStatusCode", EnumSet.of(TagName.OperationStatusCode));
    public static final CosmosMetricTagName OPERATION = new CosmosMetricTagName("Operation", EnumSet.of(TagName.Operation));
    public static final CosmosMetricTagName REQUEST_STATUS_CODE = new CosmosMetricTagName("RequestStatusCode", EnumSet.of(TagName.RequestStatusCode));
    public static final CosmosMetricTagName REQUEST_OPERATION_TYPE = new CosmosMetricTagName("RequestOperationType", EnumSet.of(TagName.RequestOperationType));
    public static final CosmosMetricTagName CLIENT_CORRELATION_ID = new CosmosMetricTagName("ClientCorrelationId", EnumSet.of(TagName.ClientCorrelationId));
    public static final CosmosMetricTagName ADDRESS_RESOLUTION_FORCED_REFRESH = new CosmosMetricTagName("IsForceRefresh", EnumSet.of(TagName.IsForceRefresh));
    public static final CosmosMetricTagName ADDRESS_RESOLUTION_COLLECTION_MAP_REFRESH = new CosmosMetricTagName("IsForceCollectionRoutingMapRefresh", EnumSet.of(TagName.IsForceCollectionRoutingMapRefresh));
    public static final CosmosMetricTagName PARTITION_KEY_RANGE_ID = new CosmosMetricTagName("PartitionKeyRangeId", EnumSet.of(TagName.PartitionKeyRangeId));

    private CosmosMetricTagName(String name, EnumSet<TagName> tagNames) {
        Preconditions.checkNotNull(name, "Argument 'name' must not be null.");
        Preconditions.checkNotNull(tagNames, "Argument 'tagNames' must not be null.");
        this.name = name;
        this.tagNames = tagNames;
    }

    public static CosmosMetricTagName fromString(String name) {
        String normalizedName;
        Preconditions.checkNotNull(name, "Argument 'name' must not be null.");
        switch (normalizedName = name.trim().toLowerCase(Locale.ROOT)) {
            case "all": {
                return ALL;
            }
            case "default": {
                return DEFAULT;
            }
            case "minimum": {
                return MINIMUM;
            }
            case "consistencylevel": {
                return CONSISTENCY_LEVEL;
            }
            case "container": {
                return CONTAINER;
            }
            case "serviceaddress": {
                return SERVICE_ADDRESS;
            }
            case "serviceendpoint": {
                return SERVICE_ENDPOINT;
            }
            case "regionname": {
                return REGION_NAME;
            }
            case "operationstatuscode": {
                return OPERATION_STATUS_CODE;
            }
            case "operation": {
                return OPERATION;
            }
            case "requeststatuscode": {
                return REQUEST_STATUS_CODE;
            }
            case "requestoperationtype": {
                return REQUEST_OPERATION_TYPE;
            }
            case "clientcorrelationid": {
                return CLIENT_CORRELATION_ID;
            }
            case "isforcerefresh": {
                return ADDRESS_RESOLUTION_FORCED_REFRESH;
            }
            case "isforcecollectionroutingmaprefresh": {
                return ADDRESS_RESOLUTION_COLLECTION_MAP_REFRESH;
            }
            case "partitionkeyrangeid": {
                return PARTITION_KEY_RANGE_ID;
            }
        }
        String errorMessage = String.format("Argument 'name' has invalid value '%s' - valid values are: %s", name, CosmosMetricTagName.getValidValues());
        throw new IllegalArgumentException(errorMessage);
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(CosmosMetricTagName.class, this.name);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!CosmosMetricTagName.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.name == null) {
            return ((CosmosMetricTagName)obj).name == null;
        }
        return this.name.equals(((CosmosMetricTagName)obj).name);
    }

    private static String getValidValues() {
        return new StringJoiner(", ").add(CosmosMetricTagName.ALL.name).add(CosmosMetricTagName.DEFAULT.name).add(CosmosMetricTagName.MINIMUM.name).add(CosmosMetricTagName.CONSISTENCY_LEVEL.name).add(CosmosMetricTagName.CONTAINER.name).add(CosmosMetricTagName.SERVICE_ADDRESS.name).add(CosmosMetricTagName.SERVICE_ENDPOINT.name).add(CosmosMetricTagName.REGION_NAME.name).add(CosmosMetricTagName.OPERATION_STATUS_CODE.name).add(CosmosMetricTagName.OPERATION.name).add(CosmosMetricTagName.REQUEST_STATUS_CODE.name).add(CosmosMetricTagName.REQUEST_OPERATION_TYPE.name).add(CosmosMetricTagName.CLIENT_CORRELATION_ID.name).add(CosmosMetricTagName.ADDRESS_RESOLUTION_FORCED_REFRESH.name).add(CosmosMetricTagName.ADDRESS_RESOLUTION_COLLECTION_MAP_REFRESH.name).add(CosmosMetricTagName.PARTITION_KEY_RANGE_ID.name).toString();
    }

    EnumSet<TagName> getTagNames() {
        return this.tagNames;
    }
}

