/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdChannelAcquisitionTimeline;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestRecord;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ChannelPromiseWithExpiryTime
implements Promise<Channel> {
    private final Promise<Channel> channelPromise;
    private final long expiryTimeInNanos;
    private final RntbdRequestRecord requestRecord;

    public ChannelPromiseWithExpiryTime(Promise<Channel> channelPromise, long expiryTimeInNanos) {
        this(channelPromise, expiryTimeInNanos, null);
    }

    public ChannelPromiseWithExpiryTime(Promise<Channel> channelPromise, long expiryTimeInNanos, RntbdRequestRecord requestRecord) {
        Preconditions.checkNotNull(channelPromise, "channelPromise must not be null");
        Preconditions.checkNotNull(expiryTimeInNanos, "expiryTimeInNanos must not be null");
        this.channelPromise = channelPromise;
        this.expiryTimeInNanos = expiryTimeInNanos;
        this.requestRecord = requestRecord;
    }

    public long getExpiryTimeInNanos() {
        return this.expiryTimeInNanos;
    }

    public Promise<Channel> setSuccess(Channel result) {
        return this.channelPromise.setSuccess((Object)result);
    }

    public boolean trySuccess(Channel result) {
        return this.channelPromise.trySuccess((Object)result);
    }

    public Promise<Channel> setFailure(Throwable cause) {
        return this.channelPromise.setFailure(cause);
    }

    public boolean tryFailure(Throwable cause) {
        return this.channelPromise.tryFailure(cause);
    }

    public boolean setUncancellable() {
        return this.channelPromise.setUncancellable();
    }

    public boolean isSuccess() {
        return this.channelPromise.isSuccess();
    }

    public boolean isCancellable() {
        return this.channelPromise.isCancellable();
    }

    public Throwable cause() {
        return this.channelPromise.cause();
    }

    public Promise<Channel> addListener(GenericFutureListener<? extends Future<? super Channel>> listener) {
        return this.channelPromise.addListener(listener);
    }

    @SafeVarargs
    public final Promise<Channel> addListeners(GenericFutureListener<? extends Future<? super Channel>> ... listeners) {
        return this.channelPromise.addListeners(listeners);
    }

    public Promise<Channel> removeListener(GenericFutureListener<? extends Future<? super Channel>> listener) {
        return this.channelPromise.removeListener(listener);
    }

    @SafeVarargs
    public final Promise<Channel> removeListeners(GenericFutureListener<? extends Future<? super Channel>> ... listeners) {
        return this.channelPromise.removeListeners(listeners);
    }

    public Promise<Channel> await() throws InterruptedException {
        return this.channelPromise.await();
    }

    public Promise<Channel> awaitUninterruptibly() {
        return this.channelPromise.awaitUninterruptibly();
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.channelPromise.await(timeout, unit);
    }

    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.channelPromise.await(timeoutMillis);
    }

    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        return this.channelPromise.awaitUninterruptibly(timeout, unit);
    }

    public boolean awaitUninterruptibly(long timeoutMillis) {
        return this.channelPromise.awaitUninterruptibly(timeoutMillis);
    }

    public Channel getNow() {
        return (Channel)this.channelPromise.getNow();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.channelPromise.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.channelPromise.isCancelled();
    }

    public boolean isDone() {
        return this.channelPromise.isDone();
    }

    public Channel get() throws InterruptedException, ExecutionException {
        return (Channel)this.channelPromise.get();
    }

    public Channel get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (Channel)this.channelPromise.get(timeout, unit);
    }

    public Promise<Channel> sync() throws InterruptedException {
        return this.channelPromise.sync();
    }

    public Promise<Channel> syncUninterruptibly() {
        return this.channelPromise.syncUninterruptibly();
    }

    public RntbdRequestRecord getRntbdRequestRecord() {
        return this.requestRecord;
    }

    public RntbdChannelAcquisitionTimeline getChannelAcquisitionTimeline() {
        return this.requestRecord == null ? null : this.requestRecord.getChannelAcquisitionTimeline();
    }
}

