/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.BadRequestException;
import com.azure.cosmos.implementation.ConflictException;
import com.azure.cosmos.implementation.CosmosError;
import com.azure.cosmos.implementation.ForbiddenException;
import com.azure.cosmos.implementation.GoneException;
import com.azure.cosmos.implementation.InternalServerErrorException;
import com.azure.cosmos.implementation.InvalidPartitionException;
import com.azure.cosmos.implementation.LockedException;
import com.azure.cosmos.implementation.MethodNotAllowedException;
import com.azure.cosmos.implementation.NotFoundException;
import com.azure.cosmos.implementation.PartitionIsMigratingException;
import com.azure.cosmos.implementation.PartitionKeyRangeGoneException;
import com.azure.cosmos.implementation.PartitionKeyRangeIsSplittingException;
import com.azure.cosmos.implementation.PreconditionFailedException;
import com.azure.cosmos.implementation.RequestEntityTooLargeException;
import com.azure.cosmos.implementation.RequestRateTooLargeException;
import com.azure.cosmos.implementation.RequestTimeoutException;
import com.azure.cosmos.implementation.RetryWithException;
import com.azure.cosmos.implementation.ServiceUnavailableException;
import com.azure.cosmos.implementation.UnauthorizedException;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdChannelAcquisitionTimeline;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdChannelState;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdChannelStatistics;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdClientChannelHealthChecker;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdConnectionStateListener;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdConstants;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdContext;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdContextException;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdContextNegotiator;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdContextRequest;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdHealthCheckRequest;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdReporter;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestRecord;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdResponse;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdThreadFactory;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdUtils;
import com.azure.cosmos.implementation.faultinjection.RntbdFaultInjectionConnectionCloseEvent;
import com.azure.cosmos.implementation.faultinjection.RntbdFaultInjectionConnectionResetEvent;
import com.azure.cosmos.implementation.faultinjection.RntbdServerErrorInjector;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.guava27.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CoalescingBufferQueue;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.ReferenceCounted;
import io.netty.util.Timeout;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.ThrowableUtil;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RntbdRequestManager
implements ChannelHandler,
ChannelInboundHandler,
ChannelOutboundHandler {
    private static final ClosedChannelException ON_CHANNEL_UNREGISTERED = (ClosedChannelException)ThrowableUtil.unknownStackTrace((Throwable)new ClosedChannelException(), RntbdRequestManager.class, (String)"channelUnregistered");
    private static final ClosedChannelException ON_CLOSE = (ClosedChannelException)ThrowableUtil.unknownStackTrace((Throwable)new ClosedChannelException(), RntbdRequestManager.class, (String)"close");
    private static final ClosedChannelException ON_DEREGISTER = (ClosedChannelException)ThrowableUtil.unknownStackTrace((Throwable)new ClosedChannelException(), RntbdRequestManager.class, (String)"deregister");
    private static final EventExecutor requestExpirationExecutor = new DefaultEventExecutor((ThreadFactory)new RntbdThreadFactory("request-expirator", true, 5));
    private static final Logger logger = LoggerFactory.getLogger(RntbdRequestManager.class);
    private final CompletableFuture<RntbdContext> contextFuture = new CompletableFuture();
    private final CompletableFuture<RntbdContextRequest> contextRequestFuture = new CompletableFuture();
    private final ChannelHealthChecker healthChecker;
    private final int pendingRequestLimit;
    private final ConcurrentHashMap<Long, RntbdRequestRecord> pendingRequests;
    private final RntbdClientChannelHealthChecker.Timestamps timestamps = new RntbdClientChannelHealthChecker.Timestamps();
    private final RntbdConnectionStateListener rntbdConnectionStateListener;
    private final long idleConnectionTimerResolutionInNanos;
    private final long tcpNetworkRequestTimeoutInNanos;
    private final RntbdServerErrorInjector serverErrorInjector;
    private boolean closingExceptionally = false;
    private CoalescingBufferQueue pendingWrites;

    public RntbdRequestManager(ChannelHealthChecker healthChecker, int pendingRequestLimit, RntbdConnectionStateListener connectionStateListener, long idleConnectionTimerResolutionInNanos, RntbdServerErrorInjector serverErrorInjector, long tcpNetworkRequestTimeoutInNanos) {
        Preconditions.checkArgument(pendingRequestLimit > 0, "pendingRequestLimit: %s", pendingRequestLimit);
        Preconditions.checkNotNull(healthChecker, "healthChecker");
        this.pendingRequests = new ConcurrentHashMap(pendingRequestLimit);
        this.pendingRequestLimit = pendingRequestLimit;
        this.healthChecker = healthChecker;
        this.rntbdConnectionStateListener = connectionStateListener;
        this.idleConnectionTimerResolutionInNanos = idleConnectionTimerResolutionInNanos;
        this.tcpNetworkRequestTimeoutInNanos = tcpNetworkRequestTimeoutInNanos;
        this.serverErrorInjector = serverErrorInjector;
    }

    public void handlerAdded(ChannelHandlerContext context) {
        this.traceOperation(context, "handlerAdded", new Object[0]);
    }

    public void handlerRemoved(ChannelHandlerContext context) {
        this.traceOperation(context, "handlerRemoved", new Object[0]);
    }

    public void channelActive(ChannelHandlerContext context) {
        this.traceOperation(context, "channelActive", new Object[0]);
        context.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext context) {
        this.traceOperation(context, "channelInactive", new Object[0]);
        context.fireChannelInactive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext context, Object message) {
        block8: {
            this.traceOperation(context, "channelRead", new Object[0]);
            this.timestamps.channelReadCompleted();
            try {
                if (message.getClass() == RntbdResponse.class) {
                    try {
                        this.messageReceived(context, (RntbdResponse)message);
                    }
                    catch (CorruptedFrameException error) {
                        this.exceptionCaught(context, error);
                    }
                    catch (Throwable throwable) {
                        RntbdRequestManager.reportIssue(context, "{} ", message, throwable);
                        this.exceptionCaught(context, throwable);
                    }
                    break block8;
                }
                IllegalStateException error = new IllegalStateException(Strings.lenientFormat("expected message of %s, not %s: %s", RntbdResponse.class, message.getClass(), message));
                RntbdRequestManager.reportIssue(context, "", error);
                this.exceptionCaught(context, error);
            }
            catch (Throwable throwable) {
                if (message instanceof ReferenceCounted) {
                    boolean released = ((ReferenceCounted)message).release();
                    RntbdRequestManager.reportIssueUnless(released, context, "failed to release message: {}", message);
                }
                throw throwable;
            }
        }
        if (message instanceof ReferenceCounted) {
            boolean released = ((ReferenceCounted)message).release();
            RntbdRequestManager.reportIssueUnless(released, context, "failed to release message: {}", message);
        }
    }

    public void channelReadComplete(ChannelHandlerContext context) {
        this.traceOperation(context, "channelReadComplete", new Object[0]);
        context.fireChannelReadComplete();
    }

    public void channelRegistered(ChannelHandlerContext context) {
        this.traceOperation(context, "channelRegistered", new Object[0]);
        RntbdRequestManager.reportIssueUnless(this.pendingWrites == null, context, "pendingWrites: {}", this.pendingWrites);
        this.pendingWrites = new CoalescingBufferQueue(context.channel());
        context.fireChannelRegistered();
    }

    public void channelUnregistered(ChannelHandlerContext context) {
        this.traceOperation(context, "channelUnregistered", new Object[0]);
        if (!this.closingExceptionally) {
            this.completeAllPendingRequestsExceptionally(context, ON_CHANNEL_UNREGISTERED);
        } else {
            logger.debug("{} channelUnregistered exceptionally", (Object)context);
        }
        context.fireChannelUnregistered();
    }

    public void channelWritabilityChanged(ChannelHandlerContext context) {
        this.traceOperation(context, "channelWritabilityChanged", new Object[0]);
        context.fireChannelWritabilityChanged();
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        this.traceOperation(context, "exceptionCaught", cause);
        if (!this.closingExceptionally) {
            this.completeAllPendingRequestsExceptionally(context, cause);
            if (logger.isDebugEnabled()) {
                logger.debug("{} closing due to:", (Object)context, (Object)cause);
            }
            context.flush().close();
        }
    }

    public void userEventTriggered(ChannelHandlerContext context, Object event) {
        this.traceOperation(context, "userEventTriggered", event);
        try {
            if (event instanceof IdleStateEvent) {
                if (this.healthChecker instanceof RntbdClientChannelHealthChecker) {
                    ((RntbdClientChannelHealthChecker)this.healthChecker).isHealthyWithFailureReason(context.channel()).addListener(future -> {
                        Object cause;
                        if (future.isSuccess()) {
                            if ("Success".equals(future.get())) {
                                return;
                            }
                            cause = new UnhealthyChannelException((String)future.get());
                        } else {
                            cause = future.cause();
                        }
                        this.exceptionCaught(context, (Throwable)cause);
                    });
                } else {
                    this.healthChecker.isHealthy(context.channel()).addListener(future -> {
                        Object cause;
                        if (future.isSuccess()) {
                            if (((Boolean)future.get()).booleanValue()) {
                                return;
                            }
                            cause = new UnhealthyChannelException(MessageFormat.format("Custom ChannelHealthChecker {0} failed.", this.healthChecker.getClass().getSimpleName()));
                        } else {
                            cause = future.cause();
                        }
                        this.exceptionCaught(context, (Throwable)cause);
                    });
                }
                return;
            }
            if (event instanceof RntbdContext) {
                this.contextFuture.complete((RntbdContext)event);
                this.removeContextNegotiatorAndFlushPendingWrites(context);
                this.timestamps.channelReadCompleted();
                return;
            }
            if (event instanceof RntbdContextException) {
                this.contextFuture.completeExceptionally((RntbdContextException)event);
                this.exceptionCaught(context, (RntbdContextException)event);
                return;
            }
            if (event instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent sslHandshakeCompletionEvent = (SslHandshakeCompletionEvent)event;
                if (sslHandshakeCompletionEvent.isSuccess()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("SslHandshake completed, adding idleStateHandler");
                    }
                    context.pipeline().addAfter(SslHandler.class.toString(), IdleStateHandler.class.toString(), (ChannelHandler)new IdleStateHandler(this.idleConnectionTimerResolutionInNanos, this.idleConnectionTimerResolutionInNanos, 0L, TimeUnit.NANOSECONDS));
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("SslHandshake failed", sslHandshakeCompletionEvent.cause());
                    }
                    this.exceptionCaught(context, sslHandshakeCompletionEvent.cause());
                    return;
                }
            }
            if (event instanceof RntbdFaultInjectionConnectionResetEvent) {
                this.exceptionCaught(context, new IOException("Fault Injection Connection Reset"));
                return;
            }
            if (event instanceof RntbdFaultInjectionConnectionCloseEvent) {
                context.close();
                return;
            }
            context.fireUserEventTriggered(event);
        }
        catch (Throwable error) {
            RntbdRequestManager.reportIssue(context, "{}: ", event, error);
            this.exceptionCaught(context, error);
        }
    }

    public void bind(ChannelHandlerContext context, SocketAddress localAddress, ChannelPromise promise) {
        this.traceOperation(context, "bind", localAddress);
        context.bind(localAddress, promise);
    }

    public void close(ChannelHandlerContext context, ChannelPromise promise) {
        this.traceOperation(context, "close", new Object[0]);
        if (!this.closingExceptionally) {
            this.completeAllPendingRequestsExceptionally(context, ON_CLOSE);
        } else {
            logger.debug("{} closed exceptionally", (Object)context);
        }
        SslHandler sslHandler = (SslHandler)context.pipeline().get(SslHandler.class);
        if (sslHandler != null) {
            try {
                sslHandler.closeOutbound();
            }
            catch (Exception exception) {
                if (exception instanceof SSLException) {
                    logger.debug("SslException when attempting to close the outbound SSL connection: ", (Throwable)exception);
                }
                logger.warn("Exception when attempting to close the outbound SSL connection: ", (Throwable)exception);
                throw exception;
            }
        }
        context.close(promise);
    }

    public void connect(ChannelHandlerContext context, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        this.traceOperation(context, "connect", remoteAddress, localAddress);
        context.connect(remoteAddress, localAddress, promise);
    }

    public void deregister(ChannelHandlerContext context, ChannelPromise promise) {
        this.traceOperation(context, "deregister", new Object[0]);
        if (!this.closingExceptionally) {
            this.completeAllPendingRequestsExceptionally(context, ON_DEREGISTER);
        } else {
            logger.debug("{} deregistered exceptionally", (Object)context);
        }
        context.deregister(promise);
    }

    public void disconnect(ChannelHandlerContext context, ChannelPromise promise) {
        this.traceOperation(context, "disconnect", new Object[0]);
        context.disconnect(promise);
    }

    public void flush(ChannelHandlerContext context) {
        this.traceOperation(context, "flush", new Object[0]);
        context.flush();
    }

    public void read(ChannelHandlerContext context) {
        this.traceOperation(context, "read", new Object[0]);
        context.read();
    }

    public void write(ChannelHandlerContext context, Object message, ChannelPromise promise) {
        this.traceOperation(context, "write", message);
        if (message instanceof RntbdRequestRecord) {
            RntbdRequestRecord record = (RntbdRequestRecord)message;
            record.setTimestamps(this.timestamps);
            if (!record.isCancelled()) {
                record.setSendingRequestHasStarted();
                this.timestamps.channelWriteAttempted();
                if (this.serverErrorInjector != null) {
                    if (this.serverErrorInjector.injectRntbdServerResponseError(record)) {
                        return;
                    }
                    Consumer<Duration> writeRequestWithInjectedDelayConsumer = delay -> this.writeRequestWithInjectedDelay(context, record, promise, (Duration)delay);
                    if (this.serverErrorInjector.injectRntbdServerResponseDelay(record, writeRequestWithInjectedDelayConsumer)) {
                        return;
                    }
                }
                context.write((Object)this.addPendingRequestRecord(context, record), promise).addListener(completed -> {
                    record.stage(RntbdRequestRecord.Stage.SENT);
                    if (completed.isSuccess()) {
                        this.timestamps.channelWriteCompleted();
                    }
                });
            }
            return;
        }
        if (message == RntbdHealthCheckRequest.MESSAGE) {
            context.write((Object)RntbdHealthCheckRequest.MESSAGE, promise).addListener(completed -> {
                if (completed.isSuccess()) {
                    this.timestamps.channelPingCompleted();
                }
            });
            return;
        }
        IllegalStateException error = new IllegalStateException(Strings.lenientFormat("message of %s: %s", message.getClass(), message));
        RntbdRequestManager.reportIssue(context, "", error);
        this.exceptionCaught(context, error);
    }

    private void writeRequestWithInjectedDelay(ChannelHandlerContext context, RntbdRequestRecord rntbdRequestRecord, ChannelPromise promise, Duration delay) {
        this.addPendingRequestRecord(context, rntbdRequestRecord);
        rntbdRequestRecord.stage(RntbdRequestRecord.Stage.SENT);
        this.timestamps.channelWriteCompleted();
        long effectiveDelayInNanos = Math.min(this.tcpNetworkRequestTimeoutInNanos, delay.toNanos());
        context.executor().schedule(() -> {
            if (this.tcpNetworkRequestTimeoutInNanos <= delay.toNanos()) {
                return;
            }
            context.write((Object)rntbdRequestRecord, promise);
        }, effectiveDelayInNanos, TimeUnit.NANOSECONDS);
    }

    public RntbdChannelStatistics getChannelStatistics(Channel channel, RntbdChannelAcquisitionTimeline channelAcquisitionTimeline) {
        return new RntbdChannelStatistics().channelId(channel.id().toString()).pendingRequestsCount(this.pendingRequests.size()).channelTaskQueueSize(RntbdUtils.tryGetExecutorTaskQueueSize((EventExecutor)channel.eventLoop())).lastReadTime(this.timestamps.lastChannelReadTime()).transitTimeoutCount(this.timestamps.transitTimeoutCount()).transitTimeoutStartingTime(this.timestamps.transitTimeoutStartingTime()).waitForConnectionInit(channelAcquisitionTimeline.isWaitForChannelInit());
    }

    int pendingRequestCount() {
        return this.pendingRequests.size();
    }

    Optional<RntbdContext> rntbdContext() {
        return Optional.of(this.contextFuture.getNow(null));
    }

    CompletableFuture<RntbdContextRequest> rntbdContextRequestFuture() {
        return this.contextRequestFuture;
    }

    boolean hasRequestedRntbdContext() {
        return this.contextRequestFuture.getNow(null) != null;
    }

    boolean hasRntbdContext() {
        return this.contextFuture.getNow(null) != null;
    }

    RntbdChannelState getChannelState(int demand) {
        int limit;
        RntbdRequestManager.reportIssueUnless(this.hasRequestedRntbdContext(), this, "Direct TCP context request was not issued", new Object[0]);
        int n = limit = this.hasRntbdContext() ? this.pendingRequestLimit : Math.min(this.pendingRequestLimit, demand);
        if (this.pendingRequests.size() < limit) {
            return RntbdChannelState.ok(this.pendingRequests.size());
        }
        if (this.hasRntbdContext()) {
            return RntbdChannelState.pendingLimit(this.pendingRequests.size());
        }
        return RntbdChannelState.contextNegotiationPending(this.pendingRequests.size());
    }

    void pendWrite(ByteBuf out, ChannelPromise promise) {
        this.pendingWrites.add(out, promise);
    }

    public RntbdClientChannelHealthChecker.Timestamps getTimestamps() {
        return this.timestamps;
    }

    RntbdClientChannelHealthChecker.Timestamps snapshotTimestamps() {
        return new RntbdClientChannelHealthChecker.Timestamps(this.timestamps);
    }

    private RntbdRequestRecord addPendingRequestRecord(ChannelHandlerContext context, RntbdRequestRecord record) {
        AtomicReference pendingRequestTimeout = new AtomicReference();
        this.pendingRequests.compute(record.transportRequestId(), (id, current) -> {
            RntbdRequestManager.reportIssueUnless(current == null, context, "id: {}, current: {}, request: {}", record);
            pendingRequestTimeout.set(record.newTimeout(timeout -> requestExpirationExecutor.execute(record::expire)));
            return record;
        });
        record.whenComplete((response, error) -> {
            this.pendingRequests.remove(record.transportRequestId());
            if (pendingRequestTimeout.get() != null) {
                ((Timeout)pendingRequestTimeout.get()).cancel();
            }
        });
        return record;
    }

    private void completeAllPendingRequestsExceptionally(ChannelHandlerContext context, Throwable throwable) {
        RntbdRequestManager.reportIssueUnless(!this.closingExceptionally, context, "", throwable);
        this.closingExceptionally = true;
        if (this.pendingWrites != null && !this.pendingWrites.isEmpty()) {
            this.pendingWrites.releaseAndFailAll((ChannelOutboundInvoker)context, throwable);
        }
        if (this.rntbdConnectionStateListener != null) {
            this.rntbdConnectionStateListener.onException(throwable);
        }
        if (this.pendingRequests.isEmpty()) {
            return;
        }
        if (!this.contextRequestFuture.isDone()) {
            this.contextRequestFuture.completeExceptionally(throwable);
        }
        if (!this.contextFuture.isDone()) {
            this.contextFuture.completeExceptionally(throwable);
        }
        int count = this.pendingRequests.size();
        Exception contextRequestException = null;
        String phrase = null;
        if (this.contextRequestFuture.isCompletedExceptionally()) {
            try {
                this.contextRequestFuture.get();
            }
            catch (CancellationException error) {
                phrase = "RNTBD context request write cancelled";
                contextRequestException = error;
            }
            catch (Exception error) {
                phrase = "RNTBD context request write failed";
                contextRequestException = error;
            }
            catch (Throwable error) {
                phrase = "RNTBD context request write failed";
                contextRequestException = new ChannelException(error);
            }
        } else if (this.contextFuture.isCompletedExceptionally()) {
            try {
                this.contextFuture.get();
            }
            catch (CancellationException error) {
                phrase = "RNTBD context request read cancelled";
                contextRequestException = error;
            }
            catch (Exception error) {
                phrase = "RNTBD context request read failed";
                contextRequestException = error;
            }
            catch (Throwable error) {
                phrase = "RNTBD context request read failed";
                contextRequestException = new ChannelException(error);
            }
        } else {
            phrase = "closed exceptionally";
        }
        String message = Strings.lenientFormat("%s %s with %s pending requests", context, phrase, count);
        Exception cause = throwable instanceof ClosedChannelException ? (contextRequestException == null ? (ClosedChannelException)throwable : contextRequestException) : (throwable instanceof Exception ? (Exception)throwable : new ChannelException(throwable));
        for (RntbdRequestRecord record : this.pendingRequests.values()) {
            Map<String, String> requestHeaders = record.args().serviceRequest().getHeaders();
            String requestUri = record.args().physicalAddressUri().getURI().toString();
            GoneException error = new GoneException(message, cause, null, requestUri);
            BridgeInternal.setRequestHeaders(error, requestHeaders);
            record.completeExceptionally((Throwable)((Object)error));
        }
    }

    private void messageReceived(ChannelHandlerContext context, RntbdResponse response) {
        Long transportRequestId = response.getTransportRequestId();
        if (transportRequestId == null) {
            RntbdRequestManager.reportIssue(context, "response ignored because its transportRequestId is missing: {}", response);
            return;
        }
        RntbdRequestRecord requestRecord = this.pendingRequests.get(transportRequestId);
        if (requestRecord == null) {
            logger.debug("response {} ignored because its requestRecord is missing: {}", (Object)transportRequestId, (Object)response);
            return;
        }
        requestRecord.stage(RntbdRequestRecord.Stage.DECODE_STARTED, response.getDecodeStartTime());
        requestRecord.stage(RntbdRequestRecord.Stage.RECEIVED, response.getDecodeEndTime() != null ? response.getDecodeEndTime() : Instant.now());
        requestRecord.responseLength(response.getMessageLength());
        HttpResponseStatus status = response.getStatus();
        UUID activityId = response.getActivityId();
        int statusCode = status.code();
        if (HttpResponseStatus.OK.code() <= statusCode && statusCode < HttpResponseStatus.MULTIPLE_CHOICES.code() || statusCode == HttpResponseStatus.NOT_MODIFIED.code()) {
            StoreResponse storeResponse = response.toStoreResponse(this.contextFuture.getNow(null));
            requestRecord.complete(storeResponse);
        } else {
            CosmosException cause;
            long lsn = (Long)response.getHeader(RntbdConstants.RntbdResponseHeader.LSN);
            String partitionKeyRangeId = (String)response.getHeader(RntbdConstants.RntbdResponseHeader.PartitionKeyRangeId);
            CosmosError error = response.hasPayload() ? new CosmosError(RntbdObjectMapper.readTree(response)) : new CosmosError(Integer.toString(statusCode), status.reasonPhrase(), status.codeClass().name());
            Map<String, String> responseHeaders = response.getHeaders().asMap(this.rntbdContext().orElseThrow(IllegalStateException::new), activityId);
            String resourceAddress = requestRecord.args().physicalAddressUri() != null ? requestRecord.args().physicalAddressUri().getURI().toString() : null;
            block0 : switch (status.code()) {
                case 400: {
                    cause = new BadRequestException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 409: {
                    cause = new ConflictException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 403: {
                    cause = new ForbiddenException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 410: {
                    int subStatusCode = Math.toIntExact((Long)response.getHeader(RntbdConstants.RntbdResponseHeader.SubStatus));
                    switch (subStatusCode) {
                        case 1007: {
                            cause = new PartitionKeyRangeIsSplittingException(error, lsn, partitionKeyRangeId, responseHeaders);
                            break block0;
                        }
                        case 1008: {
                            cause = new PartitionIsMigratingException(error, lsn, partitionKeyRangeId, responseHeaders);
                            break block0;
                        }
                        case 1000: {
                            cause = new InvalidPartitionException(error, lsn, partitionKeyRangeId, responseHeaders);
                            break block0;
                        }
                        case 1002: {
                            cause = new PartitionKeyRangeGoneException(error, lsn, partitionKeyRangeId, responseHeaders);
                            break block0;
                        }
                    }
                    GoneException goneExceptionFromService = new GoneException(error, lsn, partitionKeyRangeId, responseHeaders);
                    goneExceptionFromService.setIsBasedOn410ResponseFromService();
                    cause = goneExceptionFromService;
                    break;
                }
                case 500: {
                    cause = new InternalServerErrorException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 423: {
                    cause = new LockedException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 405: {
                    cause = new MethodNotAllowedException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 404: {
                    cause = new NotFoundException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 412: {
                    cause = new PreconditionFailedException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 413: {
                    cause = new RequestEntityTooLargeException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 408: {
                    RequestTimeoutException inner = new RequestTimeoutException(error, lsn, partitionKeyRangeId, responseHeaders);
                    cause = new GoneException(resourceAddress, error, lsn, partitionKeyRangeId, responseHeaders, (Throwable)((Object)inner));
                    break;
                }
                case 449: {
                    cause = new RetryWithException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 503: {
                    cause = new ServiceUnavailableException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 429: {
                    cause = new RequestRateTooLargeException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                case 401: {
                    cause = new UnauthorizedException(error, lsn, partitionKeyRangeId, responseHeaders);
                    break;
                }
                default: {
                    cause = BridgeInternal.createCosmosException(resourceAddress, status.code(), error, responseHeaders);
                }
            }
            BridgeInternal.setResourceAddress(cause, resourceAddress);
            requestRecord.completeExceptionally((Throwable)((Object)cause));
        }
    }

    private void removeContextNegotiatorAndFlushPendingWrites(ChannelHandlerContext context) {
        RntbdContextNegotiator negotiator = (RntbdContextNegotiator)context.pipeline().get(RntbdContextNegotiator.class);
        negotiator.removeInboundHandler();
        negotiator.removeOutboundHandler();
        if (!this.pendingWrites.isEmpty()) {
            this.pendingWrites.writeAndRemoveAll(context);
            context.flush();
        }
    }

    private static void reportIssue(Object subject, String format, Object ... args) {
        RntbdReporter.reportIssue(logger, subject, format, args);
    }

    private static void reportIssueUnless(boolean predicate, Object subject, String format, Object ... args) {
        RntbdReporter.reportIssueUnless(logger, predicate, subject, format, args);
    }

    private void traceOperation(ChannelHandlerContext context, String operationName, Object ... args) {
        logger.trace("{}\n{}\n{}", new Object[]{operationName, context, args});
    }

    public static final class UnhealthyChannelException
    extends ChannelException {
        public UnhealthyChannelException(String reason) {
            super("health check failed, reason: " + reason);
        }

        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

