/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.faultinjection;

import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestRecord;
import com.azure.cosmos.implementation.faultinjection.IRntbdServerErrorInjector;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class RntbdServerErrorInjector
implements IRntbdServerErrorInjector {
    private List<IRntbdServerErrorInjector> faultInjectors = new ArrayList<IRntbdServerErrorInjector>();

    public void registerServerErrorInjector(IRntbdServerErrorInjector serverErrorInjector) {
        Preconditions.checkNotNull(serverErrorInjector, "Argument 'serverErrorInjector' can not be null");
        this.faultInjectors.add(serverErrorInjector);
    }

    @Override
    public boolean injectRntbdServerResponseDelay(RntbdRequestRecord requestRecord, Consumer<Duration> writeRequestWithDelayConsumer) {
        for (IRntbdServerErrorInjector injector : this.faultInjectors) {
            if (!injector.injectRntbdServerResponseDelay(requestRecord, writeRequestWithDelayConsumer)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean injectRntbdServerResponseError(RntbdRequestRecord requestRecord) {
        for (IRntbdServerErrorInjector injector : this.faultInjectors) {
            if (!injector.injectRntbdServerResponseError(requestRecord)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean injectRntbdServerConnectionDelay(RntbdRequestRecord requestRecord, Consumer<Duration> openConnectionWithDelayConsumer) {
        for (IRntbdServerErrorInjector injector : this.faultInjectors) {
            if (!injector.injectRntbdServerConnectionDelay(requestRecord, openConnectionWithDelayConsumer)) continue;
            return true;
        }
        return false;
    }
}

