/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.BadRequestException;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.apachecommons.lang.tuple.Pair;
import com.azure.cosmos.implementation.caches.RxCollectionCache;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.query.DefaultDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.PartitionedQueryExecutionInfo;
import com.azure.cosmos.implementation.query.PipelinedDocumentQueryParams;
import com.azure.cosmos.implementation.query.PipelinedQueryExecutionContext;
import com.azure.cosmos.implementation.query.PipelinedQueryExecutionContextBase;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.implementation.query.QueryPlanRetriever;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.PartitionKeyDefinition;
import com.azure.cosmos.models.PartitionKind;
import com.azure.cosmos.models.SqlQuerySpec;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DocumentQueryExecutionContextFactory {
    private static final int PageSizeFactorForTop = 5;
    private static final Logger logger = LoggerFactory.getLogger(DocumentQueryExecutionContextFactory.class);

    private static Mono<Utils.ValueHolder<DocumentCollection>> resolveCollection(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, ResourceType resourceTypeEnum, String resourceLink) {
        RxCollectionCache collectionCache = client.getCollectionCache();
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(diagnosticsClientContext, OperationType.Query, resourceTypeEnum, resourceLink, null);
        return collectionCache.resolveCollectionAsync(null, request);
    }

    private static <T> Mono<Pair<List<Range<String>>, QueryInfo>> getPartitionKeyRangesAndQueryInfo(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, SqlQuerySpec query, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceLink, DocumentCollection collection, DefaultDocumentQueryExecutionContext<T> queryExecutionContext, boolean queryPlanCachingEnabled, Map<String, PartitionedQueryExecutionInfo> queryPlanCache) {
        if (cosmosQueryRequestOptions != null && !StringUtils.isEmpty(ModelBridgeInternal.getPartitionKeyRangeIdInternal(cosmosQueryRequestOptions))) {
            Mono<List<PartitionKeyRange>> partitionKeyRanges = queryExecutionContext.getTargetPartitionKeyRangesById(collection.getResourceId(), ModelBridgeInternal.getPartitionKeyRangeIdInternal(cosmosQueryRequestOptions));
            return partitionKeyRanges.map(pkRanges -> {
                List ranges = pkRanges.stream().map(PartitionKeyRange::toRange).collect(Collectors.toList());
                return Pair.of(ranges, QueryInfo.EMPTY);
            });
        }
        Instant startTime = Instant.now();
        if (ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().isQueryPlanRetrievalDisallowed(cosmosQueryRequestOptions)) {
            Instant endTime = Instant.now();
            return DocumentQueryExecutionContextFactory.getTargetRangesFromEmptyQueryPlan(cosmosQueryRequestOptions, collection, queryExecutionContext, startTime, endTime);
        }
        if (queryPlanCachingEnabled && DocumentQueryExecutionContextFactory.isScopedToSinglePartition(cosmosQueryRequestOptions) && queryPlanCache.containsKey(query.getQueryText())) {
            Instant endTime = Instant.now();
            PartitionedQueryExecutionInfo partitionedQueryExecutionInfo2 = queryPlanCache.get(query.getQueryText());
            if (partitionedQueryExecutionInfo2 != null) {
                logger.debug("Skipping query plan round trip by using the cached plan");
                return DocumentQueryExecutionContextFactory.getTargetRangesFromQueryPlan(cosmosQueryRequestOptions, collection, queryExecutionContext, partitionedQueryExecutionInfo2, startTime, endTime);
            }
        }
        Mono<PartitionedQueryExecutionInfo> queryExecutionInfoMono = QueryPlanRetriever.getQueryPlanThroughGatewayAsync(diagnosticsClientContext, client, query, resourceLink, cosmosQueryRequestOptions != null ? cosmosQueryRequestOptions.getPartitionKey() : null);
        return queryExecutionInfoMono.flatMap(partitionedQueryExecutionInfo -> {
            Instant endTime = Instant.now();
            if (queryPlanCachingEnabled && DocumentQueryExecutionContextFactory.isScopedToSinglePartition(cosmosQueryRequestOptions)) {
                DocumentQueryExecutionContextFactory.tryCacheQueryPlan(query, partitionedQueryExecutionInfo, queryPlanCache);
            }
            return DocumentQueryExecutionContextFactory.getTargetRangesFromQueryPlan(cosmosQueryRequestOptions, collection, queryExecutionContext, partitionedQueryExecutionInfo, startTime, endTime);
        });
    }

    private static <T> Mono<Pair<List<Range<String>>, QueryInfo>> getTargetRangesFromQueryPlan(CosmosQueryRequestOptions cosmosQueryRequestOptions, DocumentCollection collection, DefaultDocumentQueryExecutionContext<T> queryExecutionContext, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo, Instant planFetchStartTime, Instant planFetchEndTime) {
        QueryInfo queryInfo = partitionedQueryExecutionInfo.getQueryInfo();
        queryInfo.setQueryPlanDiagnosticsContext(new QueryInfo.QueryPlanDiagnosticsContext(planFetchStartTime, planFetchEndTime, partitionedQueryExecutionInfo.getQueryPlanRequestTimeline()));
        List<Range<String>> queryRanges = partitionedQueryExecutionInfo.getQueryRanges();
        if (DocumentQueryExecutionContextFactory.isScopedToSinglePartition(cosmosQueryRequestOptions)) {
            PartitionKeyInternal internalPartitionKey = BridgeInternal.getPartitionKeyInternal(cosmosQueryRequestOptions.getPartitionKey());
            Range<String> range2 = Range.getPointRange(internalPartitionKey.getEffectivePartitionKeyString(internalPartitionKey, collection.getPartitionKey()));
            queryRanges = Collections.singletonList(range2);
        }
        if (cosmosQueryRequestOptions != null && cosmosQueryRequestOptions.getFeedRange() != null) {
            FeedRange userProvidedFeedRange = cosmosQueryRequestOptions.getFeedRange();
            return queryExecutionContext.getTargetRange(collection.getResourceId(), FeedRangeInternal.convert(userProvidedFeedRange)).map(range -> Pair.of(Collections.singletonList(range), partitionedQueryExecutionInfo.getQueryInfo()));
        }
        return queryExecutionContext.getTargetPartitionKeyRanges(collection.getResourceId(), queryRanges).map(pkRanges -> {
            List ranges = pkRanges.stream().map(PartitionKeyRange::toRange).collect(Collectors.toList());
            return Pair.of(ranges, partitionedQueryExecutionInfo.getQueryInfo());
        });
    }

    private static <T> Mono<Pair<List<Range<String>>, QueryInfo>> getTargetRangesFromEmptyQueryPlan(CosmosQueryRequestOptions cosmosQueryRequestOptions, DocumentCollection collection, DefaultDocumentQueryExecutionContext<T> queryExecutionContext, Instant planFetchStartTime, Instant planFetchEndTime) {
        if (cosmosQueryRequestOptions == null || cosmosQueryRequestOptions.getFeedRange() == null) {
            throw new IllegalStateException("Query plan retrieval must not be suppressed when not using FeedRanges");
        }
        QueryInfo queryInfo = QueryInfo.EMPTY;
        queryInfo.setQueryPlanDiagnosticsContext(new QueryInfo.QueryPlanDiagnosticsContext(planFetchStartTime, planFetchEndTime));
        FeedRange userProvidedFeedRange = cosmosQueryRequestOptions.getFeedRange();
        return queryExecutionContext.getTargetRange(collection.getResourceId(), FeedRangeInternal.convert(userProvidedFeedRange)).map(range -> Pair.of(Collections.singletonList(range), queryInfo));
    }

    private static synchronized void tryCacheQueryPlan(SqlQuerySpec query, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo, Map<String, PartitionedQueryExecutionInfo> queryPlanCache) {
        if (DocumentQueryExecutionContextFactory.canCacheQuery(partitionedQueryExecutionInfo.getQueryInfo()) && !queryPlanCache.containsKey(query.getQueryText())) {
            if (queryPlanCache.size() >= 1000) {
                logger.warn("Clearing query plan cache as it has reached the maximum size : {}", (Object)queryPlanCache.size());
                queryPlanCache.clear();
            }
            queryPlanCache.put(query.getQueryText(), partitionedQueryExecutionInfo);
        }
    }

    private static boolean canCacheQuery(QueryInfo queryInfo) {
        return !queryInfo.hasAggregates() && !queryInfo.hasDistinct() && !queryInfo.hasGroupBy() && !queryInfo.hasLimit() && !queryInfo.hasTop() && !queryInfo.hasOffset() && !queryInfo.hasDCount() && !queryInfo.hasOrderBy();
    }

    private static boolean isScopedToSinglePartition(CosmosQueryRequestOptions cosmosQueryRequestOptions) {
        return cosmosQueryRequestOptions != null && cosmosQueryRequestOptions.getPartitionKey() != null && cosmosQueryRequestOptions.getPartitionKey() != PartitionKey.NONE;
    }

    private static List<FeedRangeEpkImpl> resolveFeedRangeBasedOnPrefixContainer(List<FeedRangeEpkImpl> feedRanges, PartitionKeyDefinition partitionKeyDefinition, PartitionKey partitionKey) {
        PartitionKeyInternal partitionKeyInternal = ModelBridgeInternal.getPartitionKeyInternal(partitionKey);
        if (partitionKeyInternal.getComponents().size() >= partitionKeyDefinition.getPaths().size()) {
            return feedRanges;
        }
        ArrayList<FeedRangeEpkImpl> feedRanges2 = new ArrayList<FeedRangeEpkImpl>();
        for (int i = 0; i < feedRanges.size(); ++i) {
            feedRanges2.add(new FeedRangeEpkImpl(partitionKeyInternal.getEPKRangeForPrefixPartitionKey(partitionKeyDefinition)));
        }
        return feedRanges2;
    }

    public static <T> Flux<? extends IDocumentQueryExecutionContext<T>> createDocumentQueryExecutionContextAsync(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceLink, boolean isContinuationExpected, UUID correlatedActivityId, boolean queryPlanCachingEnabled, Map<String, PartitionedQueryExecutionInfo> queryPlanCache) {
        Flux collectionObs = Flux.just(new Utils.ValueHolder<Object>(null));
        if (resourceTypeEnum.isCollectionChild()) {
            collectionObs = DocumentQueryExecutionContextFactory.resolveCollection(diagnosticsClientContext, client, resourceTypeEnum, resourceLink).flux();
        }
        DefaultDocumentQueryExecutionContext queryExecutionContext = new DefaultDocumentQueryExecutionContext(diagnosticsClientContext, client, resourceTypeEnum, resourceType, query, cosmosQueryRequestOptions, resourceLink, correlatedActivityId);
        if (ResourceType.Document != resourceTypeEnum && ResourceType.Conflict != resourceTypeEnum) {
            return Flux.just(queryExecutionContext);
        }
        return collectionObs.single().flatMap(collectionValueHolder -> {
            Mono<Pair<List<Range<String>>, QueryInfo>> queryPlanTask = DocumentQueryExecutionContextFactory.getPartitionKeyRangesAndQueryInfo(diagnosticsClientContext, client, query, cosmosQueryRequestOptions, resourceLink, (DocumentCollection)collectionValueHolder.v, queryExecutionContext, queryPlanCachingEnabled, queryPlanCache);
            return queryPlanTask.flatMap(queryPlan -> DocumentQueryExecutionContextFactory.createSpecializedDocumentQueryExecutionContextAsync(diagnosticsClientContext, client, resourceTypeEnum, resourceType, query, cosmosQueryRequestOptions, resourceLink, isContinuationExpected, (QueryInfo)queryPlan.getRight(), (List)queryPlan.getLeft(), (DocumentCollection)collectionValueHolder.v, correlatedActivityId).single());
        }).flux();
    }

    public static <T> Flux<? extends IDocumentQueryExecutionContext<T>> createSpecializedDocumentQueryExecutionContextAsync(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceLink, boolean isContinuationExpected, QueryInfo queryInfo, List<Range<String>> targetRanges, DocumentCollection collection, UUID correlatedActivityId) {
        int top;
        int initialPageSize = Utils.getValueOrDefault(ModelBridgeInternal.getMaxItemCountFromQueryRequestOptions(cosmosQueryRequestOptions), 100);
        BadRequestException validationError = Utils.checkRequestOrReturnException(initialPageSize > 0 || initialPageSize == -1, "MaxItemCount", "Invalid MaxItemCount %s", initialPageSize);
        if (validationError != null) {
            return Flux.error((Throwable)((Object)validationError));
        }
        boolean getLazyFeedResponse = queryInfo.hasTop();
        if (queryInfo.hasOrderBy() && queryInfo.hasTop() && (top = queryInfo.getTop().intValue()) > 0) {
            int pageSizeWithTop = Math.min((int)Math.ceil((double)top / (double)targetRanges.size()) * 5, top);
            initialPageSize = initialPageSize > 0 ? Math.min(pageSizeWithTop, initialPageSize) : pageSizeWithTop;
        }
        List<FeedRangeEpkImpl> feedRangeEpks = targetRanges.stream().map(FeedRangeEpkImpl::new).collect(Collectors.toList());
        if (collection.getPartitionKey() != null && cosmosQueryRequestOptions.getPartitionKey() != null && collection.getPartitionKey().getKind().equals((Object)PartitionKind.MULTI_HASH)) {
            feedRangeEpks = DocumentQueryExecutionContextFactory.resolveFeedRangeBasedOnPrefixContainer(feedRangeEpks, collection.getPartitionKey(), cosmosQueryRequestOptions.getPartitionKey());
        }
        PipelinedDocumentQueryParams<T> documentQueryParams = new PipelinedDocumentQueryParams<T>(resourceTypeEnum, resourceType, query, resourceLink, collection.getResourceId(), getLazyFeedResponse, isContinuationExpected, initialPageSize, queryInfo, cosmosQueryRequestOptions, correlatedActivityId, feedRangeEpks);
        return PipelinedQueryExecutionContextBase.createAsync(diagnosticsClientContext, client, documentQueryParams, resourceType, collection);
    }

    public static <T> Flux<? extends IDocumentQueryExecutionContext<T>> createReadManyQueryAsync(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient queryClient, String collectionResourceId, SqlQuerySpec sqlQuery, Map<PartitionKeyRange, SqlQuerySpec> rangeQueryMap, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceId, String collectionLink, UUID activityId, Class<T> klass, ResourceType resourceTypeEnum) {
        return PipelinedQueryExecutionContext.createReadManyAsync(diagnosticsClientContext, queryClient, sqlQuery, rangeQueryMap, cosmosQueryRequestOptions, resourceId, collectionLink, activityId, klass, resourceTypeEnum);
    }
}

