/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.core.http.ProxyOptions;
import com.azure.core.util.MetricsOptions;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.clienttelemetry.CosmosMeterOptions;
import com.azure.cosmos.implementation.clienttelemetry.MetricCategory;
import com.azure.cosmos.implementation.clienttelemetry.TagName;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosMetricName;
import com.azure.cosmos.models.CosmosMicrometerMetricsOptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.micrometer.core.instrument.MeterRegistry;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CosmosClientTelemetryConfig {
    private static Logger logger = LoggerFactory.getLogger(CosmosClientTelemetryConfig.class);
    private static final Duration DEFAULT_NETWORK_REQUEST_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_IDLE_CONNECTION_TIMEOUT = Duration.ofSeconds(60L);
    private static final int DEFAULT_MAX_CONNECTION_POOL_SIZE = 1000;
    private Boolean clientTelemetryEnabled = null;
    private final Duration httpNetworkRequestTimeout = DEFAULT_NETWORK_REQUEST_TIMEOUT;
    private final int maxConnectionPoolSize;
    private final Duration idleHttpConnectionTimeout = DEFAULT_IDLE_CONNECTION_TIMEOUT;
    private final ProxyOptions proxy = this.getProxyOptions();
    private String clientCorrelationId = null;
    private EnumSet<TagName> metricTagNamesOverride = null;
    private boolean isClientMetricsEnabled = false;
    private Boolean effectiveIsClientTelemetryEnabled = null;
    private CosmosMicrometerMetricsOptions micrometerMetricsOptions = null;

    public CosmosClientTelemetryConfig() {
        this.maxConnectionPoolSize = 1000;
    }

    public CosmosClientTelemetryConfig sendClientTelemetryToService(boolean enabled) {
        this.clientTelemetryEnabled = enabled;
        return this;
    }

    Boolean isSendClientTelemetryToServiceEnabled() {
        Boolean effectiveSnapshot = this.effectiveIsClientTelemetryEnabled;
        Boolean currentSnapshot = this.clientTelemetryEnabled;
        return effectiveSnapshot != null ? effectiveSnapshot : currentSnapshot;
    }

    void resetIsSendClientTelemetryToServiceEnabled() {
        this.clientTelemetryEnabled = null;
    }

    public CosmosClientTelemetryConfig metricsOptions(MetricsOptions clientMetricsOptions) {
        Preconditions.checkNotNull(clientMetricsOptions, "expected non-null clientMetricsOptions");
        if (!(clientMetricsOptions instanceof CosmosMicrometerMetricsOptions)) {
            throw new IllegalArgumentException("Currently only MetricsOptions of type CosmosMicrometerMetricsOptions are supported");
        }
        CosmosMicrometerMetricsOptions candidate = (CosmosMicrometerMetricsOptions)clientMetricsOptions;
        if (this.metricTagNamesOverride != null && !this.metricTagNamesOverride.equals(candidate.getDefaultTagNames())) {
            if (TagName.DEFAULT_TAGS.equals(candidate.getDefaultTagNames())) {
                candidate.configureDefaultTagNames(this.metricTagNamesOverride);
            } else {
                throw new IllegalArgumentException("Tags for meters cannot be specified via the deprecated CosmosClientTelemetryConfig when they are also specified in CosmosMicrometerMetricOptions.");
            }
        }
        this.micrometerMetricsOptions = candidate;
        this.isClientMetricsEnabled = this.micrometerMetricsOptions.isEnabled();
        return this;
    }

    MeterRegistry getClientMetricRegistry() {
        if (this.micrometerMetricsOptions == null) {
            return null;
        }
        return this.micrometerMetricsOptions.getClientMetricRegistry();
    }

    public CosmosClientTelemetryConfig clientCorrelationId(String clientCorrelationId) {
        this.clientCorrelationId = clientCorrelationId;
        return this;
    }

    String getClientCorrelationId() {
        return this.clientCorrelationId;
    }

    @Deprecated
    public CosmosClientTelemetryConfig metricTagNames(String ... tagNames) {
        if (tagNames == null || tagNames.length == 0) {
            this.metricTagNamesOverride = TagName.DEFAULT_TAGS.clone();
        }
        HashMap<String, TagName> tagNameMap = new HashMap<String, TagName>();
        for (TagName tagName2 : TagName.values()) {
            tagNameMap.put(tagName2.toLowerCase(), tagName2);
        }
        Stream<TagName> tagNameStream = Arrays.stream(tagNames).filter(tagName -> !Strings.isNullOrWhiteSpace(tagName)).map(rawTagName -> rawTagName.toLowerCase(Locale.ROOT)).map(tagName -> {
            String trimmedTagName = tagName.trim();
            if (!tagNameMap.containsKey(trimmedTagName)) {
                String validTagNames = String.join((CharSequence)", ", (String[])Arrays.stream(TagName.values()).map(tag -> tag.toString()).toArray());
                throw new IllegalArgumentException(String.format("TagName '%s' is invalid. Valid tag names are: %s", tagName, validTagNames));
            }
            return (TagName)((Object)((Object)tagNameMap.get(trimmedTagName)));
        });
        EnumSet<TagName> newTagNames = EnumSet.noneOf(TagName.class);
        tagNameStream.forEach(tagName -> newTagNames.add((TagName)((Object)tagName)));
        this.metricTagNamesOverride = newTagNames;
        return this;
    }

    private CosmosClientTelemetryConfig setEffectiveIsClientTelemetryEnabled(boolean effectiveIsClientTelemetryEnabled) {
        this.effectiveIsClientTelemetryEnabled = effectiveIsClientTelemetryEnabled;
        return this;
    }

    Duration getHttpNetworkRequestTimeout() {
        return this.httpNetworkRequestTimeout;
    }

    int getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    Duration getIdleHttpConnectionTimeout() {
        return this.idleHttpConnectionTimeout;
    }

    ProxyOptions getProxy() {
        return this.proxy;
    }

    private ProxyOptions getProxyOptions() {
        String config = Configs.getClientTelemetryProxyOptionsConfig();
        if (StringUtils.isNotEmpty(config)) {
            try {
                JsonProxyOptionsConfig proxyOptionsConfig = (JsonProxyOptionsConfig)Utils.getSimpleObjectMapper().readValue(config, JsonProxyOptionsConfig.class);
                ProxyOptions.Type type = ProxyOptions.Type.valueOf((String)proxyOptionsConfig.type);
                if (type != ProxyOptions.Type.HTTP) {
                    throw new IllegalArgumentException("Only http proxy type is supported.");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Enable proxy with type {}, host {}, port {}, userName {}, password length {}", new Object[]{type, proxyOptionsConfig.host, proxyOptionsConfig.port, proxyOptionsConfig.username, proxyOptionsConfig.password != null ? proxyOptionsConfig.password.length() : -1});
                }
                ProxyOptions proxyOptions = new ProxyOptions(type, new InetSocketAddress(proxyOptionsConfig.host, proxyOptionsConfig.port));
                if (!Strings.isNullOrEmpty(proxyOptionsConfig.username) || !Strings.isNullOrEmpty(proxyOptionsConfig.password)) {
                    proxyOptions.setCredentials(proxyOptionsConfig.username != null ? proxyOptionsConfig.username : "", proxyOptionsConfig.password != null ? proxyOptionsConfig.password : "");
                }
                return proxyOptions;
            }
            catch (JsonProcessingException e) {
                logger.error("Failed to parse client telemetry proxy option config", (Throwable)e);
            }
        }
        return null;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosClientTelemetryConfigHelper.setCosmosClientTelemetryConfigAccessor(new ImplementationBridgeHelpers.CosmosClientTelemetryConfigHelper.CosmosClientTelemetryConfigAccessor(){

            @Override
            public Duration getHttpNetworkRequestTimeout(CosmosClientTelemetryConfig config) {
                return config.getHttpNetworkRequestTimeout();
            }

            @Override
            public int getMaxConnectionPoolSize(CosmosClientTelemetryConfig config) {
                return config.getMaxConnectionPoolSize();
            }

            @Override
            public Duration getIdleHttpConnectionTimeout(CosmosClientTelemetryConfig config) {
                return config.getIdleHttpConnectionTimeout();
            }

            @Override
            public ProxyOptions getProxy(CosmosClientTelemetryConfig config) {
                return config.getProxy();
            }

            @Override
            public EnumSet<MetricCategory> getMetricCategories(CosmosClientTelemetryConfig config) {
                return config.micrometerMetricsOptions.getMetricCategories();
            }

            @Override
            public EnumSet<TagName> getMetricTagNames(CosmosClientTelemetryConfig config) {
                return config.micrometerMetricsOptions.getDefaultTagNames();
            }

            @Override
            public CosmosMeterOptions getMeterOptions(CosmosClientTelemetryConfig config, CosmosMetricName name) {
                if (config != null && config.micrometerMetricsOptions != null) {
                    return config.micrometerMetricsOptions.getMeterOptions(name);
                }
                return this.createDisabledMeterOptions(name);
            }

            @Override
            public CosmosMeterOptions createDisabledMeterOptions(CosmosMetricName name) {
                return new CosmosMeterOptions(name, false, new double[0], false, EnumSet.noneOf(TagName.class));
            }

            @Override
            public String getClientCorrelationId(CosmosClientTelemetryConfig config) {
                return config.getClientCorrelationId();
            }

            @Override
            public MeterRegistry getClientMetricRegistry(CosmosClientTelemetryConfig config) {
                return config.getClientMetricRegistry();
            }

            @Override
            public Boolean isSendClientTelemetryToServiceEnabled(CosmosClientTelemetryConfig config) {
                return config.isSendClientTelemetryToServiceEnabled();
            }

            @Override
            public boolean isClientMetricsEnabled(CosmosClientTelemetryConfig config) {
                return config.isClientMetricsEnabled;
            }

            @Override
            public CosmosClientTelemetryConfig createSnapshot(CosmosClientTelemetryConfig config, boolean effectiveIsClientTelemetryEnabled) {
                return config.setEffectiveIsClientTelemetryEnabled(effectiveIsClientTelemetryEnabled);
            }

            @Override
            public void resetIsSendClientTelemetryToServiceEnabled(CosmosClientTelemetryConfig config) {
                config.resetIsSendClientTelemetryToServiceEnabled();
            }
        });
    }

    static {
        CosmosClientTelemetryConfig.initialize();
    }

    private static class JsonProxyOptionsConfig {
        @JsonProperty
        private String host;
        @JsonProperty
        private int port;
        @JsonProperty
        private String type;
        @JsonProperty
        private String username;
        @JsonProperty
        private String password;

        private JsonProxyOptionsConfig() {
        }

        private JsonProxyOptionsConfig(String host, int port, String type, String username, String password) {
            this.host = host;
            this.port = port;
            this.type = type;
            this.username = username;
            this.password = password;
        }
    }
}

