/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.util.Context;
import com.azure.cosmos.CosmosDiagnosticsContext;
import com.azure.cosmos.CosmosDiagnosticsHandler;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CosmosDiagnosticsLogger
implements CosmosDiagnosticsHandler {
    private static final Logger logger = LoggerFactory.getLogger(CosmosDiagnosticsLogger.class);

    @Override
    public final void handleDiagnostics(CosmosDiagnosticsContext diagnosticsContext, Context traceContext) {
        Preconditions.checkNotNull(diagnosticsContext, "Argument 'diagnosticsContext' must not be null.");
        if (this.shouldLog(diagnosticsContext)) {
            this.log(diagnosticsContext);
        }
    }

    protected boolean shouldLog(CosmosDiagnosticsContext diagnosticsContext) {
        if (!diagnosticsContext.isCompleted()) {
            return false;
        }
        return diagnosticsContext.isFailure() || diagnosticsContext.isThresholdViolated() || logger.isDebugEnabled();
    }

    protected void log(CosmosDiagnosticsContext ctx) {
        if (ctx.isFailure()) {
            if (logger.isErrorEnabled()) {
                logger.error("Account: {} -> DB: {}, Col:{}, StatusCode: {}:{} Diagnostics: {}", new Object[]{ctx.getAccountName(), ctx.getDatabaseName(), ctx.getContainerName(), ctx.getStatusCode(), ctx.getSubStatusCode(), ctx});
            }
        } else if (ctx.isThresholdViolated()) {
            if (logger.isInfoEnabled()) {
                logger.info("Account: {} -> DB: {}, Col:{}, StatusCode: {}:{} Diagnostics: {}", new Object[]{ctx.getAccountName(), ctx.getDatabaseName(), ctx.getContainerName(), ctx.getStatusCode(), ctx.getSubStatusCode(), ctx});
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace("Account: {} -> DB: {}, Col:{}, StatusCode: {}:{} Diagnostics: {}", new Object[]{ctx.getAccountName(), ctx.getDatabaseName(), ctx.getContainerName(), ctx.getStatusCode(), ctx.getSubStatusCode(), ctx});
        } else if (logger.isDebugEnabled()) {
            logger.debug("Account: {} -> DB: {}, Col:{}, StatusCode: {}:{}, Latency: {}, Request charge: {}", new Object[]{ctx.getAccountName(), ctx.getDatabaseName(), ctx.getContainerName(), ctx.getStatusCode(), ctx.getSubStatusCode(), ctx.getDuration(), Float.valueOf(ctx.getTotalRequestCharge())});
        }
    }
}

