/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdChannelAcquisitionTimeline;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdChannelStatistics;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpointStatistics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreResponse {
    static final Logger LOGGER = LoggerFactory.getLogger(StoreResponse.class);
    private final int status;
    private final String[] responseHeaderNames;
    private final String[] responseHeaderValues;
    private final byte[] content;
    private int requestPayloadLength;
    private int responsePayloadLength;
    private RequestTimeline requestTimeline = RequestTimeline.empty();
    private RntbdChannelAcquisitionTimeline channelAcquisitionTimeline;
    private RntbdEndpointStatistics rntbdEndpointStatistics;
    private RntbdChannelStatistics channelStatistics;
    private int rntbdRequestLength;
    private int rntbdResponseLength;
    private final List<String> replicaStatusList;
    private String faultInjectionRuleId;

    public StoreResponse(int status, Map<String, String> headerMap, byte[] content) {
        this.responseHeaderNames = new String[headerMap.size()];
        this.responseHeaderValues = new String[headerMap.size()];
        int i = 0;
        for (Map.Entry<String, String> headerEntry : headerMap.entrySet()) {
            this.responseHeaderNames[i] = headerEntry.getKey();
            this.responseHeaderValues[i] = headerEntry.getValue();
            ++i;
        }
        this.status = status;
        this.content = content;
        if (this.content != null) {
            this.responsePayloadLength = this.content.length;
        }
        this.replicaStatusList = new ArrayList<String>();
    }

    public int getStatus() {
        return this.status;
    }

    public String[] getResponseHeaderNames() {
        return this.responseHeaderNames;
    }

    public String[] getResponseHeaderValues() {
        return this.responseHeaderValues;
    }

    public void setRntbdRequestLength(int rntbdRequestLength) {
        this.rntbdRequestLength = rntbdRequestLength;
    }

    public void setRntbdResponseLength(int rntbdResponseLength) {
        this.rntbdResponseLength = rntbdResponseLength;
    }

    public int getRntbdRequestLength() {
        return this.rntbdRequestLength;
    }

    public int getRntbdResponseLength() {
        return this.rntbdResponseLength;
    }

    public int getRequestPayloadLength() {
        return this.requestPayloadLength;
    }

    public void setRequestPayloadLength(int requestPayloadLength) {
        this.requestPayloadLength = requestPayloadLength;
    }

    public byte[] getResponseBody() {
        return this.content;
    }

    public int getResponseBodyLength() {
        return this.responsePayloadLength;
    }

    public long getLSN() {
        String lsnString = this.getHeaderValue("lsn");
        if (StringUtils.isNotEmpty(lsnString)) {
            return Long.parseLong(lsnString);
        }
        return -1L;
    }

    public String getPartitionKeyRangeId() {
        return this.getHeaderValue("x-ms-documentdb-partitionkeyrangeid");
    }

    public String getActivityId() {
        return this.getHeaderValue("x-ms-activity-id");
    }

    public String getCorrelatedActivityId() {
        return this.getHeaderValue("x-ms-cosmos-correlated-activityid");
    }

    public String getHeaderValue(String attribute) {
        if (this.responseHeaderValues == null || this.responseHeaderNames.length != this.responseHeaderValues.length) {
            return null;
        }
        for (int i = 0; i < this.responseHeaderNames.length; ++i) {
            if (!this.responseHeaderNames[i].equalsIgnoreCase(attribute)) continue;
            return this.responseHeaderValues[i];
        }
        return null;
    }

    public double getRequestCharge() {
        String value = this.getHeaderValue("x-ms-request-charge");
        if (StringUtils.isEmpty(value)) {
            return 0.0;
        }
        return Double.parseDouble(value);
    }

    public String getSessionTokenString() {
        return this.getHeaderValue("x-ms-session-token");
    }

    public void setRequestTimeline(RequestTimeline requestTimeline) {
        this.requestTimeline = requestTimeline;
    }

    RequestTimeline getRequestTimeline() {
        return this.requestTimeline;
    }

    public void setChannelAcquisitionTimeline(RntbdChannelAcquisitionTimeline channelAcquisitionTimeline) {
        this.channelAcquisitionTimeline = channelAcquisitionTimeline;
    }

    RntbdChannelAcquisitionTimeline getChannelAcquisitionTimeline() {
        return this.channelAcquisitionTimeline;
    }

    public void setEndpointStatistics(RntbdEndpointStatistics rntbdEndpointStatistics) {
        this.rntbdEndpointStatistics = rntbdEndpointStatistics;
    }

    RntbdEndpointStatistics getEndpointStatistics() {
        return this.rntbdEndpointStatistics;
    }

    public void setChannelStatistics(RntbdChannelStatistics channelStatistics) {
        this.channelStatistics = channelStatistics;
    }

    public RntbdChannelStatistics getChannelStatistics() {
        return this.channelStatistics;
    }

    int getSubStatusCode() {
        int subStatusCode = 0;
        String subStatusCodeString = this.getHeaderValue("x-ms-substatus");
        if (StringUtils.isNotEmpty(subStatusCodeString)) {
            try {
                subStatusCode = Integer.parseInt(subStatusCodeString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return subStatusCode;
    }

    public List<String> getReplicaStatusList() {
        return this.replicaStatusList;
    }

    public String getFaultInjectionRuleId() {
        return this.faultInjectionRuleId;
    }

    public void setFaultInjectionRuleId(String faultInjectionRuleId) {
        this.faultInjectionRuleId = faultInjectionRuleId;
    }

    public StoreResponse withRemappedStatusCode(int newStatusCode, double additionalRequestCharge) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (int i = 0; i < this.responseHeaderNames.length; ++i) {
            String headerName = this.responseHeaderNames[i];
            if (headerName.equalsIgnoreCase("x-ms-request-charge")) {
                double currentRequestCharge = this.getRequestCharge();
                double newRequestCharge = currentRequestCharge + additionalRequestCharge;
                headers.put(headerName, String.valueOf(newRequestCharge));
                continue;
            }
            headers.put(headerName, this.responseHeaderValues[i]);
        }
        return new StoreResponse(newStatusCode, headers, this.content);
    }
}

