/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncPermission;
import com.azure.cosmos.CosmosDiagnosticsThresholds;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.Permission;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.models.CosmosPermissionProperties;
import com.azure.cosmos.models.CosmosPermissionRequestOptions;
import com.azure.cosmos.models.CosmosPermissionResponse;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.CosmosUserProperties;
import com.azure.cosmos.models.CosmosUserResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.UtilBridgeInternal;
import reactor.core.publisher.Mono;

public class CosmosAsyncUser {
    private static final ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.CosmosQueryRequestOptionsAccessor queryOptionsAccessor = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor();
    private static final ImplementationBridgeHelpers.FeedResponseHelper.FeedResponseAccessor feedResponseAccessor = ImplementationBridgeHelpers.FeedResponseHelper.getFeedResponseAccessor();
    private final CosmosAsyncDatabase database;
    private String id;

    CosmosAsyncUser(String id, CosmosAsyncDatabase database) {
        this.id = id;
        this.database = database;
    }

    public String getId() {
        return this.id;
    }

    CosmosAsyncUser setId(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosUserResponse> read() {
        return FluxUtil.withContext(this::readInternal);
    }

    public Mono<CosmosUserResponse> replace(CosmosUserProperties userProperties) {
        return FluxUtil.withContext(context -> this.replaceInternal(userProperties, (Context)context));
    }

    public Mono<CosmosUserResponse> delete() {
        return FluxUtil.withContext(this::deleteInternal);
    }

    public Mono<CosmosPermissionResponse> createPermission(CosmosPermissionProperties permissionProperties, CosmosPermissionRequestOptions options) {
        CosmosPermissionRequestOptions requestOptions = options == null ? new CosmosPermissionRequestOptions() : options;
        Permission permission = ModelBridgeInternal.getPermission(permissionProperties, this.database.getId());
        return FluxUtil.withContext(context -> this.createPermissionInternal(permission, requestOptions, (Context)context));
    }

    public Mono<CosmosPermissionResponse> upsertPermission(CosmosPermissionProperties permissionProperties, CosmosPermissionRequestOptions options) {
        Permission permission = ModelBridgeInternal.getPermission(permissionProperties, this.database.getId());
        CosmosPermissionRequestOptions requestOptions = options == null ? new CosmosPermissionRequestOptions() : options;
        return FluxUtil.withContext(context -> this.upsertPermissionInternal(permission, requestOptions, (Context)context));
    }

    public CosmosPagedFlux<CosmosPermissionProperties> readAllPermissions() {
        return this.readAllPermissions(new CosmosQueryRequestOptions());
    }

    CosmosPagedFlux<CosmosPermissionProperties> readAllPermissions(CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            String spanName = "readAllPermissions." + this.getId();
            CosmosAsyncClient client = this.getDatabase().getClient();
            CosmosQueryRequestOptions nonNullOptions = options != null ? options : new CosmosQueryRequestOptions();
            String operationId = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().getQueryNameOrDefault(nonNullOptions, spanName);
            pagedFluxOptions.setTracerInformation(spanName, this.getDatabase().getId(), null, operationId, OperationType.ReadFeed, ResourceType.Permission, client, nonNullOptions.getConsistencyLevel(), client.getEffectiveDiagnosticsThresholds(queryOptionsAccessor.getDiagnosticsThresholds(nonNullOptions)));
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.getDatabase().getDocClientWrapper().readPermissions(this.getLink(), options).map(response -> feedResponseAccessor.createFeedResponse(ModelBridgeInternal.getCosmosPermissionPropertiesFromResults(response.getResults()), response.getResponseHeaders(), response.getCosmosDiagnostics()));
        });
    }

    public CosmosPagedFlux<CosmosPermissionProperties> queryPermissions(String query) {
        return this.queryPermissions(query, new CosmosQueryRequestOptions());
    }

    public CosmosPagedFlux<CosmosPermissionProperties> queryPermissions(String query, CosmosQueryRequestOptions options) {
        CosmosQueryRequestOptions requestOptions = options == null ? new CosmosQueryRequestOptions() : options;
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            String spanName = "queryPermissions." + this.getId();
            CosmosAsyncClient client = this.getDatabase().getClient();
            String operationId = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().getQueryNameOrDefault(requestOptions, spanName);
            pagedFluxOptions.setTracerInformation(spanName, this.getDatabase().getId(), null, operationId, OperationType.Query, ResourceType.Permission, client, requestOptions.getConsistencyLevel(), client.getEffectiveDiagnosticsThresholds(queryOptionsAccessor.getDiagnosticsThresholds(requestOptions)));
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, requestOptions);
            return this.getDatabase().getDocClientWrapper().queryPermissions(this.getLink(), query, requestOptions).map(response -> feedResponseAccessor.createFeedResponse(ModelBridgeInternal.getCosmosPermissionPropertiesFromResults(response.getResults()), response.getResponseHeaders(), response.getCosmosDiagnostics()));
        });
    }

    public CosmosAsyncPermission getPermission(String id) {
        return new CosmosAsyncPermission(id, this);
    }

    String getURIPathSegment() {
        return "users";
    }

    String getParentLink() {
        return this.database.getLink();
    }

    String getLink() {
        return this.getParentLink() + "/" + this.getURIPathSegment() + "/" + this.getId();
    }

    CosmosAsyncDatabase getDatabase() {
        return this.database;
    }

    private Mono<CosmosUserResponse> readInternal(Context context) {
        String spanName = "readUser." + this.getId();
        Mono responseMono = this.database.getDocClientWrapper().readUser(this.getLink(), null).map(ModelBridgeInternal::createCosmosUserResponse).single();
        CosmosAsyncClient client = this.database.getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.database.getId(), null, client, null, OperationType.Read, ResourceType.User, client.getEffectiveDiagnosticsThresholds(null));
    }

    private Mono<CosmosUserResponse> replaceInternal(CosmosUserProperties userSettings, Context context) {
        String spanName = "replaceUser." + this.getId();
        Mono responseMono = this.database.getDocClientWrapper().replaceUser(ModelBridgeInternal.getV2User(userSettings), null).map(ModelBridgeInternal::createCosmosUserResponse).single();
        CosmosAsyncClient client = this.database.getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.database.getId(), null, client, null, OperationType.Replace, ResourceType.User, client.getEffectiveDiagnosticsThresholds(null));
    }

    private Mono<CosmosUserResponse> deleteInternal(Context context) {
        String spanName = "deleteUser." + this.getId();
        Mono responseMono = this.database.getDocClientWrapper().deleteUser(this.getLink(), null).map(ModelBridgeInternal::createCosmosUserResponse).single();
        CosmosAsyncClient client = this.database.getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.database.getId(), null, client, null, OperationType.Delete, ResourceType.User, client.getEffectiveDiagnosticsThresholds(null));
    }

    private Mono<CosmosPermissionResponse> createPermissionInternal(Permission permission, CosmosPermissionRequestOptions options, Context context) {
        String spanName = "createPermission." + this.getId();
        Mono responseMono = this.database.getDocClientWrapper().createPermission(this.getLink(), permission, ModelBridgeInternal.toRequestOptions(options)).map(ModelBridgeInternal::createCosmosPermissionResponse).single();
        CosmosAsyncClient client = this.database.getClient();
        CosmosDiagnosticsThresholds requestDiagnosticThresholds = ModelBridgeInternal.toRequestOptions(options).getDiagnosticsThresholds();
        return client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.database.getId(), null, client, null, OperationType.Create, ResourceType.Permission, client.getEffectiveDiagnosticsThresholds(requestDiagnosticThresholds));
    }

    private Mono<CosmosPermissionResponse> upsertPermissionInternal(Permission permission, CosmosPermissionRequestOptions options, Context context) {
        String spanName = "upsertPermission." + this.getId();
        Mono responseMono = this.database.getDocClientWrapper().upsertPermission(this.getLink(), permission, ModelBridgeInternal.toRequestOptions(options)).map(ModelBridgeInternal::createCosmosPermissionResponse).single();
        CosmosAsyncClient client = this.database.getClient();
        CosmosDiagnosticsThresholds requestDiagnosticThresholds = ModelBridgeInternal.toRequestOptions(options).getDiagnosticsThresholds();
        return client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.database.getId(), null, client, null, OperationType.Upsert, ResourceType.Permission, client.getEffectiveDiagnosticsThresholds(requestDiagnosticThresholds));
    }
}

