/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosContainerProactiveInitConfig;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosContainerIdentity;
import java.util.List;

public final class CosmosContainerProactiveInitConfigBuilder {
    private static final int MAX_NO_OF_PROACTIVE_CONNECTION_REGIONS = 5;
    private final List<CosmosContainerIdentity> cosmosContainerIdentities;
    private int numProactiveConnectionRegions;

    public CosmosContainerProactiveInitConfigBuilder(List<CosmosContainerIdentity> cosmosContainerIdentities) {
        Preconditions.checkArgument(cosmosContainerIdentities != null && !cosmosContainerIdentities.isEmpty(), "The list of container identities cannot be null or empty.");
        this.cosmosContainerIdentities = cosmosContainerIdentities;
        this.numProactiveConnectionRegions = 1;
    }

    public CosmosContainerProactiveInitConfigBuilder setProactiveConnectionRegionsCount(int numProactiveConnectionRegions) {
        Preconditions.checkArgument(numProactiveConnectionRegions > 0 && numProactiveConnectionRegions <= 5, "The no. of regions to proactively connect to cannot be less than 1 or more than {}.", 5);
        this.numProactiveConnectionRegions = numProactiveConnectionRegions;
        return this;
    }

    public CosmosContainerProactiveInitConfig build() {
        Preconditions.checkArgument(this.numProactiveConnectionRegions >= 0 && this.numProactiveConnectionRegions <= 5, "The no. of regions to proactively connect to cannot be less than 0 or more than {}.", 5);
        return new CosmosContainerProactiveInitConfig(this.cosmosContainerIdentities, this.numProactiveConnectionRegions);
    }
}

