/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosDiagnosticsContext;
import com.azure.cosmos.implementation.ClientSideRequestStatistics;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.FeedResponseDiagnostics;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.guava25.collect.ImmutableList;
import com.azure.cosmos.util.Beta;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CosmosDiagnostics {
    private static final Logger LOGGER = LoggerFactory.getLogger(CosmosDiagnostics.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String COSMOS_DIAGNOSTICS_KEY = "cosmosDiagnostics";
    private ClientSideRequestStatistics clientSideRequestStatistics;
    private FeedResponseDiagnostics feedResponseDiagnostics;
    private CosmosDiagnosticsContext diagnosticsContext;
    private final AtomicBoolean diagnosticsCapturedInPagedFlux;
    static final String USER_AGENT = Utils.getUserAgent();
    static final String USER_AGENT_KEY = "userAgent";

    CosmosDiagnostics(DiagnosticsClientContext diagnosticsClientContext) {
        this.diagnosticsCapturedInPagedFlux = new AtomicBoolean(false);
        this.clientSideRequestStatistics = new ClientSideRequestStatistics(diagnosticsClientContext);
    }

    CosmosDiagnostics(FeedResponseDiagnostics feedResponseDiagnostics) {
        this.diagnosticsCapturedInPagedFlux = new AtomicBoolean(false);
        this.feedResponseDiagnostics = feedResponseDiagnostics;
    }

    CosmosDiagnostics(CosmosDiagnostics toBeCloned) {
        if (toBeCloned.feedResponseDiagnostics != null) {
            this.feedResponseDiagnostics = new FeedResponseDiagnostics(toBeCloned.feedResponseDiagnostics);
        }
        if (toBeCloned.clientSideRequestStatistics != null) {
            this.clientSideRequestStatistics = new ClientSideRequestStatistics(toBeCloned.clientSideRequestStatistics);
        }
        this.diagnosticsCapturedInPagedFlux = new AtomicBoolean(toBeCloned.diagnosticsCapturedInPagedFlux.get());
    }

    ClientSideRequestStatistics clientSideRequestStatistics() {
        return this.clientSideRequestStatistics;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.fillCosmosDiagnostics(null, stringBuilder);
        return stringBuilder.toString();
    }

    public CosmosDiagnosticsContext getDiagnosticsContext() {
        return this.diagnosticsContext;
    }

    void setDiagnosticsContext(CosmosDiagnosticsContext ctx) {
        Preconditions.checkNotNull("ctx", "Argument 'ctx' must not be null.");
        this.diagnosticsContext = ctx;
    }

    public Duration getDuration() {
        if (this.feedResponseDiagnostics != null) {
            Collection<ClientSideRequestStatistics> statistics = this.feedResponseDiagnostics.getClientSideRequestStatistics();
            if (statistics == null) {
                return Duration.ZERO;
            }
            Instant min = Instant.MAX;
            Instant max = Instant.MIN;
            for (ClientSideRequestStatistics s : statistics) {
                if (s.getRequestStartTimeUTC() != null && s.getRequestStartTimeUTC().isBefore(min)) {
                    min = s.getRequestStartTimeUTC();
                }
                if (s.getRequestEndTimeUTC() == null || !s.getRequestEndTimeUTC().isAfter(max)) continue;
                max = s.getRequestEndTimeUTC();
            }
            if (max.isBefore(min)) {
                return null;
            }
            if (min == max) {
                return Duration.ZERO;
            }
            return Duration.between(min, max);
        }
        return this.clientSideRequestStatistics.getDuration();
    }

    @Deprecated
    @Beta(value=Beta.SinceVersion.V4_9_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Set<URI> getRegionsContacted() {
        if (this.feedResponseDiagnostics != null) {
            return null;
        }
        return this.clientSideRequestStatistics.getLocationEndpointsContacted();
    }

    public Set<String> getContactedRegionNames() {
        if (this.feedResponseDiagnostics != null) {
            Collection<ClientSideRequestStatistics> clientStatisticCollection;
            Set<String> temp;
            Set<String> aggregatedRegionsContacted = Collections.synchronizedSet(new HashSet());
            if (this.clientSideRequestStatistics != null && (temp = this.clientSideRequestStatistics.getContactedRegionNames()) != null && temp.size() > 0) {
                aggregatedRegionsContacted.addAll(temp);
            }
            if ((clientStatisticCollection = this.feedResponseDiagnostics.getClientSideRequestStatistics()) != null) {
                for (ClientSideRequestStatistics clientStatistics : clientStatisticCollection) {
                    Set<String> temp2 = clientStatistics.getContactedRegionNames();
                    if (temp2 == null || temp2.size() <= 0) continue;
                    aggregatedRegionsContacted.addAll(temp2);
                }
            }
            return aggregatedRegionsContacted;
        }
        return this.clientSideRequestStatistics.getContactedRegionNames();
    }

    FeedResponseDiagnostics getFeedResponseDiagnostics() {
        return this.feedResponseDiagnostics;
    }

    int getRequestPayloadSizeInBytes() {
        if (this.feedResponseDiagnostics != null) {
            return 0;
        }
        return this.clientSideRequestStatistics.getRequestPayloadSizeInBytes();
    }

    int getTotalResponsePayloadSizeInBytes() {
        if (this.feedResponseDiagnostics != null) {
            int totalResponsePayloadSizeInBytes = 0;
            Collection<ClientSideRequestStatistics> clientStatisticCollection = this.feedResponseDiagnostics.getClientSideRequestStatistics();
            if (clientStatisticCollection != null) {
                for (ClientSideRequestStatistics clientStatistics : clientStatisticCollection) {
                    totalResponsePayloadSizeInBytes += clientStatistics.getMaxResponsePayloadSizeInBytes();
                }
            }
            return totalResponsePayloadSizeInBytes;
        }
        return this.clientSideRequestStatistics.getMaxResponsePayloadSizeInBytes();
    }

    ClientSideRequestStatistics getClientSideRequestStatisticsRaw() {
        return this.clientSideRequestStatistics;
    }

    Collection<ClientSideRequestStatistics> getClientSideRequestStatistics() {
        if (this.feedResponseDiagnostics != null) {
            return this.feedResponseDiagnostics.getClientSideRequestStatistics();
        }
        return ImmutableList.of(this.clientSideRequestStatistics);
    }

    Collection<ClientSideRequestStatistics> getClientSideRequestStatisticsForQueryPipelineAggregations() {
        ArrayList<ClientSideRequestStatistics> combinedStatistics = new ArrayList<ClientSideRequestStatistics>();
        combinedStatistics.addAll(this.feedResponseDiagnostics.getClientSideRequestStatistics());
        if (this.clientSideRequestStatistics != null) {
            combinedStatistics.add(this.clientSideRequestStatistics);
        }
        return combinedStatistics;
    }

    void fillCosmosDiagnostics(ObjectNode parentNode, StringBuilder stringBuilder) {
        if (this.feedResponseDiagnostics != null) {
            if (parentNode != null) {
                parentNode.put(USER_AGENT_KEY, USER_AGENT);
                parentNode.putPOJO(COSMOS_DIAGNOSTICS_KEY, (Object)this.feedResponseDiagnostics);
            }
            if (stringBuilder != null) {
                stringBuilder.append("userAgent=").append(USER_AGENT).append(System.lineSeparator());
                stringBuilder.append(this.feedResponseDiagnostics);
            }
        } else {
            if (parentNode != null) {
                parentNode.putPOJO(COSMOS_DIAGNOSTICS_KEY, (Object)this.clientSideRequestStatistics);
            }
            if (stringBuilder != null) {
                try {
                    stringBuilder.append(OBJECT_MAPPER.writeValueAsString((Object)this.clientSideRequestStatistics));
                }
                catch (JsonProcessingException e) {
                    LOGGER.error("Error while parsing diagnostics ", (Throwable)e);
                }
            }
        }
    }

    void setFeedResponseDiagnostics(FeedResponseDiagnostics feedResponseDiagnostics) {
        this.feedResponseDiagnostics = feedResponseDiagnostics;
    }

    private AtomicBoolean isDiagnosticsCapturedInPagedFlux() {
        return this.diagnosticsCapturedInPagedFlux;
    }

    void addClientSideDiagnosticsToFeed(Collection<ClientSideRequestStatistics> requestStatistics) {
        if (this.feedResponseDiagnostics == null || requestStatistics == null || requestStatistics.isEmpty()) {
            return;
        }
        this.feedResponseDiagnostics.addClientSideRequestStatistics(requestStatistics);
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosDiagnosticsHelper.setCosmosDiagnosticsAccessor(new ImplementationBridgeHelpers.CosmosDiagnosticsHelper.CosmosDiagnosticsAccessor(){

            @Override
            public FeedResponseDiagnostics getFeedResponseDiagnostics(CosmosDiagnostics cosmosDiagnostics) {
                if (cosmosDiagnostics == null) {
                    return null;
                }
                return cosmosDiagnostics.getFeedResponseDiagnostics();
            }

            @Override
            public AtomicBoolean isDiagnosticsCapturedInPagedFlux(CosmosDiagnostics cosmosDiagnostics) {
                if (cosmosDiagnostics == null) {
                    return null;
                }
                return cosmosDiagnostics.isDiagnosticsCapturedInPagedFlux();
            }

            @Override
            public Collection<ClientSideRequestStatistics> getClientSideRequestStatistics(CosmosDiagnostics cosmosDiagnostics) {
                if (cosmosDiagnostics == null) {
                    return null;
                }
                return cosmosDiagnostics.getClientSideRequestStatistics();
            }

            @Override
            public Collection<ClientSideRequestStatistics> getClientSideRequestStatisticsForQueryPipelineAggregations(CosmosDiagnostics cosmosDiagnostics) {
                if (cosmosDiagnostics == null) {
                    return new ArrayList<ClientSideRequestStatistics>();
                }
                return cosmosDiagnostics.getClientSideRequestStatisticsForQueryPipelineAggregations();
            }

            @Override
            public ClientSideRequestStatistics getClientSideRequestStatisticsRaw(CosmosDiagnostics cosmosDiagnostics) {
                if (cosmosDiagnostics == null) {
                    return null;
                }
                return cosmosDiagnostics.getClientSideRequestStatisticsRaw();
            }

            @Override
            public int getTotalResponsePayloadSizeInBytes(CosmosDiagnostics cosmosDiagnostics) {
                if (cosmosDiagnostics == null) {
                    return 0;
                }
                return cosmosDiagnostics.getTotalResponsePayloadSizeInBytes();
            }

            @Override
            public int getRequestPayloadSizeInBytes(CosmosDiagnostics cosmosDiagnostics) {
                if (cosmosDiagnostics == null) {
                    return 0;
                }
                return cosmosDiagnostics.getRequestPayloadSizeInBytes();
            }

            @Override
            public void addClientSideDiagnosticsToFeed(CosmosDiagnostics cosmosDiagnostics, Collection<ClientSideRequestStatistics> requestStatistics) {
                if (cosmosDiagnostics == null) {
                    return;
                }
                cosmosDiagnostics.addClientSideDiagnosticsToFeed(requestStatistics);
            }
        });
    }

    static {
        CosmosDiagnostics.initialize();
    }
}

