/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.caches;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.CosmosSchedulers;
import com.azure.cosmos.implementation.Exceptions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class AsyncCacheNonBlocking<TKey, TValue> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncCacheNonBlocking.class);
    private final ConcurrentHashMap<TKey, AsyncLazyWithRefresh<TValue>> values = new ConcurrentHashMap();

    private Boolean removeNotFoundFromCacheException(CosmosException e) {
        if (Exceptions.isNotFound(e)) {
            return true;
        }
        return false;
    }

    public Mono<TValue> getAsync(TKey key, Function<TValue, Mono<TValue>> singleValueInitFunc, Function<TValue, Boolean> forceRefresh) {
        AsyncLazyWithRefresh<TValue> initialLazyValue = this.values.get(key);
        if (initialLazyValue != null) {
            logger.debug("cache[{}] exists", key);
            return initialLazyValue.getValueAsync().flatMap(value -> {
                if (!((Boolean)forceRefresh.apply(value)).booleanValue()) {
                    return Mono.just((Object)value);
                }
                Mono refreshMono = initialLazyValue.getOrCreateBackgroundRefreshTaskAsync(singleValueInitFunc);
                return refreshMono.onErrorResume(exception -> {
                    if (exception instanceof CosmosException && this.removeNotFoundFromCacheException((CosmosException)((Object)((Object)((Object)exception)))).booleanValue() && initialLazyValue.shouldRemoveFromCache()) {
                        this.remove(key);
                    }
                    logger.debug("refresh cache [{}] resulted in error", key, exception);
                    return Mono.error((Throwable)exception);
                });
            }).onErrorResume(exception -> {
                if (initialLazyValue.shouldRemoveFromCache()) {
                    this.remove(key);
                }
                logger.debug("cache[{}] resulted in error", key, exception);
                return Mono.error((Throwable)exception);
            });
        }
        logger.debug("cache[{}] doesn't exist, computing new value", key);
        AsyncLazyWithRefresh<TValue> asyncLazyWithRefresh = new AsyncLazyWithRefresh<TValue>(singleValueInitFunc);
        AsyncLazyWithRefresh<TValue> preResult = this.values.putIfAbsent(key, asyncLazyWithRefresh);
        if (preResult == null) {
            preResult = asyncLazyWithRefresh;
        }
        AsyncLazyWithRefresh<TValue> result = preResult;
        return result.getValueAsync().onErrorResume(exception -> {
            if (result.shouldRemoveFromCache()) {
                this.remove(key);
            }
            logger.debug("cache[{}] resulted in error", key, exception);
            return Mono.error((Throwable)exception);
        });
    }

    public void refresh(TKey key, Function<TValue, Mono<TValue>> singleValueInitFunc) {
        Mono<TValue> backgroundRefreshTask;
        logger.debug("refreshing cache[{}]", key);
        AsyncLazyWithRefresh<TValue> initialLazyValue = this.values.get(key);
        if (initialLazyValue != null && (backgroundRefreshTask = initialLazyValue.refresh(singleValueInitFunc)) != null) {
            backgroundRefreshTask.subscribeOn(CosmosSchedulers.ASYNC_CACHE_BACKGROUND_REFRESH_BOUNDED_ELASTIC).onErrorResume(throwable -> {
                logger.debug("Background address refresh task failed for {}", key, throwable);
                return Mono.empty();
            }).subscribe();
        }
    }

    public void set(TKey key, TValue value) {
        logger.debug("set cache[{}]={}", key, value);
        AsyncLazyWithRefresh<TValue> updatedValue = new AsyncLazyWithRefresh<TValue>(value);
        this.values.put(key, updatedValue);
    }

    public void remove(TKey key) {
        this.values.remove(key);
    }

    private static class AsyncLazyWithRefresh<TValue> {
        private final AtomicBoolean removeFromCache = new AtomicBoolean(false);
        private final AtomicReference<Mono<TValue>> value = new AtomicReference();
        private final AtomicReference<Mono<TValue>> refreshInProgress;

        public AsyncLazyWithRefresh(TValue value) {
            this.value.set(Mono.just(value));
            this.refreshInProgress = new AtomicReference<Object>(null);
        }

        public AsyncLazyWithRefresh(Function<TValue, Mono<TValue>> taskFactory) {
            this.value.set(taskFactory.apply(null).cache());
            this.refreshInProgress = new AtomicReference<Object>(null);
        }

        public Mono<TValue> getValueAsync() {
            return this.value.get();
        }

        public Mono<TValue> value() {
            return this.value.get();
        }

        public Mono<TValue> getOrCreateBackgroundRefreshTaskAsync(Function<TValue, Mono<TValue>> createRefreshFunction) {
            Mono<TValue> refreshInProgressSnapshot = this.refreshInProgress.updateAndGet(existingMono -> {
                if (existingMono == null) {
                    logger.debug("Started a new background task");
                    return this.createBackgroundRefreshTask(createRefreshFunction);
                }
                logger.debug("Background refresh task is already in progress");
                return existingMono;
            });
            return refreshInProgressSnapshot == null ? this.value.get() : refreshInProgressSnapshot;
        }

        private Mono<TValue> createBackgroundRefreshTask(Function<TValue, Mono<TValue>> createRefreshFunction) {
            return this.value.get().flatMap(createRefreshFunction).flatMap(response -> {
                this.refreshInProgress.set(null);
                return this.value.updateAndGet(existingValue -> Mono.just((Object)response));
            }).doOnError(throwable -> {
                this.refreshInProgress.set(null);
                logger.debug("Background refresh task failed", throwable);
            }).cache();
        }

        public Mono<TValue> refresh(Function<TValue, Mono<TValue>> createRefreshFunction) {
            if (this.refreshInProgress.compareAndSet(null, this.createBackgroundRefreshTask(createRefreshFunction))) {
                logger.debug("Started a new background task");
                return this.refreshInProgress.get();
            }
            logger.debug("Background refresh task is already in progress, skip creating a new one");
            return null;
        }

        public boolean shouldRemoveFromCache() {
            return this.removeFromCache.compareAndSet(false, true);
        }
    }
}

