/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.CosmosContainerProactiveInitConfig;
import com.azure.cosmos.implementation.GoneException;
import com.azure.cosmos.implementation.OpenConnectionResponse;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.directconnectivity.AddressInformation;
import com.azure.cosmos.implementation.directconnectivity.IAddressResolver;
import com.azure.cosmos.implementation.directconnectivity.Protocol;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AddressSelector {
    private final IAddressResolver addressResolver;
    private final Protocol protocol;

    public AddressSelector(IAddressResolver addressResolver, Protocol protocol) {
        this.addressResolver = addressResolver;
        this.protocol = protocol;
    }

    public Mono<List<Uri>> resolveAllUriAsync(RxDocumentServiceRequest request, boolean includePrimary, boolean forceRefresh) {
        Mono<List<AddressInformation>> allReplicaAddressesObs = this.resolveAddressesAsync(request, forceRefresh);
        return allReplicaAddressesObs.map(allReplicaAddresses -> allReplicaAddresses.stream().filter(a -> includePrimary || !a.isPrimary()).map(a -> a.getPhysicalUri()).collect(Collectors.toList()));
    }

    public Mono<Uri> resolvePrimaryUriAsync(RxDocumentServiceRequest request, boolean forceAddressRefresh) {
        Mono<List<AddressInformation>> replicaAddressesObs = this.resolveAddressesAsync(request, forceAddressRefresh);
        return replicaAddressesObs.flatMap(replicaAddresses -> {
            try {
                return Mono.just((Object)AddressSelector.getPrimaryUri(request, replicaAddresses));
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        });
    }

    public static Uri getPrimaryUri(RxDocumentServiceRequest request, List<AddressInformation> replicaAddresses) throws GoneException {
        AddressInformation primaryAddress = null;
        if (request.getDefaultReplicaIndex() != null) {
            int defaultReplicaIndex = request.getDefaultReplicaIndex();
            if (defaultReplicaIndex >= 0 && defaultReplicaIndex < replicaAddresses.size()) {
                primaryAddress = replicaAddresses.get(defaultReplicaIndex);
            }
        } else {
            primaryAddress = replicaAddresses.stream().filter(address -> address.isPrimary() && !address.getPhysicalUri().getURIAsString().contains("[")).findAny().orElse(null);
        }
        if (primaryAddress == null) {
            throw new GoneException(String.format("The requested resource is no longer available at the server. Returned addresses are {%s}", String.join((CharSequence)",", replicaAddresses.stream().map(address -> address.getPhysicalUri().getURIAsString()).collect(Collectors.toList()))));
        }
        return primaryAddress.getPhysicalUri();
    }

    public Mono<List<AddressInformation>> resolveAddressesAsync(RxDocumentServiceRequest request, boolean forceAddressRefresh) {
        Mono resolvedAddressesObs = this.addressResolver.resolveAsync(request, forceAddressRefresh).map(addresses -> Arrays.stream(addresses).filter(address -> !Strings.isNullOrEmpty(address.getPhysicalUri().getURIAsString()) && Strings.areEqualIgnoreCase(address.getProtocolScheme(), this.protocol.scheme())).collect(Collectors.toList()));
        return resolvedAddressesObs.map(resolvedAddresses -> {
            List r = resolvedAddresses.stream().filter(address -> !address.isPublic()).collect(Collectors.toList());
            if (r.size() > 0) {
                return r;
            }
            return resolvedAddresses.stream().filter(AddressInformation::isPublic).collect(Collectors.toList());
        });
    }

    public Flux<OpenConnectionResponse> openConnectionsAndInitCaches(CosmosContainerProactiveInitConfig proactiveContainerInitConfig) {
        return this.addressResolver.openConnectionsAndInitCaches(proactiveContainerInitConfig);
    }
}

