/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.time.Duration;

public final class DirectConnectionConfig {
    private static final Boolean DEFAULT_CONNECTION_ENDPOINT_REDISCOVERY_ENABLED = true;
    private static final Duration DEFAULT_IDLE_ENDPOINT_TIMEOUT = Duration.ofHours(1L);
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(5L);
    private static final Duration DEFAULT_NETWORK_REQUEST_TIMEOUT = Duration.ofSeconds(5L);
    private static final Duration MIN_NETWORK_REQUEST_TIMEOUT = Duration.ofSeconds(1L);
    private static final Duration MAX_NETWORK_REQUEST_TIMEOUT = Duration.ofSeconds(10L);
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ENDPOINT = 130;
    private static final int DEFAULT_MAX_REQUESTS_PER_CONNECTION = 30;
    private static final int DEFAULT_IO_THREAD_COUNT_PER_CORE_FACTOR = 2;
    private static final int DEFAULT_IO_THREAD_PRIORITY = 5;
    private boolean connectionEndpointRediscoveryEnabled = DEFAULT_CONNECTION_ENDPOINT_REDISCOVERY_ENABLED;
    private Duration connectTimeout = DEFAULT_CONNECT_TIMEOUT;
    private Duration idleConnectionTimeout = Duration.ZERO;
    private Duration idleEndpointTimeout = DEFAULT_IDLE_ENDPOINT_TIMEOUT;
    private Duration networkRequestTimeout = DEFAULT_NETWORK_REQUEST_TIMEOUT;
    private int maxConnectionsPerEndpoint = 130;
    private int maxRequestsPerConnection = 30;
    private int ioThreadCountPerCoreFactor = 2;
    private int ioThreadPriority = 5;
    private boolean healthCheckTimeoutDetectionEnabled = Configs.isTcpHealthCheckTimeoutDetectionEnabled();

    public boolean isConnectionEndpointRediscoveryEnabled() {
        return this.connectionEndpointRediscoveryEnabled;
    }

    public DirectConnectionConfig setConnectionEndpointRediscoveryEnabled(boolean connectionEndpointRediscoveryEnabled) {
        this.connectionEndpointRediscoveryEnabled = connectionEndpointRediscoveryEnabled;
        return this;
    }

    public static DirectConnectionConfig getDefaultConfig() {
        return new DirectConnectionConfig();
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public DirectConnectionConfig setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public Duration getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    public DirectConnectionConfig setIdleConnectionTimeout(Duration idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
        return this;
    }

    public Duration getIdleEndpointTimeout() {
        return this.idleEndpointTimeout;
    }

    public DirectConnectionConfig setIdleEndpointTimeout(Duration idleEndpointTimeout) {
        Preconditions.checkArgument(!idleEndpointTimeout.isNegative(), "IdleEndpointTimeout cannot be less than 0");
        this.idleEndpointTimeout = idleEndpointTimeout;
        return this;
    }

    public int getMaxConnectionsPerEndpoint() {
        return this.maxConnectionsPerEndpoint;
    }

    public DirectConnectionConfig setMaxConnectionsPerEndpoint(int maxConnectionsPerEndpoint) {
        this.maxConnectionsPerEndpoint = maxConnectionsPerEndpoint;
        return this;
    }

    public int getMaxRequestsPerConnection() {
        return this.maxRequestsPerConnection;
    }

    public DirectConnectionConfig setMaxRequestsPerConnection(int maxRequestsPerConnection) {
        this.maxRequestsPerConnection = maxRequestsPerConnection;
        return this;
    }

    public Duration getNetworkRequestTimeout() {
        return this.networkRequestTimeout;
    }

    public DirectConnectionConfig setNetworkRequestTimeout(Duration networkRequestTimeout) {
        Preconditions.checkNotNull(networkRequestTimeout, "NetworkRequestTimeout can not be null");
        Preconditions.checkArgument(networkRequestTimeout.toMillis() >= MIN_NETWORK_REQUEST_TIMEOUT.toMillis(), "NetworkRequestTimeout can not be less than %s Millis", MIN_NETWORK_REQUEST_TIMEOUT.toMillis());
        Preconditions.checkArgument(networkRequestTimeout.toMillis() <= MAX_NETWORK_REQUEST_TIMEOUT.toMillis(), "NetworkRequestTimeout can not be larger than %s Millis", MAX_NETWORK_REQUEST_TIMEOUT.toMillis());
        this.networkRequestTimeout = networkRequestTimeout;
        return this;
    }

    int getIoThreadCountPerCoreFactor() {
        return this.ioThreadCountPerCoreFactor;
    }

    DirectConnectionConfig setIoThreadCountPerCoreFactor(int ioThreadCountPerCoreFactor) {
        this.ioThreadCountPerCoreFactor = ioThreadCountPerCoreFactor;
        return this;
    }

    int getIoThreadPriority() {
        return this.ioThreadPriority;
    }

    DirectConnectionConfig setIoThreadPriority(int ioThreadPriority) {
        this.ioThreadPriority = ioThreadPriority;
        return this;
    }

    DirectConnectionConfig setHealthCheckTimeoutDetectionEnabled(boolean timeoutDetectionEnabled) {
        this.healthCheckTimeoutDetectionEnabled = timeoutDetectionEnabled;
        return this;
    }

    boolean isHealthCheckTimeoutDetectionEnabled() {
        return this.healthCheckTimeoutDetectionEnabled;
    }

    public String toString() {
        return "DirectConnectionConfig{connectTimeout=" + this.connectTimeout + ", idleConnectionTimeout=" + this.idleConnectionTimeout + ", idleEndpointTimeout=" + this.idleEndpointTimeout + ", maxConnectionsPerEndpoint=" + this.maxConnectionsPerEndpoint + ", maxRequestsPerConnection=" + this.maxRequestsPerConnection + ", networkRequestTimeout=" + this.networkRequestTimeout + ", ioThreadCountPerCoreFactor=" + this.ioThreadCountPerCoreFactor + ", ioThreadPriority=" + this.ioThreadPriority + ", tcpHealthCheckTimeoutDetectionEnabled=" + this.healthCheckTimeoutDetectionEnabled + '}';
    }

    static void initialize() {
        ImplementationBridgeHelpers.DirectConnectionConfigHelper.setDirectConnectionConfigAccessor(new ImplementationBridgeHelpers.DirectConnectionConfigHelper.DirectConnectionConfigAccessor(){

            @Override
            public int getIoThreadCountPerCoreFactor(DirectConnectionConfig config) {
                return config.getIoThreadCountPerCoreFactor();
            }

            @Override
            public DirectConnectionConfig setIoThreadCountPerCoreFactor(DirectConnectionConfig config, int ioThreadCountPerCoreFactor) {
                return config.setIoThreadCountPerCoreFactor(ioThreadCountPerCoreFactor);
            }

            @Override
            public int getIoThreadPriority(DirectConnectionConfig config) {
                return config.getIoThreadPriority();
            }

            @Override
            public DirectConnectionConfig setIoThreadPriority(DirectConnectionConfig config, int ioThreadPriority) {
                return config.setIoThreadPriority(ioThreadPriority);
            }

            @Override
            public DirectConnectionConfig setHealthCheckTimeoutDetectionEnabled(DirectConnectionConfig directConnectionConfig, boolean timeoutDetectionEnabled) {
                directConnectionConfig.setHealthCheckTimeoutDetectionEnabled(timeoutDetectionEnabled);
                return directConnectionConfig;
            }

            @Override
            public boolean isHealthCheckTimeoutDetectionEnabled(DirectConnectionConfig directConnectionConfig) {
                return directConnectionConfig.isHealthCheckTimeoutDetectionEnabled();
            }
        });
    }

    static {
        DirectConnectionConfig.initialize();
    }
}

