/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.ClientSideRequestStatistics;
import com.azure.cosmos.implementation.DistinctClientSideRequestStatisticsCollection;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.implementation.query.metrics.QueryMetricsTextWriter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedResponseDiagnostics {
    private static final String EQUALS = "=";
    private static final String QUERY_PLAN = "QueryPlan";
    private static final String SPACE = " ";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedResponseDiagnostics.class);
    private Map<String, QueryMetrics> queryMetricsMap;
    private QueryInfo.QueryPlanDiagnosticsContext diagnosticsContext;
    private final Collection<ClientSideRequestStatistics> clientSideRequestStatistics;

    public FeedResponseDiagnostics(Map<String, QueryMetrics> queryMetricsMap, Collection<ClientSideRequestStatistics> clientSideRequestStatistics) {
        this.queryMetricsMap = queryMetricsMap;
        this.clientSideRequestStatistics = new DistinctClientSideRequestStatisticsCollection();
        if (clientSideRequestStatistics != null) {
            this.clientSideRequestStatistics.addAll(clientSideRequestStatistics);
        }
    }

    public FeedResponseDiagnostics(FeedResponseDiagnostics toBeCloned) {
        if (toBeCloned.queryMetricsMap != null) {
            this.queryMetricsMap = new ConcurrentHashMap<String, QueryMetrics>(toBeCloned.queryMetricsMap);
        }
        this.clientSideRequestStatistics = new DistinctClientSideRequestStatisticsCollection();
        this.clientSideRequestStatistics.addAll(toBeCloned.clientSideRequestStatistics);
        if (this.diagnosticsContext != null) {
            this.diagnosticsContext = new QueryInfo.QueryPlanDiagnosticsContext(toBeCloned.diagnosticsContext.getStartTimeUTC(), toBeCloned.diagnosticsContext.getEndTimeUTC(), toBeCloned.diagnosticsContext.getRequestTimeline());
        }
    }

    public Map<String, QueryMetrics> getQueryMetricsMap() {
        return this.queryMetricsMap;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.diagnosticsContext != null) {
            stringBuilder.append("QueryPlan Start Time (UTC)").append(EQUALS).append(QueryMetricsTextWriter.DATE_TIME_FORMATTER.format(this.diagnosticsContext.getStartTimeUTC())).append(System.lineSeparator());
            stringBuilder.append("QueryPlan End Time (UTC)").append(EQUALS).append(QueryMetricsTextWriter.DATE_TIME_FORMATTER.format(this.diagnosticsContext.getEndTimeUTC())).append(System.lineSeparator());
            if (this.diagnosticsContext.getStartTimeUTC() != null && this.diagnosticsContext.getEndTimeUTC() != null) {
                stringBuilder.append("QueryPlan Duration (ms)").append(EQUALS).append(Duration.between(this.diagnosticsContext.getStartTimeUTC(), this.diagnosticsContext.getEndTimeUTC()).toMillis()).append(System.lineSeparator());
                if (this.diagnosticsContext.getRequestTimeline() != null) {
                    try {
                        stringBuilder.append("QueryPlan RequestTimeline ").append(EQUALS).append(mapper.writeValueAsString((Object)this.diagnosticsContext.getRequestTimeline())).append(System.lineSeparator()).append(System.lineSeparator());
                    }
                    catch (JsonProcessingException e) {
                        LOGGER.error("Error while parsing diagnostics ", (Throwable)e);
                    }
                }
            }
        }
        if (this.queryMetricsMap != null && !this.queryMetricsMap.isEmpty()) {
            this.queryMetricsMap.forEach((key, value) -> stringBuilder.append((String)key).append(EQUALS).append(value.toString()).append(System.lineSeparator()));
        }
        try {
            stringBuilder.append(mapper.writeValueAsString(this.clientSideRequestStatistics));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Error while parsing diagnostics ", (Throwable)e);
        }
        return stringBuilder.toString();
    }

    public void setDiagnosticsContext(QueryInfo.QueryPlanDiagnosticsContext diagnosticsContext) {
        this.diagnosticsContext = diagnosticsContext;
    }

    public QueryInfo.QueryPlanDiagnosticsContext getQueryPlanDiagnosticsContext() {
        return this.diagnosticsContext;
    }

    public Collection<ClientSideRequestStatistics> getClientSideRequestStatistics() {
        return this.clientSideRequestStatistics;
    }

    public void addClientSideRequestStatistics(Collection<ClientSideRequestStatistics> requestStatistics) {
        this.clientSideRequestStatistics.addAll(requestStatistics);
    }

    public String getUserAgent() {
        if (this.clientSideRequestStatistics != null && !this.clientSideRequestStatistics.isEmpty()) {
            return this.clientSideRequestStatistics.stream().findFirst().get().getUserAgent();
        }
        return Utils.getUserAgent();
    }

    public FeedResponseDiagnostics setSamplingRateSnapshot(double samplingRateSnapshot) {
        for (ClientSideRequestStatistics c : this.clientSideRequestStatistics) {
            c.setSamplingRateSnapshot(samplingRateSnapshot);
        }
        return this;
    }
}

