/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.directconnectivity.IAddressResolver;
import com.azure.cosmos.implementation.directconnectivity.RntbdTransportClient;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import com.azure.cosmos.implementation.directconnectivity.rntbd.OpenConnectionRntbdRequestRecord;
import com.azure.cosmos.implementation.directconnectivity.rntbd.ProactiveOpenConnectionsProcessor;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdDurableEndpointMetrics;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestArgs;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestRecord;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micrometer.core.instrument.Tag;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.SslContext;
import java.net.SocketAddress;
import java.net.URI;
import java.time.Instant;
import java.util.stream.Stream;

public interface RntbdEndpoint
extends AutoCloseable {
    public int channelsAcquiredMetric();

    public RntbdDurableEndpointMetrics durableEndpointMetrics();

    public int channelsAvailableMetric();

    public int concurrentRequests();

    public int gettingEstablishedConnectionsMetrics();

    public Instant getCreatedTime();

    public long lastRequestNanoTime();

    public long lastSuccessfulRequestNanoTime();

    public int channelsMetrics();

    public int executorTaskQueueMetrics();

    public long id();

    public boolean isClosed();

    public int maxChannels();

    public SocketAddress remoteAddress();

    public URI serverKey();

    public int requestQueueLength();

    public Tag tag();

    public Tag clientMetricTag();

    public long usedDirectMemory();

    public long usedHeapMemory();

    public URI serviceEndpoint();

    public void injectConnectionErrors(String var1, double var2, Class<?> var4);

    public int getMinChannelsRequired();

    public void setMinChannelsRequired(int var1);

    public Uri getAddressUri();

    @Override
    public void close();

    public RntbdRequestRecord request(RntbdRequestArgs var1);

    public OpenConnectionRntbdRequestRecord openConnection(RntbdRequestArgs var1);

    public static final class Config {
        private final PooledByteBufAllocator allocator;
        private final RntbdTransportClient.Options options;
        private final SslContext sslContext;
        private final LogLevel wireLogLevel;

        public Config(RntbdTransportClient.Options options, SslContext sslContext, LogLevel wireLogLevel) {
            Preconditions.checkNotNull(options, "options");
            Preconditions.checkNotNull(sslContext, "sslContext");
            int directArenaCount = PooledByteBufAllocator.defaultNumDirectArena();
            int heapArenaCount = PooledByteBufAllocator.defaultNumHeapArena();
            int pageSize = options.bufferPageSize();
            int maxOrder = Integer.numberOfTrailingZeros(options.maxBufferCapacity()) - Integer.numberOfTrailingZeros(pageSize);
            this.allocator = new PooledByteBufAllocator(heapArenaCount, directArenaCount, pageSize, maxOrder);
            this.options = options;
            this.sslContext = sslContext;
            this.wireLogLevel = wireLogLevel;
        }

        @JsonIgnore
        public PooledByteBufAllocator allocator() {
            return this.allocator;
        }

        @JsonProperty
        public int bufferPageSize() {
            return this.options.bufferPageSize();
        }

        @JsonProperty
        public long connectionAcquisitionTimeoutInNanos() {
            return this.options.connectionAcquisitionTimeout().toNanos();
        }

        @JsonProperty
        public int connectTimeoutInMillis() {
            long value = this.options.connectTimeout().toMillis();
            assert (value <= Integer.MAX_VALUE);
            return (int)value;
        }

        @JsonProperty
        public long idleConnectionTimeoutInNanos() {
            return this.options.idleChannelTimeout().toNanos();
        }

        @JsonProperty
        public long idleConnectionTimerResolutionInNanos() {
            return this.options.idleChannelTimerResolution().toNanos();
        }

        @JsonProperty
        public long idleEndpointTimeoutInNanos() {
            return this.options.idleEndpointTimeout().toNanos();
        }

        @JsonProperty
        public boolean isConnectionEndpointRediscoveryEnabled() {
            return this.options.isConnectionEndpointRediscoveryEnabled();
        }

        @JsonProperty
        public int maxBufferCapacity() {
            return this.options.maxBufferCapacity();
        }

        @JsonProperty
        public int maxChannelsPerEndpoint() {
            return this.options.maxChannelsPerEndpoint();
        }

        @JsonProperty
        public int maxRequestsPerChannel() {
            return this.options.maxRequestsPerChannel();
        }

        @JsonProperty
        public int maxConcurrentRequestsPerEndpoint() {
            return this.options.maxConcurrentRequestsPerEndpoint();
        }

        @JsonProperty
        public long receiveHangDetectionTimeInNanos() {
            return this.options.receiveHangDetectionTime().toNanos();
        }

        @JsonProperty
        public long tcpNetworkRequestTimeoutInNanos() {
            return this.options.tcpNetworkRequestTimeout().toNanos();
        }

        @JsonProperty
        public long requestTimerResolutionInNanos() {
            return this.options.requestTimerResolution().toNanos();
        }

        @JsonProperty
        public long sendHangDetectionTimeInNanos() {
            return this.options.sendHangDetectionTime().toNanos();
        }

        @JsonProperty
        public long shutdownTimeoutInNanos() {
            return this.options.shutdownTimeout().toNanos();
        }

        @JsonIgnore
        public SslContext sslContext() {
            return this.sslContext;
        }

        @JsonProperty
        public UserAgentContainer userAgent() {
            return this.options.userAgent();
        }

        @JsonProperty
        public LogLevel wireLogLevel() {
            return this.wireLogLevel;
        }

        @JsonProperty
        public boolean isChannelAcquisitionContextEnabled() {
            return this.options.isChannelAcquisitionContextEnabled();
        }

        @JsonProperty
        public int tcpKeepIntvl() {
            return this.options.tcpKeepIntvl();
        }

        @JsonProperty
        public int tcpKeepIdle() {
            return this.options.tcpKeepIdle();
        }

        @JsonProperty
        public boolean preferTcpNative() {
            return this.options.preferTcpNative();
        }

        @JsonProperty
        public long sslHandshakeTimeoutInMillis() {
            return this.options.sslHandshakeTimeoutInMillis();
        }

        @JsonProperty
        public boolean timeoutDetectionEnabled() {
            return this.options.timeoutDetectionEnabled();
        }

        @JsonProperty
        public double timeoutDetectionDisableCPUThreshold() {
            return this.options.timeoutDetectionDisableCPUThreshold();
        }

        @JsonProperty
        public long timeoutDetectionTimeLimitInNanos() {
            return this.options.timeoutDetectionTimeLimit().toNanos();
        }

        @JsonProperty
        public int timeoutDetectionHighFrequencyThreshold() {
            return this.options.timeoutDetectionHighFrequencyThreshold();
        }

        @JsonProperty
        public long timeoutDetectionHighFrequencyTimeLimitInNanos() {
            return this.options.timeoutDetectionHighFrequencyTimeLimit().toNanos();
        }

        @JsonProperty
        public int timeoutDetectionOnWriteThreshold() {
            return this.options.timeoutDetectionOnWriteThreshold();
        }

        @JsonProperty
        public long timeoutDetectionOnWriteTimeLimitInNanos() {
            return this.options.timeoutDetectionOnWriteTimeLimit().toNanos();
        }

        public String toString() {
            return RntbdObjectMapper.toString(this);
        }
    }

    public static interface Provider
    extends AutoCloseable {
        @Override
        public void close();

        public Config config();

        public int count();

        public int evictions();

        public RntbdEndpoint createIfAbsent(URI var1, Uri var2, ProactiveOpenConnectionsProcessor var3, int var4);

        public RntbdEndpoint get(URI var1);

        public IAddressResolver getAddressResolver();

        public Stream<RntbdEndpoint> list();

        public boolean isClosed();
    }
}

