/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.routing;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.DatabaseAccount;
import com.azure.cosmos.implementation.DatabaseAccountLocation;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.implementation.apachecommons.collections.map.CaseInsensitiveMap;
import com.azure.cosmos.implementation.apachecommons.collections.map.UnmodifiableMap;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationCache {
    private static final Logger logger = LoggerFactory.getLogger(LocationCache.class);
    private final boolean enableEndpointDiscovery;
    private final URI defaultEndpoint;
    private final boolean useMultipleWriteLocations;
    private final Object lockObject;
    private final Duration unavailableLocationsExpirationTime;
    private final ConcurrentHashMap<URI, LocationUnavailabilityInfo> locationUnavailabilityInfoByEndpoint;
    private DatabaseAccountLocationsInfo locationInfo;
    private Instant lastCacheUpdateTimestamp;
    private boolean enableMultipleWriteLocations;

    public LocationCache(List<String> preferredLocations, URI defaultEndpoint, boolean enableEndpointDiscovery, boolean useMultipleWriteLocations, Configs configs) {
        this.locationInfo = new DatabaseAccountLocationsInfo(preferredLocations, defaultEndpoint);
        this.defaultEndpoint = defaultEndpoint;
        this.enableEndpointDiscovery = enableEndpointDiscovery;
        this.useMultipleWriteLocations = useMultipleWriteLocations;
        this.lockObject = new Object();
        this.locationUnavailabilityInfoByEndpoint = new ConcurrentHashMap();
        this.lastCacheUpdateTimestamp = Instant.MIN;
        this.enableMultipleWriteLocations = false;
        this.unavailableLocationsExpirationTime = Duration.ofSeconds(configs.getUnavailableLocationsExpirationTimeInSeconds());
    }

    public UnmodifiableList<URI> getReadEndpoints() {
        if (this.locationUnavailabilityInfoByEndpoint.size() > 0 && this.unavailableLocationsExpirationTimePassed()) {
            this.updateLocationCache();
        }
        return this.locationInfo.readEndpoints;
    }

    public UnmodifiableList<URI> getWriteEndpoints() {
        if (this.locationUnavailabilityInfoByEndpoint.size() > 0 && this.unavailableLocationsExpirationTimePassed()) {
            this.updateLocationCache();
        }
        return this.locationInfo.writeEndpoints;
    }

    public List<URI> getAvailableReadEndpoints() {
        return this.locationInfo.availableReadEndpointByLocation.values().stream().collect(Collectors.toList());
    }

    public List<URI> getAvailableWriteEndpoints() {
        return this.locationInfo.availableWriteEndpointByLocation.values().stream().collect(Collectors.toList());
    }

    public void markEndpointUnavailableForRead(URI endpoint) {
        this.markEndpointUnavailable(endpoint, OperationType.Read);
    }

    public void markEndpointUnavailableForWrite(URI endpoint) {
        this.markEndpointUnavailable(endpoint, OperationType.Write);
    }

    public void onDatabaseAccountRead(DatabaseAccount databaseAccount) {
        this.updateLocationCache(databaseAccount.getWritableLocations(), databaseAccount.getReadableLocations(), null, BridgeInternal.isEnableMultipleWriteLocations(databaseAccount));
    }

    void onLocationPreferenceChanged(UnmodifiableList<String> preferredLocations) {
        this.updateLocationCache(null, null, preferredLocations, null);
    }

    public URI resolveServiceEndpoint(RxDocumentServiceRequest request) {
        boolean usePreferredLocations;
        Objects.requireNonNull(request.requestContext, "RxDocumentServiceRequest.requestContext is required and cannot be null.");
        if (request.requestContext.locationEndpointToRoute != null) {
            return request.requestContext.locationEndpointToRoute;
        }
        int locationIndex = Utils.getValueOrDefault(request.requestContext.locationIndexToRoute, 0);
        boolean bl = usePreferredLocations = request.requestContext.usePreferredLocations != null ? request.requestContext.usePreferredLocations : true;
        if (!usePreferredLocations || request.getOperationType().isWriteOperation() && !this.canUseMultipleWriteLocations(request)) {
            DatabaseAccountLocationsInfo currentLocationInfo = this.locationInfo;
            if (this.enableEndpointDiscovery && currentLocationInfo.availableWriteLocations.size() > 0) {
                locationIndex = Math.min(locationIndex % 2, currentLocationInfo.availableWriteLocations.size() - 1);
                String writeLocation = (String)currentLocationInfo.availableWriteLocations.get(locationIndex);
                return (URI)currentLocationInfo.availableWriteEndpointByLocation.get(writeLocation);
            }
            return this.defaultEndpoint;
        }
        UnmodifiableList<URI> endpoints = request.getOperationType().isWriteOperation() ? this.getWriteEndpoints() : this.getReadEndpoints();
        return (URI)endpoints.get(locationIndex % endpoints.size());
    }

    public URI resolveFaultInjectionEndpoint(String region, boolean writeOnly) {
        Utils.ValueHolder endpointValueHolder = new Utils.ValueHolder();
        if (writeOnly) {
            Utils.tryGetValue(this.locationInfo.availableWriteEndpointByLocation, region, endpointValueHolder);
        } else {
            Utils.tryGetValue(this.locationInfo.availableReadEndpointByLocation, region, endpointValueHolder);
        }
        if (endpointValueHolder.v != null) {
            return (URI)endpointValueHolder.v;
        }
        throw new IllegalArgumentException("Can not find service endpoint for region " + region);
    }

    public URI getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public boolean shouldRefreshEndpoints(Utils.ValueHolder<Boolean> canRefreshInBackground) {
        canRefreshInBackground.v = true;
        DatabaseAccountLocationsInfo currentLocationInfo = this.locationInfo;
        String mostPreferredLocation = (String)Utils.firstOrDefault(currentLocationInfo.preferredLocations);
        if (this.enableEndpointDiscovery) {
            boolean shouldRefresh = this.useMultipleWriteLocations && !this.enableMultipleWriteLocations;
            UnmodifiableList readLocationEndpoints = currentLocationInfo.readEndpoints;
            if (this.isEndpointUnavailable((URI)readLocationEndpoints.get(0), OperationType.Read)) {
                canRefreshInBackground.v = this.anyEndpointsAvailable(readLocationEndpoints, OperationType.Read);
                logger.debug("shouldRefreshEndpoints = true,  since the first read endpoint [{}] is not available for read. canRefreshInBackground = [{}]", readLocationEndpoints.get(0), canRefreshInBackground.v);
                return true;
            }
            if (!Strings.isNullOrEmpty(mostPreferredLocation)) {
                Utils.ValueHolder mostPreferredReadEndpointHolder = new Utils.ValueHolder();
                logger.debug("getReadEndpoints [{}]", (Object)readLocationEndpoints);
                if (Utils.tryGetValue(currentLocationInfo.availableReadEndpointByLocation, mostPreferredLocation, mostPreferredReadEndpointHolder)) {
                    logger.debug("most preferred is [{}], most preferred available is [{}]", (Object)mostPreferredLocation, mostPreferredReadEndpointHolder.v);
                    if (!this.areEqual((URI)mostPreferredReadEndpointHolder.v, (URI)readLocationEndpoints.get(0))) {
                        logger.debug("shouldRefreshEndpoints = true, most preferred location [{}] is not available for read.", (Object)mostPreferredLocation);
                        return true;
                    }
                    logger.debug("most preferred is [{}], and most preferred available [{}] are the same", (Object)mostPreferredLocation, mostPreferredReadEndpointHolder.v);
                } else {
                    logger.debug("shouldRefreshEndpoints = true, most preferred location [{}] is not in available read locations.", (Object)mostPreferredLocation);
                    return true;
                }
            }
            Utils.ValueHolder mostPreferredWriteEndpointHolder = new Utils.ValueHolder();
            UnmodifiableList writeLocationEndpoints = currentLocationInfo.writeEndpoints;
            logger.debug("getWriteEndpoints [{}]", (Object)writeLocationEndpoints);
            if (!this.canUseMultipleWriteLocations()) {
                if (this.isEndpointUnavailable((URI)writeLocationEndpoints.get(0), OperationType.Write)) {
                    canRefreshInBackground.v = this.anyEndpointsAvailable(writeLocationEndpoints, OperationType.Write);
                    logger.debug("shouldRefreshEndpoints = true, most preferred location [{}] endpoint [{}] is not available for write. canRefreshInBackground = [{}]", new Object[]{mostPreferredLocation, writeLocationEndpoints.get(0), canRefreshInBackground.v});
                    return true;
                }
                logger.debug("shouldRefreshEndpoints: false, [{}] is available for Write", writeLocationEndpoints.get(0));
                return shouldRefresh;
            }
            if (!Strings.isNullOrEmpty(mostPreferredLocation)) {
                if (Utils.tryGetValue(currentLocationInfo.availableWriteEndpointByLocation, mostPreferredLocation, mostPreferredWriteEndpointHolder)) {
                    boolean bl = shouldRefresh = !this.areEqual((URI)mostPreferredWriteEndpointHolder.v, (URI)writeLocationEndpoints.get(0));
                    if (shouldRefresh) {
                        logger.debug("shouldRefreshEndpoints: true, write endpoint [{}] is not the same as most preferred [{}]", writeLocationEndpoints.get(0), mostPreferredWriteEndpointHolder.v);
                    } else {
                        logger.debug("shouldRefreshEndpoints: false, write endpoint [{}] is the same as most preferred [{}]", writeLocationEndpoints.get(0), mostPreferredWriteEndpointHolder.v);
                    }
                    return shouldRefresh;
                }
                logger.debug("shouldRefreshEndpoints = true, most preferred location [{}] is not in available write locations", (Object)mostPreferredLocation);
                return true;
            }
            logger.debug("shouldRefreshEndpoints: false, mostPreferredLocation [{}] is empty", (Object)mostPreferredLocation);
            return shouldRefresh;
        }
        logger.debug("shouldRefreshEndpoints: false, endpoint discovery not enabled");
        return false;
    }

    public String getRegionName(URI locationEndpoint, com.azure.cosmos.implementation.OperationType operationType) {
        Utils.ValueHolder regionName = new Utils.ValueHolder();
        if (operationType.isWriteOperation() ? Utils.tryGetValue(this.locationInfo.regionNameByWriteEndpoint, locationEndpoint, regionName) : Utils.tryGetValue(this.locationInfo.regionNameByReadEndpoint, locationEndpoint, regionName)) {
            return (String)regionName.v;
        }
        return (String)this.locationInfo.availableWriteEndpointByLocation.keySet().iterator().next();
    }

    private boolean areEqual(URI url1, URI url2) {
        return url1.equals(url2);
    }

    private void clearStaleEndpointUnavailabilityInfo() {
        if (!this.locationUnavailabilityInfoByEndpoint.isEmpty()) {
            ArrayList unavailableEndpoints = new ArrayList(this.locationUnavailabilityInfoByEndpoint.keySet());
            for (URI unavailableEndpoint : unavailableEndpoints) {
                Utils.ValueHolder unavailabilityInfoHolder = new Utils.ValueHolder();
                Utils.ValueHolder removedHolder = new Utils.ValueHolder();
                if (!Utils.tryGetValue(this.locationUnavailabilityInfoByEndpoint, unavailableEndpoint, unavailabilityInfoHolder) || !this.durationPassed(Instant.now(), ((LocationUnavailabilityInfo)unavailabilityInfoHolder.v).lastUnavailabilityCheckTimeStamp, this.unavailableLocationsExpirationTime) || !Utils.tryRemove(this.locationUnavailabilityInfoByEndpoint, unavailableEndpoint, removedHolder)) continue;
                logger.debug("Removed endpoint [{}] unavailable for operations [{}] from unavailableEndpoints", (Object)unavailableEndpoint, (Object)((LocationUnavailabilityInfo)unavailabilityInfoHolder.v).unavailableOperations);
            }
        }
    }

    private boolean isEndpointUnavailable(URI endpoint, OperationType expectedAvailableOperations) {
        Utils.ValueHolder unavailabilityInfoHolder = new Utils.ValueHolder();
        if (expectedAvailableOperations == OperationType.None || !Utils.tryGetValue(this.locationUnavailabilityInfoByEndpoint, endpoint, unavailabilityInfoHolder) || !((LocationUnavailabilityInfo)unavailabilityInfoHolder.v).unavailableOperations.supports(expectedAvailableOperations)) {
            return false;
        }
        if (this.durationPassed(Instant.now(), ((LocationUnavailabilityInfo)unavailabilityInfoHolder.v).lastUnavailabilityCheckTimeStamp, this.unavailableLocationsExpirationTime)) {
            return false;
        }
        logger.debug("Endpoint [{}] unavailable for operations [{}] present in unavailableEndpoints", (Object)endpoint, (Object)((LocationUnavailabilityInfo)unavailabilityInfoHolder.v).unavailableOperations);
        return true;
    }

    private boolean anyEndpointsAvailable(List<URI> endpoints, OperationType expectedAvailableOperations) {
        Utils.ValueHolder unavailabilityInfoHolder = new Utils.ValueHolder();
        boolean anyEndpointsAvailable = false;
        for (URI endpoint : endpoints) {
            if (this.isEndpointUnavailable(endpoint, expectedAvailableOperations)) continue;
            anyEndpointsAvailable = true;
            break;
        }
        return anyEndpointsAvailable;
    }

    private void markEndpointUnavailable(URI unavailableEndpoint, final OperationType unavailableOperationType) {
        final Instant currentTime = Instant.now();
        LocationUnavailabilityInfo updatedInfo = this.locationUnavailabilityInfoByEndpoint.compute(unavailableEndpoint, new BiFunction<URI, LocationUnavailabilityInfo, LocationUnavailabilityInfo>(){

            @Override
            public LocationUnavailabilityInfo apply(URI url, LocationUnavailabilityInfo info) {
                if (info == null) {
                    return new LocationUnavailabilityInfo(currentTime, unavailableOperationType);
                }
                info.lastUnavailabilityCheckTimeStamp = currentTime;
                info.unavailableOperations = OperationType.combine(info.unavailableOperations, unavailableOperationType);
                return info;
            }
        });
        this.updateLocationCache();
        logger.debug("Endpoint [{}] unavailable for [{}] added/updated to unavailableEndpoints with timestamp [{}]", new Object[]{unavailableEndpoint, unavailableOperationType, updatedInfo.lastUnavailabilityCheckTimeStamp});
    }

    private void updateLocationCache() {
        this.updateLocationCache(null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocationCache(Iterable<DatabaseAccountLocation> writeLocations, Iterable<DatabaseAccountLocation> readLocations, UnmodifiableList<String> preferenceList, Boolean enableMultipleWriteLocations) {
        Object object = this.lockObject;
        synchronized (object) {
            Utils.ValueHolder<UnmodifiableList<String>> out;
            DatabaseAccountLocationsInfo nextLocationInfo = new DatabaseAccountLocationsInfo(this.locationInfo);
            logger.debug("updating location cache ..., current readLocations [{}], current writeLocations [{}]", (Object)nextLocationInfo.readEndpoints, (Object)nextLocationInfo.writeEndpoints);
            if (preferenceList != null) {
                nextLocationInfo.preferredLocations = preferenceList;
            }
            if (enableMultipleWriteLocations != null) {
                this.enableMultipleWriteLocations = enableMultipleWriteLocations;
            }
            this.clearStaleEndpointUnavailabilityInfo();
            if (readLocations != null) {
                out = Utils.ValueHolder.initialize(nextLocationInfo.availableReadLocations);
                Utils.ValueHolder<UnmodifiableMap<URI, String>> outReadRegionMap = Utils.ValueHolder.initialize(nextLocationInfo.regionNameByReadEndpoint);
                nextLocationInfo.availableReadEndpointByLocation = this.getEndpointByLocation(readLocations, out, outReadRegionMap);
                nextLocationInfo.availableReadLocations = (UnmodifiableList)out.v;
                nextLocationInfo.regionNameByReadEndpoint = (UnmodifiableMap)outReadRegionMap.v;
            }
            if (writeLocations != null) {
                out = Utils.ValueHolder.initialize(nextLocationInfo.availableWriteLocations);
                Utils.ValueHolder<UnmodifiableMap<URI, String>> outWriteRegionMap = Utils.ValueHolder.initialize(nextLocationInfo.regionNameByWriteEndpoint);
                nextLocationInfo.availableWriteEndpointByLocation = this.getEndpointByLocation(writeLocations, out, outWriteRegionMap);
                nextLocationInfo.availableWriteLocations = (UnmodifiableList)out.v;
                nextLocationInfo.regionNameByWriteEndpoint = (UnmodifiableMap)outWriteRegionMap.v;
            }
            nextLocationInfo.writeEndpoints = this.getPreferredAvailableEndpoints(nextLocationInfo.availableWriteEndpointByLocation, nextLocationInfo.availableWriteLocations, OperationType.Write, this.defaultEndpoint);
            nextLocationInfo.readEndpoints = this.getPreferredAvailableEndpoints(nextLocationInfo.availableReadEndpointByLocation, nextLocationInfo.availableReadLocations, OperationType.Read, (URI)nextLocationInfo.writeEndpoints.get(0));
            this.lastCacheUpdateTimestamp = Instant.now();
            logger.debug("updating location cache finished, new readLocations [{}], new writeLocations [{}]", (Object)nextLocationInfo.readEndpoints, (Object)nextLocationInfo.writeEndpoints);
            this.locationInfo = nextLocationInfo;
        }
    }

    private UnmodifiableList<URI> getPreferredAvailableEndpoints(UnmodifiableMap<String, URI> endpointsByLocation, UnmodifiableList<String> orderedLocations, OperationType expectedAvailableOperation, URI fallbackEndpoint) {
        ArrayList<URI> endpoints = new ArrayList<URI>();
        DatabaseAccountLocationsInfo currentLocationInfo = this.locationInfo;
        if (this.enableEndpointDiscovery) {
            if (this.canUseMultipleWriteLocations() || expectedAvailableOperation.supports(OperationType.Read)) {
                ArrayList<URI> unavailableEndpoints = new ArrayList<URI>();
                for (String location : currentLocationInfo.preferredLocations) {
                    Utils.ValueHolder endpoint;
                    if (!Utils.tryGetValue(endpointsByLocation, location, endpoint = new Utils.ValueHolder())) continue;
                    if (this.isEndpointUnavailable((URI)endpoint.v, expectedAvailableOperation)) {
                        unavailableEndpoints.add((URI)endpoint.v);
                        continue;
                    }
                    endpoints.add((URI)endpoint.v);
                }
                if (endpoints.isEmpty()) {
                    endpoints.add(fallbackEndpoint);
                }
                endpoints.addAll(unavailableEndpoints);
            } else {
                for (String location : orderedLocations) {
                    Utils.ValueHolder<Object> endpoint = Utils.ValueHolder.initialize(null);
                    if (Strings.isNullOrEmpty(location) || !Utils.tryGetValue(endpointsByLocation, location, endpoint)) continue;
                    endpoints.add((URI)endpoint.v);
                }
            }
        }
        if (endpoints.isEmpty()) {
            endpoints.add(fallbackEndpoint);
        }
        return new UnmodifiableList<URI>((List<URI>)endpoints);
    }

    private UnmodifiableMap<String, URI> getEndpointByLocation(Iterable<DatabaseAccountLocation> locations, Utils.ValueHolder<UnmodifiableList<String>> orderedLocations, Utils.ValueHolder<UnmodifiableMap<URI, String>> regionMap) {
        CaseInsensitiveMap<String, URI> endpointsByLocation = new CaseInsensitiveMap<String, URI>();
        CaseInsensitiveMap<URI, String> regionByEndpoint = new CaseInsensitiveMap<URI, String>();
        ArrayList<String> parsedLocations = new ArrayList<String>();
        for (DatabaseAccountLocation location : locations) {
            if (Strings.isNullOrEmpty(location.getName())) continue;
            try {
                URI endpoint = new URI(location.getEndpoint().toLowerCase(Locale.ROOT));
                endpointsByLocation.put(location.getName().toLowerCase(Locale.ROOT), endpoint);
                regionByEndpoint.put(endpoint, location.getName().toLowerCase(Locale.ROOT));
                parsedLocations.add(location.getName());
            }
            catch (Exception e) {
                logger.warn("GetAvailableEndpointsByLocation() - skipping add for location = [{}] as it is location name is either empty or endpoint is malformed [{}]", (Object)location.getName(), (Object)location.getEndpoint());
            }
        }
        orderedLocations.v = new UnmodifiableList(parsedLocations);
        regionMap.v = (UnmodifiableMap)UnmodifiableMap.unmodifiableMap(regionByEndpoint);
        return (UnmodifiableMap)UnmodifiableMap.unmodifiableMap(endpointsByLocation);
    }

    private boolean canUseMultipleWriteLocations() {
        return this.useMultipleWriteLocations && this.enableMultipleWriteLocations;
    }

    public boolean canUseMultipleWriteLocations(RxDocumentServiceRequest request) {
        return this.canUseMultipleWriteLocations() && (request.getResourceType() == ResourceType.Document || request.getResourceType() == ResourceType.StoredProcedure && request.getOperationType() == com.azure.cosmos.implementation.OperationType.ExecuteJavaScript);
    }

    private boolean durationPassed(Instant end, Instant start, Duration duration) {
        return end.minus(duration).isAfter(start);
    }

    private boolean unavailableLocationsExpirationTimePassed() {
        return this.durationPassed(Instant.now(), this.lastCacheUpdateTimestamp, this.unavailableLocationsExpirationTime);
    }

    static class DatabaseAccountLocationsInfo {
        private UnmodifiableList<String> preferredLocations;
        private UnmodifiableList<String> availableWriteLocations;
        private UnmodifiableList<String> availableReadLocations;
        private UnmodifiableMap<String, URI> availableWriteEndpointByLocation;
        private UnmodifiableMap<String, URI> availableReadEndpointByLocation;
        private UnmodifiableMap<URI, String> regionNameByWriteEndpoint;
        private UnmodifiableMap<URI, String> regionNameByReadEndpoint;
        private UnmodifiableList<URI> writeEndpoints;
        private UnmodifiableList<URI> readEndpoints;

        public DatabaseAccountLocationsInfo(List<String> preferredLocations, URI defaultEndpoint) {
            this.preferredLocations = new UnmodifiableList(preferredLocations.stream().map(loc -> loc.toLowerCase(Locale.ROOT)).collect(Collectors.toList()));
            this.availableWriteEndpointByLocation = (UnmodifiableMap)UnmodifiableMap.unmodifiableMap(new CaseInsensitiveMap());
            this.availableReadEndpointByLocation = (UnmodifiableMap)UnmodifiableMap.unmodifiableMap(new CaseInsensitiveMap());
            this.regionNameByWriteEndpoint = (UnmodifiableMap)UnmodifiableMap.unmodifiableMap(new CaseInsensitiveMap());
            this.regionNameByReadEndpoint = (UnmodifiableMap)UnmodifiableMap.unmodifiableMap(new CaseInsensitiveMap());
            this.availableReadLocations = new UnmodifiableList(Collections.emptyList());
            this.availableWriteLocations = new UnmodifiableList(Collections.emptyList());
            this.readEndpoints = new UnmodifiableList<URI>(Collections.singletonList(defaultEndpoint));
            this.writeEndpoints = new UnmodifiableList<URI>(Collections.singletonList(defaultEndpoint));
        }

        public DatabaseAccountLocationsInfo(DatabaseAccountLocationsInfo other) {
            this.preferredLocations = other.preferredLocations;
            this.availableWriteLocations = other.availableWriteLocations;
            this.availableReadLocations = other.availableReadLocations;
            this.availableWriteEndpointByLocation = other.availableWriteEndpointByLocation;
            this.regionNameByWriteEndpoint = other.regionNameByWriteEndpoint;
            this.regionNameByReadEndpoint = other.regionNameByReadEndpoint;
            this.availableReadEndpointByLocation = other.availableReadEndpointByLocation;
            this.writeEndpoints = other.writeEndpoints;
            this.readEndpoints = other.readEndpoints;
        }
    }

    private static enum OperationType {
        None(0),
        Read(1),
        Write(2),
        ReadAndWrite(3);

        private final int flag;

        public boolean hasReadFlag() {
            return (this.flag & OperationType.Read.flag) != 0;
        }

        public boolean hasWriteFlag() {
            return (this.flag & OperationType.Write.flag) != 0;
        }

        public static OperationType combine(OperationType t1, OperationType t2) {
            switch (t1.flag | t2.flag) {
                case 0: {
                    return None;
                }
                case 1: {
                    return Read;
                }
                case 2: {
                    return Write;
                }
            }
            return ReadAndWrite;
        }

        public boolean supports(OperationType type) {
            return (this.flag & type.flag) != 0;
        }

        private OperationType(int flag) {
            this.flag = flag;
        }
    }

    private static class LocationUnavailabilityInfo {
        public Instant lastUnavailabilityCheckTimeStamp;
        public OperationType unavailableOperations;

        LocationUnavailabilityInfo(Instant instant, OperationType type) {
            this.lastUnavailabilityCheckTimeStamp = instant;
            this.unavailableOperations = type;
        }
    }
}

