/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;

public final class CosmosContainerIdentity {
    private final String databaseName;
    private final String containerName;
    private final String containerLink;

    public CosmosContainerIdentity(String databaseName, String containerName) {
        Preconditions.checkArgument(!Strings.isNullOrWhiteSpace(databaseName), "databaseName should not be null nor empty");
        Preconditions.checkArgument(!Strings.isNullOrWhiteSpace(containerName), "containerName should not be null nor empty");
        this.databaseName = databaseName;
        this.containerName = containerName;
        String databaseLink = Utils.joinPath("/dbs", databaseName);
        this.containerLink = StringUtils.strip(Utils.joinPath(databaseLink, "colls") + containerName, "/");
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosContainerIdentityHelper.setCosmosContainerIdentityAccessor(new ImplementationBridgeHelpers.CosmosContainerIdentityHelper.CosmosContainerIdentityAccessor(){

            @Override
            public String getDatabaseName(CosmosContainerIdentity cosmosContainerIdentity) {
                return cosmosContainerIdentity.databaseName;
            }

            @Override
            public String getContainerName(CosmosContainerIdentity cosmosContainerIdentity) {
                return cosmosContainerIdentity.containerName;
            }

            @Override
            public String getContainerLink(CosmosContainerIdentity cosmosContainerIdentity) {
                return cosmosContainerIdentity.containerLink;
            }
        });
    }

    static {
        CosmosContainerIdentity.initialize();
    }
}

