/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosDiagnosticsThresholds;
import com.azure.cosmos.CosmosEndToEndOperationLatencyPolicyConfig;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.WriteRetryPolicy;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.models.DedicatedGatewayRequestOptions;
import com.azure.cosmos.models.IndexingDirective;
import com.azure.cosmos.models.PartitionKey;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CosmosItemRequestOptions {
    private static final ImplementationBridgeHelpers.CosmosDiagnosticsThresholdsHelper.CosmosDiagnosticsThresholdsAccessor thresholdsAccessor = ImplementationBridgeHelpers.CosmosDiagnosticsThresholdsHelper.getCosmosAsyncClientAccessor();
    private ConsistencyLevel consistencyLevel;
    private IndexingDirective indexingDirective;
    private OperationContextAndListenerTuple operationContextAndListenerTuple;
    private List<String> preTriggerInclude;
    private List<String> postTriggerInclude;
    private String sessionToken;
    private PartitionKey partitionKey;
    private String ifMatchETag;
    private String ifNoneMatchETag;
    private Boolean contentResponseOnWriteEnabled;
    private String throughputControlGroupName;
    private DedicatedGatewayRequestOptions dedicatedGatewayRequestOptions;
    private Map<String, String> customOptions;
    private CosmosDiagnosticsThresholds thresholds;
    private Boolean nonIdempotentWriteRetriesEnabled;
    private boolean useTrackingIds;
    private CosmosEndToEndOperationLatencyPolicyConfig endToEndOperationLatencyPolicyConfig;

    CosmosItemRequestOptions(CosmosItemRequestOptions options) {
        this.consistencyLevel = options.consistencyLevel;
        this.indexingDirective = options.indexingDirective;
        this.preTriggerInclude = options.preTriggerInclude != null ? new ArrayList<String>(options.preTriggerInclude) : null;
        this.postTriggerInclude = options.postTriggerInclude != null ? new ArrayList<String>(options.postTriggerInclude) : null;
        this.sessionToken = options.sessionToken;
        this.partitionKey = options.partitionKey;
        this.ifMatchETag = options.ifMatchETag;
        this.ifNoneMatchETag = options.ifNoneMatchETag;
        this.contentResponseOnWriteEnabled = options.contentResponseOnWriteEnabled;
        this.throughputControlGroupName = options.throughputControlGroupName;
        this.dedicatedGatewayRequestOptions = options.dedicatedGatewayRequestOptions;
        this.thresholds = options.thresholds;
        this.operationContextAndListenerTuple = options.operationContextAndListenerTuple;
        this.nonIdempotentWriteRetriesEnabled = options.nonIdempotentWriteRetriesEnabled;
        this.useTrackingIds = options.useTrackingIds;
        this.endToEndOperationLatencyPolicyConfig = options.endToEndOperationLatencyPolicyConfig;
        if (options.customOptions != null) {
            this.customOptions = new HashMap<String, String>(options.customOptions);
        }
    }

    public CosmosItemRequestOptions() {
    }

    CosmosItemRequestOptions(PartitionKey partitionKey) {
        this.setPartitionKey(partitionKey);
        this.thresholds = new CosmosDiagnosticsThresholds();
    }

    public String getIfMatchETag() {
        return this.ifMatchETag;
    }

    public CosmosItemRequestOptions setIfMatchETag(String ifMatchETag) {
        this.ifMatchETag = ifMatchETag;
        return this;
    }

    public String getIfNoneMatchETag() {
        return this.ifNoneMatchETag;
    }

    public CosmosItemRequestOptions setIfNoneMatchETag(String ifNoneMatchETag) {
        this.ifNoneMatchETag = ifNoneMatchETag;
        return this;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public CosmosItemRequestOptions setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public IndexingDirective getIndexingDirective() {
        return this.indexingDirective;
    }

    public CosmosItemRequestOptions setIndexingDirective(IndexingDirective indexingDirective) {
        this.indexingDirective = indexingDirective;
        return this;
    }

    public List<String> getPreTriggerInclude() {
        return this.preTriggerInclude;
    }

    public CosmosItemRequestOptions setPreTriggerInclude(List<String> preTriggerInclude) {
        this.preTriggerInclude = preTriggerInclude;
        return this;
    }

    public List<String> getPostTriggerInclude() {
        return this.postTriggerInclude;
    }

    public CosmosItemRequestOptions setPostTriggerInclude(List<String> postTriggerInclude) {
        this.postTriggerInclude = postTriggerInclude;
        return this;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public CosmosItemRequestOptions setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
        return this;
    }

    public Boolean isContentResponseOnWriteEnabled() {
        return this.contentResponseOnWriteEnabled;
    }

    public CosmosItemRequestOptions setContentResponseOnWriteEnabled(Boolean contentResponseOnWriteEnabled) {
        this.contentResponseOnWriteEnabled = contentResponseOnWriteEnabled;
        return this;
    }

    public DedicatedGatewayRequestOptions getDedicatedGatewayRequestOptions() {
        return this.dedicatedGatewayRequestOptions;
    }

    CosmosEndToEndOperationLatencyPolicyConfig getCosmosEndToEndOperationLatencyPolicyConfig() {
        return this.endToEndOperationLatencyPolicyConfig;
    }

    public CosmosItemRequestOptions setNonIdempotentWriteRetryPolicy(boolean nonIdempotentWriteRetriesEnabled, boolean useTrackingIdPropertyForCreateAndReplace) {
        this.nonIdempotentWriteRetriesEnabled = nonIdempotentWriteRetriesEnabled;
        this.useTrackingIds = useTrackingIdPropertyForCreateAndReplace;
        return this;
    }

    public CosmosItemRequestOptions setDedicatedGatewayRequestOptions(DedicatedGatewayRequestOptions dedicatedGatewayRequestOptions) {
        this.dedicatedGatewayRequestOptions = dedicatedGatewayRequestOptions;
        return this;
    }

    public CosmosItemRequestOptions setCosmosEndToEndOperationLatencyPolicyConfig(CosmosEndToEndOperationLatencyPolicyConfig endToEndOperationLatencyPolicyConfig) {
        this.endToEndOperationLatencyPolicyConfig = endToEndOperationLatencyPolicyConfig;
        return this;
    }

    PartitionKey getPartitionKey() {
        return this.partitionKey;
    }

    CosmosItemRequestOptions setPartitionKey(PartitionKey partitionKey) {
        this.partitionKey = partitionKey;
        return this;
    }

    RequestOptions toRequestOptions() {
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setIfMatchETag(this.getIfMatchETag());
        requestOptions.setIfNoneMatchETag(this.getIfNoneMatchETag());
        requestOptions.setConsistencyLevel(this.getConsistencyLevel());
        requestOptions.setIndexingDirective(this.indexingDirective);
        requestOptions.setPreTriggerInclude(this.preTriggerInclude);
        requestOptions.setPostTriggerInclude(this.postTriggerInclude);
        requestOptions.setSessionToken(this.sessionToken);
        requestOptions.setPartitionKey(this.partitionKey);
        requestOptions.setContentResponseOnWriteEnabled(this.contentResponseOnWriteEnabled);
        requestOptions.setThroughputControlGroupName(this.throughputControlGroupName);
        requestOptions.setOperationContextAndListenerTuple(this.operationContextAndListenerTuple);
        requestOptions.setDedicatedGatewayRequestOptions(this.dedicatedGatewayRequestOptions);
        requestOptions.setDiagnosticsThresholds(this.thresholds);
        if (this.nonIdempotentWriteRetriesEnabled != null) {
            requestOptions.setNonIdempotentWriteRetriesEnabled(this.nonIdempotentWriteRetriesEnabled);
        }
        requestOptions.setCosmosEndToEndLatencyPolicyConfig(this.endToEndOperationLatencyPolicyConfig);
        if (this.customOptions != null) {
            for (Map.Entry<String, String> entry : this.customOptions.entrySet()) {
                requestOptions.setHeader(entry.getKey(), entry.getValue());
            }
        }
        return requestOptions;
    }

    public String getThroughputControlGroupName() {
        return this.throughputControlGroupName;
    }

    public void setThroughputControlGroupName(String throughputControlGroupName) {
        this.throughputControlGroupName = throughputControlGroupName;
    }

    public Duration getThresholdForDiagnosticsOnTracer() {
        return thresholdsAccessor.getPointReadLatencyThreshold(this.thresholds);
    }

    public CosmosItemRequestOptions setThresholdForDiagnosticsOnTracer(Duration thresholdForDiagnosticsOnTracer) {
        this.thresholds.setPointOperationLatencyThreshold(thresholdForDiagnosticsOnTracer);
        return this;
    }

    CosmosItemRequestOptions setHeader(String name, String value) {
        if (this.customOptions == null) {
            this.customOptions = new HashMap<String, String>();
        }
        this.customOptions.put(name, value);
        return this;
    }

    public CosmosItemRequestOptions setDiagnosticsThresholds(CosmosDiagnosticsThresholds operationSpecificThresholds) {
        this.thresholds = operationSpecificThresholds;
        return this;
    }

    Map<String, String> getHeaders() {
        return this.customOptions;
    }

    void setOperationContextAndListenerTuple(OperationContextAndListenerTuple operationContextAndListenerTuple) {
        this.operationContextAndListenerTuple = operationContextAndListenerTuple;
    }

    OperationContextAndListenerTuple getOperationContextAndListenerTuple() {
        return this.operationContextAndListenerTuple;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosItemRequestOptionsHelper.setCosmosItemRequestOptionsAccessor(new ImplementationBridgeHelpers.CosmosItemRequestOptionsHelper.CosmosItemRequestOptionsAccessor(){

            @Override
            public void setOperationContext(CosmosItemRequestOptions itemRequestOptions, OperationContextAndListenerTuple operationContextAndListenerTuple) {
                itemRequestOptions.setOperationContextAndListenerTuple(operationContextAndListenerTuple);
            }

            @Override
            public OperationContextAndListenerTuple getOperationContext(CosmosItemRequestOptions itemRequestOptions) {
                return itemRequestOptions.getOperationContextAndListenerTuple();
            }

            @Override
            public CosmosItemRequestOptions clone(CosmosItemRequestOptions options) {
                return new CosmosItemRequestOptions(options);
            }

            @Override
            public CosmosItemRequestOptions setHeader(CosmosItemRequestOptions cosmosItemRequestOptions, String name, String value) {
                return cosmosItemRequestOptions.setHeader(name, value);
            }

            @Override
            public Map<String, String> getHeader(CosmosItemRequestOptions cosmosItemRequestOptions) {
                return cosmosItemRequestOptions.getHeaders();
            }

            @Override
            public CosmosDiagnosticsThresholds getDiagnosticsThresholds(CosmosItemRequestOptions cosmosItemRequestOptions) {
                return cosmosItemRequestOptions.thresholds;
            }

            @Override
            public CosmosItemRequestOptions setNonIdempotentWriteRetryPolicy(CosmosItemRequestOptions cosmosItemRequestOptions, boolean enabled, boolean useTrackingIds) {
                return cosmosItemRequestOptions.setNonIdempotentWriteRetryPolicy(enabled, useTrackingIds);
            }

            @Override
            public WriteRetryPolicy calculateAndGetEffectiveNonIdempotentRetriesEnabled(CosmosItemRequestOptions cosmosItemRequestOptions, WriteRetryPolicy clientDefault, boolean operationDefault) {
                if (cosmosItemRequestOptions.nonIdempotentWriteRetriesEnabled != null) {
                    return new WriteRetryPolicy(cosmosItemRequestOptions.nonIdempotentWriteRetriesEnabled, cosmosItemRequestOptions.useTrackingIds);
                }
                if (!operationDefault) {
                    cosmosItemRequestOptions.setNonIdempotentWriteRetryPolicy(false, false);
                    return WriteRetryPolicy.DISABLED;
                }
                if (clientDefault != null) {
                    if (clientDefault.isEnabled()) {
                        cosmosItemRequestOptions.setNonIdempotentWriteRetryPolicy(true, clientDefault.useTrackingIdProperty());
                    } else {
                        cosmosItemRequestOptions.setNonIdempotentWriteRetryPolicy(false, false);
                    }
                    return clientDefault;
                }
                cosmosItemRequestOptions.setNonIdempotentWriteRetryPolicy(false, false);
                return WriteRetryPolicy.DISABLED;
            }
        });
    }

    static {
        CosmosItemRequestOptions.initialize();
    }
}

