/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DiagnosticsInstantSerializer;
import com.azure.cosmos.implementation.DiagnosticsProviderJvmFatalErrorMapper;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.MetadataDiagnosticsContext;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.SerializationDiagnosticsContext;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.cpu.CpuMemoryMonitor;
import com.azure.cosmos.implementation.directconnectivity.StoreResponseDiagnostics;
import com.azure.cosmos.implementation.directconnectivity.StoreResultDiagnostics;
import com.azure.cosmos.implementation.faultinjection.FaultInjectionRequestContext;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

@JsonSerialize(using=ClientSideRequestStatisticsSerializer.class)
public class ClientSideRequestStatistics {
    private static final int MAX_SUPPLEMENTAL_REQUESTS_FOR_TO_STRING = 10;
    private final DiagnosticsClientContext.DiagnosticsClientConfig diagnosticsClientConfig;
    private String activityId;
    private List<StoreResponseStatistics> responseStatisticsList;
    private List<StoreResponseStatistics> supplementalResponseStatisticsList;
    private Map<String, AddressResolutionStatistics> addressResolutionStatistics;
    private List<URI> contactedReplicas;
    private Set<URI> failedReplicas;
    private Instant requestStartTimeUTC;
    private Instant requestEndTimeUTC;
    private Set<String> regionsContacted;
    private Set<URI> locationEndpointsContacted;
    private RetryContext retryContext;
    private FaultInjectionRequestContext requestContext;
    private GatewayStatistics gatewayStatistics;
    private MetadataDiagnosticsContext metadataDiagnosticsContext;
    private SerializationDiagnosticsContext serializationDiagnosticsContext;
    private int requestPayloadSizeInBytes = 0;
    private final String userAgent;
    private double samplingRateSnapshot = 1.0;

    public ClientSideRequestStatistics(DiagnosticsClientContext diagnosticsClientContext) {
        this.diagnosticsClientConfig = diagnosticsClientContext.getConfig();
        this.requestStartTimeUTC = Instant.now();
        this.requestEndTimeUTC = Instant.now();
        this.responseStatisticsList = new ArrayList<StoreResponseStatistics>();
        this.supplementalResponseStatisticsList = new ArrayList<StoreResponseStatistics>();
        this.addressResolutionStatistics = new HashMap<String, AddressResolutionStatistics>();
        this.contactedReplicas = Collections.synchronizedList(new ArrayList());
        this.failedReplicas = Collections.synchronizedSet(new HashSet());
        this.regionsContacted = Collections.synchronizedSet(new HashSet());
        this.locationEndpointsContacted = Collections.synchronizedSet(new HashSet());
        this.metadataDiagnosticsContext = new MetadataDiagnosticsContext();
        this.serializationDiagnosticsContext = new SerializationDiagnosticsContext();
        this.retryContext = new RetryContext();
        this.requestPayloadSizeInBytes = 0;
        this.userAgent = diagnosticsClientContext.getUserAgent();
        this.samplingRateSnapshot = 1.0;
    }

    public ClientSideRequestStatistics(ClientSideRequestStatistics toBeCloned) {
        this.diagnosticsClientConfig = toBeCloned.diagnosticsClientConfig;
        this.requestStartTimeUTC = toBeCloned.requestStartTimeUTC;
        this.requestEndTimeUTC = toBeCloned.requestEndTimeUTC;
        this.responseStatisticsList = new ArrayList<StoreResponseStatistics>(toBeCloned.responseStatisticsList);
        this.supplementalResponseStatisticsList = new ArrayList<StoreResponseStatistics>(toBeCloned.supplementalResponseStatisticsList);
        this.addressResolutionStatistics = new HashMap<String, AddressResolutionStatistics>(toBeCloned.addressResolutionStatistics);
        this.contactedReplicas = Collections.synchronizedList(new ArrayList<URI>(toBeCloned.contactedReplicas));
        this.failedReplicas = Collections.synchronizedSet(new HashSet<URI>(toBeCloned.failedReplicas));
        this.regionsContacted = Collections.synchronizedSet(new HashSet<String>(toBeCloned.regionsContacted));
        this.locationEndpointsContacted = Collections.synchronizedSet(new HashSet<URI>(toBeCloned.locationEndpointsContacted));
        this.metadataDiagnosticsContext = new MetadataDiagnosticsContext(toBeCloned.metadataDiagnosticsContext);
        this.serializationDiagnosticsContext = new SerializationDiagnosticsContext(toBeCloned.serializationDiagnosticsContext);
        this.retryContext = new RetryContext(toBeCloned.retryContext);
        this.requestPayloadSizeInBytes = toBeCloned.requestPayloadSizeInBytes;
        this.userAgent = toBeCloned.userAgent;
        this.samplingRateSnapshot = toBeCloned.samplingRateSnapshot;
    }

    @JsonIgnore
    public Duration getDuration() {
        if (this.requestStartTimeUTC == null || this.requestEndTimeUTC == null || this.requestEndTimeUTC.isBefore(this.requestStartTimeUTC)) {
            return null;
        }
        if (this.requestStartTimeUTC == this.requestEndTimeUTC) {
            return Duration.ZERO;
        }
        return Duration.between(this.requestStartTimeUTC, this.requestEndTimeUTC);
    }

    public Instant getRequestStartTimeUTC() {
        return this.requestStartTimeUTC;
    }

    public Instant getRequestEndTimeUTC() {
        return this.requestEndTimeUTC;
    }

    public DiagnosticsClientContext.DiagnosticsClientConfig getDiagnosticsClientConfig() {
        return this.diagnosticsClientConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordResponse(RxDocumentServiceRequest request, StoreResultDiagnostics storeResultDiagnostics, GlobalEndpointManager globalEndpointManager) {
        Objects.requireNonNull(request, "request is required and cannot be null.");
        Instant responseTime = Instant.now();
        StoreResponseStatistics storeResponseStatistics = new StoreResponseStatistics();
        storeResponseStatistics.requestStartTimeUTC = this.requestStartTimeUTC;
        storeResponseStatistics.requestResponseTimeUTC = responseTime;
        storeResponseStatistics.storeResult = storeResultDiagnostics;
        storeResponseStatistics.requestOperationType = request.getOperationType();
        storeResponseStatistics.requestResourceType = request.getResourceType();
        storeResponseStatistics.requestSessionToken = request.getHeaders().get("x-ms-session-token");
        this.activityId = request.getActivityId().toString();
        this.requestPayloadSizeInBytes = request.getContentLength();
        URI locationEndPoint = null;
        if (request.requestContext != null && request.requestContext.locationEndpointToRoute != null) {
            locationEndPoint = request.requestContext.locationEndpointToRoute;
        }
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            if (responseTime.isAfter(this.requestEndTimeUTC)) {
                this.requestEndTimeUTC = responseTime;
            }
            if (locationEndPoint != null) {
                storeResponseStatistics.regionName = globalEndpointManager.getRegionName(locationEndPoint, request.getOperationType());
                this.regionsContacted.add(storeResponseStatistics.regionName);
                this.locationEndpointsContacted.add(locationEndPoint);
            }
            if (storeResponseStatistics.requestOperationType == OperationType.Head || storeResponseStatistics.requestOperationType == OperationType.HeadFeed) {
                this.supplementalResponseStatisticsList.add(storeResponseStatistics);
            } else {
                this.responseStatisticsList.add(storeResponseStatistics);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordGatewayResponse(RxDocumentServiceRequest rxDocumentServiceRequest, StoreResponseDiagnostics storeResponseDiagnostics, GlobalEndpointManager globalEndpointManager) {
        Instant responseTime = Instant.now();
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            if (responseTime.isAfter(this.requestEndTimeUTC)) {
                this.requestEndTimeUTC = responseTime;
            }
            URI locationEndPoint = null;
            if (rxDocumentServiceRequest != null && rxDocumentServiceRequest.requestContext != null) {
                locationEndPoint = rxDocumentServiceRequest.requestContext.locationEndpointToRoute;
            }
            this.recordRetryContextEndTime();
            if (locationEndPoint != null) {
                this.regionsContacted.add(globalEndpointManager.getRegionName(locationEndPoint, rxDocumentServiceRequest.getOperationType()));
                this.locationEndpointsContacted.add(locationEndPoint);
            }
            this.gatewayStatistics = new GatewayStatistics();
            if (rxDocumentServiceRequest != null) {
                this.gatewayStatistics.operationType = rxDocumentServiceRequest.getOperationType();
                this.gatewayStatistics.resourceType = rxDocumentServiceRequest.getResourceType();
                this.requestPayloadSizeInBytes = rxDocumentServiceRequest.getContentLength();
            }
            this.gatewayStatistics.statusCode = storeResponseDiagnostics.getStatusCode();
            this.gatewayStatistics.subStatusCode = storeResponseDiagnostics.getSubStatusCode();
            this.gatewayStatistics.sessionToken = storeResponseDiagnostics.getSessionTokenAsString();
            this.gatewayStatistics.requestCharge = storeResponseDiagnostics.getRequestCharge();
            this.gatewayStatistics.requestTimeline = storeResponseDiagnostics.getRequestTimeline();
            this.gatewayStatistics.partitionKeyRangeId = storeResponseDiagnostics.getPartitionKeyRangeId();
            this.gatewayStatistics.exceptionMessage = storeResponseDiagnostics.getExceptionMessage();
            this.gatewayStatistics.exceptionResponseHeaders = storeResponseDiagnostics.getExceptionResponseHeaders();
            this.gatewayStatistics.responsePayloadSizeInBytes = storeResponseDiagnostics.getResponsePayloadLength();
            this.activityId = storeResponseDiagnostics.getActivityId();
        }
    }

    public int getRequestPayloadSizeInBytes() {
        return this.requestPayloadSizeInBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String recordAddressResolutionStart(URI targetEndpoint, boolean forceRefresh, boolean forceCollectionRoutingMapRefresh) {
        String identifier = UUID.randomUUID().toString();
        AddressResolutionStatistics resolutionStatistics = new AddressResolutionStatistics();
        resolutionStatistics.startTimeUTC = Instant.now();
        resolutionStatistics.endTimeUTC = null;
        resolutionStatistics.targetEndpoint = targetEndpoint == null ? "<NULL>" : targetEndpoint.toString();
        resolutionStatistics.forceRefresh = forceRefresh;
        resolutionStatistics.forceCollectionRoutingMapRefresh = forceCollectionRoutingMapRefresh;
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            this.addressResolutionStatistics.put(identifier, resolutionStatistics);
        }
        return identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordAddressResolutionEnd(String identifier, String exceptionMessage) {
        if (StringUtils.isEmpty(identifier)) {
            return;
        }
        Instant responseTime = Instant.now();
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            if (!this.addressResolutionStatistics.containsKey(identifier)) {
                throw new IllegalArgumentException("Identifier " + identifier + " does not exist. Please call start before calling end");
            }
            if (responseTime.isAfter(this.requestEndTimeUTC)) {
                this.requestEndTimeUTC = responseTime;
            }
            AddressResolutionStatistics resolutionStatistics = this.addressResolutionStatistics.get(identifier);
            resolutionStatistics.endTimeUTC = responseTime;
            resolutionStatistics.exceptionMessage = exceptionMessage;
            resolutionStatistics.inflightRequest = false;
        }
    }

    private void mergeContactedReplicas(List<URI> otherContactedReplicas) {
        if (otherContactedReplicas == null) {
            return;
        }
        if (this.contactedReplicas == null || this.contactedReplicas.isEmpty()) {
            this.contactedReplicas = otherContactedReplicas;
            return;
        }
        LinkedHashSet<URI> totalContactedReplicas = new LinkedHashSet<URI>();
        totalContactedReplicas.addAll(otherContactedReplicas);
        totalContactedReplicas.addAll(this.contactedReplicas);
        this.setContactedReplicas(new ArrayList<URI>(totalContactedReplicas));
    }

    private void mergeSupplementalResponses(List<StoreResponseStatistics> other) {
        if (other == null) {
            return;
        }
        if (this.supplementalResponseStatisticsList == null || this.supplementalResponseStatisticsList.isEmpty()) {
            this.supplementalResponseStatisticsList = other;
            return;
        }
        this.supplementalResponseStatisticsList.addAll(other);
    }

    private void mergeResponseStatistics(List<StoreResponseStatistics> other) {
        if (other == null) {
            return;
        }
        if (this.responseStatisticsList == null || this.responseStatisticsList.isEmpty()) {
            this.responseStatisticsList = other;
            return;
        }
        this.responseStatisticsList.addAll(other);
        this.responseStatisticsList.sort((left, right) -> {
            if (left == null || ((StoreResponseStatistics)left).requestStartTimeUTC == null) {
                return -1;
            }
            if (right == null || ((StoreResponseStatistics)right).requestStartTimeUTC == null) {
                return 1;
            }
            return ((StoreResponseStatistics)left).requestStartTimeUTC.compareTo(((StoreResponseStatistics)right).requestStartTimeUTC);
        });
    }

    private void mergeAddressResolutionStatistics(Map<String, AddressResolutionStatistics> otherAddressResolutionStatistics) {
        if (otherAddressResolutionStatistics == null) {
            return;
        }
        if (this.addressResolutionStatistics == null || this.addressResolutionStatistics.isEmpty()) {
            this.addressResolutionStatistics = otherAddressResolutionStatistics;
            return;
        }
        for (Map.Entry<String, AddressResolutionStatistics> pair : otherAddressResolutionStatistics.entrySet()) {
            this.addressResolutionStatistics.putIfAbsent(pair.getKey(), pair.getValue());
        }
    }

    private void mergeFailedReplica(Set<URI> other) {
        if (other == null) {
            return;
        }
        if (this.failedReplicas == null || this.failedReplicas.isEmpty()) {
            this.failedReplicas = other;
            return;
        }
        for (URI uri : other) {
            this.failedReplicas.add(uri);
        }
    }

    private void mergeLocationEndpointsContacted(Set<URI> other) {
        if (other == null) {
            return;
        }
        if (this.locationEndpointsContacted == null || this.locationEndpointsContacted.isEmpty()) {
            this.locationEndpointsContacted = other;
            return;
        }
        for (URI uri : other) {
            this.locationEndpointsContacted.add(uri);
        }
    }

    private void mergeRegionsContacted(Set<String> other) {
        if (other == null) {
            return;
        }
        if (this.regionsContacted == null || this.regionsContacted.isEmpty()) {
            this.regionsContacted = other;
            return;
        }
        for (String region : other) {
            this.regionsContacted.add(region);
        }
    }

    private void mergeStartTime(Instant other) {
        if (other == null) {
            return;
        }
        if (this.requestStartTimeUTC == null || this.requestStartTimeUTC.isAfter(other)) {
            this.requestStartTimeUTC = other;
        }
    }

    private void mergeEndTime(Instant other) {
        if (other == null || this.requestEndTimeUTC == null) {
            return;
        }
        if (this.requestEndTimeUTC.isBefore(other)) {
            this.requestEndTimeUTC = other;
        }
    }

    public void recordContributingPointOperation(ClientSideRequestStatistics other) {
        if (other == null) {
            return;
        }
        this.mergeAddressResolutionStatistics(other.addressResolutionStatistics);
        this.mergeContactedReplicas(other.contactedReplicas);
        this.mergeFailedReplica(other.failedReplicas);
        this.mergeLocationEndpointsContacted(other.locationEndpointsContacted);
        this.mergeRegionsContacted(other.regionsContacted);
        this.mergeStartTime(other.requestStartTimeUTC);
        this.mergeEndTime(other.requestEndTimeUTC);
        this.mergeSupplementalResponses(other.supplementalResponseStatisticsList);
        this.mergeResponseStatistics(other.responseStatisticsList);
        this.requestPayloadSizeInBytes = Math.max(this.requestPayloadSizeInBytes, other.requestPayloadSizeInBytes);
        if (this.retryContext == null) {
            this.retryContext = other.retryContext;
        } else {
            this.retryContext.merge(other.retryContext);
        }
    }

    public List<URI> getContactedReplicas() {
        return this.contactedReplicas;
    }

    public void setContactedReplicas(List<URI> contactedReplicas) {
        this.contactedReplicas = Collections.synchronizedList(contactedReplicas);
    }

    public Set<URI> getFailedReplicas() {
        return this.failedReplicas;
    }

    public void setFailedReplicas(Set<URI> failedReplicas) {
        this.failedReplicas = Collections.synchronizedSet(failedReplicas);
    }

    public Set<String> getContactedRegionNames() {
        return this.regionsContacted;
    }

    public void setRegionsContacted(Set<String> regionsContacted) {
        this.regionsContacted = Collections.synchronizedSet(regionsContacted);
    }

    public Set<URI> getLocationEndpointsContacted() {
        return this.locationEndpointsContacted;
    }

    public void setLocationEndpointsContacted(Set<URI> locationEndpointsContacted) {
        this.locationEndpointsContacted = locationEndpointsContacted;
    }

    public MetadataDiagnosticsContext getMetadataDiagnosticsContext() {
        return this.metadataDiagnosticsContext;
    }

    public SerializationDiagnosticsContext getSerializationDiagnosticsContext() {
        return this.serializationDiagnosticsContext;
    }

    public void recordRetryContextEndTime() {
        this.retryContext.updateEndTime();
    }

    public RetryContext getRetryContext() {
        return this.retryContext;
    }

    public List<StoreResponseStatistics> getResponseStatisticsList() {
        return this.responseStatisticsList;
    }

    @JsonIgnore
    public String getUserAgent() {
        return this.userAgent;
    }

    public int getMaxResponsePayloadSizeInBytes() {
        if (this.responseStatisticsList == null || this.responseStatisticsList.isEmpty()) {
            if (this.gatewayStatistics != null) {
                return this.gatewayStatistics.responsePayloadSizeInBytes;
            }
            return 0;
        }
        int maxResponsePayloadSizeInBytes = 0;
        int currentResponsePayloadSizeInBytes = 0;
        for (StoreResponseStatistics responseDiagnostic : this.responseStatisticsList) {
            StoreResponseDiagnostics storeResponseDiagnostics;
            StoreResultDiagnostics storeResultDiagnostics = responseDiagnostic.getStoreResult();
            if (storeResultDiagnostics == null || (storeResponseDiagnostics = storeResultDiagnostics.getStoreResponseDiagnostics()) == null || (currentResponsePayloadSizeInBytes = storeResponseDiagnostics.getResponsePayloadLength()) <= maxResponsePayloadSizeInBytes) continue;
            maxResponsePayloadSizeInBytes = currentResponsePayloadSizeInBytes;
        }
        return maxResponsePayloadSizeInBytes;
    }

    public List<StoreResponseStatistics> getSupplementalResponseStatisticsList() {
        return this.supplementalResponseStatisticsList;
    }

    public Map<String, AddressResolutionStatistics> getAddressResolutionStatistics() {
        return this.addressResolutionStatistics;
    }

    public GatewayStatistics getGatewayStatistics() {
        return this.gatewayStatistics;
    }

    public ClientSideRequestStatistics setSamplingRateSnapshot(double samplingRateSnapshot) {
        this.samplingRateSnapshot = samplingRateSnapshot;
        return this;
    }

    public static List<StoreResponseStatistics> getCappedSupplementalResponseStatisticsList(List<StoreResponseStatistics> supplementalResponseStatisticsList) {
        int supplementalResponseStatisticsListCount = supplementalResponseStatisticsList.size();
        int initialIndex = Math.max(supplementalResponseStatisticsListCount - 10, 0);
        if (initialIndex != 0) {
            List<StoreResponseStatistics> subList = supplementalResponseStatisticsList.subList(initialIndex, supplementalResponseStatisticsListCount);
            return subList;
        }
        return supplementalResponseStatisticsList;
    }

    public static SystemInformation fetchSystemInformation() {
        SystemInformation systemInformation = new SystemInformation();
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory() / 1024L;
        long freeMemory = runtime.freeMemory() / 1024L;
        long maxMemory = runtime.maxMemory() / 1024L;
        systemInformation.usedMemory = totalMemory - freeMemory + " KB";
        systemInformation.availableMemory = maxMemory - (totalMemory - freeMemory) + " KB";
        systemInformation.availableProcessors = runtime.availableProcessors();
        systemInformation.systemCpuLoad = CpuMemoryMonitor.getCpuLoad().toString();
        return systemInformation;
    }

    public static class GatewayStatistics {
        private String sessionToken;
        private OperationType operationType;
        private ResourceType resourceType;
        private int statusCode;
        private int subStatusCode;
        private double requestCharge;
        private RequestTimeline requestTimeline;
        private String partitionKeyRangeId;
        private String exceptionMessage;
        private String exceptionResponseHeaders;
        private int responsePayloadSizeInBytes;

        public String getSessionToken() {
            return this.sessionToken;
        }

        public OperationType getOperationType() {
            return this.operationType;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public int getSubStatusCode() {
            return this.subStatusCode;
        }

        public double getRequestCharge() {
            return this.requestCharge;
        }

        public RequestTimeline getRequestTimeline() {
            return this.requestTimeline;
        }

        public ResourceType getResourceType() {
            return this.resourceType;
        }

        public String getPartitionKeyRangeId() {
            return this.partitionKeyRangeId;
        }

        public String getExceptionMessage() {
            return this.exceptionMessage;
        }

        public String getExceptionResponseHeaders() {
            return this.exceptionResponseHeaders;
        }

        public int getResponsePayloadSizeInBytes() {
            return this.responsePayloadSizeInBytes;
        }
    }

    public static class StoreResponseStatistics {
        @JsonSerialize(using=StoreResultDiagnostics.StoreResultDiagnosticsSerializer.class)
        private StoreResultDiagnostics storeResult;
        @JsonSerialize(using=DiagnosticsInstantSerializer.class)
        private Instant requestResponseTimeUTC;
        @JsonSerialize(using=DiagnosticsInstantSerializer.class)
        private Instant requestStartTimeUTC;
        @JsonSerialize
        private ResourceType requestResourceType;
        @JsonSerialize
        private OperationType requestOperationType;
        @JsonSerialize
        private String requestSessionToken;
        @JsonIgnore
        private String regionName;

        public StoreResultDiagnostics getStoreResult() {
            return this.storeResult;
        }

        public Instant getRequestResponseTimeUTC() {
            return this.requestResponseTimeUTC;
        }

        public ResourceType getRequestResourceType() {
            return this.requestResourceType;
        }

        public OperationType getRequestOperationType() {
            return this.requestOperationType;
        }

        public String getRegionName() {
            return this.regionName;
        }

        public String getRequestSessionToken() {
            return this.requestSessionToken;
        }

        @JsonIgnore
        public Duration getDuration() {
            if (this.requestStartTimeUTC == null || this.requestResponseTimeUTC == null || this.requestResponseTimeUTC.isBefore(this.requestStartTimeUTC)) {
                return null;
            }
            if (this.requestStartTimeUTC == this.requestResponseTimeUTC) {
                return Duration.ZERO;
            }
            return Duration.between(this.requestStartTimeUTC, this.requestResponseTimeUTC);
        }
    }

    public static class AddressResolutionStatistics {
        @JsonSerialize(using=DiagnosticsInstantSerializer.class)
        private Instant startTimeUTC;
        @JsonSerialize(using=DiagnosticsInstantSerializer.class)
        private Instant endTimeUTC;
        @JsonSerialize
        private String targetEndpoint;
        @JsonSerialize
        private String exceptionMessage;
        @JsonSerialize
        private boolean forceRefresh;
        @JsonSerialize
        private boolean forceCollectionRoutingMapRefresh;
        @JsonSerialize
        private boolean inflightRequest = true;

        public Instant getStartTimeUTC() {
            return this.startTimeUTC;
        }

        public Instant getEndTimeUTC() {
            return this.endTimeUTC;
        }

        public String getTargetEndpoint() {
            return this.targetEndpoint;
        }

        public String getExceptionMessage() {
            return this.exceptionMessage;
        }

        public boolean isInflightRequest() {
            return this.inflightRequest;
        }

        public boolean isForceRefresh() {
            return this.forceRefresh;
        }

        public boolean isForceCollectionRoutingMapRefresh() {
            return this.forceCollectionRoutingMapRefresh;
        }
    }

    public static class SystemInformation {
        private String usedMemory;
        private String availableMemory;
        private String systemCpuLoad;
        private int availableProcessors;

        public String getUsedMemory() {
            return this.usedMemory;
        }

        public String getAvailableMemory() {
            return this.availableMemory;
        }

        public String getSystemCpuLoad() {
            return this.systemCpuLoad;
        }

        public int getAvailableProcessors() {
            return this.availableProcessors;
        }
    }

    public static class ClientSideRequestStatisticsSerializer
    extends StdSerializer<ClientSideRequestStatistics> {
        private static final long serialVersionUID = -2746532297176812860L;

        ClientSideRequestStatisticsSerializer() {
            super(ClientSideRequestStatistics.class);
        }

        public void serialize(ClientSideRequestStatistics statistics, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            Duration duration = statistics.getDuration();
            long requestLatency = duration != null ? duration.toMillis() : 0L;
            generator.writeStringField("userAgent", statistics.userAgent);
            generator.writeStringField("activityId", statistics.activityId);
            generator.writeNumberField("requestLatencyInMs", requestLatency);
            generator.writeStringField("requestStartTimeUTC", DiagnosticsInstantSerializer.fromInstant(statistics.requestStartTimeUTC));
            generator.writeStringField("requestEndTimeUTC", DiagnosticsInstantSerializer.fromInstant(statistics.requestEndTimeUTC));
            generator.writeObjectField("responseStatisticsList", (Object)statistics.responseStatisticsList);
            generator.writeObjectField("supplementalResponseStatisticsList", ClientSideRequestStatistics.getCappedSupplementalResponseStatisticsList(statistics.supplementalResponseStatisticsList));
            generator.writeObjectField("addressResolutionStatistics", (Object)statistics.addressResolutionStatistics);
            generator.writeObjectField("regionsContacted", (Object)statistics.regionsContacted);
            generator.writeObjectField("retryContext", (Object)statistics.retryContext);
            generator.writeObjectField("metadataDiagnosticsContext", (Object)statistics.getMetadataDiagnosticsContext());
            generator.writeObjectField("serializationDiagnosticsContext", (Object)statistics.getSerializationDiagnosticsContext());
            generator.writeObjectField("gatewayStatistics", (Object)statistics.gatewayStatistics);
            generator.writeObjectField("samplingRateSnapshot", (Object)statistics.samplingRateSnapshot);
            try {
                SystemInformation systemInformation = ClientSideRequestStatistics.fetchSystemInformation();
                generator.writeObjectField("systemInformation", (Object)systemInformation);
            }
            catch (Exception systemInformation) {
                // empty catch block
            }
            long diagnosticsProviderFatalErrorExecutionCount = DiagnosticsProviderJvmFatalErrorMapper.getMapper().getMapperExecutionCount();
            if (diagnosticsProviderFatalErrorExecutionCount > 0L) {
                generator.writeNumberField("jvmFatalErrorMapperExecutionCount", diagnosticsProviderFatalErrorExecutionCount);
            }
            generator.writeObjectField("clientCfgs", (Object)statistics.diagnosticsClientConfig);
            generator.writeEndObject();
        }
    }
}

