/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.IRetryPolicy;
import com.azure.cosmos.implementation.OpenConnectionResponse;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.ShouldRetryResult;
import com.azure.cosmos.implementation.directconnectivity.TimeoutHelper;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class OpenConnectionTask
extends CompletableFuture<OpenConnectionResponse> {
    private final String collectionRid;
    private final URI serviceEndpoint;
    private final Uri addressUri;
    private int minConnectionsRequiredForEndpoint;
    private final IRetryPolicy retryPolicy;

    public OpenConnectionTask(String collectionRid, URI serviceEndpoint, Uri addressUri, int minConnectionsRequiredForEndpoint) {
        this.collectionRid = collectionRid;
        this.serviceEndpoint = serviceEndpoint;
        this.addressUri = addressUri;
        this.minConnectionsRequiredForEndpoint = minConnectionsRequiredForEndpoint;
        this.retryPolicy = new ProactiveOpenConnectionsRetryPolicy();
    }

    public String getCollectionRid() {
        return this.collectionRid;
    }

    public URI getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public Uri getAddressUri() {
        return this.addressUri;
    }

    public int getMinConnectionsRequiredForEndpoint() {
        return this.minConnectionsRequiredForEndpoint;
    }

    public void setMinConnectionsRequiredForEndpoint(int minConnectionsRequiredForEndpoint) {
        this.minConnectionsRequiredForEndpoint = minConnectionsRequiredForEndpoint;
    }

    public IRetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    private static class ProactiveOpenConnectionsRetryPolicy
    implements IRetryPolicy {
        private static final Logger logger = LoggerFactory.getLogger(ProactiveOpenConnectionsRetryPolicy.class);
        private static final int MAX_RETRY_ATTEMPTS = 2;
        private static final Duration INITIAL_OPEN_CONNECTION_REATTEMPT_BACK_OFF_IN_MS = Duration.ofMillis(1000L);
        private static final Duration MAX_FAILED_OPEN_CONNECTION_RETRY_WINDOW_IN_MS = Duration.ofMillis(15000L);
        private static final int BACKOFF_MULTIPLIER = 4;
        private Duration currentBackoff;
        private final TimeoutHelper waitTimeTimeoutHelper = new TimeoutHelper(MAX_FAILED_OPEN_CONNECTION_RETRY_WINDOW_IN_MS);
        private final AtomicInteger retryCount = new AtomicInteger(0);

        private ProactiveOpenConnectionsRetryPolicy() {
            this.currentBackoff = INITIAL_OPEN_CONNECTION_REATTEMPT_BACK_OFF_IN_MS;
        }

        @Override
        public Mono<ShouldRetryResult> shouldRetry(Exception e) {
            if (this.retryCount.get() >= 2 || this.waitTimeTimeoutHelper.isElapsed() || e == null) {
                logger.debug("In retry policy: ProactiveOpenConnectionsRetryPolicy, retry attempt will not be performed");
                return Mono.just((Object)ShouldRetryResult.noRetry());
            }
            logger.debug("In retry policy: ProactiveOpenConnectionsRetryPolicy, retry attempt: {}, exception :{}", (Object)this.retryCount.get(), (Object)e.getMessage());
            this.retryCount.incrementAndGet();
            Duration effectiveBackoff = ProactiveOpenConnectionsRetryPolicy.getEffectiveBackoff(this.currentBackoff, this.waitTimeTimeoutHelper.getRemainingTime());
            this.currentBackoff = ProactiveOpenConnectionsRetryPolicy.getEffectiveBackoff(Duration.ofMillis(this.currentBackoff.toMillis() * 4L), MAX_FAILED_OPEN_CONNECTION_RETRY_WINDOW_IN_MS);
            return Mono.just((Object)ShouldRetryResult.retryAfter(effectiveBackoff));
        }

        @Override
        public RetryContext getRetryContext() {
            return null;
        }

        private static Duration getEffectiveBackoff(Duration backoff, Duration remainingTime) {
            if (backoff.compareTo(remainingTime) > 0) {
                return remainingTime;
            }
            return backoff;
        }
    }
}

