/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.core.http.ProxyOptions;
import com.azure.core.util.MetricsOptions;
import com.azure.core.util.TracingOptions;
import com.azure.core.util.tracing.Tracer;
import com.azure.core.util.tracing.TracerProvider;
import com.azure.cosmos.CosmosDiagnosticsHandler;
import com.azure.cosmos.CosmosDiagnosticsThresholds;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.HttpConstants;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.clienttelemetry.ClientTelemetry;
import com.azure.cosmos.implementation.clienttelemetry.CosmosMeterOptions;
import com.azure.cosmos.implementation.clienttelemetry.MetricCategory;
import com.azure.cosmos.implementation.clienttelemetry.TagName;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosMetricName;
import com.azure.cosmos.models.CosmosMicrometerMetricsOptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CosmosClientTelemetryConfig {
    private static final Logger logger = LoggerFactory.getLogger(CosmosClientTelemetryConfig.class);
    private static final Duration DEFAULT_NETWORK_REQUEST_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_IDLE_CONNECTION_TIMEOUT = Duration.ofSeconds(60L);
    private static final int DEFAULT_MAX_CONNECTION_POOL_SIZE = 1000;
    private Boolean clientTelemetryEnabled = null;
    private final Duration httpNetworkRequestTimeout;
    private final int maxConnectionPoolSize;
    private final Duration idleHttpConnectionTimeout;
    private final ProxyOptions proxy;
    private String clientCorrelationId = null;
    private EnumSet<TagName> metricTagNamesOverride = null;
    private boolean isClientMetricsEnabled = false;
    private final HashSet<CosmosDiagnosticsHandler> customDiagnosticHandlers;
    private final CopyOnWriteArrayList<CosmosDiagnosticsHandler> diagnosticHandlers;
    private boolean useLegacyOpenTelemetryTracing = Configs.useLegacyTracing();
    private boolean isTransportLevelTracingEnabled = false;
    private Tag clientCorrelationTag;
    private String accountName;
    private ClientTelemetry clientTelemetry;
    private Boolean effectiveIsClientTelemetryEnabled = null;
    private CosmosMicrometerMetricsOptions micrometerMetricsOptions = null;
    private CosmosDiagnosticsThresholds diagnosticsThresholds = new CosmosDiagnosticsThresholds();
    private Tracer tracer = null;
    private TracingOptions tracingOptions = null;
    private double samplingRate = 1.0;

    public CosmosClientTelemetryConfig() {
        this.httpNetworkRequestTimeout = DEFAULT_NETWORK_REQUEST_TIMEOUT;
        this.maxConnectionPoolSize = 1000;
        this.idleHttpConnectionTimeout = DEFAULT_IDLE_CONNECTION_TIMEOUT;
        this.proxy = this.getProxyOptions();
        this.customDiagnosticHandlers = new HashSet();
        this.diagnosticHandlers = new CopyOnWriteArrayList();
    }

    public CosmosClientTelemetryConfig sendClientTelemetryToService(boolean enabled) {
        this.clientTelemetryEnabled = enabled;
        return this;
    }

    Boolean isSendClientTelemetryToServiceEnabled() {
        Boolean effectiveSnapshot = this.effectiveIsClientTelemetryEnabled;
        Boolean currentSnapshot = this.clientTelemetryEnabled;
        return effectiveSnapshot != null ? effectiveSnapshot : currentSnapshot;
    }

    void resetIsSendClientTelemetryToServiceEnabled() {
        this.clientTelemetryEnabled = null;
    }

    void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    String getAccountName() {
        return this.accountName;
    }

    void setClientCorrelationTag(Tag clientCorrelationTag) {
        this.clientCorrelationTag = clientCorrelationTag;
    }

    Tag getClientCorrelationTag() {
        return this.clientCorrelationTag;
    }

    void setUseLegacyOpenTelemetryTracing(boolean useLegacyTracing) {
        this.useLegacyOpenTelemetryTracing = useLegacyTracing;
    }

    public CosmosClientTelemetryConfig metricsOptions(MetricsOptions clientMetricsOptions) {
        Preconditions.checkNotNull(clientMetricsOptions, "expected non-null clientMetricsOptions");
        if (!(clientMetricsOptions instanceof CosmosMicrometerMetricsOptions)) {
            throw new IllegalArgumentException("Currently only MetricsOptions of type CosmosMicrometerMetricsOptions are supported");
        }
        CosmosMicrometerMetricsOptions candidate = (CosmosMicrometerMetricsOptions)clientMetricsOptions;
        if (this.metricTagNamesOverride != null && !this.metricTagNamesOverride.equals(candidate.getDefaultTagNames())) {
            if (TagName.DEFAULT_TAGS.equals(candidate.getDefaultTagNames())) {
                candidate.configureDefaultTagNames(this.metricTagNamesOverride);
            } else {
                throw new IllegalArgumentException("Tags for meters cannot be specified via the deprecated CosmosClientTelemetryConfig when they are also specified in CosmosMicrometerMetricOptions.");
            }
        }
        this.micrometerMetricsOptions = candidate;
        this.isClientMetricsEnabled = this.micrometerMetricsOptions.isEnabled();
        return this;
    }

    MeterRegistry getClientMetricRegistry() {
        if (this.micrometerMetricsOptions == null) {
            return null;
        }
        return this.micrometerMetricsOptions.getClientMetricRegistry();
    }

    public CosmosClientTelemetryConfig clientCorrelationId(String clientCorrelationId) {
        this.clientCorrelationId = clientCorrelationId;
        return this;
    }

    public CosmosClientTelemetryConfig diagnosticsThresholds(CosmosDiagnosticsThresholds thresholds) {
        Preconditions.checkNotNull(thresholds, "Argument 'thresholds' must not be null.");
        this.diagnosticsThresholds = thresholds;
        return this;
    }

    CosmosClientTelemetryConfig tracer(Tracer tracer) {
        this.tracer = tracer;
        return this;
    }

    public CosmosClientTelemetryConfig tracingOptions(TracingOptions tracingOptions) {
        this.tracingOptions = tracingOptions;
        return this;
    }

    CosmosDiagnosticsThresholds getDiagnosticsThresholds() {
        return this.diagnosticsThresholds;
    }

    String getClientCorrelationId() {
        return this.clientCorrelationId;
    }

    List<CosmosDiagnosticsHandler> getDiagnosticHandlers() {
        ArrayList<CosmosDiagnosticsHandler> snapshot = new ArrayList<CosmosDiagnosticsHandler>(this.diagnosticHandlers);
        snapshot.addAll(this.customDiagnosticHandlers);
        return snapshot;
    }

    @Deprecated
    public CosmosClientTelemetryConfig metricTagNames(String ... tagNames) {
        if (tagNames == null || tagNames.length == 0) {
            this.metricTagNamesOverride = TagName.DEFAULT_TAGS.clone();
        }
        HashMap<String, TagName> tagNameMap = new HashMap<String, TagName>();
        for (TagName tagName2 : TagName.values()) {
            tagNameMap.put(tagName2.toLowerCase(), tagName2);
        }
        Stream<TagName> tagNameStream = Arrays.stream(tagNames).filter(tagName -> !Strings.isNullOrWhiteSpace(tagName)).map(rawTagName -> rawTagName.toLowerCase(Locale.ROOT)).map(tagName -> {
            String trimmedTagName = tagName.trim();
            if (!tagNameMap.containsKey(trimmedTagName)) {
                String validTagNames = String.join((CharSequence)", ", (String[])Arrays.stream(TagName.values()).map(tag -> tag.toString()).toArray());
                throw new IllegalArgumentException(String.format("TagName '%s' is invalid. Valid tag names are: %s", tagName, validTagNames));
            }
            return (TagName)((Object)((Object)tagNameMap.get(trimmedTagName)));
        });
        EnumSet<TagName> newTagNames = EnumSet.noneOf(TagName.class);
        tagNameStream.forEach(tagName -> newTagNames.add((TagName)((Object)tagName)));
        this.metricTagNamesOverride = newTagNames;
        return this;
    }

    private CosmosClientTelemetryConfig setEffectiveIsClientTelemetryEnabled(boolean effectiveIsClientTelemetryEnabled) {
        this.effectiveIsClientTelemetryEnabled = effectiveIsClientTelemetryEnabled;
        return this;
    }

    Duration getHttpNetworkRequestTimeout() {
        return this.httpNetworkRequestTimeout;
    }

    int getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    Duration getIdleHttpConnectionTimeout() {
        return this.idleHttpConnectionTimeout;
    }

    ProxyOptions getProxy() {
        return this.proxy;
    }

    private ProxyOptions getProxyOptions() {
        String config = Configs.getClientTelemetryProxyOptionsConfig();
        if (StringUtils.isNotEmpty(config)) {
            try {
                JsonProxyOptionsConfig proxyOptionsConfig = (JsonProxyOptionsConfig)Utils.getSimpleObjectMapper().readValue(config, JsonProxyOptionsConfig.class);
                ProxyOptions.Type type = ProxyOptions.Type.valueOf((String)proxyOptionsConfig.type);
                if (type != ProxyOptions.Type.HTTP) {
                    throw new IllegalArgumentException("Only http proxy type is supported.");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Enable proxy with type {}, host {}, port {}, userName {}, password length {}", new Object[]{type, proxyOptionsConfig.host, proxyOptionsConfig.port, proxyOptionsConfig.username, proxyOptionsConfig.password != null ? proxyOptionsConfig.password.length() : -1});
                }
                ProxyOptions proxyOptions = new ProxyOptions(type, new InetSocketAddress(proxyOptionsConfig.host, proxyOptionsConfig.port));
                if (!Strings.isNullOrEmpty(proxyOptionsConfig.username) || !Strings.isNullOrEmpty(proxyOptionsConfig.password)) {
                    proxyOptions.setCredentials(proxyOptionsConfig.username != null ? proxyOptionsConfig.username : "", proxyOptionsConfig.password != null ? proxyOptionsConfig.password : "");
                }
                return proxyOptions;
            }
            catch (JsonProcessingException e) {
                logger.error("Failed to parse client telemetry proxy option config", (Throwable)e);
            }
        }
        return null;
    }

    public CosmosClientTelemetryConfig diagnosticsHandler(CosmosDiagnosticsHandler handler) {
        Preconditions.checkNotNull(handler, "Argument 'handler' must not be null.");
        this.customDiagnosticHandlers.add(handler);
        return this;
    }

    public CosmosClientTelemetryConfig enableTransportLevelTracing() {
        this.isTransportLevelTracingEnabled = true;
        return this;
    }

    public CosmosClientTelemetryConfig sampleDiagnostics(double samplingRate) {
        Preconditions.checkArgument(0.0 <= samplingRate && samplingRate <= 1.0, "The samplingRate must be between 0 and 1 (both inclusive).");
        this.samplingRate = samplingRate;
        return this;
    }

    Tracer getOrCreateTracer() {
        if (this.tracer != null) {
            return this.tracer;
        }
        return TracerProvider.getDefaultProvider().createTracer("azure-cosmos", HttpConstants.Versions.getSdkVersion(), "Microsoft.DocumentDB", this.tracingOptions);
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosClientTelemetryConfigHelper.setCosmosClientTelemetryConfigAccessor(new ImplementationBridgeHelpers.CosmosClientTelemetryConfigHelper.CosmosClientTelemetryConfigAccessor(){

            @Override
            public Duration getHttpNetworkRequestTimeout(CosmosClientTelemetryConfig config) {
                return config.getHttpNetworkRequestTimeout();
            }

            @Override
            public int getMaxConnectionPoolSize(CosmosClientTelemetryConfig config) {
                return config.getMaxConnectionPoolSize();
            }

            @Override
            public Duration getIdleHttpConnectionTimeout(CosmosClientTelemetryConfig config) {
                return config.getIdleHttpConnectionTimeout();
            }

            @Override
            public ProxyOptions getProxy(CosmosClientTelemetryConfig config) {
                return config.getProxy();
            }

            @Override
            public EnumSet<MetricCategory> getMetricCategories(CosmosClientTelemetryConfig config) {
                return config.micrometerMetricsOptions.getMetricCategories();
            }

            @Override
            public EnumSet<TagName> getMetricTagNames(CosmosClientTelemetryConfig config) {
                return config.micrometerMetricsOptions.getDefaultTagNames();
            }

            @Override
            public CosmosMeterOptions getMeterOptions(CosmosClientTelemetryConfig config, CosmosMetricName name) {
                if (config != null && config.micrometerMetricsOptions != null) {
                    return config.micrometerMetricsOptions.getMeterOptions(name);
                }
                return this.createDisabledMeterOptions(name);
            }

            @Override
            public CosmosMeterOptions createDisabledMeterOptions(CosmosMetricName name) {
                return new CosmosMeterOptions(name, false, new double[0], false, EnumSet.noneOf(TagName.class), false);
            }

            @Override
            public String getClientCorrelationId(CosmosClientTelemetryConfig config) {
                return config.getClientCorrelationId();
            }

            @Override
            public MeterRegistry getClientMetricRegistry(CosmosClientTelemetryConfig config) {
                return config.getClientMetricRegistry();
            }

            @Override
            public Boolean isSendClientTelemetryToServiceEnabled(CosmosClientTelemetryConfig config) {
                return config.isSendClientTelemetryToServiceEnabled();
            }

            @Override
            public boolean isClientMetricsEnabled(CosmosClientTelemetryConfig config) {
                return config.isClientMetricsEnabled;
            }

            @Override
            public CosmosClientTelemetryConfig createSnapshot(CosmosClientTelemetryConfig config, boolean effectiveIsClientTelemetryEnabled) {
                return config.setEffectiveIsClientTelemetryEnabled(effectiveIsClientTelemetryEnabled);
            }

            @Override
            public Collection<CosmosDiagnosticsHandler> getDiagnosticHandlers(CosmosClientTelemetryConfig config) {
                return config.getDiagnosticHandlers();
            }

            @Override
            public void setAccountName(CosmosClientTelemetryConfig config, String accountName) {
                config.setAccountName(accountName);
            }

            @Override
            public String getAccountName(CosmosClientTelemetryConfig config) {
                return config.getAccountName();
            }

            @Override
            public void setClientCorrelationTag(CosmosClientTelemetryConfig config, Tag clientCorrelationTag) {
                config.setClientCorrelationTag(clientCorrelationTag);
            }

            @Override
            public Tag getClientCorrelationTag(CosmosClientTelemetryConfig config) {
                return config.getClientCorrelationTag();
            }

            @Override
            public void setClientTelemetry(CosmosClientTelemetryConfig config, ClientTelemetry clientTelemetry) {
                config.clientTelemetry = clientTelemetry;
            }

            @Override
            public ClientTelemetry getClientTelemetry(CosmosClientTelemetryConfig config) {
                return config.clientTelemetry;
            }

            @Override
            public void addDiagnosticsHandler(CosmosClientTelemetryConfig config, CosmosDiagnosticsHandler handler) {
                config.diagnosticHandlers.add(handler);
            }

            @Override
            public void resetIsSendClientTelemetryToServiceEnabled(CosmosClientTelemetryConfig config) {
                config.resetIsSendClientTelemetryToServiceEnabled();
            }

            @Override
            public CosmosDiagnosticsThresholds getDiagnosticsThresholds(CosmosClientTelemetryConfig config) {
                return config.diagnosticsThresholds;
            }

            @Override
            public boolean isLegacyTracingEnabled(CosmosClientTelemetryConfig config) {
                return config.useLegacyOpenTelemetryTracing;
            }

            @Override
            public boolean isTransportLevelTracingEnabled(CosmosClientTelemetryConfig config) {
                return config.isTransportLevelTracingEnabled;
            }

            @Override
            public Tracer getOrCreateTracer(CosmosClientTelemetryConfig config) {
                return config.getOrCreateTracer();
            }

            @Override
            public void setUseLegacyTracing(CosmosClientTelemetryConfig config, boolean useLegacyTracing) {
                config.setUseLegacyOpenTelemetryTracing(useLegacyTracing);
            }

            @Override
            public void setTracer(CosmosClientTelemetryConfig config, Tracer tracer) {
                if (tracer != null) {
                    config.tracer = tracer;
                }
            }

            @Override
            public double getSamplingRate(CosmosClientTelemetryConfig config) {
                return config.samplingRate;
            }
        });
    }

    static {
        CosmosClientTelemetryConfig.initialize();
    }

    private static class JsonProxyOptionsConfig {
        @JsonProperty
        private String host;
        @JsonProperty
        private int port;
        @JsonProperty
        private String type;
        @JsonProperty
        private String username;
        @JsonProperty
        private String password;

        private JsonProxyOptionsConfig() {
        }

        private JsonProxyOptionsConfig(String host, int port, String type, String username, String password) {
            this.host = host;
            this.port = port;
            this.type = type;
            this.username = username;
            this.password = password;
        }
    }
}

