/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.directconnectivity.ContainerDirectConnectionMetadata;
import com.azure.cosmos.models.CosmosContainerIdentity;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class CosmosContainerProactiveInitConfig {
    private static final ImplementationBridgeHelpers.CosmosContainerIdentityHelper.CosmosContainerIdentityAccessor containerIdAccessor = ImplementationBridgeHelpers.CosmosContainerIdentityHelper.getCosmosContainerIdentityAccessor();
    private final List<CosmosContainerIdentity> cosmosContainerIdentities;
    private final Map<CosmosContainerIdentity, ContainerDirectConnectionMetadata> containerDirectConnectionMetadataMap;
    private final int numProactiveConnectionRegions;
    private final Duration aggressiveWarmupDuration;

    CosmosContainerProactiveInitConfig(int numProactiveConnectionRegions, Map<CosmosContainerIdentity, ContainerDirectConnectionMetadata> containerDirectConnectionMetadataMap, Duration aggressiveWarmupDuration) {
        this.cosmosContainerIdentities = new ArrayList<CosmosContainerIdentity>(containerDirectConnectionMetadataMap.keySet());
        this.numProactiveConnectionRegions = numProactiveConnectionRegions;
        this.containerDirectConnectionMetadataMap = containerDirectConnectionMetadataMap;
        this.aggressiveWarmupDuration = aggressiveWarmupDuration;
    }

    public List<CosmosContainerIdentity> getCosmosContainerIdentities() {
        return Collections.unmodifiableList(this.cosmosContainerIdentities);
    }

    public int getProactiveConnectionRegionsCount() {
        return this.numProactiveConnectionRegions;
    }

    Duration getAggressiveWarmupDuration() {
        return this.aggressiveWarmupDuration;
    }

    public String toString() {
        if (this.cosmosContainerIdentities == null || this.cosmosContainerIdentities.isEmpty()) {
            return "";
        }
        return String.format("%s(%d)", this.cosmosContainerIdentities.stream().map(ci -> String.join((CharSequence)".", containerIdAccessor.getDatabaseName((CosmosContainerIdentity)ci), containerIdAccessor.getContainerName((CosmosContainerIdentity)ci))).collect(Collectors.joining(",")), this.numProactiveConnectionRegions);
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosContainerProactiveInitConfigHelper.setCosmosContainerProactiveInitConfigAccessor(new ImplementationBridgeHelpers.CosmosContainerProactiveInitConfigHelper.CosmosContainerProactiveInitConfigAccessor(){

            @Override
            public Map<CosmosContainerIdentity, ContainerDirectConnectionMetadata> getContainerPropertiesMap(CosmosContainerProactiveInitConfig cosmosContainerProactiveInitConfig) {
                return cosmosContainerProactiveInitConfig.containerDirectConnectionMetadataMap;
            }
        });
    }

    static {
        CosmosContainerProactiveInitConfig.initialize();
    }
}

