/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.core.http.ProxyOptions;
import com.azure.core.util.tracing.Tracer;
import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncClientEncryptionKey;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.cosmos.CosmosContainerProactiveInitConfig;
import com.azure.cosmos.CosmosDiagnostics;
import com.azure.cosmos.CosmosDiagnosticsContext;
import com.azure.cosmos.CosmosDiagnosticsHandler;
import com.azure.cosmos.CosmosDiagnosticsThresholds;
import com.azure.cosmos.CosmosEndToEndOperationLatencyPolicyConfig;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.CosmosRegionSwitchHint;
import com.azure.cosmos.DirectConnectionConfig;
import com.azure.cosmos.GlobalThroughputControlConfig;
import com.azure.cosmos.SessionRetryOptions;
import com.azure.cosmos.ThroughputControlGroupConfig;
import com.azure.cosmos.implementation.ApiType;
import com.azure.cosmos.implementation.ClientSideRequestStatistics;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ConnectionPolicy;
import com.azure.cosmos.implementation.CosmosClientMetadataCachesSnapshot;
import com.azure.cosmos.implementation.CosmosDiagnosticsSystemUsageSnapshot;
import com.azure.cosmos.implementation.CosmosPagedFluxOptions;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DiagnosticsProvider;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.FeedResponseDiagnostics;
import com.azure.cosmos.implementation.ItemDeserializer;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.WriteRetryPolicy;
import com.azure.cosmos.implementation.batch.ItemBatchOperation;
import com.azure.cosmos.implementation.batch.PartitionScopeThresholds;
import com.azure.cosmos.implementation.clienttelemetry.ClientTelemetry;
import com.azure.cosmos.implementation.clienttelemetry.CosmosMeterOptions;
import com.azure.cosmos.implementation.clienttelemetry.MetricCategory;
import com.azure.cosmos.implementation.clienttelemetry.TagName;
import com.azure.cosmos.implementation.directconnectivity.ContainerDirectConnectionMetadata;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdChannelStatistics;
import com.azure.cosmos.implementation.faultinjection.IFaultInjectorProvider;
import com.azure.cosmos.implementation.patch.PatchOperation;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.models.CosmosBatch;
import com.azure.cosmos.models.CosmosBatchOperationResult;
import com.azure.cosmos.models.CosmosBatchRequestOptions;
import com.azure.cosmos.models.CosmosBatchResponse;
import com.azure.cosmos.models.CosmosBulkExecutionOptions;
import com.azure.cosmos.models.CosmosBulkExecutionThresholdsState;
import com.azure.cosmos.models.CosmosBulkItemResponse;
import com.azure.cosmos.models.CosmosChangeFeedRequestOptions;
import com.azure.cosmos.models.CosmosClientEncryptionKeyResponse;
import com.azure.cosmos.models.CosmosClientTelemetryConfig;
import com.azure.cosmos.models.CosmosContainerIdentity;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosMetricName;
import com.azure.cosmos.models.CosmosPatchOperations;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.PriorityLevel;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.UtilBridgeInternal;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.time.Duration;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ImplementationBridgeHelpers {
    private static final Logger logger = LoggerFactory.getLogger(ImplementationBridgeHelpers.class);

    private static void initializeAllAccessors() {
        BridgeInternal.initializeAllAccessors();
        ModelBridgeInternal.initializeAllAccessors();
        UtilBridgeInternal.initializeAllAccessors();
    }

    public static final class CosmosSessionRetryOptionsHelper {
        private static final AtomicReference<Boolean> cosmosSessionRetryOptionsClassLoaded = new AtomicReference<Boolean>(false);
        private static final AtomicReference<CosmosSessionRetryOptionsAccessor> accessor = new AtomicReference();

        private CosmosSessionRetryOptionsHelper() {
        }

        public static CosmosSessionRetryOptionsAccessor getCosmosSessionRetryOptionsAccessor() {
            CosmosSessionRetryOptionsAccessor snapshot;
            if (!cosmosSessionRetryOptionsClassLoaded.get().booleanValue()) {
                logger.debug("Initializing cosmosSessionRetryOptionsAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("cosmosSessionRetryOptionsAccessor is not initialized yet!");
                System.exit(9727);
            }
            return snapshot;
        }

        public static void setCosmosSessionRetryOptionsAccessor(CosmosSessionRetryOptionsAccessor newAccessor) {
            assert (newAccessor != null);
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosSessionRetryOptionsAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosSessionRetryOptionsAccessor...");
                cosmosSessionRetryOptionsClassLoaded.set(true);
            }
        }

        public static interface CosmosSessionRetryOptionsAccessor {
            public CosmosRegionSwitchHint getRegionSwitchHint(SessionRetryOptions var1);
        }
    }

    public static final class CosmosContainerProactiveInitConfigHelper {
        private static final AtomicReference<Boolean> cosmosContainerProactiveInitConfigClassLoaded = new AtomicReference<Boolean>(false);
        private static final AtomicReference<CosmosContainerProactiveInitConfigAccessor> accessor = new AtomicReference();

        private CosmosContainerProactiveInitConfigHelper() {
        }

        public static CosmosContainerProactiveInitConfigAccessor getCosmosContainerProactiveInitConfigAccessor() {
            CosmosContainerProactiveInitConfigAccessor snapshot;
            if (!cosmosContainerProactiveInitConfigClassLoaded.get().booleanValue()) {
                logger.debug("Initializing CosmosContainerProactiveInitConfigAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosContainerProactiveInitConfigAccessor is not initialized yet!");
                System.exit(9726);
            }
            return snapshot;
        }

        public static void setCosmosContainerProactiveInitConfigAccessor(CosmosContainerProactiveInitConfigAccessor newAccessor) {
            assert (newAccessor != null);
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosContainerProactiveInitConfigAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosContainerProactiveInitConfigAccessor...");
                cosmosContainerProactiveInitConfigClassLoaded.set(true);
            }
        }

        public static interface CosmosContainerProactiveInitConfigAccessor {
            public Map<CosmosContainerIdentity, ContainerDirectConnectionMetadata> getContainerPropertiesMap(CosmosContainerProactiveInitConfig var1);
        }
    }

    public static final class CosmosContainerIdentityHelper {
        private static final AtomicReference<Boolean> cosmosContainerIdentityClassLoaded = new AtomicReference<Boolean>(false);
        private static final AtomicReference<CosmosContainerIdentityAccessor> accessor = new AtomicReference();

        private CosmosContainerIdentityHelper() {
        }

        public static CosmosContainerIdentityAccessor getCosmosContainerIdentityAccessor() {
            CosmosContainerIdentityAccessor snapshot;
            if (!cosmosContainerIdentityClassLoaded.get().booleanValue()) {
                logger.debug("Initializing CosmosContainerIdentityAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosContainerIdentityAccessor is not initialized yet!");
                System.exit(9725);
            }
            return snapshot;
        }

        public static void setCosmosContainerIdentityAccessor(CosmosContainerIdentityAccessor newAccessor) {
            assert (newAccessor != null);
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosContainerIdentityAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosContainerIdentityAccessor...");
                cosmosContainerIdentityClassLoaded.set(true);
            }
        }

        public static interface CosmosContainerIdentityAccessor {
            public String getDatabaseName(CosmosContainerIdentity var1);

            public String getContainerName(CosmosContainerIdentity var1);

            public String getContainerLink(CosmosContainerIdentity var1);
        }
    }

    public static final class PriorityLevelHelper {
        private static final AtomicBoolean priorityLevelClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<PriorityLevelAccessor> accessor = new AtomicReference();

        private PriorityLevelHelper() {
        }

        public static PriorityLevelAccessor getPriorityLevelAccessor() {
            PriorityLevelAccessor snapshot;
            if (!priorityLevelClassLoaded.get()) {
                logger.debug("Initializing PriorityLevelAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("PriorityLevelAccessor is not initialized yet!");
                System.exit(9728);
            }
            return snapshot;
        }

        public static void setPriorityLevelAccessor(PriorityLevelAccessor newAccessor) {
            assert (newAccessor != null);
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("PriorityLevelAccessor already initialized!");
            } else {
                logger.debug("Setting PriorityLevelAccessor...");
                priorityLevelClassLoaded.set(true);
            }
        }

        public static interface PriorityLevelAccessor {
            public byte getPriorityValue(PriorityLevel var1);
        }
    }

    public static final class CosmosClientTelemetryConfigHelper {
        private static final AtomicBoolean cosmosClientTelemetryClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosClientTelemetryConfigAccessor> accessor = new AtomicReference();

        private CosmosClientTelemetryConfigHelper() {
        }

        public static CosmosClientTelemetryConfigAccessor getCosmosClientTelemetryConfigAccessor() {
            CosmosClientTelemetryConfigAccessor snapshot;
            if (!cosmosClientTelemetryClassLoaded.get()) {
                logger.debug("Initializing CosmosClientTelemetryConfigAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosClientTelemetryConfigAccessor is not initialized yet!");
                System.exit(9724);
            }
            return snapshot;
        }

        public static void setCosmosClientTelemetryConfigAccessor(CosmosClientTelemetryConfigAccessor newAccessor) {
            assert (newAccessor != null);
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosClientTelemetryConfigAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosClientTelemetryConfigAccessor...");
                cosmosClientTelemetryClassLoaded.set(true);
            }
        }

        public static interface CosmosClientTelemetryConfigAccessor {
            public Duration getHttpNetworkRequestTimeout(CosmosClientTelemetryConfig var1);

            public int getMaxConnectionPoolSize(CosmosClientTelemetryConfig var1);

            public Duration getIdleHttpConnectionTimeout(CosmosClientTelemetryConfig var1);

            public ProxyOptions getProxy(CosmosClientTelemetryConfig var1);

            public EnumSet<MetricCategory> getMetricCategories(CosmosClientTelemetryConfig var1);

            public EnumSet<TagName> getMetricTagNames(CosmosClientTelemetryConfig var1);

            public String getClientCorrelationId(CosmosClientTelemetryConfig var1);

            public MeterRegistry getClientMetricRegistry(CosmosClientTelemetryConfig var1);

            public Boolean isSendClientTelemetryToServiceEnabled(CosmosClientTelemetryConfig var1);

            public boolean isClientMetricsEnabled(CosmosClientTelemetryConfig var1);

            public void resetIsSendClientTelemetryToServiceEnabled(CosmosClientTelemetryConfig var1);

            public CosmosMeterOptions getMeterOptions(CosmosClientTelemetryConfig var1, CosmosMetricName var2);

            public CosmosMeterOptions createDisabledMeterOptions(CosmosMetricName var1);

            public CosmosClientTelemetryConfig createSnapshot(CosmosClientTelemetryConfig var1, boolean var2);

            public Collection<CosmosDiagnosticsHandler> getDiagnosticHandlers(CosmosClientTelemetryConfig var1);

            public void setAccountName(CosmosClientTelemetryConfig var1, String var2);

            public String getAccountName(CosmosClientTelemetryConfig var1);

            public void setClientCorrelationTag(CosmosClientTelemetryConfig var1, Tag var2);

            public Tag getClientCorrelationTag(CosmosClientTelemetryConfig var1);

            public void setClientTelemetry(CosmosClientTelemetryConfig var1, ClientTelemetry var2);

            public ClientTelemetry getClientTelemetry(CosmosClientTelemetryConfig var1);

            public void addDiagnosticsHandler(CosmosClientTelemetryConfig var1, CosmosDiagnosticsHandler var2);

            public CosmosDiagnosticsThresholds getDiagnosticsThresholds(CosmosClientTelemetryConfig var1);

            public boolean isLegacyTracingEnabled(CosmosClientTelemetryConfig var1);

            public boolean isTransportLevelTracingEnabled(CosmosClientTelemetryConfig var1);

            public Tracer getOrCreateTracer(CosmosClientTelemetryConfig var1);

            public void setUseLegacyTracing(CosmosClientTelemetryConfig var1, boolean var2);

            public void setTracer(CosmosClientTelemetryConfig var1, Tracer var2);

            public double getSamplingRate(CosmosClientTelemetryConfig var1);
        }
    }

    public static final class CosmosExceptionHelper {
        private static final AtomicBoolean cosmosExceptionClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosExceptionAccessor> accessor = new AtomicReference();

        private CosmosExceptionHelper() {
        }

        public static CosmosExceptionAccessor getCosmosExceptionAccessor() {
            CosmosExceptionAccessor snapshot;
            if (!cosmosExceptionClassLoaded.get()) {
                logger.debug("Initializing CosmosExceptionAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosExceptionAccessor is not initialized yet!");
                System.exit(9800);
            }
            return snapshot;
        }

        public static void setCosmosExceptionAccessor(CosmosExceptionAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosExceptionAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosExceptionAccessor...");
                cosmosExceptionClassLoaded.set(true);
            }
        }

        public static interface CosmosExceptionAccessor {
            public CosmosException createCosmosException(int var1, Exception var2);

            public List<String> getReplicaStatusList(CosmosException var1);

            public CosmosException setRntbdChannelStatistics(CosmosException var1, RntbdChannelStatistics var2);

            public RntbdChannelStatistics getRntbdChannelStatistics(CosmosException var1);

            public void setFaultInjectionRuleId(CosmosException var1, String var2);

            public String getFaultInjectionRuleId(CosmosException var1);

            public void setFaultInjectionEvaluationResults(CosmosException var1, List<String> var2);

            public List<String> getFaultInjectionEvaluationResults(CosmosException var1);

            public void setRequestUri(CosmosException var1, Uri var2);

            public Uri getRequestUri(CosmosException var1);
        }
    }

    public static final class CosmosDiagnosticsThresholdsHelper {
        private static final AtomicReference<CosmosDiagnosticsThresholdsAccessor> accessor = new AtomicReference();
        private static final AtomicBoolean cosmosDiagnosticsThresholdsClassLoaded = new AtomicBoolean(false);

        private CosmosDiagnosticsThresholdsHelper() {
        }

        public static void setCosmosDiagnosticsThresholdsAccessor(CosmosDiagnosticsThresholdsAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosDiagnosticsThresholds already initialized!");
            } else {
                logger.debug("Setting CosmosDiagnosticsThresholds...");
                cosmosDiagnosticsThresholdsClassLoaded.set(true);
            }
        }

        public static CosmosDiagnosticsThresholdsAccessor getCosmosAsyncClientAccessor() {
            CosmosDiagnosticsThresholdsAccessor snapshot;
            if (!cosmosDiagnosticsThresholdsClassLoaded.get()) {
                logger.debug("Initializing CosmosDiagnosticsThresholds...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosDiagnosticsThresholdsAccessor is not initialized yet!");
                System.exit(9727);
            }
            return snapshot;
        }

        public static interface CosmosDiagnosticsThresholdsAccessor {
            public Duration getPointReadLatencyThreshold(CosmosDiagnosticsThresholds var1);

            public Duration getNonPointReadLatencyThreshold(CosmosDiagnosticsThresholds var1);

            public float getRequestChargeThreshold(CosmosDiagnosticsThresholds var1);

            public int getPayloadSizeThreshold(CosmosDiagnosticsThresholds var1);

            public boolean isFailureCondition(CosmosDiagnosticsThresholds var1, int var2, int var3);
        }
    }

    public static final class CosmosAsyncClientHelper {
        private static final AtomicReference<CosmosAsyncClientAccessor> accessor = new AtomicReference();
        private static final AtomicBoolean cosmosAsyncClientClassLoaded = new AtomicBoolean(false);

        private CosmosAsyncClientHelper() {
        }

        public static void setCosmosAsyncClientAccessor(CosmosAsyncClientAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosAsyncClientAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosAsyncClientAccessor...");
                cosmosAsyncClientClassLoaded.set(true);
            }
        }

        public static CosmosAsyncClientAccessor getCosmosAsyncClientAccessor() {
            CosmosAsyncClientAccessor snapshot;
            if (!cosmosAsyncClientClassLoaded.get()) {
                logger.debug("Initializing CosmosAsyncClientAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosAsyncClientAccessor is not initialized yet!");
                System.exit(9723);
            }
            return snapshot;
        }

        public static interface CosmosAsyncClientAccessor {
            public Tag getClientCorrelationTag(CosmosAsyncClient var1);

            public String getAccountTagValue(CosmosAsyncClient var1);

            public EnumSet<TagName> getMetricTagNames(CosmosAsyncClient var1);

            public EnumSet<MetricCategory> getMetricCategories(CosmosAsyncClient var1);

            public boolean shouldEnableEmptyPageDiagnostics(CosmosAsyncClient var1);

            public boolean isSendClientTelemetryToServiceEnabled(CosmosAsyncClient var1);

            public List<String> getPreferredRegions(CosmosAsyncClient var1);

            public boolean isEndpointDiscoveryEnabled(CosmosAsyncClient var1);

            public String getConnectionMode(CosmosAsyncClient var1);

            public String getUserAgent(CosmosAsyncClient var1);

            public CosmosMeterOptions getMeterOptions(CosmosAsyncClient var1, CosmosMetricName var2);

            public boolean isEffectiveContentResponseOnWriteEnabled(CosmosAsyncClient var1, Boolean var2);

            public ConsistencyLevel getEffectiveConsistencyLevel(CosmosAsyncClient var1, OperationType var2, ConsistencyLevel var3);

            public CosmosDiagnosticsThresholds getEffectiveDiagnosticsThresholds(CosmosAsyncClient var1, CosmosDiagnosticsThresholds var2);

            public DiagnosticsProvider getDiagnosticsProvider(CosmosAsyncClient var1);
        }
    }

    public static final class CosmosAsyncClientEncryptionKeyHelper {
        private static final AtomicBoolean cosmosAsyncClientEncryptionKeyClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosAsyncClientEncryptionKeyAccessor> accessor = new AtomicReference();

        private CosmosAsyncClientEncryptionKeyHelper() {
        }

        public static CosmosAsyncClientEncryptionKeyAccessor getCosmosAsyncClientEncryptionKeyAccessor() {
            CosmosAsyncClientEncryptionKeyAccessor snapshot;
            if (!cosmosAsyncClientEncryptionKeyClassLoaded.get()) {
                logger.debug("Initializing CosmosAsyncClientEncryptionKeyAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosAsyncClientEncryptionKeyAccessor is not initialized yet!");
                System.exit(9722);
            }
            return snapshot;
        }

        public static void setCosmosAsyncClientEncryptionKeyAccessor(CosmosAsyncClientEncryptionKeyAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosAsyncClientEncryptionKeyAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosAsyncClientEncryptionKeyAccessor...");
                cosmosAsyncClientEncryptionKeyClassLoaded.set(true);
            }
        }

        public static interface CosmosAsyncClientEncryptionKeyAccessor {
            public Mono<CosmosClientEncryptionKeyResponse> readClientEncryptionKey(CosmosAsyncClientEncryptionKey var1, RequestOptions var2);
        }
    }

    public static final class CosmosBatchResponseHelper {
        private static final AtomicBoolean cosmosBatchResponseClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosBatchResponseAccessor> accessor = new AtomicReference();

        private CosmosBatchResponseHelper() {
        }

        public static CosmosBatchResponseAccessor getCosmosBatchResponseAccessor() {
            CosmosBatchResponseAccessor snapshot;
            if (!cosmosBatchResponseClassLoaded.get()) {
                logger.debug("Initializing CosmosBatchResponseAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosBatchResponseAccessor is not initialized yet!");
                System.exit(9721);
            }
            return snapshot;
        }

        public static void setCosmosBatchResponseAccessor(CosmosBatchResponseAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosBatchResponseAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosBatchResponseAccessor...");
                cosmosBatchResponseClassLoaded.set(true);
            }
        }

        public static interface CosmosBatchResponseAccessor {
            public List<CosmosBatchOperationResult> getResults(CosmosBatchResponse var1);
        }
    }

    public static final class CosmosBulkItemResponseHelper {
        private static final AtomicBoolean cosmosBulkItemResponseClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosBulkItemResponseAccessor> accessor = new AtomicReference();

        private CosmosBulkItemResponseHelper() {
        }

        public static CosmosBulkItemResponseAccessor getCosmosBulkItemResponseAccessor() {
            CosmosBulkItemResponseAccessor snapshot;
            if (!cosmosBulkItemResponseClassLoaded.get()) {
                logger.debug("Initializing CosmosBulkItemResponseAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosBulkItemResponseAccessor is not initialized yet!");
                System.exit(9720);
            }
            return snapshot;
        }

        public static void setCosmosBulkItemResponseAccessor(CosmosBulkItemResponseAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosBulkItemResponseAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosBulkItemResponseAccessor...");
                cosmosBulkItemResponseClassLoaded.set(true);
            }
        }

        public static interface CosmosBulkItemResponseAccessor {
            public ObjectNode getResourceObject(CosmosBulkItemResponse var1);

            public void setResourceObject(CosmosBulkItemResponse var1, ObjectNode var2);
        }
    }

    public static final class CosmosBatchHelper {
        private static AtomicBoolean cosmosBatchClassLoaded = new AtomicBoolean(false);
        private static AtomicReference<CosmosBatchAccessor> accessor = new AtomicReference();

        private CosmosBatchHelper() {
        }

        public static CosmosBatchAccessor getCosmosBatchAccessor() {
            CosmosBatchAccessor snapshot;
            if (!cosmosBatchClassLoaded.get()) {
                logger.debug("Initializing CosmosBatchAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosBatchAccessor is not initialized yet!");
                System.exit(9719);
            }
            return snapshot;
        }

        public static void setCosmosBatchAccessor(CosmosBatchAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosBatchAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosBatchAccessor...");
                cosmosBatchClassLoaded.set(true);
            }
        }

        public static interface CosmosBatchAccessor {
            public List<ItemBatchOperation<?>> getOperationsInternal(CosmosBatch var1);
        }
    }

    public static final class CosmosPatchOperationsHelper {
        private static final AtomicBoolean cosmosPatchOperationsClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosPatchOperationsAccessor> accessor = new AtomicReference();

        private CosmosPatchOperationsHelper() {
        }

        public static CosmosPatchOperationsAccessor getCosmosPatchOperationsAccessor() {
            CosmosPatchOperationsAccessor snapshot;
            if (!cosmosPatchOperationsClassLoaded.get()) {
                logger.debug("Initializing CosmosPatchOperationsAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosPatchOperationsAccessor is not initialized yet!");
                System.exit(9718);
            }
            return snapshot;
        }

        public static void setCosmosPatchOperationsAccessor(CosmosPatchOperationsAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosPatchOperationsAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosPatchOperationsAccessor...");
                cosmosPatchOperationsClassLoaded.set(true);
            }
        }

        public static interface CosmosPatchOperationsAccessor {
            public List<PatchOperation> getPatchOperations(CosmosPatchOperations var1);
        }
    }

    public static final class CosmosBatchOperationResultHelper {
        private static final AtomicBoolean cosmosBatchOperationResultClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosBatchOperationResultAccessor> accessor = new AtomicReference();

        private CosmosBatchOperationResultHelper() {
        }

        public static CosmosBatchOperationResultAccessor getCosmosBatchOperationResultAccessor() {
            CosmosBatchOperationResultAccessor snapshot;
            if (!cosmosBatchOperationResultClassLoaded.get()) {
                logger.debug("Initializing CosmosBatchOperationResultAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosBatchOperationResultAccessor is not initialized yet!");
                System.exit(9717);
            }
            return snapshot;
        }

        public static void setCosmosBatchOperationResultAccessor(CosmosBatchOperationResultAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosBatchOperationResultAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosBatchOperationResultAccessor...");
                cosmosBatchOperationResultClassLoaded.set(true);
            }
        }

        public static interface CosmosBatchOperationResultAccessor {
            public ObjectNode getResourceObject(CosmosBatchOperationResult var1);

            public void setResourceObject(CosmosBatchOperationResult var1, ObjectNode var2);
        }
    }

    public static final class CosmosBatchRequestOptionsHelper {
        private static final AtomicBoolean cosmosBatchRequestOptionsClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosBatchRequestOptionsAccessor> accessor = new AtomicReference();

        private CosmosBatchRequestOptionsHelper() {
        }

        public static CosmosBatchRequestOptionsAccessor getCosmosBatchRequestOptionsAccessor() {
            CosmosBatchRequestOptionsAccessor snapshot;
            if (!cosmosBatchRequestOptionsClassLoaded.get()) {
                logger.debug("Initializing CosmosBatchRequestOptionsAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosBatchRequestOptionsAccessor is not initialized yet!");
                System.exit(9716);
            }
            return snapshot;
        }

        public static void setCosmosBatchRequestOptionsAccessor(CosmosBatchRequestOptionsAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosBatchRequestOptionsAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosBatchRequestOptionsAccessor...");
                cosmosBatchRequestOptionsClassLoaded.set(true);
            }
        }

        public static interface CosmosBatchRequestOptionsAccessor {
            public ConsistencyLevel getConsistencyLevel(CosmosBatchRequestOptions var1);

            public CosmosBatchRequestOptions setConsistencyLevel(CosmosBatchRequestOptions var1, ConsistencyLevel var2);

            public CosmosBatchRequestOptions setHeader(CosmosBatchRequestOptions var1, String var2, String var3);

            public Map<String, String> getHeader(CosmosBatchRequestOptions var1);

            public List<String> getExcludeRegions(CosmosBatchRequestOptions var1);
        }
    }

    public static final class FeedResponseHelper {
        private static final AtomicBoolean feedResponseClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<FeedResponseAccessor> accessor = new AtomicReference();

        private FeedResponseHelper() {
        }

        public static void setFeedResponseAccessor(FeedResponseAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("FeedResponseAccessor already initialized!");
            } else {
                logger.debug("Setting FeedResponseAccessor...");
                feedResponseClassLoaded.set(true);
            }
        }

        public static FeedResponseAccessor getFeedResponseAccessor() {
            FeedResponseAccessor snapshot;
            if (!feedResponseClassLoaded.get()) {
                logger.debug("Initializing FeedResponseAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("FeedResponseAccessor is not initialized yet!");
                System.exit(9715);
            }
            return snapshot;
        }

        public static interface FeedResponseAccessor {
            public <T> boolean getNoChanges(FeedResponse<T> var1);

            public <TNew, T> FeedResponse<TNew> convertGenericType(FeedResponse<T> var1, Function<T, TNew> var2);

            public <T> FeedResponse<T> createFeedResponse(List<T> var1, Map<String, String> var2, CosmosDiagnostics var3);
        }
    }

    public static final class CosmosAsyncContainerHelper {
        private static final AtomicBoolean cosmosAsyncContainerClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosAsyncContainerAccessor> accessor = new AtomicReference();

        private CosmosAsyncContainerHelper() {
        }

        public static void setCosmosAsyncContainerAccessor(CosmosAsyncContainerAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosAsyncContainerAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosAsyncContainerAccessor...");
                cosmosAsyncContainerClassLoaded.set(true);
            }
        }

        public static CosmosAsyncContainerAccessor getCosmosAsyncContainerAccessor() {
            CosmosAsyncContainerAccessor snapshot;
            if (!cosmosAsyncContainerClassLoaded.get()) {
                logger.debug("Initializing CosmosAsyncContainerAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosAsyncContainerAccessor is not initialized yet!");
                System.exit(9714);
            }
            return snapshot;
        }

        public static interface CosmosAsyncContainerAccessor {
            public <T> Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> queryChangeFeedInternalFunc(CosmosAsyncContainer var1, CosmosChangeFeedRequestOptions var2, Class<T> var3);

            public void enableLocalThroughputControlGroup(CosmosAsyncContainer var1, ThroughputControlGroupConfig var2, Mono<Integer> var3);

            public void enableGlobalThroughputControlGroup(CosmosAsyncContainer var1, ThroughputControlGroupConfig var2, GlobalThroughputControlConfig var3, Mono<Integer> var4);

            public IFaultInjectorProvider getOrConfigureFaultInjectorProvider(CosmosAsyncContainer var1, Callable<IFaultInjectorProvider> var2);
        }
    }

    public static final class CosmosDiagnosticsContextHelper {
        private static final AtomicBoolean cosmosDiagnosticsContextClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosDiagnosticsContextAccessor> accessor = new AtomicReference();

        private CosmosDiagnosticsContextHelper() {
        }

        public static void setCosmosDiagnosticsContextAccessor(CosmosDiagnosticsContextAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosDiagnosticsContextAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosDiagnosticsContextAccessor...");
                cosmosDiagnosticsContextClassLoaded.set(true);
            }
        }

        public static CosmosDiagnosticsContextAccessor getCosmosDiagnosticsContextAccessor() {
            CosmosDiagnosticsContextAccessor snapshot;
            if (!cosmosDiagnosticsContextClassLoaded.get()) {
                logger.debug("Initializing CosmosDiagnosticsAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosDiagnosticsAccessor is not initialized yet!");
                System.exit(9713);
            }
            return snapshot;
        }

        public static interface CosmosDiagnosticsContextAccessor {
            public CosmosDiagnosticsContext create(String var1, String var2, String var3, String var4, String var5, ResourceType var6, OperationType var7, String var8, ConsistencyLevel var9, Integer var10, CosmosDiagnosticsThresholds var11, String var12, String var13, String var14);

            public CosmosDiagnosticsSystemUsageSnapshot createSystemUsageSnapshot(String var1, String var2, String var3, int var4);

            public void startOperation(CosmosDiagnosticsContext var1);

            public void recordOperation(CosmosDiagnosticsContext var1, int var2, int var3, Integer var4, Double var5, CosmosDiagnostics var6, Throwable var7);

            public boolean endOperation(CosmosDiagnosticsContext var1, int var2, int var3, Integer var4, Double var5, CosmosDiagnostics var6, Throwable var7);

            public void addRequestCharge(CosmosDiagnosticsContext var1, float var2);

            public void addRequestSize(CosmosDiagnosticsContext var1, int var2);

            public void addResponseSize(CosmosDiagnosticsContext var1, int var2);

            public void addDiagnostics(CosmosDiagnosticsContext var1, CosmosDiagnostics var2);

            public Collection<CosmosDiagnostics> getDiagnostics(CosmosDiagnosticsContext var1);

            public ResourceType getResourceType(CosmosDiagnosticsContext var1);

            public OperationType getOperationType(CosmosDiagnosticsContext var1);

            public String getEndpoint(CosmosDiagnosticsContext var1);

            public Collection<ClientSideRequestStatistics> getDistinctCombinedClientSideRequestStatistics(CosmosDiagnosticsContext var1);

            public String getSpanName(CosmosDiagnosticsContext var1);

            public void setSamplingRateSnapshot(CosmosDiagnosticsContext var1, double var2);
        }
    }

    public static final class CosmosDiagnosticsHelper {
        private static final AtomicBoolean cosmosDiagnosticsClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosDiagnosticsAccessor> accessor = new AtomicReference();

        private CosmosDiagnosticsHelper() {
        }

        public static void setCosmosDiagnosticsAccessor(CosmosDiagnosticsAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosDiagnosticsAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosDiagnosticsAccessor...");
                cosmosDiagnosticsClassLoaded.set(true);
            }
        }

        public static CosmosDiagnosticsAccessor getCosmosDiagnosticsAccessor() {
            CosmosDiagnosticsAccessor snapshot;
            if (!cosmosDiagnosticsClassLoaded.get()) {
                logger.debug("Initializing CosmosDiagnosticsAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosDiagnosticsAccessor is not initialized yet!");
                System.exit(9713);
            }
            return snapshot;
        }

        public static interface CosmosDiagnosticsAccessor {
            public FeedResponseDiagnostics getFeedResponseDiagnostics(CosmosDiagnostics var1);

            public AtomicBoolean isDiagnosticsCapturedInPagedFlux(CosmosDiagnostics var1);

            public Collection<ClientSideRequestStatistics> getClientSideRequestStatistics(CosmosDiagnostics var1);

            public Collection<ClientSideRequestStatistics> getClientSideRequestStatisticsForQueryPipelineAggregations(CosmosDiagnostics var1);

            public int getTotalResponsePayloadSizeInBytes(CosmosDiagnostics var1);

            public int getRequestPayloadSizeInBytes(CosmosDiagnostics var1);

            public ClientSideRequestStatistics getClientSideRequestStatisticsRaw(CosmosDiagnostics var1);

            public void addClientSideDiagnosticsToFeed(CosmosDiagnostics var1, Collection<ClientSideRequestStatistics> var2);

            public void setSamplingRateSnapshot(CosmosDiagnostics var1, double var2);

            public CosmosDiagnostics create(DiagnosticsClientContext var1, double var2);

            public void recordAddressResolutionEnd(RxDocumentServiceRequest var1, String var2, String var3, long var4);
        }
    }

    public static final class CosmosBulkExecutionThresholdsStateHelper {
        private static final AtomicBoolean cosmosBulkExecutionThresholdsStateClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosBulkExecutionThresholdsStateAccessor> accessor = new AtomicReference();

        private CosmosBulkExecutionThresholdsStateHelper() {
        }

        public static void setBulkExecutionThresholdsAccessor(CosmosBulkExecutionThresholdsStateAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosBulkExecutionThresholdsStateAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosBulkExecutionThresholdsStateAccessor...");
                cosmosBulkExecutionThresholdsStateClassLoaded.set(true);
            }
        }

        public static CosmosBulkExecutionThresholdsStateAccessor getBulkExecutionThresholdsAccessor() {
            CosmosBulkExecutionThresholdsStateAccessor snapshot;
            if (!cosmosBulkExecutionThresholdsStateClassLoaded.get()) {
                logger.debug("Initializing CosmosBulkExecutionThresholdsStateAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosBulkExecutionThresholdsStateAccessor is not initialized yet!");
                System.exit(9712);
            }
            return snapshot;
        }

        public static interface CosmosBulkExecutionThresholdsStateAccessor {
            public ConcurrentMap<String, PartitionScopeThresholds> getPartitionScopeThresholds(CosmosBulkExecutionThresholdsState var1);

            public CosmosBulkExecutionThresholdsState createWithPartitionScopeThresholds(ConcurrentMap<String, PartitionScopeThresholds> var1);
        }
    }

    public static final class CosmosAsyncDatabaseHelper {
        private static final AtomicBoolean cosmosAsyncDatabaseClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosAsyncDatabaseAccessor> accessor = new AtomicReference();

        private CosmosAsyncDatabaseHelper() {
        }

        public static <T> void setCosmosAsyncDatabaseAccessor(CosmosAsyncDatabaseAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosAsyncDatabaseAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosAsyncDatabaseAccessor...");
                cosmosAsyncDatabaseClassLoaded.set(true);
            }
        }

        public static <T> CosmosAsyncDatabaseAccessor getCosmosAsyncDatabaseAccessor() {
            CosmosAsyncDatabaseAccessor snapshot;
            if (!cosmosAsyncDatabaseClassLoaded.get()) {
                logger.debug("Initializing CosmosAsyncDatabaseAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosAsyncDatabaseAccessor is not initialized yet!");
                System.exit(9711);
            }
            return snapshot;
        }

        public static interface CosmosAsyncDatabaseAccessor {
            public CosmosAsyncClient getCosmosAsyncClient(CosmosAsyncDatabase var1);

            public String getLink(CosmosAsyncDatabase var1);
        }
    }

    public static final class CosmosPageFluxHelper {
        private static final AtomicBoolean cosmosPagedFluxClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosPageFluxAccessor> accessor = new AtomicReference();

        private CosmosPageFluxHelper() {
        }

        public static <T> void setCosmosPageFluxAccessor(CosmosPageFluxAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosPageFluxAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosPageFluxAccessor...");
                cosmosPagedFluxClassLoaded.set(true);
            }
        }

        public static <T> CosmosPageFluxAccessor getCosmosPageFluxAccessor() {
            CosmosPageFluxAccessor snapshot;
            if (!cosmosPagedFluxClassLoaded.get()) {
                logger.debug("Initializing CosmosPageFluxAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosPageFluxAccessor is not initialized yet!");
                System.exit(9710);
            }
            return snapshot;
        }

        public static interface CosmosPageFluxAccessor {
            public <T> CosmosPagedFlux<T> getCosmosPagedFlux(Function<CosmosPagedFluxOptions, Flux<FeedResponse<T>>> var1);
        }
    }

    public static final class CosmosContainerPropertiesHelper {
        private static final AtomicBoolean cosmosContainerPropertiesClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosContainerPropertiesAccessor> accessor = new AtomicReference();

        private CosmosContainerPropertiesHelper() {
        }

        public static void setCosmosContainerPropertiesAccessor(CosmosContainerPropertiesAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosContainerPropertiesAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosContainerPropertiesAccessor...");
                cosmosContainerPropertiesClassLoaded.set(true);
            }
        }

        public static CosmosContainerPropertiesAccessor getCosmosContainerPropertiesAccessor() {
            CosmosContainerPropertiesAccessor snapshot;
            if (!cosmosContainerPropertiesClassLoaded.get()) {
                logger.debug("Initializing CosmosContainerPropertiesAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosContainerPropertiesAccessor is not initialized yet!");
                System.exit(9709);
            }
            return snapshot;
        }

        public static interface CosmosContainerPropertiesAccessor {
            public String getSelfLink(CosmosContainerProperties var1);

            public void setSelfLink(CosmosContainerProperties var1, String var2);
        }
    }

    public static final class CosmosClientHelper {
        private static final AtomicBoolean cosmosClientClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosClientAccessor> accessor = new AtomicReference();

        private CosmosClientHelper() {
        }

        public static void setCosmosClientAccessor(CosmosClientAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosClientAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosClientAccessor...");
                cosmosClientClassLoaded.set(true);
            }
        }

        public static CosmosClientAccessor getCosmosClientAccessor() {
            CosmosClientAccessor snapshot;
            if (!cosmosClientClassLoaded.get()) {
                logger.debug("Initializing CosmosClientAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosClientAccessor is not initialized yet!");
                System.exit(9708);
            }
            return snapshot;
        }

        public static interface CosmosClientAccessor {
            public CosmosAsyncClient getCosmosAsyncClient(CosmosClient var1);
        }
    }

    public static final class CosmosItemResponseHelper {
        private static final AtomicBoolean cosmosItemResponseClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosItemResponseBuilderAccessor> accessor = new AtomicReference();

        private CosmosItemResponseHelper() {
        }

        public static void setCosmosItemResponseBuilderAccessor(CosmosItemResponseBuilderAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosItemResponseBuilderAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosItemResponseBuilderAccessor...");
                cosmosItemResponseClassLoaded.set(true);
            }
        }

        public static CosmosItemResponseBuilderAccessor getCosmosItemResponseBuilderAccessor() {
            CosmosItemResponseBuilderAccessor snapshot;
            if (!cosmosItemResponseClassLoaded.get()) {
                logger.debug("Initializing CosmosItemResponseBuilderAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosItemResponseBuilderAccessor is not initialized yet!");
                System.exit(9707);
            }
            return snapshot;
        }

        public static interface CosmosItemResponseBuilderAccessor {
            public <T> CosmosItemResponse<T> createCosmosItemResponse(ResourceResponse<Document> var1, byte[] var2, Class<T> var3, ItemDeserializer var4);

            public <T> CosmosItemResponse<T> withRemappedStatusCode(CosmosItemResponse<T> var1, int var2, double var3, boolean var5);

            public byte[] getByteArrayContent(CosmosItemResponse<byte[]> var1);

            public void setByteArrayContent(CosmosItemResponse<byte[]> var1, byte[] var2);

            public ResourceResponse<Document> getResourceResponse(CosmosItemResponse<byte[]> var1);

            public boolean hasTrackingId(CosmosItemResponse<?> var1, String var2);
        }
    }

    public static final class CosmosBulkExecutionOptionsHelper {
        private static final AtomicBoolean cosmosBulkExecutionOptionsClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosBulkExecutionOptionsAccessor> accessor = new AtomicReference();

        private CosmosBulkExecutionOptionsHelper() {
        }

        public static void setCosmosBulkExecutionOptionsAccessor(CosmosBulkExecutionOptionsAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosBulkExecutionOptionsAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosBulkExecutionOptionsAccessor...");
                cosmosBulkExecutionOptionsClassLoaded.set(true);
            }
        }

        public static CosmosBulkExecutionOptionsAccessor getCosmosBulkExecutionOptionsAccessor() {
            CosmosBulkExecutionOptionsAccessor snapshot;
            if (!cosmosBulkExecutionOptionsClassLoaded.get()) {
                logger.debug("Initializing CosmosBulkExecutionOptionsAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosBulkExecutionOptionsAccessor is not initialized yet!");
                System.exit(9706);
            }
            return snapshot;
        }

        public static interface CosmosBulkExecutionOptionsAccessor {
            public void setOperationContext(CosmosBulkExecutionOptions var1, OperationContextAndListenerTuple var2);

            public OperationContextAndListenerTuple getOperationContext(CosmosBulkExecutionOptions var1);

            public <T> T getLegacyBatchScopedContext(CosmosBulkExecutionOptions var1);

            public double getMinTargetedMicroBatchRetryRate(CosmosBulkExecutionOptions var1);

            public double getMaxTargetedMicroBatchRetryRate(CosmosBulkExecutionOptions var1);

            public CosmosBulkExecutionOptions setTargetedMicroBatchRetryRate(CosmosBulkExecutionOptions var1, double var2, double var4);

            public int getMaxMicroBatchSize(CosmosBulkExecutionOptions var1);

            public CosmosBulkExecutionOptions setMaxMicroBatchSize(CosmosBulkExecutionOptions var1, int var2);

            public int getMaxMicroBatchPayloadSizeInBytes(CosmosBulkExecutionOptions var1);

            public CosmosBulkExecutionOptions setMaxMicroBatchPayloadSizeInBytes(CosmosBulkExecutionOptions var1, int var2);

            public int getMaxMicroBatchConcurrency(CosmosBulkExecutionOptions var1);

            public Integer getMaxConcurrentCosmosPartitions(CosmosBulkExecutionOptions var1);

            public CosmosBulkExecutionOptions setMaxConcurrentCosmosPartitions(CosmosBulkExecutionOptions var1, int var2);

            public Duration getMaxMicroBatchInterval(CosmosBulkExecutionOptions var1);

            public CosmosBulkExecutionOptions setHeader(CosmosBulkExecutionOptions var1, String var2, String var3);

            public Map<String, String> getHeader(CosmosBulkExecutionOptions var1);

            public Map<String, String> getCustomOptions(CosmosBulkExecutionOptions var1);

            public List<String> getExcludeRegions(CosmosBulkExecutionOptions var1);
        }
    }

    public static final class CosmosItemRequestOptionsHelper {
        private static final AtomicBoolean cosmosItemRequestOptionsClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosItemRequestOptionsAccessor> accessor = new AtomicReference();

        private CosmosItemRequestOptionsHelper() {
        }

        public static void setCosmosItemRequestOptionsAccessor(CosmosItemRequestOptionsAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosItemRequestOptionsAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosItemRequestOptionsAccessor...");
                cosmosItemRequestOptionsClassLoaded.set(true);
            }
        }

        public static CosmosItemRequestOptionsAccessor getCosmosItemRequestOptionsAccessor() {
            CosmosItemRequestOptionsAccessor snapshot;
            if (!cosmosItemRequestOptionsClassLoaded.get()) {
                logger.debug("Initializing CosmosItemRequestOptionsAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosItemRequestOptionsAccessor is not initialized yet!");
                System.exit(9705);
            }
            return snapshot;
        }

        public static interface CosmosItemRequestOptionsAccessor {
            public void setOperationContext(CosmosItemRequestOptions var1, OperationContextAndListenerTuple var2);

            public OperationContextAndListenerTuple getOperationContext(CosmosItemRequestOptions var1);

            public CosmosItemRequestOptions clone(CosmosItemRequestOptions var1);

            public CosmosItemRequestOptions setHeader(CosmosItemRequestOptions var1, String var2, String var3);

            public Map<String, String> getHeader(CosmosItemRequestOptions var1);

            public CosmosDiagnosticsThresholds getDiagnosticsThresholds(CosmosItemRequestOptions var1);

            public CosmosItemRequestOptions setNonIdempotentWriteRetryPolicy(CosmosItemRequestOptions var1, boolean var2, boolean var3);

            public WriteRetryPolicy calculateAndGetEffectiveNonIdempotentRetriesEnabled(CosmosItemRequestOptions var1, WriteRetryPolicy var2, boolean var3);
        }
    }

    public static final class CosmosChangeFeedRequestOptionsHelper {
        private static final AtomicBoolean cosmosChangeFeedRequestOptionsClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosChangeFeedRequestOptionsAccessor> accessor = new AtomicReference();

        private CosmosChangeFeedRequestOptionsHelper() {
        }

        public static void setCosmosChangeFeedRequestOptionsAccessor(CosmosChangeFeedRequestOptionsAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosChangeFeedRequestOptionsAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosChangeFeedRequestOptionsAccessor...");
                cosmosChangeFeedRequestOptionsClassLoaded.set(true);
            }
        }

        public static CosmosChangeFeedRequestOptionsAccessor getCosmosChangeFeedRequestOptionsAccessor() {
            CosmosChangeFeedRequestOptionsAccessor snapshot;
            if (!cosmosChangeFeedRequestOptionsClassLoaded.get()) {
                logger.debug("Initializing CosmosChangeFeedRequestOptionsAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosChangeFeedRequestOptionsAccessor is not initialized yet!");
                System.exit(9704);
            }
            return snapshot;
        }

        public static interface CosmosChangeFeedRequestOptionsAccessor {
            public CosmosChangeFeedRequestOptions setHeader(CosmosChangeFeedRequestOptions var1, String var2, String var3);

            public Map<String, String> getHeader(CosmosChangeFeedRequestOptions var1);

            public void setOperationContext(CosmosChangeFeedRequestOptions var1, OperationContextAndListenerTuple var2);

            public OperationContextAndListenerTuple getOperationContext(CosmosChangeFeedRequestOptions var1);

            public <T> Function<JsonNode, T> getItemFactoryMethod(CosmosChangeFeedRequestOptions var1, Class<T> var2);

            public CosmosChangeFeedRequestOptions setItemFactoryMethod(CosmosChangeFeedRequestOptions var1, Function<JsonNode, ?> var2);

            public CosmosDiagnosticsThresholds getDiagnosticsThresholds(CosmosChangeFeedRequestOptions var1);

            public void applyMaxItemCount(CosmosChangeFeedRequestOptions var1, CosmosPagedFluxOptions var2);

            public List<String> getExcludeRegions(CosmosChangeFeedRequestOptions var1);
        }
    }

    public static final class CosmosQueryRequestOptionsHelper {
        private static final AtomicBoolean cosmosQueryRequestOptionsClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<CosmosQueryRequestOptionsAccessor> accessor = new AtomicReference();

        private CosmosQueryRequestOptionsHelper() {
        }

        public static void setCosmosQueryRequestOptionsAccessor(CosmosQueryRequestOptionsAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosQueryRequestOptionsAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosQueryRequestOptionsAccessor...");
                cosmosQueryRequestOptionsClassLoaded.set(true);
            }
        }

        public static CosmosQueryRequestOptionsAccessor getCosmosQueryRequestOptionsAccessor() {
            CosmosQueryRequestOptionsAccessor snapshot;
            if (!cosmosQueryRequestOptionsClassLoaded.get()) {
                logger.debug("Initializing CosmosQueryRequestOptionsAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosQueryRequestOptionsAccessor is not initialized yet!");
                System.exit(9703);
            }
            return snapshot;
        }

        public static interface CosmosQueryRequestOptionsAccessor {
            public void setOperationContext(CosmosQueryRequestOptions var1, OperationContextAndListenerTuple var2);

            public OperationContextAndListenerTuple getOperationContext(CosmosQueryRequestOptions var1);

            public CosmosQueryRequestOptions setHeader(CosmosQueryRequestOptions var1, String var2, String var3);

            public Map<String, String> getHeader(CosmosQueryRequestOptions var1);

            public boolean isQueryPlanRetrievalDisallowed(CosmosQueryRequestOptions var1);

            public CosmosQueryRequestOptions disallowQueryPlanRetrieval(CosmosQueryRequestOptions var1);

            public UUID getCorrelationActivityId(CosmosQueryRequestOptions var1);

            public CosmosQueryRequestOptions setCorrelationActivityId(CosmosQueryRequestOptions var1, UUID var2);

            public boolean isEmptyPageDiagnosticsEnabled(CosmosQueryRequestOptions var1);

            public CosmosQueryRequestOptions setEmptyPageDiagnosticsEnabled(CosmosQueryRequestOptions var1, boolean var2);

            public CosmosQueryRequestOptions withEmptyPageDiagnosticsEnabled(CosmosQueryRequestOptions var1, boolean var2);

            public <T> Function<JsonNode, T> getItemFactoryMethod(CosmosQueryRequestOptions var1, Class<T> var2);

            public CosmosQueryRequestOptions setItemFactoryMethod(CosmosQueryRequestOptions var1, Function<JsonNode, ?> var2);

            public String getQueryNameOrDefault(CosmosQueryRequestOptions var1, String var2);

            public RequestOptions toRequestOptions(CosmosQueryRequestOptions var1);

            public CosmosDiagnosticsThresholds getDiagnosticsThresholds(CosmosQueryRequestOptions var1);

            public void applyMaxItemCount(CosmosQueryRequestOptions var1, CosmosPagedFluxOptions var2);

            public CosmosEndToEndOperationLatencyPolicyConfig getEndToEndOperationLatencyPolicyConfig(CosmosQueryRequestOptions var1);

            public List<String> getExcludeRegions(CosmosQueryRequestOptions var1);

            public List<CosmosDiagnostics> getCancelledRequestDiagnosticsTracker(CosmosQueryRequestOptions var1);

            public void setCancelledRequestDiagnosticsTracker(CosmosQueryRequestOptions var1, List<CosmosDiagnostics> var2);
        }
    }

    public static final class DirectConnectionConfigHelper {
        private static final AtomicBoolean directConnectionConfigClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<DirectConnectionConfigAccessor> accessor = new AtomicReference();

        private DirectConnectionConfigHelper() {
        }

        public static void setDirectConnectionConfigAccessor(DirectConnectionConfigAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("DirectConnectionConfigAccessor already initialized!");
            } else {
                logger.debug("Setting DirectConnectionConfigAccessor...");
                directConnectionConfigClassLoaded.set(true);
            }
        }

        public static DirectConnectionConfigAccessor getDirectConnectionConfigAccessor() {
            DirectConnectionConfigAccessor snapshot;
            if (!directConnectionConfigClassLoaded.get()) {
                logger.debug("Initializing DirectConnectionConfigAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("DirectConnectionConfigAccessor is not initialized yet!");
                System.exit(9702);
            }
            return snapshot;
        }

        public static interface DirectConnectionConfigAccessor {
            public int getIoThreadCountPerCoreFactor(DirectConnectionConfig var1);

            public DirectConnectionConfig setIoThreadCountPerCoreFactor(DirectConnectionConfig var1, int var2);

            public int getIoThreadPriority(DirectConnectionConfig var1);

            public DirectConnectionConfig setIoThreadPriority(DirectConnectionConfig var1, int var2);

            public DirectConnectionConfig setHealthCheckTimeoutDetectionEnabled(DirectConnectionConfig var1, boolean var2);

            public boolean isHealthCheckTimeoutDetectionEnabled(DirectConnectionConfig var1);

            public DirectConnectionConfig setMinConnectionPoolSizePerEndpoint(DirectConnectionConfig var1, int var2);

            public int getMinConnectionPoolSizePerEndpoint(DirectConnectionConfig var1);
        }
    }

    public static final class PartitionKeyHelper {
        private static final AtomicBoolean partitionKeyClassLoaded = new AtomicBoolean(false);
        private static final AtomicReference<PartitionKeyAccessor> accessor = new AtomicReference();

        private PartitionKeyHelper() {
        }

        public static void setPartitionKeyAccessor(PartitionKeyAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("PartitionKeyAccessor already initialized!");
            } else {
                logger.debug("Setting PartitionKeyAccessor...");
                partitionKeyClassLoaded.set(true);
            }
        }

        public static PartitionKeyAccessor getPartitionKeyAccessor() {
            PartitionKeyAccessor snapshot;
            if (!partitionKeyClassLoaded.get()) {
                logger.debug("Initializing PartitionKeyAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("PartitionKeyAccessor is not initialized yet!");
                System.exit(9701);
            }
            return snapshot;
        }

        public static interface PartitionKeyAccessor {
            public PartitionKey toPartitionKey(PartitionKeyInternal var1);
        }
    }

    public static final class CosmosClientBuilderHelper {
        private static final AtomicReference<CosmosClientBuilderAccessor> accessor = new AtomicReference();
        private static final AtomicBoolean cosmosClientBuilderClassLoaded = new AtomicBoolean(false);

        private CosmosClientBuilderHelper() {
        }

        public static void setCosmosClientBuilderAccessor(CosmosClientBuilderAccessor newAccessor) {
            if (!accessor.compareAndSet(null, newAccessor)) {
                logger.debug("CosmosClientBuilderAccessor already initialized!");
            } else {
                logger.debug("Setting CosmosClientBuilderAccessor...");
                cosmosClientBuilderClassLoaded.set(true);
            }
        }

        public static CosmosClientBuilderAccessor getCosmosClientBuilderAccessor() {
            CosmosClientBuilderAccessor snapshot;
            if (!cosmosClientBuilderClassLoaded.get()) {
                logger.debug("Initializing CosmosClientBuilderAccessor...");
                ImplementationBridgeHelpers.initializeAllAccessors();
            }
            if ((snapshot = accessor.get()) == null) {
                logger.error("CosmosClientBuilderAccessor is not initialized yet!");
                System.exit(9700);
            }
            return snapshot;
        }

        public static interface CosmosClientBuilderAccessor {
            public void setCosmosClientMetadataCachesSnapshot(CosmosClientBuilder var1, CosmosClientMetadataCachesSnapshot var2);

            public CosmosClientMetadataCachesSnapshot getCosmosClientMetadataCachesSnapshot(CosmosClientBuilder var1);

            public void setCosmosClientApiType(CosmosClientBuilder var1, ApiType var2);

            public ApiType getCosmosClientApiType(CosmosClientBuilder var1);

            public ConnectionPolicy getConnectionPolicy(CosmosClientBuilder var1);

            public ConnectionPolicy buildConnectionPolicy(CosmosClientBuilder var1);

            public Configs getConfigs(CosmosClientBuilder var1);

            public ConsistencyLevel getConsistencyLevel(CosmosClientBuilder var1);

            public String getEndpoint(CosmosClientBuilder var1);
        }
    }
}

