/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.epkversion;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.InternalObjectNode;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.changefeed.CancellationToken;
import com.azure.cosmos.implementation.changefeed.ChangeFeedContextClient;
import com.azure.cosmos.implementation.changefeed.Lease;
import com.azure.cosmos.implementation.changefeed.LeaseStore;
import com.azure.cosmos.implementation.changefeed.LeaseStoreManager;
import com.azure.cosmos.implementation.changefeed.LeaseStoreManagerSettings;
import com.azure.cosmos.implementation.changefeed.RequestOptionsFactory;
import com.azure.cosmos.implementation.changefeed.ServiceItemLeaseUpdater;
import com.azure.cosmos.implementation.changefeed.common.LeaseVersion;
import com.azure.cosmos.implementation.changefeed.epkversion.DocumentServiceLeaseUpdaterImpl;
import com.azure.cosmos.implementation.changefeed.epkversion.LeaseStoreImpl;
import com.azure.cosmos.implementation.changefeed.epkversion.ServiceItemLeaseV1;
import com.azure.cosmos.implementation.changefeed.exceptions.LeaseLostException;
import com.azure.cosmos.implementation.changefeed.exceptions.TaskCancelledException;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosItemIdentity;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LeaseStoreManagerImpl
implements LeaseStoreManager,
LeaseStoreManager.LeaseStoreManagerBuilderDefinition {
    private final String LEASE_STORE_MANAGER_LEASE_SUFFIX = "..";
    private final Logger logger = LoggerFactory.getLogger(LeaseStoreManagerImpl.class);
    private LeaseStoreManagerSettings settings = new LeaseStoreManagerSettings();
    private ChangeFeedContextClient leaseDocumentClient;
    private RequestOptionsFactory requestOptionsFactory;
    private ServiceItemLeaseUpdater leaseUpdater;
    private LeaseStore leaseStore;

    public static LeaseStoreManager.LeaseStoreManagerBuilderDefinition builder() {
        return new LeaseStoreManagerImpl();
    }

    @Override
    public LeaseStoreManager.LeaseStoreManagerBuilderDefinition leaseContextClient(ChangeFeedContextClient leaseContextClient) {
        Preconditions.checkNotNull(leaseContextClient, "Argument 'leaseContextClient' can not be null");
        this.leaseDocumentClient = leaseContextClient;
        return this;
    }

    @Override
    public LeaseStoreManager.LeaseStoreManagerBuilderDefinition leasePrefix(String leasePrefix) {
        Preconditions.checkNotNull(leasePrefix, "Argument 'leasePrefix' can not be null");
        this.settings.withContainerNamePrefix(leasePrefix);
        return this;
    }

    @Override
    public LeaseStoreManager.LeaseStoreManagerBuilderDefinition leaseCollectionLink(CosmosAsyncContainer leaseCollectionLink) {
        Preconditions.checkNotNull(leaseCollectionLink, "Argument 'leaseCollectionLink' can not be null");
        this.settings.withLeaseCollectionLink(leaseCollectionLink);
        return this;
    }

    @Override
    public LeaseStoreManager.LeaseStoreManagerBuilderDefinition requestOptionsFactory(RequestOptionsFactory requestOptionsFactory) {
        Preconditions.checkNotNull(requestOptionsFactory, "Argument 'requestOptionsFactory' can not be null");
        this.requestOptionsFactory = requestOptionsFactory;
        return this;
    }

    @Override
    public LeaseStoreManager.LeaseStoreManagerBuilderDefinition hostName(String hostName) {
        Preconditions.checkNotNull(hostName, "Argument 'hostName' can not be null");
        this.settings.withHostName(hostName);
        return this;
    }

    @Override
    public LeaseStoreManager build() {
        Preconditions.checkNotNull(this.settings, "settings can not be null");
        Preconditions.checkNotNull(this.settings.getContainerNamePrefix(), "settings.containerNamePrefix can not be null");
        Preconditions.checkNotNull(this.settings.getLeaseCollectionLink(), "settings.leaseCollectionLink can not be null");
        Preconditions.checkArgument(StringUtils.isNotEmpty(this.settings.getHostName()), "settings.getHostName can not be null nor empty");
        Preconditions.checkNotNull(this.leaseDocumentClient, "leaseDocumentClient can not be null");
        Preconditions.checkNotNull(this.requestOptionsFactory, "requestOptionsFactory can not be null");
        if (this.leaseUpdater == null) {
            this.leaseUpdater = new DocumentServiceLeaseUpdaterImpl(this.leaseDocumentClient);
        }
        this.leaseStore = new LeaseStoreImpl(this.leaseDocumentClient, this.settings.getContainerNamePrefix(), this.settings.getLeaseCollectionLink(), this.requestOptionsFactory);
        return this;
    }

    @Override
    public Flux<Lease> getAllLeases() {
        return this.listDocuments(this.getPartitionLeasePrefix()).map(documentServiceLease -> documentServiceLease);
    }

    @Override
    public Flux<Lease> getOwnedLeases() {
        return this.getAllLeases().filter(lease -> lease.getOwner() != null && lease.getOwner().equalsIgnoreCase(this.settings.getHostName()));
    }

    @Override
    public Mono<Lease> createLeaseIfNotExist(String leaseToken, String continuationToken) {
        return this.createLeaseIfNotExist(leaseToken, continuationToken, null);
    }

    @Override
    public Mono<Lease> createLeaseIfNotExist(String leaseToken, String continuationToken, Map<String, String> properties) {
        throw new UnsupportedOperationException("partition key based leases are not supported for Change Feed V1 wire format");
    }

    @Override
    public Mono<Lease> createLeaseIfNotExist(FeedRangeEpkImpl feedRange, String continuationToken) {
        return this.createLeaseIfNotExist(feedRange, continuationToken, null);
    }

    @Override
    public Mono<Lease> createLeaseIfNotExist(FeedRangeEpkImpl feedRange, String continuationToken, Map<String, String> properties) {
        Preconditions.checkNotNull(feedRange, "Argument 'feedRanges' should not be null");
        String leaseToken = feedRange.getRange().getMin() + "-" + feedRange.getRange().getMax();
        String leaseDocId = this.getDocumentId(leaseToken);
        ServiceItemLeaseV1 documentServiceLease = new ServiceItemLeaseV1().withVersion(LeaseVersion.EPK_RANGE_BASED_LEASE).withId(leaseDocId).withLeaseToken(leaseToken).withFeedRange(feedRange).withContinuationToken(continuationToken).withProperties(properties);
        return this.leaseDocumentClient.createItem(this.settings.getLeaseCollectionLink(), documentServiceLease, null, false).onErrorResume(ex -> {
            CosmosException e;
            if (ex instanceof CosmosException && Exceptions.isConflict(e = (CosmosException)((Object)((Object)ex)))) {
                this.logger.info("Some other host created lease for {}.", (Object)leaseToken);
                return Mono.empty();
            }
            return Mono.error((Throwable)ex);
        }).map(documentResourceResponse -> {
            if (documentResourceResponse == null) {
                return null;
            }
            InternalObjectNode document = BridgeInternal.getProperties(documentResourceResponse);
            return documentServiceLease.withId(document.getId()).withETag(document.getETag()).withTs(ModelBridgeInternal.getStringFromJsonSerializable(document, "_ts"));
        });
    }

    @Override
    public Mono<Void> delete(Lease lease) {
        if (lease == null || lease.getId() == null) {
            throw new IllegalArgumentException("lease");
        }
        return this.leaseDocumentClient.deleteItem(lease.getId(), new PartitionKey(lease.getId()), this.requestOptionsFactory.createItemRequestOptions(lease)).onErrorResume(ex -> {
            CosmosException e;
            if (ex instanceof CosmosException && Exceptions.isNotFound(e = (CosmosException)((Object)((Object)ex)))) {
                return Mono.empty();
            }
            return Mono.error((Throwable)ex);
        }).map(documentResourceResponse -> true).then();
    }

    @Override
    public Mono<Void> deleteAll(List<Lease> leases) {
        Preconditions.checkNotNull(leases, "Argument 'leases' can not be null");
        this.logger.info("Deleting all leases");
        HashMap<String, CosmosItemIdentity> cosmosIdentityMap = new HashMap<String, CosmosItemIdentity>();
        for (Lease lease : leases) {
            cosmosIdentityMap.put(lease.getId(), new CosmosItemIdentity(new PartitionKey(lease.getId()), lease.getId()));
        }
        return Mono.defer(() -> Mono.just((Object)cosmosIdentityMap)).flatMapMany(itemIdentities -> this.leaseDocumentClient.deleteAllItems(cosmosIdentityMap.values().stream().collect(Collectors.toList()))).flatMap(itemResponse -> {
            if (itemResponse.getResponse() != null && itemResponse.getResponse().isSuccessStatusCode()) {
                cosmosIdentityMap.remove(itemResponse.getOperation().getId());
            } else {
                int effectiveStatusCode = 0;
                int effectiveSubStatusCode = 0;
                if (itemResponse.getResponse() != null) {
                    effectiveStatusCode = itemResponse.getResponse().getStatusCode();
                    effectiveSubStatusCode = itemResponse.getResponse().getStatusCode();
                } else if (itemResponse.getException() != null && itemResponse.getException() instanceof CosmosException) {
                    CosmosException cosmosException = (CosmosException)((Object)((Object)itemResponse.getException()));
                    effectiveStatusCode = cosmosException.getStatusCode();
                    effectiveSubStatusCode = cosmosException.getSubStatusCode();
                }
                if (effectiveStatusCode == 404 && effectiveSubStatusCode == 0) {
                    cosmosIdentityMap.remove(itemResponse.getOperation().getId());
                }
            }
            return Mono.empty();
        }).repeat(() -> cosmosIdentityMap.size() != 0).then();
    }

    @Override
    public Mono<Lease> acquire(Lease lease) {
        if (lease == null) {
            throw new IllegalArgumentException("lease");
        }
        String oldOwner = lease.getOwner();
        return this.leaseUpdater.updateLease(lease, lease.getId(), new PartitionKey(lease.getId()), this.requestOptionsFactory.createItemRequestOptions(lease), serverLease -> {
            if (serverLease.getOwner() != null && !serverLease.getOwner().equalsIgnoreCase(oldOwner)) {
                this.logger.info("Lease with token {} : lease was acquired already by owner '{}'", (Object)lease.getLeaseToken(), (Object)serverLease.getOwner());
                throw new LeaseLostException(lease);
            }
            serverLease.setOwner(this.settings.getHostName());
            serverLease.setProperties(lease.getProperties());
            return serverLease;
        });
    }

    @Override
    public Mono<Void> release(Lease lease) {
        if (lease == null) {
            throw new IllegalArgumentException("lease");
        }
        return this.leaseDocumentClient.readItem(lease.getId(), new PartitionKey(lease.getId()), this.requestOptionsFactory.createItemRequestOptions(lease), InternalObjectNode.class).onErrorResume(ex -> {
            CosmosException e;
            if (ex instanceof CosmosException && Exceptions.isNotFound(e = (CosmosException)((Object)((Object)ex)))) {
                this.logger.info("Lease with token {} : failed to renew lease. The lease is gone already.", (Object)lease.getLeaseToken());
                throw new LeaseLostException(lease);
            }
            return Mono.error((Throwable)ex);
        }).map(documentResourceResponse -> ServiceItemLeaseV1.fromDocument(BridgeInternal.getProperties(documentResourceResponse))).flatMap(refreshedLease -> this.leaseUpdater.updateLease((Lease)refreshedLease, lease.getId(), new PartitionKey(lease.getId()), this.requestOptionsFactory.createItemRequestOptions(lease), serverLease -> {
            if (serverLease.getOwner() != null && !serverLease.getOwner().equalsIgnoreCase(lease.getOwner())) {
                this.logger.info("Lease with token {} : no need to release lease. The lease was already taken by another host '{}'.", (Object)lease.getLeaseToken(), (Object)serverLease.getOwner());
                throw new LeaseLostException(lease);
            }
            serverLease.setOwner(null);
            return serverLease;
        })).then();
    }

    @Override
    public Mono<Lease> renew(Lease lease) {
        if (lease == null) {
            throw new IllegalArgumentException("lease");
        }
        return this.leaseDocumentClient.readItem(lease.getId(), new PartitionKey(lease.getId()), this.requestOptionsFactory.createItemRequestOptions(lease), InternalObjectNode.class).onErrorResume(ex -> {
            CosmosException e;
            if (ex instanceof CosmosException && Exceptions.isNotFound(e = (CosmosException)((Object)((Object)ex)))) {
                this.logger.info("Lease with token {} : failed to renew lease. The lease is gone already.", (Object)lease.getLeaseToken());
                throw new LeaseLostException(lease);
            }
            return Mono.error((Throwable)ex);
        }).map(documentResourceResponse -> ServiceItemLeaseV1.fromDocument(BridgeInternal.getProperties(documentResourceResponse))).flatMap(refreshedLease -> this.leaseUpdater.updateLease((Lease)refreshedLease, lease.getId(), new PartitionKey(lease.getId()), this.requestOptionsFactory.createItemRequestOptions(lease), serverLease -> {
            if (serverLease.getOwner() == null) {
                this.logger.info("Lease with token {} : lease was taken over and released by a different owner", (Object)lease.getLeaseToken());
                throw new LeaseLostException(lease);
            }
            if (!serverLease.getOwner().equalsIgnoreCase(lease.getOwner())) {
                this.logger.info("Lease with token {} : lease was taken over by owner '{}'", (Object)lease.getLeaseToken(), (Object)serverLease.getOwner());
                throw new LeaseLostException(lease);
            }
            return serverLease;
        }));
    }

    @Override
    public Mono<Lease> updateProperties(Lease lease) {
        if (lease == null) {
            throw new IllegalArgumentException("lease");
        }
        if (lease.getOwner() != null && !lease.getOwner().equalsIgnoreCase(this.settings.getHostName())) {
            this.logger.info("Lease with token '{}' : lease was taken over by owner '{}' before lease item update", (Object)lease.getLeaseToken(), (Object)lease.getOwner());
            throw new LeaseLostException(lease);
        }
        return this.leaseUpdater.updateLease(lease, lease.getId(), new PartitionKey(lease.getId()), this.requestOptionsFactory.createItemRequestOptions(lease), serverLease -> {
            if (serverLease.getOwner() != null && !serverLease.getOwner().equalsIgnoreCase(lease.getOwner())) {
                this.logger.info("Lease with token '{}' : lease was taken over by owner '{}'", (Object)lease.getLeaseToken(), (Object)serverLease.getOwner());
                throw new LeaseLostException(lease);
            }
            serverLease.setProperties(lease.getProperties());
            return serverLease;
        });
    }

    @Override
    public Mono<Lease> checkpoint(Lease lease, String continuationToken, CancellationToken cancellationToken) {
        if (lease == null) {
            throw new IllegalArgumentException("lease");
        }
        if (continuationToken == null || continuationToken.isEmpty()) {
            throw new IllegalArgumentException("continuationToken must be a non-empty string");
        }
        if (cancellationToken.isCancellationRequested()) {
            return Mono.error((Throwable)new TaskCancelledException());
        }
        return this.leaseDocumentClient.readItem(lease.getId(), new PartitionKey(lease.getId()), this.requestOptionsFactory.createItemRequestOptions(lease), InternalObjectNode.class).map(documentResourceResponse -> ServiceItemLeaseV1.fromDocument(BridgeInternal.getProperties(documentResourceResponse))).flatMap(refreshedLease -> {
            if (cancellationToken.isCancellationRequested()) {
                return Mono.error((Throwable)new TaskCancelledException());
            }
            return this.leaseUpdater.updateLease((Lease)refreshedLease, lease.getId(), new PartitionKey(lease.getId()), this.requestOptionsFactory.createItemRequestOptions(lease), serverLease -> {
                if (serverLease.getOwner() == null) {
                    this.logger.info("Lease with token {} : lease was taken over and released by a different owner", (Object)lease.getLeaseToken());
                    throw new LeaseLostException(lease);
                }
                if (!serverLease.getOwner().equalsIgnoreCase(lease.getOwner())) {
                    this.logger.info("Lease with token {} : lease was taken over by owner '{}'", (Object)lease.getLeaseToken(), (Object)serverLease.getOwner());
                    throw new LeaseLostException(lease);
                }
                serverLease.setContinuationToken(continuationToken);
                return serverLease;
            });
        }).doOnError(throwable -> this.logger.info("Lease with token {}  : lease with token '{}' failed to checkpoint for owner '{}' with continuation token '{}'", new Object[]{lease.getLeaseToken(), lease.getConcurrencyToken(), lease.getOwner(), lease.getReadableContinuationToken()}));
    }

    @Override
    public Mono<Boolean> isInitialized() {
        return this.leaseStore.isInitialized();
    }

    @Override
    public Mono<Boolean> markInitialized() {
        return this.leaseStore.markInitialized();
    }

    @Override
    public Mono<Boolean> acquireInitializationLock(Duration lockExpirationTime) {
        return this.leaseStore.acquireInitializationLock(lockExpirationTime);
    }

    @Override
    public Mono<Boolean> releaseInitializationLock() {
        return this.leaseStore.releaseInitializationLock();
    }

    private Flux<ServiceItemLeaseV1> listDocuments(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            throw new IllegalArgumentException("prefix");
        }
        SqlParameter param = new SqlParameter();
        param.setName("@PartitionLeasePrefix");
        param.setValue(prefix);
        SqlQuerySpec querySpec = new SqlQuerySpec("SELECT * FROM c WHERE STARTSWITH(c.id, @PartitionLeasePrefix)", Collections.singletonList(param));
        Flux<FeedResponse<InternalObjectNode>> query = this.leaseDocumentClient.queryItems(this.settings.getLeaseCollectionLink(), querySpec, this.requestOptionsFactory.createQueryRequestOptions(), InternalObjectNode.class);
        return query.flatMap(documentFeedResponse -> Flux.fromIterable(documentFeedResponse.getResults())).map(ServiceItemLeaseV1::fromDocument);
    }

    private String getDocumentId(String leaseToken) {
        return this.getPartitionLeasePrefix() + leaseToken;
    }

    private String getPartitionLeasePrefix() {
        return this.settings.getContainerNamePrefix() + "..";
    }
}

