/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncStoredProcedure;
import com.azure.cosmos.CosmosAsyncTrigger;
import com.azure.cosmos.CosmosAsyncUserDefinedFunction;
import com.azure.cosmos.CosmosDiagnosticsThresholds;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.StoredProcedure;
import com.azure.cosmos.implementation.Trigger;
import com.azure.cosmos.implementation.UserDefinedFunction;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.CosmosStoredProcedureProperties;
import com.azure.cosmos.models.CosmosStoredProcedureRequestOptions;
import com.azure.cosmos.models.CosmosStoredProcedureResponse;
import com.azure.cosmos.models.CosmosTriggerProperties;
import com.azure.cosmos.models.CosmosTriggerResponse;
import com.azure.cosmos.models.CosmosUserDefinedFunctionProperties;
import com.azure.cosmos.models.CosmosUserDefinedFunctionResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.UtilBridgeInternal;
import reactor.core.publisher.Mono;

public class CosmosAsyncScripts {
    private static final ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.CosmosQueryRequestOptionsAccessor queryOptionsAccessor = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor();
    private static final ImplementationBridgeHelpers.FeedResponseHelper.FeedResponseAccessor feedResponseAccessor = ImplementationBridgeHelpers.FeedResponseHelper.getFeedResponseAccessor();
    private final CosmosAsyncContainer container;
    private final CosmosAsyncDatabase database;

    CosmosAsyncScripts(CosmosAsyncContainer container) {
        this.container = container;
        this.database = container.getDatabase();
    }

    public Mono<CosmosStoredProcedureResponse> createStoredProcedure(CosmosStoredProcedureProperties properties) {
        return this.createStoredProcedure(properties, new CosmosStoredProcedureRequestOptions());
    }

    public Mono<CosmosStoredProcedureResponse> createStoredProcedure(CosmosStoredProcedureProperties properties, CosmosStoredProcedureRequestOptions options) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        StoredProcedure sProc = new StoredProcedure();
        sProc.setId(properties.getId());
        sProc.setBody(properties.getBody());
        CosmosStoredProcedureRequestOptions requestOptions = options;
        return FluxUtil.withContext(context -> this.createStoredProcedureInternal(sProc, requestOptions, (Context)context));
    }

    public CosmosPagedFlux<CosmosStoredProcedureProperties> readAllStoredProcedures() {
        return this.readAllStoredProcedures(new CosmosQueryRequestOptions());
    }

    CosmosPagedFlux<CosmosStoredProcedureProperties> readAllStoredProcedures(CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            String spanName = "readAllStoredProcedures." + this.container.getId();
            CosmosAsyncClient client = this.container.getDatabase().getClient();
            CosmosQueryRequestOptions nonNullOptions = options != null ? options : new CosmosQueryRequestOptions();
            String operationId = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().getQueryNameOrDefault(nonNullOptions, spanName);
            pagedFluxOptions.setTracerInformation(spanName, this.container.getDatabase().getId(), this.container.getId(), operationId, OperationType.ReadFeed, ResourceType.StoredProcedure, client, nonNullOptions.getConsistencyLevel(), client.getEffectiveDiagnosticsThresholds(queryOptionsAccessor.getDiagnosticsThresholds(nonNullOptions)));
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.database.getDocClientWrapper().readStoredProcedures(this.container.getLink(), options).map(response -> feedResponseAccessor.createFeedResponse(ModelBridgeInternal.getCosmosStoredProcedurePropertiesFromV2Results(response.getResults()), response.getResponseHeaders(), response.getCosmosDiagnostics()));
        });
    }

    public CosmosPagedFlux<CosmosStoredProcedureProperties> queryStoredProcedures(String query, CosmosQueryRequestOptions options) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryStoredProceduresInternal(new SqlQuerySpec(query), options);
    }

    public CosmosPagedFlux<CosmosStoredProcedureProperties> queryStoredProcedures(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryStoredProceduresInternal(querySpec, options);
    }

    public CosmosAsyncStoredProcedure getStoredProcedure(String id) {
        return new CosmosAsyncStoredProcedure(id, this.container);
    }

    public Mono<CosmosUserDefinedFunctionResponse> createUserDefinedFunction(CosmosUserDefinedFunctionProperties properties) {
        UserDefinedFunction udf = new UserDefinedFunction();
        udf.setId(properties.getId());
        udf.setBody(properties.getBody());
        return FluxUtil.withContext(context -> this.createUserDefinedFunctionInternal(udf, (Context)context));
    }

    public CosmosPagedFlux<CosmosUserDefinedFunctionProperties> readAllUserDefinedFunctions() {
        return this.readAllUserDefinedFunctions(new CosmosQueryRequestOptions());
    }

    CosmosPagedFlux<CosmosUserDefinedFunctionProperties> readAllUserDefinedFunctions(CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            String spanName = "readAllUserDefinedFunctions." + this.container.getId();
            CosmosAsyncClient client = this.container.getDatabase().getClient();
            CosmosQueryRequestOptions nonNullOptions = options != null ? options : new CosmosQueryRequestOptions();
            String operationId = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().getQueryNameOrDefault(nonNullOptions, spanName);
            pagedFluxOptions.setTracerInformation(spanName, this.container.getDatabase().getId(), this.container.getId(), operationId, OperationType.ReadFeed, ResourceType.UserDefinedFunction, client, nonNullOptions.getConsistencyLevel(), client.getEffectiveDiagnosticsThresholds(queryOptionsAccessor.getDiagnosticsThresholds(nonNullOptions)));
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.database.getDocClientWrapper().readUserDefinedFunctions(this.container.getLink(), options).map(response -> feedResponseAccessor.createFeedResponse(ModelBridgeInternal.getCosmosUserDefinedFunctionPropertiesFromV2Results(response.getResults()), response.getResponseHeaders(), response.getCosmosDiagnostics()));
        });
    }

    public CosmosPagedFlux<CosmosUserDefinedFunctionProperties> queryUserDefinedFunctions(String query, CosmosQueryRequestOptions options) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryUserDefinedFunctions(new SqlQuerySpec(query), options);
    }

    public CosmosPagedFlux<CosmosUserDefinedFunctionProperties> queryUserDefinedFunctions(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryUserDefinedFunctionsInternal(querySpec, options);
    }

    public CosmosAsyncUserDefinedFunction getUserDefinedFunction(String id) {
        return new CosmosAsyncUserDefinedFunction(id, this.container);
    }

    public Mono<CosmosTriggerResponse> createTrigger(CosmosTriggerProperties properties) {
        return FluxUtil.withContext(context -> this.createTriggerInternal(properties, (Context)context));
    }

    public CosmosPagedFlux<CosmosTriggerProperties> readAllTriggers() {
        return this.readAllTriggers(new CosmosQueryRequestOptions());
    }

    CosmosPagedFlux<CosmosTriggerProperties> readAllTriggers(CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            String spanName = "readAllTriggers." + this.container.getId();
            CosmosAsyncClient client = this.container.getDatabase().getClient();
            CosmosQueryRequestOptions nonNullOptions = options != null ? options : new CosmosQueryRequestOptions();
            String operationId = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().getQueryNameOrDefault(nonNullOptions, spanName);
            pagedFluxOptions.setTracerInformation(spanName, this.container.getDatabase().getId(), this.container.getId(), operationId, OperationType.ReadFeed, ResourceType.Trigger, client, nonNullOptions.getConsistencyLevel(), client.getEffectiveDiagnosticsThresholds(queryOptionsAccessor.getDiagnosticsThresholds(nonNullOptions)));
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.database.getDocClientWrapper().readTriggers(this.container.getLink(), options).map(response -> feedResponseAccessor.createFeedResponse(ModelBridgeInternal.getCosmosTriggerPropertiesFromV2Results(response.getResults()), response.getResponseHeaders(), response.getCosmosDiagnostics()));
        });
    }

    public CosmosPagedFlux<CosmosTriggerProperties> queryTriggers(String query, CosmosQueryRequestOptions options) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryTriggersInternal(false, new SqlQuerySpec(query), options);
    }

    public CosmosPagedFlux<CosmosTriggerProperties> queryTriggers(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        if (options == null) {
            options = new CosmosQueryRequestOptions();
        }
        return this.queryTriggersInternal(true, querySpec, options);
    }

    public CosmosAsyncTrigger getTrigger(String id) {
        return new CosmosAsyncTrigger(id, this.container);
    }

    private CosmosPagedFlux<CosmosStoredProcedureProperties> queryStoredProceduresInternal(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            String spanName = "queryStoredProcedures." + this.container.getId();
            CosmosAsyncClient client = this.container.getDatabase().getClient();
            CosmosQueryRequestOptions nonNullOptions = options != null ? options : new CosmosQueryRequestOptions();
            String operationId = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().getQueryNameOrDefault(nonNullOptions, spanName);
            pagedFluxOptions.setTracerInformation(spanName, this.container.getDatabase().getId(), this.container.getId(), operationId, OperationType.Query, ResourceType.StoredProcedure, client, nonNullOptions.getConsistencyLevel(), client.getEffectiveDiagnosticsThresholds(queryOptionsAccessor.getDiagnosticsThresholds(nonNullOptions)));
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.database.getDocClientWrapper().queryStoredProcedures(this.container.getLink(), querySpec, options).map(response -> feedResponseAccessor.createFeedResponse(ModelBridgeInternal.getCosmosStoredProcedurePropertiesFromV2Results(response.getResults()), response.getResponseHeaders(), response.getCosmosDiagnostics()));
        });
    }

    private CosmosPagedFlux<CosmosUserDefinedFunctionProperties> queryUserDefinedFunctionsInternal(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            String spanName = "queryUserDefinedFunctions." + this.container.getId();
            CosmosAsyncClient client = this.container.getDatabase().getClient();
            CosmosQueryRequestOptions nonNullOptions = options != null ? options : new CosmosQueryRequestOptions();
            String operationId = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().getQueryNameOrDefault(nonNullOptions, spanName);
            pagedFluxOptions.setTracerInformation(spanName, this.container.getDatabase().getId(), this.container.getId(), operationId, OperationType.Query, ResourceType.UserDefinedFunction, client, nonNullOptions.getConsistencyLevel(), client.getEffectiveDiagnosticsThresholds(queryOptionsAccessor.getDiagnosticsThresholds(nonNullOptions)));
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.database.getDocClientWrapper().queryUserDefinedFunctions(this.container.getLink(), querySpec, options).map(response -> feedResponseAccessor.createFeedResponse(ModelBridgeInternal.getCosmosUserDefinedFunctionPropertiesFromV2Results(response.getResults()), response.getResponseHeaders(), response.getCosmosDiagnostics()));
        });
    }

    private CosmosPagedFlux<CosmosTriggerProperties> queryTriggersInternal(boolean isParameterised, SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return UtilBridgeInternal.createCosmosPagedFlux(pagedFluxOptions -> {
            String spanName = isParameterised ? "queryTriggers." + this.container.getId() + "." + querySpec.getQueryText() : "queryTriggers." + this.container.getId();
            CosmosAsyncClient client = this.container.getDatabase().getClient();
            CosmosQueryRequestOptions nonNullOptions = options != null ? options : new CosmosQueryRequestOptions();
            String operationId = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor().getQueryNameOrDefault(nonNullOptions, spanName);
            pagedFluxOptions.setTracerInformation(spanName, this.container.getDatabase().getId(), this.container.getId(), operationId, OperationType.Query, ResourceType.Trigger, client, nonNullOptions.getConsistencyLevel(), client.getEffectiveDiagnosticsThresholds(queryOptionsAccessor.getDiagnosticsThresholds(nonNullOptions)));
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.database.getDocClientWrapper().queryTriggers(this.container.getLink(), querySpec, options).map(response -> feedResponseAccessor.createFeedResponse(ModelBridgeInternal.getCosmosTriggerPropertiesFromV2Results(response.getResults()), response.getResponseHeaders(), response.getCosmosDiagnostics()));
        });
    }

    private Mono<CosmosStoredProcedureResponse> createStoredProcedureInternal(StoredProcedure sProc, CosmosStoredProcedureRequestOptions options, Context context) {
        String spanName = "createStoredProcedure." + this.container.getId();
        Mono<CosmosStoredProcedureResponse> responseMono = this.createStoredProcedureInternal(sProc, options);
        CosmosAsyncClient client = this.database.getClient();
        CosmosDiagnosticsThresholds requestDiagnosticThresholds = ModelBridgeInternal.toRequestOptions(options).getDiagnosticsThresholds();
        return client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.database.getId(), this.container.getId(), client, null, OperationType.Create, ResourceType.StoredProcedure, client.getEffectiveDiagnosticsThresholds(requestDiagnosticThresholds));
    }

    private Mono<CosmosStoredProcedureResponse> createStoredProcedureInternal(StoredProcedure sProc, CosmosStoredProcedureRequestOptions options) {
        return this.database.getDocClientWrapper().createStoredProcedure(this.container.getLink(), sProc, ModelBridgeInternal.toRequestOptions(options)).map(ModelBridgeInternal::createCosmosStoredProcedureResponse).single();
    }

    private Mono<CosmosUserDefinedFunctionResponse> createUserDefinedFunctionInternal(UserDefinedFunction udf, Context context) {
        String spanName = "createUserDefinedFunction." + this.container.getId();
        Mono<CosmosUserDefinedFunctionResponse> responseMono = this.createUserDefinedFunctionInternal(udf);
        CosmosAsyncClient client = this.database.getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.database.getId(), this.container.getId(), client, null, OperationType.Create, ResourceType.UserDefinedFunction, client.getEffectiveDiagnosticsThresholds(null));
    }

    private Mono<CosmosUserDefinedFunctionResponse> createUserDefinedFunctionInternal(UserDefinedFunction udf) {
        return this.database.getDocClientWrapper().createUserDefinedFunction(this.container.getLink(), udf, null).map(ModelBridgeInternal::createCosmosUserDefinedFunctionResponse).single();
    }

    private Mono<CosmosTriggerResponse> createTriggerInternal(CosmosTriggerProperties properties, Context context) {
        String spanName = "createTrigger." + this.container.getId();
        Mono<CosmosTriggerResponse> responseMono = this.createTriggerInternal(properties);
        CosmosAsyncClient client = this.database.getClient();
        return client.getDiagnosticsProvider().traceEnabledCosmosResponsePublisher(responseMono, context, spanName, this.database.getId(), this.container.getId(), client, null, OperationType.Create, ResourceType.Trigger, client.getEffectiveDiagnosticsThresholds(null));
    }

    private Mono<CosmosTriggerResponse> createTriggerInternal(CosmosTriggerProperties properties) {
        Trigger trigger = new Trigger(ModelBridgeInternal.toJsonFromJsonSerializable(ModelBridgeInternal.getResource(properties)));
        return this.database.getDocClientWrapper().createTrigger(this.container.getLink(), trigger, null).map(ModelBridgeInternal::createCosmosTriggerResponse).single();
    }
}

