/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.clienttelemetry.TagName;
import com.azure.cosmos.models.CosmosMetricTagName;
import java.util.EnumSet;

public final class CosmosMicrometerMeterOptions {
    private Boolean isHistogramPublishingEnabled = null;
    private double[] percentiles = null;
    private EnumSet<TagName> suppressedTagNames = null;
    private Boolean isEnabled = null;
    private Boolean applyDiagnosticThresholds;

    public CosmosMicrometerMeterOptions suppressTagNames(CosmosMetricTagName ... tags) {
        EnumSet<TagName> newTagNames = EnumSet.noneOf(TagName.class);
        if (tags != null && tags.length > 0) {
            for (CosmosMetricTagName t : tags) {
                for (TagName tagName : t.getTagNames()) {
                    if (TagName.MINIMUM_TAGS.contains((Object)tagName)) continue;
                    newTagNames.add(tagName);
                }
            }
        }
        this.suppressedTagNames = newTagNames;
        return this;
    }

    public CosmosMicrometerMeterOptions applyDiagnosticThresholds(boolean isEnabled) {
        this.applyDiagnosticThresholds = isEnabled;
        return this;
    }

    public CosmosMicrometerMeterOptions enableHistograms(boolean isEnabled) {
        this.isHistogramPublishingEnabled = isEnabled;
        return this;
    }

    public CosmosMicrometerMeterOptions configurePercentiles(double ... percentiles) {
        this.percentiles = percentiles == null || percentiles.length == 0 ? new double[0] : (double[])percentiles.clone();
        return this;
    }

    public CosmosMicrometerMeterOptions setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        return this;
    }

    EnumSet<TagName> getSuppressedTagNames() {
        return this.suppressedTagNames;
    }

    Boolean getIsHistogramPublishingEnabled() {
        return this.isHistogramPublishingEnabled;
    }

    Boolean getIsEnabled() {
        return this.isEnabled;
    }

    Boolean getApplyDiagnosticThresholdsEnabled() {
        return this.applyDiagnosticThresholds;
    }

    double[] getPercentiles() {
        return this.percentiles;
    }
}

